/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ias.crypt;

import java.io.DataInput;
import java.io.DataOutput;
import java.security.Key;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.crypto.AEADBadTagException;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import ru.vidtu.ias.IAS;
import ru.vidtu.ias.crypt.DummyCrypt;
import ru.vidtu.ias.crypt.HardwareCrypt;
import ru.vidtu.ias.crypt.PasswordCrypt;
import ru.vidtu.ias.utils.exceptions.FriendlyException;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Crypt {
    public boolean insecure();

    public byte[] encrypt(byte[] var1);

    public byte[] decrypt(byte[] var1);

    public static CompletableFuture<Crypt> decrypt(DataInput input, Supplier<CompletableFuture<String>> password) {
        try {
            String type;
            return switch (type = input.readUTF()) {
                case "ias:dummy_crypt_v1" -> CompletableFuture.completedFuture(DummyCrypt.INSTANCE);
                case "ias:hardware_crypt_v1" -> CompletableFuture.completedFuture(HardwareCrypt.INSTANCE);
                case "ias:password_crypt_v1" -> password.get().thenApplyAsync(pass -> pass == null ? null : new PasswordCrypt((String)pass), (Executor)IAS.executor());
                default -> CompletableFuture.failedFuture(new IllegalArgumentException("Unknown crypt type: " + type));
            };
        }
        catch (Throwable t) {
            return CompletableFuture.failedFuture(new RuntimeException("Unable to read typed crypt.", t));
        }
    }

    public static void encrypt(DataOutput out, Crypt crypt) {
        try {
            String type;
            if (crypt instanceof DummyCrypt) {
                type = "ias:dummy_crypt_v1";
            } else if (crypt instanceof HardwareCrypt) {
                type = "ias:hardware_crypt_v1";
            } else if (crypt instanceof PasswordCrypt) {
                type = "ias:password_crypt_v1";
            } else {
                throw new IllegalArgumentException("Unknown crypt type: " + crypt + " (" + (crypt != null ? crypt.getClass() : null) + ")");
            }
            out.writeUTF(type);
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to write typed crypt.", t);
        }
    }

    public static byte[] pbkdfAesEncrypt(byte[] decrypted, String password, byte[] salt, byte[] iv) {
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
            PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt, 500000, 256);
            byte[] secret = factory.generateSecret(spec).getEncoded();
            SecretKeySpec key = new SecretKeySpec(secret, "AES");
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(1, (Key)key, new GCMParameterSpec(128, iv));
            return cipher.doFinal(decrypted);
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to encrypt data using AES via PBKDF2-hashed password.", t);
        }
    }

    public static byte[] pbkdfAesDecrypt(byte[] encrypted, String password, byte[] salt, byte[] iv) {
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
            PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt, 500000, 256);
            byte[] secret = factory.generateSecret(spec).getEncoded();
            SecretKeySpec key = new SecretKeySpec(secret, "AES");
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(2, (Key)key, new GCMParameterSpec(128, iv));
            try {
                return cipher.doFinal(encrypted);
            }
            catch (AEADBadTagException e) {
                throw new FriendlyException("Unable to do AES final decrypt.", e, "ias.error.decrypt");
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to decrypt data using AES via PBKDF2-hashed password.", t);
        }
    }
}

