/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ias.config.migrator;

import com.google.gson.JsonObject;
import java.util.regex.Pattern;
import ru.vidtu.ias.config.migrator.MigratorV1;
import ru.vidtu.ias.config.migrator.MigratorV2;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Migrator {
    public static final Pattern OBFUSCATE_LOGS = Pattern.compile("(\"?(?:accessToken|refreshToken)\"?\\s*:)\"?[^,\":{}\\[\\]]*\"?", 2);

    public void load(JsonObject var1);

    public static Migrator fromVersion(int version) {
        return switch (version) {
            case 1 -> new MigratorV1();
            case 2 -> new MigratorV2();
            case 3 -> null;
            default -> throw new IllegalArgumentException("Unknown config version: " + version);
        };
    }
}

