/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ias.account;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.UUID;
import ru.vidtu.ias.account.MicrosoftAccount;
import ru.vidtu.ias.account.OfflineAccount;
import ru.vidtu.ias.auth.handlers.LoginHandler;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Account {
    public String type();

    public String typeTipKey();

    public UUID uuid();

    public String name();

    default public boolean is(UUID uuid, String name) {
        return this.uuid().equals(uuid) && this.name().equals(name);
    }

    public boolean canLogin();

    public boolean insecure();

    public void login(LoginHandler var1);

    public void write(DataOutput var1) throws IOException;

    public static void writeTyped(DataOutput out, Account account) throws IOException {
        String type = account.type();
        out.writeUTF(type);
        account.write(out);
    }

    public static Account readTyped(DataInput in) throws IOException {
        String type;
        return switch (type = in.readUTF()) {
            case "ias:offline_v1" -> OfflineAccount.read(in);
            case "ias:microsoft_v1" -> MicrosoftAccount.read(in);
            default -> throw new IllegalArgumentException("Unknown account type: " + type);
        };
    }
}

