/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ias;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vidtu.ias.config.IASConfig;
import ru.vidtu.ias.config.IASStorage;

public final class IAS {
    public static final String CLIENT_ID = "54fd49e4-2103-4044-9603-2b028c814ec3";
    public static final Duration TIMEOUT = Duration.ofSeconds(Long.getLong("ias.timeout", 15L));
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"IAS");
    private static final UUID SESSION = UUID.randomUUID();
    private static final String USER_AGENT_TEMPLATE = "IAS/%s (Session: %s; Loader: %s %s; Minecraft %s; Java %s)";
    private static ScheduledExecutorService executor = null;
    private static String userAgent = null;
    private static Path gameDirectory;
    private static Path configDirectory;
    private static boolean disabled;

    private IAS() {
        throw new AssertionError((Object)"No instances.");
    }

    public static void init(Path gamePath, Path configPath, String version, String loader, String loaderVersion, String gameVersion) {
        gameDirectory = gamePath;
        configDirectory = configPath;
        userAgent = USER_AGENT_TEMPLATE.formatted(version, SESSION, loader, loaderVersion, gameVersion, Runtime.version().toString());
        LOGGER.info("IAS user agent: {}", (Object)userAgent);
        try {
            IAS.disclaimersStorage();
        }
        catch (Throwable t) {
            LOGGER.error("IAS: Unable to write disclaimers.", t);
        }
        try {
            IAS.loadConfig();
        }
        catch (Throwable t) {
            LOGGER.error("IAS: Unable to load IAS config.", t);
        }
        try {
            IAS.loadStorage();
        }
        catch (Throwable t) {
            LOGGER.error("IAS: Unable to load IAS storage.", t);
        }
        executor = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "IAS Executor Thread"));
        if (Boolean.getBoolean("ias.skipDisableScanning")) {
            return;
        }
        executor.scheduleWithFixedDelay(() -> {
            try {
                if (disabled || Boolean.getBoolean("ias.skipDisableScanning")) {
                    return;
                }
                HttpClient client = HttpClient.newBuilder().connectTimeout(TIMEOUT).version(HttpClient.Version.HTTP_2).followRedirects(HttpClient.Redirect.NORMAL).executor(Runnable::run).priority(1).build();
                HttpResponse<Stream<String>> response = client.send(HttpRequest.newBuilder().uri(new URI("https://raw.githubusercontent.com/The-Fireplace-Minecraft-Mods/In-Game-Account-Switcher/main/.ias/disabled_v1")).header("User-Agent", userAgent).timeout(TIMEOUT).GET().build(), HttpResponse.BodyHandlers.ofLines());
                int code = response.statusCode();
                if (code < 200 || code > 299) {
                    return;
                }
                disabled = response.body().anyMatch(line -> "ALL".equalsIgnoreCase(line = line.strip()) || version.equalsIgnoreCase((String)line));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }, 3L, 3L, TimeUnit.HOURS);
    }

    public static void close() {
        try {
            if (executor != null) {
                executor.shutdown();
                if (!executor.awaitTermination(30L, TimeUnit.SECONDS)) {
                    LOGGER.warn("IAS: Unable to shutdown IAS executor. Shutting down forcefully...");
                    executor.shutdownNow();
                    if (!executor.awaitTermination(30L, TimeUnit.SECONDS)) {
                        LOGGER.error("IAS: Unable to shutdown IAS executor forcefully.");
                    }
                }
            }
        }
        catch (InterruptedException e) {
            executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
        executor = null;
        userAgent = null;
        if (gameDirectory != null) {
            try {
                IAS.disclaimersStorage();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static ScheduledExecutorService executor() {
        Objects.requireNonNull(executor, "IAS executor is not available.");
        return executor;
    }

    public static String userAgent() {
        Objects.requireNonNull(userAgent, "IAS user agent is not set.");
        return userAgent;
    }

    public static boolean disabled() {
        return disabled;
    }

    public static void loadConfig() {
        IASConfig.load(configDirectory);
    }

    public static void saveConfig() {
        IASConfig.save(configDirectory);
    }

    public static void loadStorage() {
        IASStorage.load(gameDirectory);
    }

    public static void saveStorage() {
        IASStorage.save(gameDirectory);
    }

    public static void disclaimersStorage() {
        IASStorage.disclaimers(gameDirectory);
    }

    public static void gameDisclaimerShownStorage() {
        IASStorage.gameDisclaimerShown(gameDirectory);
    }

    static {
        disabled = false;
    }
}

