/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.jukebox.impl.apple;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import org.jetbrains.annotations.NotNull;
import tech.thatgravyboat.jukebox.api.service.BaseSocketService;
import tech.thatgravyboat.jukebox.api.state.RepeatState;
import tech.thatgravyboat.jukebox.api.state.ShuffleState;
import tech.thatgravyboat.jukebox.api.state.State;
import tech.thatgravyboat.jukebox.impl.apple.AppleServiceKt;
import tech.thatgravyboat.jukebox.impl.apple.state.ApplePlayerState;
import tech.thatgravyboat.jukebox.impl.apple.state.AppleState;
import tech.thatgravyboat.jukebox.impl.apple.state.AppleStateSerializer;
import tech.thatgravyboat.jukebox.utils.CloseableSocket;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\f\u0010\u0005J\u0017\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0005J\u001f\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001a"}, d2={"Ltech/thatgravyboat/jukebox/impl/apple/AppleService;", "Ltech/thatgravyboat/jukebox/api/service/BaseSocketService;", "", "forward", "move", "(Z)Z", "", "message", "", "onMessage", "(Ljava/lang/String;)V", "paused", "setPaused", "Ltech/thatgravyboat/jukebox/api/state/RepeatState;", "repeat", "setRepeat", "(Ltech/thatgravyboat/jukebox/api/state/RepeatState;)Z", "shuffle", "setShuffle", "", "volume", "notify", "setVolume", "(IZ)Z", "<init>", "()V", "jukebox"})
public final class AppleService
extends BaseSocketService {
    public AppleService() {
        super(new CloseableSocket(AppleServiceKt.access$getAPI_URL$p(), null, 2, null));
    }

    @Override
    public void onMessage(@NotNull String message2) {
        block3: {
            AppleState appleState;
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            try {
                appleState = (AppleState)AppleServiceKt.access$getJSON$p().decodeFromString((DeserializationStrategy)AppleStateSerializer.INSTANCE, message2);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.onError("Error parsing Player JSON");
                appleState = null;
            }
            AppleState appleState2 = appleState;
            if (appleState2 == null) break block3;
            AppleState $this$onMessage_u24lambda_u2d0 = appleState = appleState2;
            boolean bl = false;
            if ($this$onMessage_u24lambda_u2d0 instanceof ApplePlayerState) {
                this.onSuccess(((ApplePlayerState)$this$onMessage_u24lambda_u2d0).getState());
            }
        }
    }

    @Override
    public boolean setPaused(boolean paused) {
        this.getSocket().send("{\"action\":\"" + (paused ? "pause" : "play") + "\"}");
        return true;
    }

    @Override
    public boolean setShuffle(boolean shuffle) {
        Boolean shuffleState;
        block1: {
            State state = this.getState();
            if (state == null) {
                return false;
            }
            State state2 = state;
            Boolean bl = shuffleState = shuffle && state2.getPlayer().getShuffle() == ShuffleState.OFF ? Boolean.valueOf(true) : (!shuffle && state2.getPlayer().getShuffle() == ShuffleState.ON ? Boolean.valueOf(false) : null);
            if (bl == null) break block1;
            boolean it = bl;
            boolean bl2 = false;
            this.getSocket().send("{\"action\":\"set-shuffle\", \"shuffle\":" + it + '}');
        }
        return shuffleState != null;
    }

    @Override
    public boolean setRepeat(@NotNull RepeatState repeat) {
        Integer repeatState;
        block1: {
            Intrinsics.checkNotNullParameter((Object)((Object)repeat), (String)"repeat");
            State state = this.getState();
            if (state == null) {
                return false;
            }
            State state2 = state;
            Integer n = repeatState = this.checkRepeatState(RepeatState.OFF, repeat, state2) ? Integer.valueOf(0) : (this.checkRepeatState(RepeatState.SONG, repeat, state2) ? Integer.valueOf(1) : (this.checkRepeatState(RepeatState.ALL, repeat, state2) ? Integer.valueOf(2) : null));
            if (n == null) break block1;
            int it = ((Number)n).intValue();
            boolean bl = false;
            this.getSocket().send("{\"action\":\"set-repeat\", \"repeat\":" + it + '}');
        }
        return repeatState != null;
    }

    @Override
    public boolean setVolume(int volume, boolean notify) {
        boolean bl = 0 <= volume ? volume < 101 : false;
        if (bl) {
            this.getSocket().send("{\"action\":\"volume\", \"volume\":" + (double)volume / 100.0 + '}');
            this.onVolumeChange(volume, notify);
            return true;
        }
        return false;
    }

    @Override
    public boolean move(boolean forward) {
        String state = forward ? "next" : "previous";
        this.getSocket().send("{\"action\":\"" + state + "\"}");
        return true;
    }
}

