/*
 * Decompiled with CFR 0.152.
 */
package obro1961.chatpatches.util;

import com.mojang.authlib.GameProfile;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_303;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_338;
import net.minecraft.class_341;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7417;
import obro1961.chatpatches.ChatPatches;
import obro1961.chatpatches.accessor.ChatHudAccessor;
import obro1961.chatpatches.chatlog.ChatLog;
import obro1961.chatpatches.util.Flags;
import obro1961.chatpatches.util.TextUtils;
import org.jetbrains.annotations.NotNull;

public class ChatUtils {
    public static final UUID NIL_UUID = new UUID(0L, 0L);
    public static final MessageData NIL_MSG_DATA = new MessageData(new GameProfile(NIL_UUID, ""), Date.from(Instant.EPOCH), false);
    public static final int TIMESTAMP_INDEX = 0;
    public static final int MESSAGE_INDEX = 1;
    public static final int DUPE_INDEX = 2;
    public static final int MSG_TEAM_INDEX = 0;
    public static final int MSG_SENDER_INDEX = 1;
    public static final int MSG_CONTENT_INDEX = 2;

    public static class_2561 getPart(class_2561 message, int index) {
        return message.method_10855().size() > index ? (class_2561)message.method_10855().get(index) : class_2561.method_43473();
    }

    public static class_2561 getMsgPart(class_2561 message, int index) {
        return ChatUtils.getPart(ChatUtils.getPart(message, 1), index);
    }

    public static class_5250 getArg(class_2588 content, int index) {
        class_5348 arg;
        if (index < 0) {
            index = content.method_11023().length + index;
        }
        if ((arg = content.method_29434(index)) == null) {
            return class_2561.method_43473();
        }
        if (arg instanceof class_2561) {
            class_2561 t = (class_2561)arg;
            return (class_5250)t;
        }
        if (arg instanceof class_5348) {
            class_5348 sv = arg;
            return class_2561.method_43470((String)sv.getString());
        }
        if (arg instanceof String) {
            String s = (String)arg;
            return class_2561.method_43470((String)s);
        }
        return class_2561.method_43473();
    }

    public static class_5250 buildMessage(class_2583 rootStyle, class_2561 first, class_2561 second, class_2561 third) {
        class_5250 root = class_2561.method_43473();
        if (rootStyle != null && !rootStyle.equals((Object)class_2583.field_24360)) {
            root.method_10862(rootStyle);
        }
        first = (class_2561)Objects.requireNonNullElse(first, class_2561.method_43473());
        second = (class_2561)Objects.requireNonNullElse(second, class_2561.method_43473());
        third = (class_2561)Objects.requireNonNullElse(third, class_2561.method_43473());
        return root.method_10852(first).method_10852(second).method_10852(third);
    }

    public static class_2561 modifyMessage(@NotNull class_2561 m, boolean refreshing) {
        if (refreshing || Flags.LOADING_CHATLOG.isRaised()) {
            return m;
        }
        boolean lastEmpty = ChatPatches.msgData.equals(NIL_MSG_DATA);
        boolean boundary = Flags.BOUNDARY_LINE.isRaised() && ChatPatches.config.boundary && !ChatPatches.config.vanillaClearing;
        Date now = lastEmpty ? new Date() : ChatPatches.msgData.timestamp();
        String nowStr = String.valueOf(now.getTime());
        class_2583 style = m.method_10866();
        class_5250 timestamp = null;
        class_5250 content = m.method_27661();
        try {
            timestamp = ChatPatches.config.time && !boundary ? ChatPatches.config.makeTimestamp(now).method_10862(ChatPatches.config.makeHoverStyle(now)) : class_2561.method_43473().method_27694(s -> s.method_10975(nowStr));
            content = class_2561.method_43473().method_10862(style);
            if (!lastEmpty && !boundary && ChatPatches.msgData.vanilla()) {
                class_2588 ttc;
                class_7417 class_74172 = m.method_10851();
                if (class_74172 instanceof class_2588 && (ttc = (class_2588)class_74172).method_11022().matches("chat.type.(text|team.(text|sent))")) {
                    String key = ttc.method_11022();
                    if (key.startsWith("chat.type.team.")) {
                        class_5250 teamPart = class_2561.method_43473();
                        if (key.endsWith("sent")) {
                            teamPart.method_10852((class_2561)class_2561.method_43470((String)"-> ").method_10862(style));
                        }
                        teamPart.method_10852((class_2561)ChatUtils.getArg(ttc, 0).method_27693(" "));
                        content.method_10852((class_2561)teamPart);
                    } else {
                        content.method_27693("");
                    }
                    content.method_10852((class_2561)ChatPatches.config.formatPlayername(ChatPatches.msgData.sender()));
                    content.method_10852((class_2561)ChatUtils.getArg(ttc, -1));
                } else {
                    List parts = (List)class_156.method_654(new ArrayList(m.method_10855().size() + 1), a -> {
                        if (!m.equals(class_2561.field_25310)) {
                            a.add(m.method_27662().method_10862(style));
                        }
                        a.addAll(m.method_10855());
                    });
                    class_5250 realContent = class_2561.method_43473();
                    class_2561 firstPart = parts.stream().filter(p -> p.getString().contains(">")).findFirst().orElseThrow(() -> new IllegalStateException("No closing angle bracket found in vanilla message '" + m.getString() + "' !"));
                    String afterEndBracket = firstPart.getString().split(">")[1];
                    if (!afterEndBracket.isEmpty()) {
                        realContent.method_10852((class_2561)class_2561.method_43470((String)afterEndBracket).method_10862(firstPart.method_10866()));
                    }
                    for (int i = parts.indexOf(firstPart) + 1; i < parts.size(); ++i) {
                        realContent.method_10852((class_2561)parts.get(i));
                    }
                    content.method_10852((class_2561)ChatPatches.config.formatPlayername(ChatPatches.msgData.sender()));
                    content.method_10852((class_2561)realContent);
                }
            } else {
                content = m.method_27661();
            }
        }
        catch (Throwable e) {
            ChatPatches.LOGGER.error("[ChatUtils.modifyMessage] An error occurred while modifying message '{}', returning original:", (Object)m.getString());
            ChatPatches.LOGGER.debug("[ChatUtils.modifyMessage] \tOriginal message structure: {}", (Object)m);
            ChatPatches.LOGGER.debug("[ChatUtils.modifyMessage] \tModified message structure:");
            ChatPatches.LOGGER.debug("[ChatUtils.modifyMessage] \t\tTimestamp structure: {}", (Object)timestamp);
            ChatPatches.LOGGER.debug("[ChatUtils.modifyMessage] \t\tContent structure: {}", (Object)content);
            ChatPatches.logInfoReportMessage(e);
        }
        class_5250 modified = ChatUtils.buildMessage(style, (class_2561)timestamp, (class_2561)content, null);
        ChatLog.addMessage((class_2561)modified);
        ChatPatches.msgData = NIL_MSG_DATA;
        return modified;
    }

    public static class_2561 getCondensedMessage(class_2561 incoming, int index) {
        class_310 client = class_310.method_1551();
        class_338 chatHud = client.field_1705.method_1743();
        ChatHudAccessor chat = ChatHudAccessor.from(chatHud);
        List<class_303> messages = chat.chatpatches$getMessages();
        List<class_303.class_7590> visibleMessages = chat.chatpatches$getVisibleMessages();
        class_303 comparingLine = messages.get(index);
        List comparingParts = comparingLine.comp_893().method_10855();
        ArrayList<class_5250> incomingParts = new ArrayList<class_5250>(incoming.method_10855());
        class_2561 incMsg = (class_2561)incomingParts.get(1);
        class_2561 compMsg = (class_2561)comparingParts.get(1);
        boolean equalIgnoreCase = incMsg.getString().equalsIgnoreCase(compMsg.getString());
        if (equalIgnoreCase && (!ChatPatches.config.counterCheckStyle || TextUtils.copyWithoutContent(incMsg).equals((Object)TextUtils.copyWithoutContent(compMsg)))) {
            int dupes = (comparingParts.size() > 2 ? Integer.parseInt(((class_2561)comparingParts.get(2)).getString().replaceAll("(\u00a7[0-9a-fk-or])+", "").replaceAll("\\D", "").replaceAll("^$", "1")) : 1) + 1;
            if (incomingParts.size() > 2) {
                incomingParts.set(2, ChatPatches.config.makeDupeCounter(dupes));
            } else {
                incomingParts.add(2, ChatPatches.config.makeDupeCounter(dupes));
            }
            messages.remove(index);
            List<String> calcVisibles = class_341.method_1850((class_5348)comparingLine.comp_893(), (int)class_3532.method_15357((double)((double)chatHud.method_1811() / chatHud.method_1814())), (class_327)client.field_1772).stream().map(visible -> TextUtils.reorder(visible, ChatPatches.config.counterCheckStyle)).toList();
            if (ChatPatches.config.counterCompact) {
                visibleMessages.removeIf(hudLine -> calcVisibles.stream().anyMatch(ot -> ot.equalsIgnoreCase(TextUtils.reorder(hudLine.comp_896(), ChatPatches.config.counterCheckStyle))));
            } else {
                visibleMessages.remove(0);
                while (!visibleMessages.isEmpty() && !visibleMessages.get(0).comp_898()) {
                    visibleMessages.remove(0);
                }
            }
        }
        return incoming.method_27661();
    }

    public record MessageData(GameProfile sender, Date timestamp, boolean vanilla) {
    }
}

