/*
 * Decompiled with CFR 0.152.
 */
package obro1961.chatpatches.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.mojang.authlib.GameProfile;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_268;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import obro1961.chatpatches.ChatPatches;
import obro1961.chatpatches.config.YACLConfig;
import obro1961.chatpatches.util.ChatUtils;
import obro1961.chatpatches.util.RenderUtils;
import obro1961.chatpatches.util.TextUtils;

public class Config {
    public static final Path PATH = FabricLoader.getInstance().getConfigDir().resolve("chatpatches.json");
    public static final Config DEFAULTS = new Config();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public boolean time = true;
    public String timeDate = "HH:mm:ss";
    public String timeFormat = "[$]";
    public int timeColor = 0xFF55FF;
    public boolean hover = true;
    public String hoverDate = "MM/dd/yyyy";
    public String hoverFormat = "$";
    public int hoverColor = 0xFFFFFF;
    public boolean counter = true;
    public String counterFormat = "&8(&7x&r$&8)";
    public int counterColor = 0xFFFF55;
    public boolean counterCheckStyle = false;
    public boolean counterCompact = false;
    public int counterCompactDistance = 0;
    public boolean boundary = true;
    public String boundaryFormat = "&8[&r$&8]";
    public int boundaryColor = 0x55FFFF;
    public boolean chatlog = true;
    public int chatlogSaveInterval = 0;
    public boolean chatHidePacket = true;
    public int chatWidth = 0;
    public int chatMaxMessages = 16384;
    public String chatNameFormat = "<$>";
    public int chatNameColor = 0xFFFFFF;
    public int shiftChat = 10;
    public boolean messageDrafting = false;
    public boolean onlyInvasiveDrafting = false;
    public boolean searchDrafting = true;
    public boolean hideSearchButton = false;
    public boolean vanillaClearing = false;
    public int copyColor = 0x55FFFF;
    public String copyReplyFormat = "/msg $ ";

    public static Config create() {
        FabricLoader fbr = FabricLoader.getInstance();
        boolean accessibleInGame = fbr.isModLoaded("modmenu") || fbr.isModLoaded("catalogue") && fbr.isModLoaded("menulogue");
        ChatPatches.config = accessibleInGame ? new YACLConfig() : DEFAULTS;
        Config.read();
        Config.write();
        return ChatPatches.config;
    }

    public class_437 getConfigScreen(class_437 parent) {
        return null;
    }

    private class_5250 makeObject(String formatStr, String varStr, String prefix, String suffix, class_2583 style) {
        return TextUtils.text(prefix + TextUtils.fillVars(formatStr, varStr) + suffix).method_27696(RenderUtils.BLANK_STYLE.method_27702(style));
    }

    public class_5250 makeTimestamp(Date when) {
        return this.makeObject(this.timeFormat, new SimpleDateFormat(this.timeDate).format(when), "", " ", RenderUtils.BLANK_STYLE.method_36139(this.timeColor));
    }

    public class_2583 makeHoverStyle(Date when) {
        class_5250 hoverText = this.makeObject(this.hoverFormat, new SimpleDateFormat(this.hoverDate).format(when), "", "", RenderUtils.BLANK_STYLE.method_36139(this.hoverColor));
        return RenderUtils.BLANK_STYLE.method_10949(this.hover ? new class_2568(class_2568.class_5247.field_24342, (Object)hoverText) : null).method_10958(this.hover ? new class_2558(class_2558.class_2559.field_11745, hoverText.getString()) : null).method_10975(String.valueOf(when.getTime())).method_36139(this.timeColor);
    }

    public class_5250 formatPlayername(GameProfile profile) {
        class_2583 style = RenderUtils.BLANK_STYLE.method_36139(this.chatNameColor);
        try {
            class_1657 entity = class_310.method_1551().field_1687.method_18470(profile.getId());
            class_268 team = null;
            if (entity != null) {
                team = entity.method_7327().method_1164(profile.getName());
                style = entity.method_5476().method_10866().method_36139(entity.method_22861() != 0xFFFFFF ? entity.method_22861() : this.chatNameColor);
            }
            if (team != null) {
                class_5250 playername = TextUtils.text(profile.getName());
                String[] configFormat = this.chatNameFormat.split("\\$");
                class_5250 configPrefix = TextUtils.text(configFormat[0]);
                class_5250 configSuffix = TextUtils.text(configFormat[1] + " ");
                return class_2561.method_43473().method_10862(style).method_10852((class_2561)configPrefix).method_10852(team.method_1144()).method_10852((class_2561)playername).method_10852(team.method_1136()).method_10852((class_2561)configSuffix);
            }
        }
        catch (Exception e) {
            ChatPatches.LOGGER.error("[Config.formatPlayername] /!\\ An error occurred while trying to format '{}'s playername /!\\", (Object)profile.getName());
            ChatPatches.logInfoReportMessage(e);
        }
        return this.makeObject(this.chatNameFormat, profile.getName(), "", " ", style);
    }

    public class_5250 makeDupeCounter(int dupes) {
        return this.makeObject(this.counterFormat, Integer.toString(dupes), " ", "", RenderUtils.BLANK_STYLE.method_36139(this.counterColor));
    }

    public class_2561 makeBoundaryLine(String levelName) {
        class_5250 boundary = this.makeObject(this.boundaryFormat, levelName, "", "", RenderUtils.BLANK_STYLE.method_36139(this.boundaryColor));
        return ChatUtils.buildMessage(null, null, (class_2561)boundary, null);
    }

    public static void read() {
        if (!Files.exists(PATH, new LinkOption[0])) {
            ChatPatches.LOGGER.info("[Config.read] No config file found; using default values.");
        } else {
            try {
                String rawData = Files.readString(PATH);
                ChatPatches.config = (Config)GSON.fromJson(rawData, ChatPatches.config.getClass());
                ChatPatches.LOGGER.info("[Config.read] Loaded config info from '{}'!", (Object)PATH);
            }
            catch (JsonIOException | JsonSyntaxException e) {
                Config.writeCopy();
                Config.reset();
                ChatPatches.LOGGER.info("[Config.read] The config couldn't be loaded; copied old data and reset:", e);
            }
            catch (IOException e) {
                Config.reset();
                ChatPatches.LOGGER.error("[Config.read] An error occurred while trying to load config data from '{}':", (Object)PATH, (Object)e);
            }
        }
    }

    public static void write() {
        try (FileWriter fw = new FileWriter(PATH.toFile());){
            GSON.toJson((Object)ChatPatches.config, ChatPatches.config.getClass(), (Appendable)fw);
            ChatPatches.LOGGER.info("[Config.write] Saved config info to '{}'!", (Object)PATH);
        }
        catch (Exception e) {
            ChatPatches.LOGGER.error("[Config.write] An error occurred while trying to save the config to '{}':", (Object)PATH, (Object)e);
        }
    }

    public static void reset() {
        Config.getOptions().forEach(opt -> Config.getOption(opt.key).set(opt.def));
    }

    public static void writeCopy() {
        try {
            Files.copy(PATH, PATH.resolveSibling("chatpatches_" + ChatPatches.TIME_FORMATTER.get() + ".json"), new CopyOption[0]);
        }
        catch (IOException e) {
            ChatPatches.LOGGER.warn("[Config.writeCopy] An error occurred trying to write a copy of the original config file:", (Throwable)e);
        }
    }

    public static List<ConfigOption<?>> getOptions() {
        ArrayList options = new ArrayList(Config.class.getDeclaredFields().length);
        for (Field field : Config.class.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            options.add(Config.getOption(field.getName()));
        }
        return options;
    }

    public static <T> ConfigOption<T> getOption(String key) {
        try {
            return new ConfigOption<Object>(ChatPatches.config.getClass().getField(key).get(ChatPatches.config), ChatPatches.config.getClass().getField(key).get(DEFAULTS), key);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            ChatPatches.LOGGER.error("[Config.getOption({})] An error occurred while trying to get an option value!", (Object)key);
            ChatPatches.logInfoReportMessage(e);
            return new ConfigOption<Object>(new Object(), new Object(), key);
        }
    }

    public static class ConfigOption<T> {
        private T val;
        public final T def;
        public final String key;

        public ConfigOption(T val, T def, String key) {
            this.val = Objects.requireNonNull(val, "Cannot create a ConfigOption without a default value");
            this.def = Objects.requireNonNull(def, "Cannot create a ConfigOption without a default value");
            this.key = Objects.requireNonNull(key, "Cannot create a ConfigOption without a key");
        }

        public T get() {
            return this.val;
        }

        public Class<T> getType() {
            return this.def.getClass();
        }

        public void set(Object obj, boolean set) {
            try {
                Object inc = obj;
                if (inc != null && !inc.equals(this.val) && set) {
                    ChatPatches.config.getClass().getField(this.key).set(ChatPatches.config, inc);
                    this.val = inc;
                }
            }
            catch (ClassCastException | IllegalAccessException | NoSuchFieldException e) {
                ChatPatches.LOGGER.error("[ConfigOption.set({})] An error occurred trying to set a config option:", obj, (Object)e);
            }
        }

        public void set(Object obj) {
            this.set(obj, true);
        }

        public boolean changed() {
            return !this.val.equals(this.def);
        }
    }
}

