/*
 * Decompiled with CFR 0.152.
 */
package obro1961.chatpatches.chatlog;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_338;
import net.minecraft.class_7591;
import obro1961.chatpatches.ChatPatches;
import obro1961.chatpatches.util.Flags;

public class ChatLog {
    public static final Path PATH = FabricLoader.getInstance().getGameDir().resolve("logs").resolve("chatlog.json");
    public static final class_7591 RESTORED_TEXT = new class_7591(3682229, null, null, class_1074.method_4662((String)"text.chatpatches.restored", (Object[])new Object[0]));
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(class_2561.class, (src, type, context) -> class_2561.class_2562.method_10868((class_2561)src)).registerTypeAdapter(class_2561.class, (json, type, context) -> class_2561.class_2562.method_10872((JsonElement)json)).registerTypeAdapter(class_2561.class, type -> class_2561.method_43473()).create();
    private static boolean savedAfterCrash = false;
    private static Data data = new Data();
    private static int lastHistoryCount = -1;
    private static int lastMessageCount = -1;
    public static boolean loaded = false;
    public static int ticksUntilSave = ChatPatches.config.chatlogSaveInterval * 60 * 20;

    public static void deserialize() {
        String rawData = "{\"history\":[],\"messages\":[]}";
        if (Files.exists(PATH, new LinkOption[0])) {
            try {
                rawData = Files.readString(PATH);
            }
            catch (MalformedInputException notUTF8) {
                ChatPatches.LOGGER.warn("[ChatLog.deserialize] ChatLog file encoding was '{}', not UTF-8. Complex text characters may have been replaced with question marks.", (Object)Charset.defaultCharset().name());
                try {
                    Files.writeString(PATH, (CharSequence)new String(Files.readAllBytes(PATH)), StandardOpenOption.TRUNCATE_EXISTING);
                    rawData = Files.readString(PATH);
                }
                catch (IOException ioexc) {
                    ChatPatches.LOGGER.error("[ChatLog.deserialize] Couldn't rewrite the ChatLog at '{}', resetting:", (Object)PATH, (Object)ioexc);
                    try {
                        rawData = "{\"history\":[],\"messages\":[]}";
                        Files.writeString(PATH, (CharSequence)"{\"history\":[],\"messages\":[]}", StandardOpenOption.TRUNCATE_EXISTING);
                    }
                    catch (IOException ioerr) {
                        ChatPatches.LOGGER.error("[ChatLog.deserialize] Couldn't reset the ChatLog at '{}':", (Object)PATH, (Object)ioerr);
                    }
                }
            }
            catch (IOException e) {
                ChatPatches.LOGGER.error("[ChatLog.deserialize] Couldn't access the ChatLog at '{}':", (Object)PATH, (Object)e);
                rawData = "{\"history\":[],\"messages\":[]}";
            }
        } else {
            data = new Data();
            loaded = true;
            return;
        }
        if (rawData.length() < 2 || !rawData.startsWith("{")) {
            data = new Data();
            loaded = true;
            return;
        }
        try {
            data = (Data)GSON.fromJson(rawData, Data.class);
            ChatLog.removeOverflowData();
        }
        catch (JsonSyntaxException e) {
            ChatPatches.LOGGER.error("[ChatLog.deserialize] Tried to read the ChatLog and found an error, loading an empty one: ", (Throwable)e);
            data = new Data();
            loaded = true;
            return;
        }
        loaded = true;
        ChatPatches.LOGGER.info("[ChatLog.deserialize] Read the chat log containing {} messages and {} sent messages from '{}'", new Object[]{ChatLog.data.messages.size(), ChatLog.data.history.size(), PATH});
    }

    public static void serialize(boolean crashing) {
        if (!ChatPatches.config.chatlog) {
            return;
        }
        if (crashing && savedAfterCrash) {
            return;
        }
        if (ChatLog.data.messages.isEmpty() && ChatLog.data.history.isEmpty()) {
            return;
        }
        if (ChatLog.data.messages.size() == lastMessageCount && ChatLog.data.history.size() == lastHistoryCount) {
            return;
        }
        ChatLog.removeOverflowData();
        try {
            String str = GSON.toJson((Object)data, Data.class);
            Files.writeString(PATH, (CharSequence)str, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            lastHistoryCount = ChatLog.data.history.size();
            lastMessageCount = ChatLog.data.messages.size();
            ChatPatches.LOGGER.info("[ChatLog.serialize] Saved the chat log containing {} messages and {} sent messages to '{}'", new Object[]{ChatLog.data.messages.size(), ChatLog.data.history.size(), PATH});
        }
        catch (IOException e) {
            ChatPatches.LOGGER.error("[ChatLog.serialize] An I/O error occurred while trying to save the chat log:", (Throwable)e);
        }
        finally {
            if (crashing) {
                savedAfterCrash = true;
            }
        }
    }

    public static void backup() {
        try {
            Files.copy(PATH, PATH.resolveSibling("chatlog_" + ChatPatches.TIME_FORMATTER.get() + ".json"), new CopyOption[0]);
        }
        catch (IOException e) {
            ChatPatches.LOGGER.warn("[ChatLog.backup] Couldn't backup the chat log at '{}':", (Object)PATH, (Object)e);
        }
    }

    public static void restore(class_310 client) {
        Flags.LOADING_CHATLOG.raise();
        if (!ChatLog.data.history.isEmpty()) {
            ChatLog.data.history.forEach(arg_0 -> ((class_338)client.field_1705.method_1743()).method_1803(arg_0));
        }
        if (!ChatLog.data.messages.isEmpty()) {
            ChatLog.data.messages.forEach(msg -> client.field_1705.method_1743().method_44811(msg, null, RESTORED_TEXT));
        }
        Flags.LOADING_CHATLOG.lower();
        ChatPatches.LOGGER.info("[ChatLog.restore] Restored {} messages and {} history messages from '{}' into Minecraft!", new Object[]{ChatLog.data.messages.size(), ChatLog.data.history.size(), PATH});
    }

    public static void tickSaveCounter() {
        if (ChatPatches.config.chatlogSaveInterval > 0 && ticksUntilSave == 0) {
            ChatLog.serialize(false);
        }
        if (--ticksUntilSave < 0) {
            ticksUntilSave = ChatPatches.config.chatlogSaveInterval * 60 * 20;
        }
    }

    public static void addMessage(class_2561 msg) {
        if (ChatLog.data.messages.size() > ChatPatches.config.chatMaxMessages) {
            ChatLog.data.messages.remove(0);
        }
        ChatLog.data.messages.add(msg);
    }

    public static void addHistory(String msg) {
        if (ChatLog.data.history.size() > ChatPatches.config.chatMaxMessages) {
            ChatLog.data.history.remove(0);
        }
        ChatLog.data.history.add(msg);
    }

    public static void removeOverflowData() {
        if (ChatLog.data.messages.size() > ChatPatches.config.chatMaxMessages) {
            ChatLog.data.messages = ChatLog.data.messages.subList(ChatLog.data.messages.size() - ChatPatches.config.chatMaxMessages, ChatLog.data.messages.size());
        }
        if (ChatLog.data.history.size() > ChatPatches.config.chatMaxMessages) {
            ChatLog.data.history = ChatLog.data.history.subList(ChatLog.data.history.size() - ChatPatches.config.chatMaxMessages, ChatLog.data.history.size());
        }
    }

    public static void clearMessages() {
        ChatLog.data.messages.clear();
    }

    public static void clearHistory() {
        ChatLog.data.history.clear();
    }

    public static int messageCount() {
        return ChatLog.data.messages.size();
    }

    public static int historyCount() {
        return ChatLog.data.history.size();
    }

    private static class Data {
        public static final String EMPTY_DATA = "{\"history\":[],\"messages\":[]}";
        public static final int DEFAULT_SIZE = 100;
        public List<class_2561> messages = Lists.newArrayListWithExpectedSize((int)100);
        public List<String> history = Lists.newArrayListWithExpectedSize((int)100);

        private Data() {
        }
    }
}

