/*
 * Decompiled with CFR 0.152.
 */
package obro1961.chatpatches;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.function.Supplier;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_2960;
import net.minecraft.class_303;
import net.minecraft.class_310;
import net.minecraft.class_433;
import obro1961.chatpatches.accessor.ChatHudAccessor;
import obro1961.chatpatches.chatlog.ChatLog;
import obro1961.chatpatches.config.Config;
import obro1961.chatpatches.util.ChatUtils;
import obro1961.chatpatches.util.Flags;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatPatches
implements ClientModInitializer {
    public static final Supplier<String> TIME_FORMATTER = () -> new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date());
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Chat Patches");
    public static final String MOD_ID = "chatpatches";
    public static Config config = Config.create();
    public static ChatUtils.MessageData msgData = ChatUtils.NIL_MSG_DATA;
    private static String lastWorld = "";

    public void onInitializeClient() {
        ClientLifecycleEvents.CLIENT_STOPPING.register(client -> ChatLog.serialize(false));
        ScreenEvents.AFTER_INIT.register((client, screen, sW, sH) -> {
            if (ChatPatches.config.chatlogSaveInterval == 0 && (screen instanceof class_433 || !client.method_1569())) {
                ChatLog.serialize(false);
            }
        });
        ClientTickEvents.START_CLIENT_TICK.register(client -> ChatLog.tickSaveCounter());
        ClientPlayConnectionEvents.JOIN.register((network, packetSender, client) -> {
            if (ChatPatches.config.chatlog && !ChatLog.loaded) {
                ChatLog.deserialize();
                ChatLog.restore(client);
            }
            ChatHudAccessor chatHud = ChatHudAccessor.from(client);
            String current = ChatPatches.currentWorldName(client);
            if (!(!ChatPatches.config.boundary || chatHud.chatpatches$getMessages().isEmpty() || current.startsWith("S_") && lastWorld.startsWith("S_") && current.equals(lastWorld))) {
                try {
                    lastWorld = current;
                    String levelName = lastWorld.substring(2);
                    Flags.BOUNDARY_LINE.raise();
                    client.field_1705.method_1743().method_1812(config.makeBoundaryLine(levelName));
                    Flags.BOUNDARY_LINE.lower();
                }
                catch (Exception e) {
                    LOGGER.warn("[ChatPatches.boundary] An error occurred while adding the boundary line:", (Throwable)e);
                }
            }
            if (ChatLog.loaded && Flags.INIT.isRaised()) {
                chatHud.chatpatches$getVisibleMessages().replaceAll(ln -> new class_303.class_7590(0, ln.comp_896(), ln.comp_897(), ln.comp_898()));
                Flags.INIT.lower();
            }
        });
        LOGGER.info("[ChatPatches()] Finished setting up!");
    }

    public static void logInfoReportMessage(Throwable error) {
        StackWalker walker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
        String clazz = walker.getCallerClass().getSimpleName();
        String method = walker.walk(frames -> ((StackWalker.StackFrame)frames.skip(1L).findFirst().orElseThrow()).getMethodName());
        method = method.isBlank() ? error.getStackTrace()[0].getMethodName() : method;
        LOGGER.error("[%s.%s] /!\\ Please report this error on GitHub or Discord with the full log file attached! /!\\".formatted(clazz, method), error);
    }

    public static class_2960 id(String path) {
        return new class_2960(MOD_ID, path);
    }

    public static String currentWorldName(@NotNull class_310 client) {
        String entryName;
        Objects.requireNonNull(client, "MinecraftClient must exist to access client data:");
        return client.method_1496() ? "C_" + client.method_1576().method_27728().method_150() : ((entryName = client.method_1558().field_3752) == null || entryName.isBlank() ? "S_" + client.method_1558().field_3761 : "S_" + client.method_1558().field_3752);
    }
}

