/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms.custom;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kroppeb.stareval.element.ExpressionElement;
import kroppeb.stareval.expression.Expression;
import kroppeb.stareval.expression.VariableExpression;
import kroppeb.stareval.function.FunctionContext;
import kroppeb.stareval.function.FunctionReturn;
import kroppeb.stareval.function.Type;
import kroppeb.stareval.parser.Parser;
import kroppeb.stareval.resolver.ExpressionResolver;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.uniform.LocationalUniformHolder;
import net.coderbot.iris.gl.uniform.UniformHolder;
import net.coderbot.iris.parsing.IrisFunctions;
import net.coderbot.iris.parsing.IrisOptions;
import net.coderbot.iris.parsing.VectorType;
import net.coderbot.iris.uniforms.custom.CustomUniformFixedInputUniformsHolder;
import net.coderbot.iris.uniforms.custom.cached.CachedUniform;

public class CustomUniforms
implements FunctionContext {
    private final Map<String, CachedUniform> variables = new Object2ObjectLinkedOpenHashMap();
    private final Map<String, Expression> variablesExpressions = new Object2ObjectLinkedOpenHashMap();
    private final CustomUniformFixedInputUniformsHolder inputHolder;
    private final List<CachedUniform> uniforms = new ArrayList<CachedUniform>();
    private final List<CachedUniform> uniformOrder;
    private final Map<Object, Object2IntMap<CachedUniform>> locationMap = new Object2ObjectOpenHashMap();
    private final Map<CachedUniform, List<CachedUniform>> dependsOn;
    private final Map<CachedUniform, List<CachedUniform>> requiredBy;

    private CustomUniforms(CustomUniformFixedInputUniformsHolder customUniformFixedInputUniformsHolder, Map<String, Builder.Variable> map) {
        Object object;
        CachedUniform cachedUniform;
        this.inputHolder = customUniformFixedInputUniformsHolder;
        ExpressionResolver expressionResolver = new ExpressionResolver(IrisFunctions.functions, string -> {
            Type type = this.inputHolder.getType((String)string);
            if (type != null) {
                return type;
            }
            Builder.Variable variable = (Builder.Variable)map.get(string);
            if (variable != null) {
                return variable.type;
            }
            return null;
        }, true);
        for (Builder.Variable object22 : map.values()) {
            try {
                Expression expression = expressionResolver.resolveExpression(object22.type, object22.expression);
                cachedUniform = CachedUniform.forExpression(object22.name, object22.type, expression, this);
                this.addVariable(expression, cachedUniform);
                if (!object22.uniform) continue;
                this.uniforms.add(cachedUniform);
            }
            catch (Exception exception) {
                Iris.logger.warn("Failed to resolve uniform " + object22.name + ", reason: " + exception.getMessage() + " ( = " + object22.expression + ")", exception);
            }
        }
        this.dependsOn = new Object2ObjectOpenHashMap();
        this.requiredBy = new Object2ObjectOpenHashMap();
        Object2IntOpenHashMap object2IntOpenHashMap = new Object2IntOpenHashMap();
        for (CachedUniform cachedUniform2 : this.inputHolder.getAll()) {
            this.requiredBy.put(cachedUniform2, (List<CachedUniform>)new ObjectArrayList());
        }
        for (CachedUniform cachedUniform3 : this.variables.values()) {
            this.requiredBy.put(cachedUniform3, (List<CachedUniform>)new ObjectArrayList());
        }
        FunctionReturn functionReturn = new FunctionReturn();
        ObjectOpenHashSet objectOpenHashSet = new ObjectOpenHashSet();
        cachedUniform = new ObjectOpenHashSet();
        for (Map.Entry<String, Expression> entry2 : this.variablesExpressions.entrySet()) {
            objectOpenHashSet.clear();
            entry2.getValue().listVariables((Collection<? super VariableExpression>)objectOpenHashSet);
            if (objectOpenHashSet.isEmpty()) continue;
            object = this.variables.get(entry2.getKey());
            ArrayList<CachedUniform> arrayList = new ArrayList<CachedUniform>();
            for (VariableExpression variableExpression : objectOpenHashSet) {
                Expression expression = variableExpression.partialEval(this, functionReturn);
                if (expression instanceof CachedUniform) {
                    arrayList.add((CachedUniform)expression);
                    continue;
                }
                cachedUniform.add(object);
            }
            if (arrayList.isEmpty()) continue;
            this.dependsOn.put((CachedUniform)object, arrayList);
            object2IntOpenHashMap.put(object, arrayList.size());
            for (VariableExpression variableExpression : arrayList) {
                this.requiredBy.get(variableExpression).add((CachedUniform)object);
            }
        }
        ObjectArrayList objectArrayList = new ObjectArrayList();
        ObjectArrayList objectArrayList2 = new ObjectArrayList();
        for (CachedUniform cachedUniform4 : this.requiredBy.keySet()) {
            if (object2IntOpenHashMap.containsKey((Object)cachedUniform4)) continue;
            objectArrayList2.add(cachedUniform4);
        }
        while (!objectArrayList2.isEmpty()) {
            object = (CachedUniform)objectArrayList2.remove(objectArrayList2.size() - 1);
            if (!cachedUniform.contains(object)) {
                objectArrayList.add(object);
            } else {
                cachedUniform.addAll((Collection)this.requiredBy.get(object));
            }
            for (CachedUniform cachedUniform5 : this.requiredBy.get(object)) {
                int n = object2IntOpenHashMap.mergeInt((Object)cachedUniform5, -1, Integer::sum);
                assert (n >= 0);
                if (n != 0) continue;
                objectArrayList2.add(cachedUniform5);
                object2IntOpenHashMap.removeInt((Object)cachedUniform5);
            }
        }
        if (!cachedUniform.isEmpty()) {
            Iris.logger.warn("The following uniforms won't work, either because they are broken, or reference a broken uniform: \n" + cachedUniform.stream().map(CachedUniform::getName).collect(Collectors.joining(", ")));
        }
        if (!object2IntOpenHashMap.isEmpty()) {
            throw new IllegalStateException("Circular reference detected between: " + object2IntOpenHashMap.object2IntEntrySet().stream().map(entry -> ((CachedUniform)entry.getKey()).getName() + " (" + entry.getIntValue() + ")").collect(Collectors.joining(", ")));
        }
        this.uniformOrder = objectArrayList;
    }

    private void addVariable(Expression expression, CachedUniform cachedUniform) throws Exception {
        String string = cachedUniform.getName();
        if (this.variables.containsKey(string)) {
            throw new Exception("Duplicated variable: " + string);
        }
        if (this.inputHolder.containsKey(string)) {
            throw new Exception("Variable shadows build in uniform: " + string);
        }
        this.variables.put(string, cachedUniform);
        this.variablesExpressions.put(string, expression);
    }

    public void assignTo(LocationalUniformHolder locationalUniformHolder) {
        Object2IntOpenHashMap object2IntOpenHashMap = new Object2IntOpenHashMap();
        for (CachedUniform cachedUniform : this.uniformOrder) {
            try {
                OptionalInt optionalInt = locationalUniformHolder.location(cachedUniform.getName(), Type.convert(cachedUniform.getType()));
                if (!optionalInt.isPresent()) continue;
                object2IntOpenHashMap.put((Object)cachedUniform, optionalInt.getAsInt());
            }
            catch (Exception exception) {
                throw new RuntimeException(cachedUniform.getName(), exception);
            }
        }
        this.locationMap.put(locationalUniformHolder, (Object2IntMap<CachedUniform>)object2IntOpenHashMap);
    }

    public void mapholderToPass(LocationalUniformHolder locationalUniformHolder, Object object) {
        this.locationMap.put(object, this.locationMap.remove(locationalUniformHolder));
    }

    public void update() {
        for (CachedUniform cachedUniform : this.uniformOrder) {
            cachedUniform.update();
        }
    }

    public void push(Object object) {
        Object2IntMap<CachedUniform> object2IntMap = this.locationMap.get(object);
        if (object2IntMap != null) {
            object2IntMap.forEach(CachedUniform::pushIfChanged);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void optimise() {
        void var3_7;
        Object2IntOpenHashMap object2IntOpenHashMap = new Object2IntOpenHashMap();
        for (List<CachedUniform> object2IntMap : this.dependsOn.values()) {
            for (Object object2 : object2IntMap) {
                object2IntOpenHashMap.mergeInt(object2, 1, Integer::sum);
            }
        }
        for (Object2IntMap object2IntMap : this.locationMap.values()) {
            for (Object object2 : object2IntMap.keySet()) {
                object2IntOpenHashMap.mergeInt(object2, 1, Integer::sum);
            }
        }
        ObjectOpenHashSet objectOpenHashSet = new ObjectOpenHashSet();
        int n2 = this.uniformOrder.size() - 1;
        while (var3_7 >= 0) {
            Object object = this.uniformOrder.get((int)var3_7);
            if (!object2IntOpenHashMap.containsKey(object)) {
                Object object2;
                objectOpenHashSet.add(object);
                object2 = this.dependsOn.get(object);
                if (object2 != null) {
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        CachedUniform cachedUniform2 = (CachedUniform)iterator.next();
                        object2IntOpenHashMap.computeIntIfPresent((Object)cachedUniform2, (cachedUniform, n) -> n - 1);
                    }
                }
            }
            --var3_7;
        }
        this.uniformOrder.removeAll((Collection<?>)objectOpenHashSet);
    }

    @Override
    public boolean hasVariable(String string) {
        return this.inputHolder.containsKey(string) || this.variables.containsKey(string);
    }

    @Override
    public Expression getVariable(String string) {
        CachedUniform cachedUniform = this.inputHolder.getUniform(string);
        if (cachedUniform != null) {
            return cachedUniform;
        }
        CachedUniform cachedUniform2 = this.variables.get(string);
        if (cachedUniform2 != null) {
            return cachedUniform2;
        }
        throw new RuntimeException("Unknown variable: " + string);
    }

    public static class Builder {
        Map<String, Variable> variables = new Object2ObjectLinkedOpenHashMap();
        private static final Map<String, Type> types = new ImmutableMap.Builder().put((Object)"bool", (Object)Type.Boolean).put((Object)"float", (Object)Type.Float).put((Object)"int", (Object)Type.Int).put((Object)"vec2", VectorType.VEC2).put((Object)"vec3", VectorType.VEC3).put((Object)"vec4", VectorType.VEC4).build();

        public void addVariable(String string, String string2, String string3, boolean bl) {
            if (this.variables.containsKey(string2)) {
                Iris.logger.warn("Ignoring duplicated custom uniform name: " + string2);
                return;
            }
            Type type = types.get(string);
            if (type == null) {
                Iris.logger.warn("Ignoring invalid uniform type: " + string + " of " + string2);
                return;
            }
            try {
                ExpressionElement expressionElement = Parser.parse(string3, IrisOptions.options);
                this.variables.put(string2, new Variable(type, string2, expressionElement, bl));
            }
            catch (Exception exception) {
                Iris.logger.warn("Failed to parse custom variable/uniform " + string2 + " with expression " + string3, exception);
            }
        }

        public CustomUniforms build(CustomUniformFixedInputUniformsHolder customUniformFixedInputUniformsHolder) {
            Iris.logger.info("Starting custom uniform resolving");
            return new CustomUniforms(customUniformFixedInputUniformsHolder, this.variables);
        }

        @SafeVarargs
        public final CustomUniforms build(Consumer<UniformHolder> ... consumerArray) {
            CustomUniformFixedInputUniformsHolder.Builder builder = new CustomUniformFixedInputUniformsHolder.Builder();
            for (Consumer<UniformHolder> consumer : consumerArray) {
                consumer.accept(builder);
            }
            return this.build(builder.build());
        }

        private static class Variable {
            public final Type type;
            public final String name;
            public final ExpressionElement expression;
            public final boolean uniform;

            public Variable(Type type, String string, ExpressionElement expressionElement, boolean bl) {
                this.type = type;
                this.name = string;
                this.expression = expressionElement;
                this.uniform = bl;
            }
        }
    }
}

