/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.mixin.vertex_format;

import java.nio.ByteBuffer;
import me.jellysquid.mods.sodium.client.render.vertex.buffer.ExtendedBufferBuilder;
import me.jellysquid.mods.sodium.client.render.vertex.buffer.SodiumBufferBuilder;
import net.caffeinemc.mods.sodium.api.vertex.attributes.common.NormalAttribute;
import net.caffeinemc.mods.sodium.api.vertex.attributes.common.PositionAttribute;
import net.caffeinemc.mods.sodium.api.vertex.format.VertexFormatDescription;
import net.coderbot.iris.compat.sodium.impl.vertex_format.IrisCommonVertexAttributes;
import net.coderbot.iris.compat.sodium.impl.vertex_format.SodiumBufferBuilderPolygonView;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.vertices.BlockSensitiveBufferBuilder;
import net.coderbot.iris.vertices.ExtendedDataHelper;
import net.coderbot.iris.vertices.IrisExtendedBufferBuilder;
import net.coderbot.iris.vertices.NormI8;
import net.coderbot.iris.vertices.NormalHelper;
import net.minecraft.class_287;
import net.minecraft.class_293;
import org.joml.Vector3f;
import org.lwjgl.system.MemoryUtil;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SodiumBufferBuilder.class})
public abstract class MixinSodiumBufferBuilder
implements BlockSensitiveBufferBuilder {
    @Shadow
    @Final
    private static int ATTRIBUTE_NOT_PRESENT;
    @Shadow
    @Final
    private static int ATTRIBUTE_NORMAL_BIT;
    @Shadow
    @Final
    private ExtendedBufferBuilder builder;
    @Shadow
    private int attributeOffsetPosition;
    @Shadow
    private int attributeOffsetTexture;
    @Shadow
    private int attributeOffsetNormal;
    @Shadow
    private int requiredAttributes;
    @Shadow
    private int writtenAttributes;
    @Unique
    private static final int ATTRIBUTE_TANGENT_BIT;
    @Unique
    private static final int ATTRIBUTE_MID_TEX_COORD_BIT;
    @Unique
    private static final int ATTRIBUTE_BLOCK_ID_BIT;
    @Unique
    private static final int ATTRIBUTE_ENTITY_ID_BIT;
    @Unique
    private static final int ATTRIBUTE_MID_BLOCK_BIT;
    @Unique
    private int attributeOffsetTangent;
    @Unique
    private int attributeOffsetMidTexCoord;
    @Unique
    private int attributeOffsetBlockId;
    @Unique
    private int attributeOffsetEntityId;
    @Unique
    private int attributeOffsetMidBlock;
    @Unique
    private final SodiumBufferBuilderPolygonView polygon = new SodiumBufferBuilderPolygonView();
    @Unique
    private final Vector3f normal = new Vector3f();

    @Shadow
    public abstract class_287 getOriginalBufferBuilder();

    @Shadow
    abstract void putNormalAttribute(int var1);

    @Unique
    private void putBlockIdAttribute(short s, short s2) {
        if (this.attributeOffsetBlockId == ATTRIBUTE_NOT_PRESENT) {
            return;
        }
        long l = MemoryUtil.memAddress((ByteBuffer)this.builder.sodium$getBuffer(), (int)(this.builder.sodium$getElementOffset() + this.attributeOffsetBlockId));
        MemoryUtil.memPutShort((long)l, (short)s);
        MemoryUtil.memPutShort((long)(l + 2L), (short)s2);
        this.writtenAttributes |= ATTRIBUTE_BLOCK_ID_BIT;
    }

    @Unique
    private void putEntityIdAttribute(short s, short s2, short s3) {
        if (this.attributeOffsetEntityId == ATTRIBUTE_NOT_PRESENT) {
            return;
        }
        long l = MemoryUtil.memAddress((ByteBuffer)this.builder.sodium$getBuffer(), (int)(this.builder.sodium$getElementOffset() + this.attributeOffsetEntityId));
        MemoryUtil.memPutShort((long)l, (short)s);
        MemoryUtil.memPutShort((long)(l + 2L), (short)s2);
        MemoryUtil.memPutShort((long)(l + 4L), (short)s3);
        this.writtenAttributes |= ATTRIBUTE_ENTITY_ID_BIT;
    }

    @Unique
    private void putMidBlockAttribute(int n) {
        if (this.attributeOffsetMidBlock == ATTRIBUTE_NOT_PRESENT) {
            return;
        }
        long l = MemoryUtil.memAddress((ByteBuffer)this.builder.sodium$getBuffer(), (int)(this.builder.sodium$getElementOffset() + this.attributeOffsetMidBlock));
        MemoryUtil.memPutInt((long)l, (int)n);
        this.writtenAttributes |= ATTRIBUTE_MID_BLOCK_BIT;
    }

    @Override
    public void beginBlock(short s, short s2, int n, int n2, int n3) {
        ((BlockSensitiveBufferBuilder)this.getOriginalBufferBuilder()).beginBlock(s, s2, n, n2, n3);
    }

    @Override
    public void endBlock() {
        ((BlockSensitiveBufferBuilder)this.getOriginalBufferBuilder()).endBlock();
    }

    @Inject(method={"resetAttributeBindings"}, at={@At(value="RETURN")}, remap=false)
    private void onResetAttributeBindings(CallbackInfo callbackInfo) {
        this.attributeOffsetTangent = ATTRIBUTE_NOT_PRESENT;
        this.attributeOffsetMidTexCoord = ATTRIBUTE_NOT_PRESENT;
        this.attributeOffsetBlockId = ATTRIBUTE_NOT_PRESENT;
        this.attributeOffsetEntityId = ATTRIBUTE_NOT_PRESENT;
        this.attributeOffsetMidBlock = ATTRIBUTE_NOT_PRESENT;
    }

    @Inject(method={"updateAttributeBindings"}, at={@At(value="RETURN")}, remap=false)
    private void onUpdateAttributeBindings(VertexFormatDescription vertexFormatDescription, CallbackInfo callbackInfo) {
        if (vertexFormatDescription.containsElement(IrisCommonVertexAttributes.TANGENT)) {
            this.requiredAttributes |= ATTRIBUTE_TANGENT_BIT;
            this.attributeOffsetTangent = vertexFormatDescription.getElementOffset(IrisCommonVertexAttributes.TANGENT);
        }
        if (vertexFormatDescription.containsElement(IrisCommonVertexAttributes.MID_TEX_COORD)) {
            this.requiredAttributes |= ATTRIBUTE_MID_TEX_COORD_BIT;
            this.attributeOffsetMidTexCoord = vertexFormatDescription.getElementOffset(IrisCommonVertexAttributes.MID_TEX_COORD);
        }
        if (vertexFormatDescription.containsElement(IrisCommonVertexAttributes.BLOCK_ID)) {
            this.requiredAttributes |= ATTRIBUTE_BLOCK_ID_BIT;
            this.attributeOffsetBlockId = vertexFormatDescription.getElementOffset(IrisCommonVertexAttributes.BLOCK_ID);
        }
        if (vertexFormatDescription.containsElement(IrisCommonVertexAttributes.ENTITY_ID)) {
            this.requiredAttributes |= ATTRIBUTE_ENTITY_ID_BIT;
            this.attributeOffsetEntityId = vertexFormatDescription.getElementOffset(IrisCommonVertexAttributes.ENTITY_ID);
        }
        if (vertexFormatDescription.containsElement(IrisCommonVertexAttributes.MID_BLOCK)) {
            this.requiredAttributes |= ATTRIBUTE_MID_BLOCK_BIT;
            this.attributeOffsetMidBlock = vertexFormatDescription.getElementOffset(IrisCommonVertexAttributes.MID_BLOCK);
        }
    }

    @Inject(method={"endVertex"}, at={@At(value="HEAD")})
    private void onEndVertex(CallbackInfo callbackInfo) {
        IrisExtendedBufferBuilder irisExtendedBufferBuilder = (IrisExtendedBufferBuilder)this.builder;
        if (!irisExtendedBufferBuilder.iris$extending()) {
            return;
        }
        if (irisExtendedBufferBuilder.iris$injectNormalAndUV1() && (this.writtenAttributes & ATTRIBUTE_NORMAL_BIT) == 0) {
            this.putNormalAttribute(0);
        }
        if (irisExtendedBufferBuilder.iris$isTerrain()) {
            this.putBlockIdAttribute(irisExtendedBufferBuilder.iris$currentBlock(), irisExtendedBufferBuilder.iris$currentRenderType());
        } else {
            this.putEntityIdAttribute((short)CapturedRenderingState.INSTANCE.getCurrentRenderedEntity(), (short)CapturedRenderingState.INSTANCE.getCurrentRenderedBlockEntity(), (short)CapturedRenderingState.INSTANCE.getCurrentRenderedItem());
        }
        this.writtenAttributes |= ATTRIBUTE_MID_TEX_COORD_BIT;
        this.writtenAttributes |= ATTRIBUTE_TANGENT_BIT;
        if (irisExtendedBufferBuilder.iris$isTerrain()) {
            long l = MemoryUtil.memAddress((ByteBuffer)this.builder.sodium$getBuffer(), (int)(this.builder.sodium$getElementOffset() + this.attributeOffsetPosition));
            float f = PositionAttribute.getX((long)l);
            float f2 = PositionAttribute.getY((long)l);
            float f3 = PositionAttribute.getZ((long)l);
            this.putMidBlockAttribute(ExtendedDataHelper.computeMidBlock(f, f2, f3, irisExtendedBufferBuilder.iris$currentLocalPosX(), irisExtendedBufferBuilder.iris$currentLocalPosY(), irisExtendedBufferBuilder.iris$currentLocalPosZ()));
        }
        irisExtendedBufferBuilder.iris$incrementVertexCount();
        class_293.class_5596 class_55962 = irisExtendedBufferBuilder.iris$mode();
        int n = irisExtendedBufferBuilder.iris$vertexCount();
        if (class_55962 == class_293.class_5596.field_27382 && n == 4 || class_55962 == class_293.class_5596.field_27379 && n == 3) {
            this.fillExtendedData(n);
        }
    }

    @Unique
    private void fillExtendedData(int n) {
        int n2;
        IrisExtendedBufferBuilder irisExtendedBufferBuilder = (IrisExtendedBufferBuilder)this.builder;
        irisExtendedBufferBuilder.iris$resetVertexCount();
        int n3 = irisExtendedBufferBuilder.iris$format().method_1362();
        long l = MemoryUtil.memAddress((ByteBuffer)this.builder.sodium$getBuffer(), (int)this.builder.sodium$getElementOffset());
        this.polygon.setup(l, this.attributeOffsetPosition, this.attributeOffsetTexture, n3, n);
        float f = 0.0f;
        float f2 = 0.0f;
        for (n2 = 0; n2 < n; ++n2) {
            f += this.polygon.u(n2);
            f2 += this.polygon.v(n2);
        }
        f /= (float)n;
        f2 /= (float)n;
        if (n == 3) {
            for (n2 = 0; n2 < n; ++n2) {
                int n4 = NormalAttribute.get((long)(l + (long)this.attributeOffsetNormal - (long)(n3 * n2)));
                int n5 = NormalHelper.computeTangentSmooth(NormI8.unpackX(n4), NormI8.unpackY(n4), NormI8.unpackZ(n4), this.polygon);
                MemoryUtil.memPutFloat((long)(l + (long)this.attributeOffsetMidTexCoord - (long)(n3 * n2)), (float)f);
                MemoryUtil.memPutFloat((long)(l + (long)this.attributeOffsetMidTexCoord + 4L - (long)(n3 * n2)), (float)f2);
                MemoryUtil.memPutInt((long)(l + (long)this.attributeOffsetTangent - (long)(n3 * n2)), (int)n5);
            }
        } else {
            NormalHelper.computeFaceNormal(this.normal, this.polygon);
            n2 = NormI8.pack(this.normal.x, this.normal.y, this.normal.z, 0.0f);
            int n6 = NormalHelper.computeTangent(this.normal.x, this.normal.y, this.normal.z, this.polygon);
            for (int i = 0; i < n; ++i) {
                MemoryUtil.memPutFloat((long)(l + (long)this.attributeOffsetMidTexCoord - (long)(n3 * i)), (float)f);
                MemoryUtil.memPutFloat((long)(l + (long)this.attributeOffsetMidTexCoord + 4L - (long)(n3 * i)), (float)f2);
                MemoryUtil.memPutInt((long)(l + (long)this.attributeOffsetNormal - (long)(n3 * i)), (int)n2);
                MemoryUtil.memPutInt((long)(l + (long)this.attributeOffsetTangent - (long)(n3 * i)), (int)n6);
            }
        }
    }

    static {
        ATTRIBUTE_TANGENT_BIT = 1 << IrisCommonVertexAttributes.TANGENT.ordinal();
        ATTRIBUTE_MID_TEX_COORD_BIT = 1 << IrisCommonVertexAttributes.MID_TEX_COORD.ordinal();
        ATTRIBUTE_BLOCK_ID_BIT = 1 << IrisCommonVertexAttributes.BLOCK_ID.ordinal();
        ATTRIBUTE_ENTITY_ID_BIT = 1 << IrisCommonVertexAttributes.ENTITY_ID.ordinal();
        ATTRIBUTE_MID_BLOCK_BIT = 1 << IrisCommonVertexAttributes.MID_BLOCK.ordinal();
    }
}

