/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ksyxis;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.launch.MixinBootstrap;
import org.spongepowered.asm.mixin.Mixins;

public final class Ksyxis {
    private static final Logger LOG = LogManager.getLogger((String)"Ksyxis");
    private static final String MIXIN_ABSENT = "Ksyxis: No Mixin found. If you're using old (1.15.2 or older) Forge, please install a Mixin loader, for example MixinBootstrap, MixinBooter, UniMixins, or any other if you find. If you're using new (1.16 or newer) Forge, any Fabric, any Quilt, or any NeoForge, then something went wrong and you should report it on GitHub. If you don't want any hassles and just want to load the game without solving anything, delete the Ksyxis mod.";
    private static final String MIXIN_INJECT = "Ksyxis: Unable to inject the Ksyxis configuration. It's probably a bug or something, you should report it on GitHub. If you don't want any hassles and just want to load the game without solving anything, delete the Ksyxis mod.";
    private static int loadedChunks = 0;

    private Ksyxis() {
        throw new AssertionError((Object)"No instances.");
    }

    public static void legacyInit() {
        Ksyxis.verifyMixins();
        try {
            MixinBootstrap.init();
            Mixins.addConfiguration((String)"ksyxis.mixins.json");
        }
        catch (Throwable t) {
            LOG.error(MIXIN_INJECT, t);
            try {
                Class<?> tinyFd = Class.forName("org.lwjgl.util.tinyfd.TinyFileDialogs");
                Method tinyFdMessageBox = tinyFd.getMethod("tinyfd_messageBox", CharSequence.class, CharSequence.class, CharSequence.class, CharSequence.class, Boolean.TYPE);
                tinyFdMessageBox.invoke(null, "Minecraft | Ksyxis Mod", MIXIN_INJECT, "ok", "error", false);
            }
            catch (Throwable th) {
                t.addSuppressed(th);
            }
            try {
                Class<?> sys = Class.forName("org.lwjgl.Sys");
                Method sysAlert = sys.getMethod("alert", String.class, String.class);
                sysAlert.invoke(null, "Minecraft | Ksyxis Mod", MIXIN_INJECT);
            }
            catch (Throwable th) {
                t.addSuppressed(th);
            }
            LOG.error(MIXIN_INJECT, t);
            throw new RuntimeException(MIXIN_INJECT, t);
        }
        LOG.info("Ksyxis feels the passing of time, because it had to manually inject Mixin configuration. Hey, it's okay, it'll still will speedup your world loading and still may break everything...");
    }

    public static void init() {
        Ksyxis.verifyMixins();
        try {
            Class<?> modernFixPluginClass = Class.forName("org.embeddedt.modernfix.core.ModernFixMixinPlugin");
            Field modernFixPluginField = modernFixPluginClass.getDeclaredField("instance");
            Method modernFixIsOptionEnabled = modernFixPluginClass.getMethod("isOptionEnabled", String.class);
            Object modernFix = modernFixPluginField.get(null);
            boolean removeSpawnChunks = (Boolean)modernFixIsOptionEnabled.invoke(modernFix, "perf.remove_spawn_chunks.MinecraftServer");
            if (removeSpawnChunks) {
                loadedChunks = 441;
                LOG.info("Ksyxis will report 441 loaded chunks to prevent deadlocks with ModernFix.");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        LOG.info("Ksyxis will speedup your world loading, but may break everything :P");
    }

    public static int loadedChunks() {
        return loadedChunks;
    }

    public static void world() {
        LOG.info("Hey. This is Ksyxis. We will now load the world and will try to do it quickly. If the game is not responding after this, it's probably us to blame. (Or delete for good)");
    }

    private static void verifyMixins() {
        try {
            Class.forName("org.spongepowered.asm.mixin.Mixin");
            LOG.info("Ksyxis found Mixin library.");
        }
        catch (Throwable t) {
            LOG.error(MIXIN_ABSENT, t);
            try {
                Class<?> tinyFd = Class.forName("org.lwjgl.util.tinyfd.TinyFileDialogs");
                Method tinyFdMessageBox = tinyFd.getMethod("tinyfd_messageBox", CharSequence.class, CharSequence.class, CharSequence.class, CharSequence.class, Boolean.TYPE);
                tinyFdMessageBox.invoke(null, "Minecraft | Ksyxis Mod", MIXIN_ABSENT, "ok", "error", false);
            }
            catch (Throwable th) {
                t.addSuppressed(th);
            }
            try {
                Class<?> sys = Class.forName("org.lwjgl.Sys");
                Method sysAlert = sys.getMethod("alert", String.class, String.class);
                sysAlert.invoke(null, "Minecraft | Ksyxis Mod", MIXIN_ABSENT);
            }
            catch (Throwable th) {
                t.addSuppressed(th);
            }
            LOG.error(MIXIN_ABSENT, t);
            throw new RuntimeException(MIXIN_ABSENT, t);
        }
    }
}

