/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.mc249136;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.imageio.ImageIO;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageReference {
    private final Logger log = LoggerFactory.getLogger(ImageReference.class);
    private final String imagePath;
    private WeakReference<BufferedImage> imageReference = null;

    public ImageReference(String imagePath) {
        this.imagePath = imagePath;
        this.getImage();
    }

    public BufferedImage getImage() {
        BufferedImage image;
        if (this.imageReference != null && (image = (BufferedImage)this.imageReference.get()) != null) {
            return image;
        }
        image = this.readImage();
        this.imageReference = new WeakReference<BufferedImage>(image);
        return image;
    }

    private BufferedImage readImage() {
        BufferedImage image;
        InputStream inputStream;
        Path configPath = this.getConfigPath();
        File configFile = configPath.toFile();
        if (Files.exists(configPath, new LinkOption[0])) {
            try {
                return ImageIO.read(configFile);
            }
            catch (Exception e) {
                this.log.error("Unable to read image path: " + this.imagePath, (Throwable)e);
            }
        }
        try {
            inputStream = ImageReference.class.getResourceAsStream(this.getResourcePath());
            try {
                image = ImageIO.read(inputStream);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (Exception e) {
            this.log.error("Unable to read image resource: " + this.imagePath, (Throwable)e);
            return null;
        }
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            Files.createFile(configPath, new FileAttribute[0]);
        }
        catch (Exception e) {
            this.log.error("Error creating file: " + this.imagePath, (Throwable)e);
            return image;
        }
        try {
            inputStream = ImageReference.class.getResourceAsStream(this.getResourcePath());
            try (FileOutputStream outputStream = new FileOutputStream(configFile);){
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (Exception e) {
            this.log.error("Error writing to file: " + this.imagePath, (Throwable)e);
        }
        return image;
    }

    private Path getConfigPath() {
        return FabricLoader.getInstance().getConfigDir().resolve("mc249136").resolve(this.imagePath);
    }

    private String getResourcePath() {
        return "/assets/mc249136/" + this.imagePath;
    }
}

