/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.recursiveresources.pack;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_521;
import net.minecraft.class_5352;
import net.minecraft.class_5369;
import nl.enjarai.recursiveresources.RecursiveResources;
import nl.enjarai.recursiveresources.gui.ResourcePackFolderEntry;
import nl.enjarai.recursiveresources.pack.FolderedPackSource;
import nl.enjarai.recursiveresources.util.ResourcePackUtils;
import org.slf4j.Logger;

public record FolderMeta(Path icon, String description, List<Path> packs, boolean hidden) {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path DUMMY_ROOT_PATH = Path.of("/", new String[0]);
    private static final Path EMPTY_PATH = Path.of("", new String[0]);
    public static final Codec<FolderMeta> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.xmap(x$0 -> Path.of(x$0, new String[0]), Path::toString).fieldOf("icon").forGetter(FolderMeta::icon), (App)Codec.STRING.fieldOf("description").forGetter(FolderMeta::description), (App)Codec.STRING.xmap(x$0 -> Path.of(x$0, new String[0]), Path::toString).listOf().fieldOf("packs").forGetter(FolderMeta::packs), (App)Codec.BOOL.fieldOf("hidden").forGetter(FolderMeta::hidden)).apply((Applicative)instance, FolderMeta::new));
    public static final FolderMeta DEFAULT = new FolderMeta(Path.of("icon.png", new String[0]), "", List.of(), false);
    public static final String META_FILE_NAME = "folder.json";

    public static FolderMeta loadMetaFile(List<Path> roots, Path folder) {
        for (Path root : roots) {
            Path rootedFolder = root.resolve(folder);
            Path metaFile = rootedFolder.resolve(META_FILE_NAME);
            if (!Files.exists(rootedFolder, new LinkOption[0]) || !Files.isDirectory(rootedFolder, new LinkOption[0])) continue;
            FolderMeta meta = DEFAULT;
            if (Files.exists(metaFile, new LinkOption[0])) {
                meta = FolderMeta.load(metaFile);
            }
            try (Stream<Path> packs = Files.list(rootedFolder);){
                meta = meta.getRefreshed(packs.filter(ResourcePackUtils::isPack).map(Path::normalize).map(rootedFolder::relativize).toList());
                meta.save(metaFile);
            }
            catch (Exception e) {
                RecursiveResources.LOGGER.error("Failed to process meta file for folder " + folder, (Throwable)e);
            }
            return meta;
        }
        return DEFAULT;
    }

    private static Path relativiseRelativePath(Path folder, Path path) {
        Path packPath = DUMMY_ROOT_PATH.resolve(path);
        Path folderPath = DUMMY_ROOT_PATH.resolve(folder);
        return folderPath.relativize(packPath);
    }

    public static FolderMeta load(Path metaFile) {
        FolderMeta folderMeta;
        block8: {
            BufferedReader reader = Files.newBufferedReader(metaFile);
            try {
                JsonElement json = JsonParser.parseReader((Reader)reader);
                folderMeta = (FolderMeta)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, arg_0 -> ((Logger)RecursiveResources.LOGGER).error(arg_0));
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    RecursiveResources.LOGGER.error("Failed to load folder meta file: " + metaFile, (Throwable)e);
                    return DEFAULT;
                }
            }
            reader.close();
        }
        return folderMeta;
    }

    public void save(Path metaFile) {
        try (BufferedWriter writer = Files.newBufferedWriter(metaFile, new OpenOption[0]);){
            JsonElement json = (JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).getOrThrow(false, arg_0 -> ((Logger)RecursiveResources.LOGGER).error(arg_0));
            writer.write(GSON.toJson(json));
        }
        catch (Exception e) {
            RecursiveResources.LOGGER.error("Failed to save folder meta file: " + metaFile, (Throwable)e);
        }
    }

    public FolderMeta getRefreshed(List<Path> packsInFolder) {
        ArrayList<Path> packs = new ArrayList<Path>(this.packs());
        for (Path pack : packsInFolder) {
            if (packs.contains(pack)) continue;
            packs.add(pack);
        }
        return new FolderMeta(this.icon, this.description, Collections.unmodifiableList(packs), this.hidden);
    }

    public int sortEntry(class_521.class_4271 entry, Path folder) {
        class_5352 class_53522 = entry.field_19129.method_29652();
        if (class_53522 instanceof FolderedPackSource) {
            FolderedPackSource folderedPackSource = (FolderedPackSource)class_53522;
            int packIndex = this.packs().indexOf(FolderMeta.relativiseRelativePath(folder, folderedPackSource.file()));
            if (packIndex != -1) {
                return packIndex;
            }
        }
        if (entry instanceof ResourcePackFolderEntry) {
            return Integer.MIN_VALUE;
        }
        return Integer.MAX_VALUE;
    }

    public boolean containsEntry(class_521.class_4271 entry, Path folder) {
        Path pack;
        class_5352 class_53522 = entry.field_19129.method_29652();
        if (class_53522 instanceof FolderedPackSource) {
            FolderedPackSource folderedPackSource = (FolderedPackSource)class_53522;
            pack = folderedPackSource.file();
        } else if (entry.field_19129.method_29652() == class_5352.field_25348) {
            pack = EMPTY_PATH.resolve(entry.method_48279());
            if (folder.equals(EMPTY_PATH)) {
                return true;
            }
        } else {
            Path fsPath = ResourcePackUtils.determinePackFolder(((class_5369.class_5372)entry.field_19129).field_25461.method_14458());
            if (fsPath == null) {
                return false;
            }
            pack = EMPTY_PATH.resolve(fsPath.getFileName());
        }
        Path relativePath = FolderMeta.relativiseRelativePath(folder, pack);
        Path packParent = pack.getParent() != null ? pack.getParent() : EMPTY_PATH;
        return folder.equals(packParent) || this.packs().contains(relativePath);
    }
}

