/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.recursiveresources.gui;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_521;
import net.minecraft.class_5369;
import nl.enjarai.recursiveresources.RecursiveResources;
import nl.enjarai.recursiveresources.gui.FolderedResourcePackScreen;
import nl.enjarai.recursiveresources.pack.FolderMeta;
import nl.enjarai.recursiveresources.pack.FolderPack;

public class ResourcePackFolderEntry
extends class_521.class_4271 {
    public static final class_2960 WIDGETS_TEXTURE = RecursiveResources.id("textures/gui/widgets.png");
    public static final String UP_TEXT = "..";
    private static final class_2561 BACK_DESCRIPTION = class_2561.method_43471((String)"recursiveresources.folder.back");
    private static final class_2561 FOLDER_DESCRIPTION = class_2561.method_43471((String)"recursiveresources.folder.folder");
    private final FolderedResourcePackScreen ownerScreen;
    public final Path folder;
    public final boolean isUp;
    public final List<class_521.class_4271> children;
    public final FolderMeta meta;

    private static Function<Path, Path> getIconFileResolver(List<Path> roots, Path folder) {
        return iconPath -> {
            if (iconPath.isAbsolute()) {
                return iconPath;
            }
            for (Path root : roots) {
                Path iconFile = root.resolve(folder).resolve((Path)iconPath);
                if (!Files.exists(iconFile, new LinkOption[0])) continue;
                return iconFile;
            }
            return null;
        };
    }

    public ResourcePackFolderEntry(class_310 client, class_521 list, FolderedResourcePackScreen ownerScreen, Path folder, boolean isUp) {
        super(client, list, (class_5369.class_5371)new FolderPack(class_2561.method_30163((String)(isUp ? UP_TEXT : String.valueOf(folder.getFileName()))), isUp ? BACK_DESCRIPTION : FOLDER_DESCRIPTION, ResourcePackFolderEntry.getIconFileResolver(ownerScreen.roots, folder), folder, FolderMeta.loadMetaFile(ownerScreen.roots, folder)));
        this.ownerScreen = ownerScreen;
        this.folder = folder;
        this.isUp = isUp;
        this.meta = ((FolderPack)this.field_19129).getMeta();
        this.children = isUp ? List.of() : this.resolveChildren();
    }

    public ResourcePackFolderEntry(class_310 client, class_521 list, FolderedResourcePackScreen ownerScreen, Path folder) {
        this(client, list, ownerScreen, folder, false);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        double relativeMouseX = mouseX - (double)this.field_19130.method_25342();
        if (this.getChildren().size() > 0 && relativeMouseX <= 32.0) {
            this.enableChildren();
            return true;
        }
        this.ownerScreen.moveToFolder(this.folder);
        return true;
    }

    public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        class_5369.class_5371 class_53712 = this.field_19129;
        if (class_53712 instanceof FolderPack) {
            FolderPack folderPack = (FolderPack)class_53712;
            folderPack.setHovered(hovered);
        }
        super.method_25343(context, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
        if (hovered) {
            context.method_25294(x, y, x + 32, y + 32, -1601138544);
            int relativeMouseX = mouseX - x;
            if (this.getChildren().size() > 0) {
                if (relativeMouseX < 32) {
                    context.method_25290(WIDGETS_TEXTURE, x, y, 0.0f, 32.0f, 32, 32, 256, 256);
                } else {
                    context.method_25290(WIDGETS_TEXTURE, x, y, 0.0f, 0.0f, 32, 32, 256, 256);
                }
            }
        }
    }

    public void enableChildren() {
        for (class_521.class_4271 entry : this.getChildren()) {
            if (!entry.field_19129.method_29661()) continue;
            entry.field_19129.method_29656();
        }
    }

    public List<class_521.class_4271> getChildren() {
        return this.children;
    }

    private List<class_521.class_4271> resolveChildren() {
        return this.field_19130.method_25396().stream().filter(entry -> !(entry instanceof ResourcePackFolderEntry)).filter(entry -> this.meta.containsEntry((class_521.class_4271)entry, this.folder)).sorted(Comparator.comparingInt(entry -> this.meta.sortEntry((class_521.class_4271)entry, this.folder)).reversed()).toList();
    }
}

