/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.recursiveresources.gui;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3283;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_521;
import net.minecraft.class_5375;
import nl.enjarai.recursiveresources.RecursiveResources;
import nl.enjarai.recursiveresources.gui.FolderedPackListWidget;
import nl.enjarai.recursiveresources.gui.ResourcePackFolderEntry;
import nl.enjarai.recursiveresources.pack.FolderMeta;
import nl.enjarai.recursiveresources.pack.FolderPack;
import nl.enjarai.recursiveresources.util.ResourcePackListProcessor;
import nl.enjarai.recursiveresources.util.ResourcePackUtils;

public class FolderedResourcePackScreen
extends class_5375 {
    private static final Path ROOT_FOLDER = Path.of("", new String[0]);
    private static final class_2561 OPEN_PACK_FOLDER = class_2561.method_43471((String)"pack.openFolder");
    private static final class_2561 DONE = class_2561.method_43471((String)"gui.done");
    private static final class_2561 SORT_AZ = class_2561.method_43471((String)"recursiveresources.sort.a-z");
    private static final class_2561 SORT_ZA = class_2561.method_43471((String)"recursiveresources.sort.z-a");
    private static final class_2561 VIEW_FOLDER = class_2561.method_43471((String)"recursiveresources.view.folder");
    private static final class_2561 VIEW_FLAT = class_2561.method_43471((String)"recursiveresources.view.flat");
    private static final class_2561 AVAILABLE_PACKS_TITLE_HOVER = class_2561.method_43471((String)"recursiveresources.availablepacks.title.hover");
    private static final class_2561 SELECTED_PACKS_TITLE_HOVER = class_2561.method_43471((String)"recursiveresources.selectedpacks.title.hover");
    protected final class_310 client = class_310.method_1551();
    protected final class_437 parent;
    private final ResourcePackListProcessor listProcessor = new ResourcePackListProcessor(() -> ((FolderedResourcePackScreen)this).method_29680());
    private Comparator<class_521.class_4271> currentSorter;
    private class_521 originalAvailablePacks;
    private class_521 customAvailablePacks;
    private class_342 searchField;
    private Path currentFolder = ROOT_FOLDER;
    private FolderMeta currentFolderMeta;
    private boolean folderView = true;
    public final List<Path> roots;

    public FolderedResourcePackScreen(class_437 parent, class_3283 packManager, Consumer<class_3283> applier, File mainRoot, class_2561 title, List<Path> roots) {
        super(packManager, applier, mainRoot.toPath(), title);
        this.parent = parent;
        this.roots = roots;
        this.currentFolderMeta = FolderMeta.loadMetaFile(roots, this.currentFolder);
        this.currentSorter = (pack1, pack2) -> Integer.compare(this.currentFolderMeta.sortEntry((class_521.class_4271)pack1, this.currentFolder), this.currentFolderMeta.sortEntry((class_521.class_4271)pack2, this.currentFolder));
    }

    protected void method_25426() {
        super.method_25426();
        this.findButton(OPEN_PACK_FOLDER).ifPresent(btn -> {
            btn.method_46421(this.field_22789 / 2 + 25);
            btn.method_46419(this.field_22790 - 48);
        });
        this.findButton(DONE).ifPresent(btn -> {
            btn.method_46421(this.field_22789 / 2 + 25);
            btn.method_46419(this.field_22790 - 26);
            if (btn instanceof class_4185) {
                class_4185 button = (class_4185)btn;
                button.field_22767 = btn2 -> this.applyAndClose();
            }
        });
        this.method_37063((class_364)class_4185.method_46430((class_2561)(this.folderView ? VIEW_FOLDER : VIEW_FLAT), btn -> {
            this.folderView = !this.folderView;
            btn.method_25355(this.folderView ? VIEW_FOLDER : VIEW_FLAT);
            this.method_29680();
            this.customAvailablePacks.method_25307(0.0);
        }).method_46434(this.field_22789 / 2 - 179, this.field_22790 - 26, 154, 20).method_46431());
        this.searchField = (class_342)this.method_37063((class_364)new class_342(this.field_22793, this.field_22789 / 2 - 179, this.field_22790 - 46, 154, 16, this.searchField, class_2561.method_30163((String)"")));
        this.searchField.method_1856(true);
        this.searchField.method_1863(this.listProcessor::setFilter);
        this.method_37063((class_364)this.searchField);
        this.originalAvailablePacks = this.field_25472;
        this.method_37066((class_364)this.originalAvailablePacks);
        this.customAvailablePacks = new class_521(this.client, (class_5375)this, 200, this.field_22790, this.field_25472.field_18978);
        this.method_37063((class_364)this.customAvailablePacks);
        this.customAvailablePacks.method_48229(this.field_22789 / 2 - 204, this.originalAvailablePacks.method_46427());
        ((FolderedPackListWidget)this.customAvailablePacks).recursiveresources$setTitleClickable(AVAILABLE_PACKS_TITLE_HOVER, null, () -> {
            for (class_521.class_4271 entry : Lists.reverse(List.copyOf(this.field_25472.method_25396()))) {
                if (!entry.field_19129.method_29661()) continue;
                entry.field_19129.method_29656();
            }
        });
        this.field_25472 = this.customAvailablePacks;
        ((FolderedPackListWidget)this.field_25473).recursiveresources$setTitleClickable(SELECTED_PACKS_TITLE_HOVER, null, () -> {
            for (class_521.class_4271 entry : List.copyOf(this.field_25473.method_25396())) {
                if (!entry.field_19129.method_29662()) continue;
                entry.field_19129.method_29657();
            }
        });
        this.listProcessor.pauseCallback();
        this.listProcessor.setSorter(this.currentSorter == null ? (this.currentSorter = ResourcePackListProcessor.sortAZ) : this.currentSorter);
        this.listProcessor.setFilter(this.searchField.method_1882());
        this.listProcessor.resumeCallback();
    }

    private Optional<class_339> findButton(class_2561 text) {
        return this.field_22786.stream().filter(class_339.class::isInstance).map(class_339.class::cast).filter(btn -> text.equals(btn.method_25369())).findFirst();
    }

    public void method_29678() {
        super.method_29678();
        if (this.customAvailablePacks != null) {
            this.onFiltersUpdated();
        }
    }

    private Path getParentFileSafe(Path file) {
        Path parent = file.getParent();
        return parent == null ? ROOT_FOLDER : parent;
    }

    private boolean notInRoot() {
        return this.folderView && !this.currentFolder.equals(ROOT_FOLDER);
    }

    private void onFiltersUpdated() {
        ArrayList<class_521.class_4271> folders = null;
        if (this.folderView) {
            folders = new ArrayList<class_521.class_4271>();
            if (this.notInRoot()) {
                folders.add(new ResourcePackFolderEntry(this.client, this.customAvailablePacks, this, this.getParentFileSafe(this.currentFolder), true));
            }
            ArrayList<Path> createdFolders = new ArrayList<Path>();
            for (Path root : this.roots) {
                Path absolute = root.resolve(this.currentFolder);
                try (Stream<Path> contents = Files.list(absolute);){
                    for (Path folder : contents.filter(ResourcePackUtils::isFolderButNotFolderBasedPack).toList()) {
                        Path relative = root.relativize(folder.normalize());
                        if (createdFolders.contains(relative)) continue;
                        ResourcePackFolderEntry entry2 = new ResourcePackFolderEntry(this.client, this.customAvailablePacks, this, relative);
                        if (((FolderPack)entry2.field_19129).isVisible()) {
                            folders.add(entry2);
                        }
                        createdFolders.add(relative);
                    }
                }
                catch (IOException e) {
                    RecursiveResources.LOGGER.error("Failed to read contents of " + absolute, (Throwable)e);
                }
            }
        }
        this.listProcessor.apply(this.customAvailablePacks.method_25396().stream().toList(), folders, this.customAvailablePacks.method_25396());
        if (this.folderView) {
            List<class_521.class_4271> filteredPacks = this.customAvailablePacks.method_25396().stream().filter(entry -> {
                if (entry instanceof ResourcePackFolderEntry) {
                    ResourcePackFolderEntry folder = (ResourcePackFolderEntry)((Object)entry);
                    return folder.isUp || this.currentFolder.equals(this.getParentFileSafe(folder.folder));
                }
                return this.currentFolderMeta.containsEntry((class_521.class_4271)entry, this.currentFolder);
            }).toList();
            this.customAvailablePacks.method_25396().clear();
            this.customAvailablePacks.method_25396().addAll(filteredPacks);
        }
        this.customAvailablePacks.method_25307(this.customAvailablePacks.method_25341());
    }

    public void moveToFolder(Path folder) {
        this.currentFolder = folder;
        this.currentFolderMeta = FolderMeta.loadMetaFile(this.roots, this.currentFolder);
        this.method_29680();
        this.customAvailablePacks.method_25307(0.0);
    }

    public void method_25393() {
        super.method_25393();
    }

    protected void applyAndClose() {
        this.field_25468.method_29642();
        this.method_30291();
    }

    public void method_25419() {
        this.method_30291();
        this.client.method_1507(this.parent);
        this.client.field_1690.method_1627(this.client.method_1520());
    }
}

