/*
 * Decompiled with CFR 0.152.
 */
package net.superkat.explosiveenhancement;

import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.superkat.explosiveenhancement.ExplosiveEnhancement;
import net.superkat.explosiveenhancement.ExplosiveEnhancementClient;
import net.superkat.explosiveenhancement.config.ExplosiveConfig;

public class ExplosiveHandler {
    public static void spawnParticles(class_1937 world, double x, double y, double z, float power, boolean isUnderWater, boolean didDestroyBlocks, boolean isImportant) {
        ExplosiveConfig config = ExplosiveEnhancementClient.config;
        if (config.modEnabled) {
            if (config.debugLogs) {
                ExplosiveEnhancement.LOGGER.info("ExplosiveApi has been called!");
            }
            power = isUnderWater ? (config.dynamicUnderwater ? power : 4.0f) : (config.dynamicSize ? power : 4.0f);
            y = config.attemptBetterSmallExplosions && power == 1.0f ? y + config.smallExplosionYOffset : y;
            isImportant = isImportant || config.alwaysShow;
            float blastwavePower = power * 1.75f;
            float fireballPower = power * 1.25f;
            float smokePower = power * 0.4f;
            if (isUnderWater) {
                if (config.showUnderwaterBlastWave) {
                    world.method_8466((class_2394)ExplosiveEnhancement.UNDERWATERBLASTWAVE, isImportant, x, y + 0.5, z, (double)blastwavePower, 0.0, 0.0);
                }
                if (config.showShockwave) {
                    world.method_8466((class_2394)ExplosiveEnhancement.SHOCKWAVE, isImportant, x, y + 0.5, z, (double)fireballPower, isImportant ? 1.0 : 0.0, 0.0);
                } else if (config.showUnderwaterSparks) {
                    world.method_8466((class_2394)ExplosiveEnhancement.BLANK_SHOCKWAVE, isImportant, x, y + 0.5, z, (double)fireballPower, isImportant ? 1.0 : 0.0, 0.0);
                }
                for (int total = config.bubbleAmount; total >= 1; --total) {
                    world.method_8466((class_2394)ExplosiveEnhancement.BUBBLE, isImportant, x, y, z, (double)ExplosiveHandler.nextBetween(1, 7) * 0.3 * (double)ExplosiveHandler.nextBetween(-1, 1), (double)ExplosiveHandler.nextBetween(1, 10) * 0.1, (double)ExplosiveHandler.nextBetween(1, 7) * 0.3 * (double)ExplosiveHandler.nextBetween(-1, 1));
                }
                if (config.showDefaultExplosionUnderwater) {
                    ExplosiveHandler.showDefaultParticles(world, x, y, z, power, didDestroyBlocks, isImportant);
                }
            } else {
                if (config.debugLogs) {
                    ExplosiveEnhancement.LOGGER.info("Particle is being shown!");
                }
                if (config.showBlastWave) {
                    world.method_8466((class_2394)ExplosiveEnhancement.BLASTWAVE, isImportant, x, y, z, (double)blastwavePower, 0.0, 0.0);
                }
                if (config.showFireball) {
                    world.method_8466((class_2394)ExplosiveEnhancement.FIREBALL, isImportant, x, y + 0.5, z, (double)fireballPower, isImportant ? 1.0 : 0.0, 0.0);
                } else if (config.showSparks) {
                    world.method_8466((class_2394)ExplosiveEnhancement.BLANK_FIREBALL, isImportant, x, y + 0.5, z, (double)fireballPower, isImportant ? 1.0 : 0.0, 0.0);
                }
                if (config.showMushroomCloud) {
                    world.method_8466((class_2394)ExplosiveEnhancement.SMOKE, isImportant, x, y, z, (double)power, (double)power * 0.25, 0.0);
                    world.method_8466((class_2394)ExplosiveEnhancement.SMOKE, isImportant, x, y, z, (double)power, (double)smokePower, 0.0);
                    world.method_8466((class_2394)ExplosiveEnhancement.SMOKE, isImportant, x, y, z, 0.15, (double)smokePower, (double)power);
                    world.method_8466((class_2394)ExplosiveEnhancement.SMOKE, isImportant, x, y, z, -0.15, (double)smokePower, (double)power);
                    world.method_8466((class_2394)ExplosiveEnhancement.SMOKE, isImportant, x, y, z, (double)power, (double)smokePower, 0.15);
                    world.method_8466((class_2394)ExplosiveEnhancement.SMOKE, isImportant, x, y, z, (double)power, (double)smokePower, -0.15);
                }
                if (config.showDefaultExplosion) {
                    ExplosiveHandler.showDefaultParticles(world, x, y, z, power, didDestroyBlocks, isImportant);
                }
            }
            if (config.debugLogs) {
                ExplosiveEnhancement.LOGGER.info("Particle finished!");
            }
        }
    }

    private static void showDefaultParticles(class_1937 world, double x, double y, double z, float power, boolean didDestroyBlocks, boolean isImportant) {
        if (!(power < 2.0f) && didDestroyBlocks) {
            world.method_8466((class_2394)class_2398.field_11221, isImportant, x, y, z, 1.0, 0.0, 0.0);
        } else {
            world.method_8466((class_2394)class_2398.field_11236, isImportant, x, y, z, 1.0, 0.0, 0.0);
        }
    }

    private static int nextBetween(int min, int max) {
        return class_3532.method_32751((class_5819)class_5819.method_43047(), (int)min, (int)max);
    }
}

