/*
 * Decompiled with CFR 0.152.
 */
package com.axolotlmaid.optionsprofiles.profiles;

import com.axolotlmaid.optionsprofiles.profiles.SodiumConfigLoader;
import dev.architectury.platform.Platform;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;

public class Profiles {
    public void createProfile() {
        Object profileName = "Profile 1";
        Path profile = Paths.get("options-profiles/" + (String)profileName, new String[0]);
        int i = 1;
        while (Files.exists(profile, new LinkOption[0])) {
            profileName = "Profile " + i;
            profile = Paths.get("options-profiles/" + (String)profileName, new String[0]);
            ++i;
        }
        try {
            Files.createDirectory(profile, new FileAttribute[0]);
            if (Files.exists(profile, new LinkOption[0])) {
                System.out.println("Profile created.");
                this.writeOptionsFilesIntoProfile((String)profileName);
            } else {
                System.out.println("Profile was not created successfully.");
            }
        }
        catch (IOException e) {
            System.out.println("An error occurred when creating a profile.");
            e.printStackTrace();
        }
    }

    public void writeOptionsFilesIntoProfile(String profileName) {
        Path profile = Paths.get("options-profiles/" + profileName, new String[0]);
        Path options = Paths.get("options.txt", new String[0]);
        Path profileOptions = Paths.get(profile.toAbsolutePath() + "/options.txt", new String[0]);
        try (Stream<String> paths = Files.lines(options);){
            if (Files.exists(profileOptions, new LinkOption[0])) {
                Files.newBufferedWriter(profileOptions, StandardOpenOption.TRUNCATE_EXISTING);
            }
            paths.forEach(line -> {
                try {
                    Files.write(profileOptions, line.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                    Files.write(profileOptions, "\n".getBytes(), StandardOpenOption.APPEND);
                }
                catch (IOException e) {
                    System.out.println("An error occurred when writing a profile.");
                    e.printStackTrace();
                }
            });
        }
        catch (IOException e) {
            System.out.println("An error occurred when reading options.txt.");
            e.printStackTrace();
        }
        if (Platform.isFabric() && Platform.isModLoaded((String)"sodium")) {
            Path sodiumConfiguration = Paths.get("config/sodium-options.json", new String[0]);
            Path sodiumConfigurationProfile = Paths.get(profile.toAbsolutePath() + "/sodium-options.json", new String[0]);
            try (Stream<String> paths = Files.lines(sodiumConfiguration);){
                if (Files.exists(sodiumConfigurationProfile, new LinkOption[0])) {
                    Files.newBufferedWriter(sodiumConfigurationProfile, StandardOpenOption.TRUNCATE_EXISTING);
                }
                paths.forEach(line -> {
                    try {
                        Files.write(sodiumConfigurationProfile, line.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                        Files.write(sodiumConfigurationProfile, "\n".getBytes(), StandardOpenOption.APPEND);
                    }
                    catch (IOException e) {
                        System.out.println("An error occurred when writing a profile.");
                        e.printStackTrace();
                    }
                });
            }
            catch (IOException e) {
                System.out.println("An error occurred when reading options.txt.");
                e.printStackTrace();
            }
        }
    }

    public boolean isProfileLoaded(String profileName) {
        Path profile = Paths.get("options-profiles/" + profileName, new String[0]);
        Path options = Paths.get("options.txt", new String[0]);
        Path profileOptions = Paths.get(profile.toAbsolutePath() + "/options.txt", new String[0]);
        try {
            List<String> linesOptions = Files.readAllLines(options);
            List<String> linesProfileOptions = Files.readAllLines(profileOptions);
            if (Platform.isFabric() && Platform.isModLoaded((String)"sodium")) {
                Path sodiumConfiguration = Paths.get("config/sodium-options.json", new String[0]);
                Path sodiumConfigurationProfile = Paths.get(profile.toAbsolutePath() + "/sodium-options.json", new String[0]);
                if (Files.exists(sodiumConfigurationProfile, new LinkOption[0])) {
                    List<String> linesSodiumConfig = Files.readAllLines(sodiumConfiguration);
                    List<String> linesSodiumConfigProfile = Files.readAllLines(sodiumConfigurationProfile);
                    return linesOptions.equals(linesProfileOptions) && linesSodiumConfig.equals(linesSodiumConfigProfile);
                }
            }
            return linesOptions.equals(linesProfileOptions);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void loadProfile(String profileName) {
        Path sodiumConfigurationProfile;
        Path profile = Paths.get("options-profiles/" + profileName, new String[0]);
        Path options = Paths.get("options.txt", new String[0]);
        Path profileOptions = Paths.get(profile.toAbsolutePath() + "/options.txt", new String[0]);
        try (Stream<String> paths = Files.lines(profileOptions);){
            Files.newBufferedWriter(options, StandardOpenOption.TRUNCATE_EXISTING);
            paths.forEach(line -> {
                try {
                    Files.write(options, line.getBytes(), StandardOpenOption.APPEND);
                    Files.write(options, "\n".getBytes(), StandardOpenOption.APPEND);
                }
                catch (IOException e) {
                    System.out.println("An error occurred when loading a profile.");
                    e.printStackTrace();
                }
            });
        }
        catch (IOException e) {
            System.out.println("An error occurred when loading a profile.");
            e.printStackTrace();
        }
        if (Platform.isFabric() && Platform.isModLoaded((String)"sodium") && Files.exists(sodiumConfigurationProfile = Paths.get(profile.toAbsolutePath() + "/sodium-options.json", new String[0]), new LinkOption[0])) {
            SodiumConfigLoader.load(sodiumConfigurationProfile);
        }
    }

    public void renameProfile(String profileName, String newProfileName) {
        Path profile = Paths.get("options-profiles/" + profileName, new String[0]);
        Path newProfile = Paths.get("options-profiles/" + newProfileName, new String[0]);
        if (Files.exists(newProfile, new LinkOption[0])) {
            System.out.println("New profile already exists!");
        }
        try {
            Files.move(profile, newProfile, new CopyOption[0]);
            if (Files.exists(newProfile, new LinkOption[0])) {
                System.out.println("Profile renamed.");
            } else {
                System.out.println("Profile was not renamed successfully.");
            }
        }
        catch (IOException e) {
            System.out.println("Profile was not renamed successfully.");
            e.printStackTrace();
        }
    }

    public void deleteProfile(String profileName) {
        Path profile = Paths.get("options-profiles/" + profileName, new String[0]);
        try (Stream<Path> files = Files.walk(profile, new FileVisitOption[0]);){
            files.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
        catch (IOException e) {
            System.out.println("Profile was not deleted.");
            e.printStackTrace();
        }
        System.out.println("Profile deleted.");
    }
}

