/*
 * Decompiled with CFR 0.152.
 */
package com.axolotlmaid.optionsprofiles.gui;

import com.axolotlmaid.optionsprofiles.gui.EditProfileScreen;
import com.axolotlmaid.optionsprofiles.gui.ProfilesScreen;
import com.axolotlmaid.optionsprofiles.profiles.Profiles;
import com.google.common.collect.ImmutableList;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_6379;

public class ProfilesList
extends class_4265<Entry> {
    final ProfilesScreen profilesScreen;

    public ProfilesList(ProfilesScreen profilesScreen, class_310 minecraft) {
        super(minecraft, profilesScreen.field_22789 + 45, profilesScreen.field_22790 - 52, 20, 20);
        this.profilesScreen = profilesScreen;
        this.refreshEntries();
    }

    public void refreshEntries() {
        this.method_25339();
        Path profilesDirectory = Paths.get("options-profiles/", new String[0]);
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(profilesDirectory);){
            for (Path profile : directoryStream) {
                this.method_25321((class_350.class_351)new ProfileEntry((class_2561)class_2561.method_43470((String)profile.getFileName().toString())));
            }
        }
        catch (Exception e) {
            System.out.println("An error occurred when listing profiles.");
            e.printStackTrace();
        }
    }

    protected int method_25329() {
        return super.method_25329() + 15;
    }

    public int method_25322() {
        return super.method_25322() + 32;
    }

    public class ProfileEntry
    extends Entry {
        private final class_2561 profileName;
        private final class_4185 editButton;
        private final class_4185 loadButton;

        ProfileEntry(class_2561 profileName) {
            this.profileName = profileName;
            this.editButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.optionsprofiles.edit-profile"), button -> ProfilesList.this.field_22740.method_1507((class_437)new EditProfileScreen(ProfilesList.this.profilesScreen, profileName))).method_46437(75, 20).method_46435(supplier -> class_2561.method_43471((String)"gui.optionsprofiles.edit-profile")).method_46431();
            this.loadButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.optionsprofiles.load-profile"), button -> {
                new Profiles().loadProfile(profileName.getString());
                ((ProfilesList)ProfilesList.this).field_22740.field_1690.method_1636();
                ((ProfilesList)ProfilesList.this).field_22740.field_1690.method_1627(ProfilesList.this.field_22740.method_1520());
                ProfilesList.this.field_22740.method_1521();
                ((ProfilesList)ProfilesList.this).field_22740.field_1690.method_1640();
                button.field_22763 = false;
            }).method_46437(75, 20).method_46435(supplier -> class_2561.method_43471((String)"gui.optionsprofiles.load-profile")).method_46431();
            this.loadButton.field_22763 = !new Profiles().isProfileLoaded(profileName.getString());
        }

        public void method_25343(class_332 guiGraphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            class_327 fontRenderer = ((ProfilesList)ProfilesList.this).field_22740.field_1772;
            int textY = y + entryHeight / 2;
            Objects.requireNonNull(((ProfilesList)ProfilesList.this).field_22740.field_1772);
            guiGraphics.method_51439(fontRenderer, this.profileName, x - 50, textY - 4, 0xFFFFFF, false);
            this.editButton.method_46421(x + 115);
            this.editButton.method_46419(y);
            this.editButton.method_25394(guiGraphics, mouseX, mouseY, tickDelta);
            this.loadButton.method_46421(x + 190);
            this.loadButton.method_46419(y);
            this.loadButton.method_25394(guiGraphics, mouseX, mouseY, tickDelta);
        }

        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)this.editButton, (Object)this.loadButton);
        }

        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)this.editButton, (Object)this.loadButton);
        }
    }

    public static abstract class Entry
    extends class_4265.class_4266<Entry> {
    }
}

