/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.accelerateddecay;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.utils.value.IntValue;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3341;
import net.minecraft.class_3481;
import net.minecraft.class_3610;
import net.minecraft.class_4770;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;

public class AcceleratedDecay {
    public static final String MOD_ID = "accelerateddecay";
    private static final ConcurrentHashMap<TimedDimBlockPos, Boolean> timeBasedScanLocations = new ConcurrentHashMap();
    private static final class_2338[] SCAN_LOCATIONS;

    public static void init() {
        BlockEvent.BREAK.register(AcceleratedDecay::breakHandler);
        TickEvent.SERVER_LEVEL_POST.register(AcceleratedDecay::levelTick);
    }

    private static void levelTick(class_3218 serverLevel) {
        Instant now = Instant.now();
        Iterator iterator = ((ConcurrentHashMap.KeySetView)timeBasedScanLocations.keySet()).iterator();
        while (iterator.hasNext()) {
            TimedDimBlockPos location = (TimedDimBlockPos)iterator.next();
            if (location.checkAfter.isAfter(now) || !serverLevel.method_27983().equals(location.dim)) continue;
            if (location.player == null || !location.player.method_5805()) {
                iterator.remove();
                continue;
            }
            Set<class_2338> yeetLeaves = AcceleratedDecay.seekLeaves((class_1937)serverLevel, location.pos);
            boolean isFirst = true;
            for (class_2338 yeetLeaf : yeetLeaves) {
                EventResult eventResult;
                class_2680 blockState = serverLevel.method_8320(yeetLeaf);
                if (!blockState.method_26164(class_3481.field_15503) || (eventResult = ((BlockEvent.Break)BlockEvent.BREAK.invoker()).breakBlock((class_1937)serverLevel, yeetLeaf, blockState, location.player, null)).isFalse()) continue;
                AcceleratedDecay.destroyBlockWithOptionalSoundAndParticles((class_1937)serverLevel, yeetLeaf, true, 512, location.player, isFirst);
                isFirst = false;
            }
            iterator.remove();
        }
    }

    private static EventResult breakHandler(class_1937 level, class_2338 blockPos, class_2680 state, class_3222 player, @Nullable IntValue intValue) {
        if (!state.method_26164(class_3481.field_15475)) {
            return EventResult.pass();
        }
        timeBasedScanLocations.put(new TimedDimBlockPos(Instant.now().plus(1L, ChronoUnit.SECONDS), blockPos, (class_5321<class_1937>)level.method_27983(), player), Boolean.TRUE);
        return EventResult.pass();
    }

    private static Set<class_2338> seekLeaves(class_1937 level, class_2338 pos) {
        HashSet<class_2338> validLocations = new HashSet<class_2338>();
        HashSet<class_2338> walked = new HashSet<class_2338>();
        ArrayDeque<class_2338> nextToScan = new ArrayDeque<class_2338>(List.of(pos));
        while (!nextToScan.isEmpty()) {
            class_2338 currentLocation = (class_2338)nextToScan.pop();
            for (class_2338 offset : SCAN_LOCATIONS) {
                class_2338 nextLocation = currentLocation.method_10081((class_2382)offset);
                class_2680 state = level.method_8320(nextLocation);
                if (!(state.method_26204() instanceof class_2397) || ((Boolean)state.method_11654((class_2769)class_2741.field_12514)).booleanValue() || (Integer)state.method_11654((class_2769)class_2741.field_12541) != 7 || !validLocations.add(nextLocation) || !walked.add(nextLocation)) continue;
                nextToScan.add(nextLocation);
            }
        }
        return validLocations;
    }

    public static void destroyBlockWithOptionalSoundAndParticles(class_1937 level, class_2338 blockPos, boolean bl, int i, class_3222 player, boolean soundAndParticles) {
        class_2680 blockState = level.method_8320(blockPos);
        if (blockState.method_26215()) {
            return;
        }
        class_3610 fluidState = level.method_8316(blockPos);
        if (!(blockState.method_26204() instanceof class_4770) && soundAndParticles) {
            level.method_20290(2001, blockPos, class_2248.method_9507((class_2680)blockState));
        }
        if (bl) {
            class_2586 blockEntity = blockState.method_31709() ? level.method_8321(blockPos) : null;
            class_2248.method_9511((class_2680)blockState, (class_1937)level, (class_2338)blockPos, (class_2586)blockEntity, (class_1297)player, (class_1799)class_1799.field_8037);
        }
        level.method_30092(blockPos, fluidState.method_15759(), 3, i);
        level.method_33596((class_1297)player, class_5712.field_28165, blockPos);
    }

    static {
        class_3341 box = new class_3341(class_2338.field_10980).method_35410(1);
        SCAN_LOCATIONS = (class_2338[])class_2338.method_23627((class_3341)box).map(class_2338::method_10062).filter(e -> !e.equals((Object)class_2338.field_10980)).distinct().toArray(class_2338[]::new);
    }

    record TimedDimBlockPos(Instant checkAfter, class_2338 pos, class_5321<class_1937> dim, class_3222 player) {
    }
}

