/*
 * Decompiled with CFR 0.152.
 */
package atonkish.reputation.provider;

import atonkish.reputation.util.cache.IronGolemCache;
import com.google.common.cache.Cache;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1439;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public enum IronGolemProvider implements IEntityComponentProvider,
IServerDataProvider<EntityAccessor>
{
    INSTANCE;

    public static final class_2960 IRON_GOLEM_IDENTIFIER;
    public static final String ANGRY_AT_KEY = "ReputationModAngryAt";

    public class_2960 getUid() {
        return IRON_GOLEM_IDENTIFIER;
    }

    public int getDefaultPriority() {
        return 100;
    }

    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        class_2487 data = accessor.getServerData();
        class_1657 player = accessor.getPlayer();
        class_1439 golem = (class_1439)accessor.getEntity();
        IronGolemCache.Data golemData = IronGolemProvider.getIronGolemData(data, player, golem);
        @Nullable UUID angryAt = golemData.getAngryAt();
        if (player.method_5667().equals(angryAt)) {
            String angryTranslateKey = String.format("entity.%s.iron_golem.angry", "reputation");
            class_5250 text = class_2561.method_43471((String)angryTranslateKey).method_27692(class_124.field_1079);
            tooltip.add((class_2561)text);
        }
    }

    public final void appendServerData(class_2487 data, EntityAccessor accessor) {
        class_1439 golem = (class_1439)accessor.getEntity();
        @Nullable UUID angryAt = golem.method_29508();
        if (angryAt != null) {
            data.method_25927(ANGRY_AT_KEY, angryAt);
        }
    }

    private static IronGolemCache.Data getIronGolemData(class_2487 data, class_1657 player, class_1439 golem) {
        Cache<class_1439, IronGolemCache.Data> golemCache = IronGolemCache.getOrCreate(player);
        IronGolemCache.Data golemData = Optional.ofNullable((IronGolemCache.Data)golemCache.getIfPresent((Object)golem)).orElse(new IronGolemCache.Data());
        UUID angryAt = data.method_10545(ANGRY_AT_KEY) ? data.method_25926(ANGRY_AT_KEY) : null;
        golemData.setAngryAt(angryAt);
        golemCache.put((Object)golem, (Object)golemData);
        return golemData;
    }

    static {
        IRON_GOLEM_IDENTIFIER = new class_2960("reputation", "iron_golem");
    }
}

