/*
 * Decompiled with CFR 0.152.
 */
package com.soradgaming.simplehudenhanced.hud;

import net.minecraft.class_332;

public class ScreenManager {
    private final int screenWidth;
    private final int screenHeight;
    private int padding;
    private float lastZ = 0.0f;

    public ScreenManager(int screenWidth, int screenHeight) {
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.padding = 0;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    public int calculateXAxis(int configX, double scale, int lineWidth) {
        int adjustedWidth = (int)Math.round((double)(this.screenWidth - this.padding) - (double)lineWidth * scale);
        int calculatedValue = (int)Math.round((double)adjustedWidth / scale * (double)configX / 100.0);
        if (scale < 1.0) {
            int adjustedScreenWidth = (int)Math.round((double)this.screenWidth * scale);
            int maximumX = this.padding;
            int minimumX = Math.min(this.screenWidth - adjustedScreenWidth - this.padding, maximumX);
            return Math.max(Math.max(calculatedValue, minimumX), maximumX);
        }
        int adjustedLineWidth = (int)Math.round((double)lineWidth * scale);
        return Math.min(Math.max(calculatedValue, this.padding), this.screenWidth - this.padding - adjustedLineWidth);
    }

    public int calculateYAxis(int lineHeight, int size, int configY, double scale) {
        int adjustedHeight = (int)Math.round((double)(this.screenHeight - this.padding) - (double)(lineHeight * size) * scale);
        int calculatedValue = (int)Math.round((double)adjustedHeight / scale * (double)configY / 100.0);
        if (scale < 1.0) {
            return Math.max(calculatedValue, this.padding);
        }
        int adjustedLineHeight = (int)Math.round((double)(lineHeight * size) * scale);
        return Math.min(Math.max(calculatedValue, this.padding), this.screenHeight - adjustedLineHeight - this.padding);
    }

    public void setScale(class_332 context, float scale) {
        context.method_51448().method_22903();
        context.method_51448().method_22905(scale, scale, scale);
    }

    public void resetScale(class_332 context) {
        context.method_51448().method_22909();
    }

    public void zSet(class_332 context, float z) {
        this.lastZ = z;
        context.method_51448().method_22904(0.0, 0.0, (double)z);
    }

    public void zRevert(class_332 context) {
        context.method_51448().method_22904(0.0, 0.0, (double)(-this.lastZ));
    }
}

