/*
 * Decompiled with CFR 0.152.
 */
package com.soradgaming.simplehudenhanced.hud;

import com.soradgaming.simplehudenhanced.config.SimpleHudEnhancedConfig;
import com.soradgaming.simplehudenhanced.hud.GameInfo;
import com.soradgaming.simplehudenhanced.hud.ScreenManager;
import com.soradgaming.simplehudenhanced.utli.Utilities;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_4597;
import net.minecraft.class_746;
import net.minecraft.class_898;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class Movement {
    private final class_310 client = class_310.method_1551();
    private final class_327 renderer;
    private final SimpleHudEnhancedConfig config;
    private final class_332 context;

    public Movement(class_332 context, SimpleHudEnhancedConfig config) {
        this.renderer = this.client.field_1772;
        this.config = config;
        this.context = context;
    }

    public void init(GameInfo GameInformation) {
        if (this.config.movementStatus.movementTypes.toggleSwimmingStatus && GameInformation.isPlayerSwimming()) {
            this.draw(this.context, "text.hud.simplehudenhanced.swimming");
        } else if (this.config.movementStatus.movementTypes.toggleFlyingStatus && GameInformation.isPlayerFlying()) {
            this.draw(this.context, "text.hud.simplehudenhanced.flying");
        } else if (this.config.movementStatus.movementTypes.toggleSneakStatus && GameInformation.isPlayerSneaking()) {
            this.draw(this.context, "text.hud.simplehudenhanced.sneaking");
        } else if (this.config.movementStatus.movementTypes.toggleSprintStatus && GameInformation.isPlayerSprinting()) {
            this.draw(this.context, "text.hud.simplehudenhanced.sprinting");
        }
    }

    private void draw(class_332 context, String textKey) {
        String text = Utilities.translatable(textKey).getString();
        float Scale = (float)this.config.movementStatus.textScale / 100.0f;
        ScreenManager screenManager = new ScreenManager(this.client.method_22683().method_4486(), this.client.method_22683().method_4502());
        screenManager.setPadding(4);
        int xAxis = screenManager.calculateXAxis(this.config.movementStatus.movementStatusLocationX, Scale, this.renderer.method_1727(text));
        Objects.requireNonNull(this.renderer);
        int yAxis = screenManager.calculateYAxis(9, 1, this.config.movementStatus.movementStatusLocationY, Scale);
        screenManager.setScale(context, Scale);
        context.method_25303(this.renderer, text, xAxis, yAxis, this.config.uiConfig.textColor);
        screenManager.resetScale(context);
    }

    public void drawPaperDoll(class_332 context) {
        if (!this.config.paperDoll.togglePaperDoll) {
            return;
        }
        class_746 entity = this.client.field_1724;
        if (entity == null) {
            return;
        }
        ScreenManager screenManager = new ScreenManager(this.client.method_22683().method_4486(), this.client.method_22683().method_4502());
        float scale = (float)this.config.paperDoll.textScale / 100.0f;
        float size = 20.0f * scale;
        screenManager.setPadding((int)(26.0f * scale));
        int xAxis = screenManager.calculateXAxis(this.config.paperDoll.paperDollLocationX, 1.0, 0);
        screenManager.setPadding((int)(26.0f * scale));
        int yAxis = screenManager.calculateYAxis(0, 1, this.config.paperDoll.paperDollLocationY, 1.0);
        this.drawEntity(context, xAxis, yAxis, size, (class_1309)entity);
    }

    private void drawEntity(class_332 context, int xAxis, int yAxis, float size, class_1309 entity) {
        context.method_51448().method_22903();
        context.method_51448().method_22904((double)xAxis, (double)yAxis, 250.0);
        context.method_51448().method_22905(size, size, -size);
        Quaternionf quaternionZ = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionX = new Quaternionf().rotateX(0.2617994f);
        quaternionZ.mul((Quaternionfc)quaternionX);
        context.method_51448().method_22907(quaternionZ);
        class_308.method_34742();
        class_898 entityRenderDispatcher = class_310.method_1551().method_1561();
        float xRot = entity.method_36455();
        float yBodyRot = entity.field_6283;
        float yHeadRot = entity.field_6241;
        float xRotO = entity.field_6004;
        float yBodyRotO = entity.field_6220;
        float yHeadRotO = entity.field_6259;
        this.applyEntityRotations(entity);
        entityRenderDispatcher.method_3948(false);
        float xOffset = 0.0f;
        float yOffset = (entity.method_17682() + (1.0f - Movement.getCurrentHeightOffset(entity))) * -0.5f;
        entityRenderDispatcher.method_3954((class_1297)entity, (double)xOffset, (double)yOffset, 0.0, 0.0f, 1.0f, this.context.method_51448(), (class_4597)context.method_51450(), 0xF000F0);
        context.method_51452();
        entity.method_36457(xRot);
        entity.field_6283 = yBodyRot;
        entity.field_6241 = yHeadRot;
        entity.field_6004 = xRotO;
        entity.field_6220 = yBodyRotO;
        entity.field_6259 = yHeadRotO;
        entityRenderDispatcher.method_3948(true);
        context.method_51448().method_22909();
        class_308.method_24211();
    }

    private void applyEntityRotations(class_1309 entity) {
        if (this.config.paperDoll.paperDollLocationY >= 50) {
            entity.method_36457(-7.5f);
            entity.field_6004 = -7.5f;
        } else {
            entity.method_36457(7.5f);
            entity.field_6004 = 7.5f;
        }
        float defaultRotationYaw = 180.0f;
        defaultRotationYaw = this.config.paperDoll.paperDollLocationX >= 50 ? (defaultRotationYaw += 20.0f) : (defaultRotationYaw -= 20.0f);
        float yRotOffset = 0.0f;
        float yRotOffsetO = 0.0f;
        entity.field_6283 = entity.field_6220 = defaultRotationYaw;
        entity.field_6259 = defaultRotationYaw + yRotOffsetO;
        entity.field_6241 = defaultRotationYaw + yRotOffset;
    }

    private static float getCurrentHeightOffset(class_1309 player) {
        float height = player.method_18381(class_4050.field_18076);
        if (player.method_6128()) {
            float ticksElytraFlying = player.field_6017 + 1.0f;
            float flyingAnimation = class_3532.method_15363((float)(ticksElytraFlying * 0.09f), (float)0.0f, (float)1.0f);
            float flyingHeight = player.method_18381(class_4050.field_18077) / height;
            return class_3532.method_16439((float)flyingAnimation, (float)1.0f, (float)flyingHeight);
        }
        if (player.method_5681()) {
            float swimmingAnimation = player.method_20232() ? 1.0f : player.field_6251;
            float swimmingHeight = player.method_18381(class_4050.field_18079) / height;
            return class_3532.method_16439((float)swimmingAnimation, (float)1.0f, (float)swimmingHeight);
        }
        if (player.method_6123()) {
            return player.method_18381(class_4050.field_18080) / height;
        }
        if (player.method_5715()) {
            return player.method_18381(class_4050.field_18081) / height;
        }
        if (player.method_6113()) {
            return player.method_18381(class_4050.field_18078) / height;
        }
        if (player.field_6213 > 0) {
            float dyingAnimation = ((float)player.field_6213 + 1.0f - 1.0f) / 20.0f * 1.6f;
            dyingAnimation = Math.min(1.0f, class_3532.method_15355((float)dyingAnimation));
            float dyingHeight = player.method_18381(class_4050.field_18082) / height;
            return class_3532.method_16439((float)dyingAnimation, (float)1.0f, (float)dyingHeight);
        }
        return 1.0f;
    }
}

