/*
 * Decompiled with CFR 0.152.
 */
package com.soradgaming.simplehudenhanced.hud;

import com.soradgaming.simplehudenhanced.config.SimpleHudEnhancedConfig;
import com.soradgaming.simplehudenhanced.config.TextAlignment;
import com.soradgaming.simplehudenhanced.hud.Equipment;
import com.soradgaming.simplehudenhanced.hud.GameInfo;
import com.soradgaming.simplehudenhanced.hud.Movement;
import com.soradgaming.simplehudenhanced.hud.ScreenManager;
import com.soradgaming.simplehudenhanced.utli.Utilities;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;

public class HUD {
    private static HUD instance;
    private final class_310 client;
    private final class_327 renderer;
    private final SimpleHudEnhancedConfig config;
    public boolean sprintTimerRunning = false;

    private HUD(class_310 client, SimpleHudEnhancedConfig config) {
        this.client = client;
        this.renderer = client.field_1772;
        this.config = config;
    }

    public static void initialize(class_310 client, SimpleHudEnhancedConfig config) {
        if (instance == null) {
            instance = new HUD(client, config);
            Logger.getLogger(Utilities.getModName()).warning("New HUD instance created.");
        } else {
            Logger.getLogger(Utilities.getModName()).warning("HUD has already been initialized.");
            instance = new HUD(client, config);
            Logger.getLogger(Utilities.getModName()).warning("New HUD instance created. (Override)");
        }
    }

    public static HUD getInstance() {
        if (instance == null) {
            Logger.getLogger(Utilities.getModName()).warning("HUD has not been initialized yet.");
            return null;
        }
        return instance;
    }

    public void drawAsyncHud(class_332 context) {
        if (!this.config.uiConfig.toggleSimpleHUDEnhanced) {
            return;
        }
        GameInfo GameInformation = new GameInfo(this.client, this.config);
        CompletableFuture<Void> statusElementsFuture = CompletableFuture.runAsync(() -> this.drawStatusElements(context, GameInformation), arg_0 -> ((class_310)class_310.method_1551()).method_18859(arg_0));
        CompletableFuture<Void> equipmentFuture = CompletableFuture.runAsync(() -> {
            if (this.config.toggleEquipmentStatus) {
                Equipment equipment = new Equipment(context, this.config);
                equipment.init();
            }
        }, arg_0 -> ((class_310)class_310.method_1551()).method_18859(arg_0));
        if (this.config.toggleMovementStatus) {
            Movement movement = new Movement(context, this.config);
            if (this.config.movementStatus.toggleMovementStatus) {
                movement.init(GameInformation);
            }
            if (this.sprintTimerRunning) {
                movement.drawPaperDoll(context);
            }
        }
        this.drawTime(context, GameInformation.getSystemTime());
        CompletableFuture.allOf(equipmentFuture, statusElementsFuture).join();
    }

    @NotNull
    private static ArrayList<String> getHudInfo(GameInfo GameInformation) {
        ArrayList<String> hudInfo = new ArrayList<String>();
        hudInfo.add(GameInformation.getCords() + GameInformation.getDirection() + GameInformation.getOffset());
        hudInfo.add(GameInformation.getNether());
        hudInfo.add(GameInformation.getFPS());
        hudInfo.add(GameInformation.getSpeed());
        hudInfo.add(GameInformation.getLightLevel());
        hudInfo.add(GameInformation.getBiome());
        hudInfo.add(GameInformation.getTime());
        hudInfo.add(GameInformation.getPlayerName());
        hudInfo.add(GameInformation.getPing());
        hudInfo.add(GameInformation.getTPS());
        hudInfo.add(GameInformation.getServer());
        hudInfo.add(GameInformation.getServerAddress());
        return hudInfo;
    }

    public int getColor(String line, GameInfo GameInformation) {
        int colour = this.config.uiConfig.textColor;
        if (Objects.equals(line, GameInformation.getFPS()) && this.config.statusElements.fps.toggleColourFPS) {
            String[] fps = line.split(" ");
            int fpsInt = Integer.parseInt(fps[0]);
            if (fpsInt < 15) {
                return 0xFF0000;
            }
            if (fpsInt < 30) {
                return -43691;
            }
            if (fpsInt < 45) {
                return -21931;
            }
            if (fpsInt < 60) {
                return -171;
            }
            return 65280;
        }
        return colour;
    }

    private void drawStatusElements(class_332 context, GameInfo gameInformation) {
        ArrayList<String> hudInfo = HUD.getHudInfo(gameInformation);
        hudInfo.removeIf(String::isEmpty);
        int Xcords = this.config.statusElements.Xcords;
        int Ycords = this.config.statusElements.Ycords;
        float Scale = (float)this.config.uiConfig.textScale / 100.0f;
        int longestString = 0;
        int BoxWidth = 0;
        for (String s : hudInfo) {
            if (s.length() <= longestString) continue;
            longestString = s.length();
            BoxWidth = this.renderer.method_1727(s);
        }
        Objects.requireNonNull(this.renderer);
        int lineHeight = 9;
        ScreenManager screenManager = new ScreenManager(this.client.method_22683().method_4486(), this.client.method_22683().method_4502());
        screenManager.setPadding(4);
        int xAxis = screenManager.calculateXAxis(Xcords, Scale, BoxWidth);
        int yAxis = screenManager.calculateYAxis(lineHeight, hudInfo.size(), Ycords, Scale);
        screenManager.setScale(context, Scale);
        for (String line : hudInfo) {
            int offset = 0;
            if (this.config.uiConfig.textAlignment == TextAlignment.Right) {
                lineLength = this.renderer.method_1727(line);
                offset = BoxWidth - lineLength;
            } else if (this.config.uiConfig.textAlignment == TextAlignment.Center) {
                lineLength = this.renderer.method_1727(line);
                offset = (BoxWidth - lineLength) / 2;
            }
            int colour = this.getColor(line, gameInformation);
            if (this.config.uiConfig.textBackground) {
                context.method_25294(xAxis - 1, yAxis - 1, xAxis + this.renderer.method_1727(line), yAxis + lineHeight - 1, Integer.MIN_VALUE);
            }
            context.method_25303(this.renderer, line, xAxis + offset, yAxis, colour);
            yAxis += lineHeight;
        }
        screenManager.resetScale(context);
    }

    private void drawTime(class_332 context, String systemTime) {
        ScreenManager timeScreenManager = new ScreenManager(this.client.method_22683().method_4486(), this.client.method_22683().method_4502());
        timeScreenManager.setPadding(2);
        float timeScale = (float)this.config.statusElements.systemTime.textScale / 100.0f;
        int xAxisTime = timeScreenManager.calculateXAxis(100, timeScale, this.renderer.method_1727(systemTime));
        Objects.requireNonNull(this.renderer);
        int yAxisTime = timeScreenManager.calculateYAxis(9, 1, 100, timeScale);
        timeScreenManager.setScale(context, timeScale);
        if (this.config.statusElements.systemTime.textBackground) {
            int n = xAxisTime + this.renderer.method_1727(systemTime);
            Objects.requireNonNull(this.renderer);
            context.method_25294(xAxisTime - 1, yAxisTime - 1, n, yAxisTime + 9 - 1, Integer.MIN_VALUE);
        }
        context.method_25303(this.renderer, systemTime, xAxisTime, yAxisTime, this.config.uiConfig.textColor);
        timeScreenManager.resetScale(context);
    }
}

