/*
 * Decompiled with CFR 0.152.
 */
package com.soradgaming.simplehudenhanced.hud;

import com.soradgaming.simplehudenhanced.config.EquipmentAlignment;
import com.soradgaming.simplehudenhanced.config.EquipmentOrientation;
import com.soradgaming.simplehudenhanced.config.SimpleHudEnhancedConfig;
import com.soradgaming.simplehudenhanced.hud.EquipmentInfoStack;
import com.soradgaming.simplehudenhanced.hud.ScreenManager;
import com.soradgaming.simplehudenhanced.utli.TrinketAccessor;
import com.soradgaming.simplehudenhanced.utli.Utilities;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_746;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Equipment {
    private final class_310 client = class_310.method_1551();
    private final class_327 renderer;
    private class_746 player;
    private final SimpleHudEnhancedConfig config;
    private final class_332 context;
    private List<EquipmentInfoStack> equipmentInfo;

    public Equipment(class_332 context, SimpleHudEnhancedConfig config) {
        this.renderer = this.client.field_1772;
        this.config = config;
        this.context = context;
        if (this.client.field_1724 != null) {
            this.player = this.client.field_1724;
        } else {
            Logger logger = LogManager.getLogger((String)Utilities.getModName());
            logger.error("Player is null", (Throwable)new Exception("Player is null"));
        }
    }

    public void init() {
        TrinketAccessor trinketData = new TrinketAccessor((class_1657)this.player, this.config);
        this.equipmentInfo = trinketData.getEquipmentInfo();
        this.equipmentInfo.removeIf(equipment -> equipment.getItem().method_7909().equals(class_2246.field_10124.method_8389()));
        this.equipmentInfo.removeIf(equipment -> equipment.getItem().method_7947() == 0);
        if (!this.config.equipmentStatus.showNonTools) {
            this.equipmentInfo.removeIf(equipment -> equipment.getItem().method_7909().method_7841() == 0);
        }
        if (this.config.equipmentStatus.Durability.showDurability) {
            this.getDurability();
        }
        if (!this.config.equipmentStatus.slots.Head) {
            this.equipmentInfo.removeIf(equipment -> equipment.getItem().equals(this.player.method_31548().method_7372(3)));
        }
        if (!this.config.equipmentStatus.slots.Body) {
            this.equipmentInfo.removeIf(equipment -> equipment.getItem().equals(this.player.method_31548().method_7372(2)));
        }
        if (!this.config.equipmentStatus.slots.Legs) {
            this.equipmentInfo.removeIf(equipment -> equipment.getItem().equals(this.player.method_31548().method_7372(1)));
        }
        if (!this.config.equipmentStatus.slots.Boots) {
            this.equipmentInfo.removeIf(equipment -> equipment.getItem().equals(this.player.method_31548().method_7372(0)));
        }
        if (!this.config.equipmentStatus.slots.OffHand) {
            this.equipmentInfo.removeIf(equipment -> equipment.getItem().equals(this.player.method_6079()));
        }
        if (!this.config.equipmentStatus.slots.MainHand) {
            this.equipmentInfo.removeIf(equipment -> equipment.getItem().equals(this.player.method_6047()));
        }
        this.draw();
    }

    private void getDurability() {
        for (EquipmentInfoStack index : this.equipmentInfo) {
            class_1799 item = index.getItem();
            if (this.isItemDurabilityDisabled(item)) {
                index.setText("");
                continue;
            }
            if (item.method_7936() != 0) {
                int currentDurability = item.method_7936() - item.method_7919();
                if (this.config.equipmentStatus.Durability.showDurabilityAsPercentage) {
                    index.setText(String.format("%s%%", currentDurability * 100 / item.method_7936()));
                } else if (this.config.equipmentStatus.Durability.showTotalCount) {
                    index.setText(String.format("%s/%s", currentDurability, item.method_7936()));
                } else {
                    index.setText(String.format("%s", currentDurability));
                }
                if (this.config.equipmentStatus.Durability.showColour && item.method_7919() != 0) {
                    index.setColor(item.method_31580());
                    continue;
                }
                index.setColor(this.config.uiConfig.textColor);
                continue;
            }
            if (this.config.equipmentStatus.showCount && item.method_7947() > 1) {
                if (this.player.method_31548().method_18861(item.method_7909()) == item.method_7947()) {
                    index.setText(String.valueOf(item.method_7947()));
                    continue;
                }
                index.setText(item.method_7947() + " (" + this.player.method_31548().method_18861(item.method_7909()) + ")");
                continue;
            }
            index.setText("");
        }
    }

    private boolean isItemDurabilityDisabled(class_1799 item) {
        if (item.equals(this.player.method_6047())) {
            return !this.config.equipmentStatus.Durability.slots.MainHand;
        }
        if (item.equals(this.player.method_6079())) {
            return !this.config.equipmentStatus.Durability.slots.OffHand;
        }
        if (item.equals(this.player.method_31548().method_7372(0))) {
            return !this.config.equipmentStatus.Durability.slots.Boots;
        }
        if (item.equals(this.player.method_31548().method_7372(1))) {
            return !this.config.equipmentStatus.Durability.slots.Legs;
        }
        if (item.equals(this.player.method_31548().method_7372(2))) {
            return !this.config.equipmentStatus.Durability.slots.Body;
        }
        if (item.equals(this.player.method_31548().method_7372(3))) {
            return !this.config.equipmentStatus.Durability.slots.Head;
        }
        return false;
    }

    private void draw() {
        int longestString = 0;
        int BoxWidth = 0;
        for (EquipmentInfoStack index : this.equipmentInfo) {
            String s = index.getText();
            if (s.length() <= longestString) continue;
            longestString = s.length();
            BoxWidth = this.renderer.method_1727(s);
        }
        int configX = this.config.equipmentStatus.equipmentStatusLocationX;
        int configY = this.config.equipmentStatus.equipmentStatusLocationY;
        float Scale = (float)this.config.equipmentStatus.textScale / 100.0f;
        int lineHeight = 16;
        ScreenManager screenManager = new ScreenManager(this.client.method_22683().method_4486(), this.client.method_22683().method_4502());
        screenManager.setPadding(4);
        int xAxis = screenManager.calculateXAxis(configX, Scale, BoxWidth + 16);
        int yAxis = screenManager.calculateYAxis(lineHeight, this.equipmentInfo.size(), configY, Scale);
        if (this.config.equipmentStatus.equipmentOrientation == EquipmentOrientation.Horizontal) {
            int total = 0;
            for (EquipmentInfoStack index : this.equipmentInfo) {
                int lineLength = this.renderer.method_1727(index.getText());
                total += lineLength;
            }
            xAxis = screenManager.calculateXAxis(configX, Scale, total + 24 * this.equipmentInfo.size() - 4);
            yAxis = screenManager.calculateYAxis(lineHeight, 1, configY, Scale);
        }
        screenManager.setScale(this.context, Scale);
        boolean isHorizontal = this.config.equipmentStatus.equipmentOrientation == EquipmentOrientation.Horizontal;
        boolean isOnRight = configX >= 50;
        boolean isRightAligned = this.config.equipmentStatus.equipmentAlignment == EquipmentAlignment.Right || this.config.equipmentStatus.equipmentAlignment == EquipmentAlignment.Auto && isOnRight;
        for (EquipmentInfoStack index : this.equipmentInfo) {
            int lineLength;
            class_1799 item = index.getItem();
            if (isRightAligned) {
                lineLength = this.renderer.method_1727(index.getText());
                int offset = BoxWidth - lineLength;
                this.context.method_25303(this.renderer, index.getText(), xAxis + offset + (isHorizontal ? -offset : (isOnRight ? -4 : 0)), yAxis + 4, index.getColor());
                int x = xAxis + BoxWidth + 4 + (isHorizontal ? -BoxWidth + lineLength : (isOnRight ? -4 : 0));
                this.context.method_51427(item, x, yAxis);
                this.drawDurabilityBar(x, yAxis, item);
            } else {
                this.context.method_25303(this.renderer, index.getText(), xAxis + 16 + 4 + (isOnRight ? (isHorizontal ? 0 : -4) : 0), yAxis + 4, index.getColor());
                int x = xAxis + (isOnRight ? (isHorizontal ? 0 : -4) : 0);
                this.context.method_51427(item, x, yAxis);
                this.drawDurabilityBar(x, yAxis, item);
            }
            if (isHorizontal) {
                lineLength = this.renderer.method_1727(index.getText());
                xAxis += lineLength + 4 + 16 + 4;
                continue;
            }
            yAxis += lineHeight;
        }
        screenManager.resetScale(this.context);
    }

    private void drawDurabilityBar(int xAxis, int yAxis, class_1799 item) {
        if (this.config.equipmentStatus.Durability.showDurabilityAsBar && item.method_7936() != 0) {
            if (item.method_7919() == 0) {
                return;
            }
            int i = item.method_31579();
            int j = item.method_31580();
            int k = xAxis + 2;
            int l = yAxis + 13;
            this.context.method_51737(k, l, k + 13, l + 2, 200, -16777216);
            this.context.method_51737(k, l, k + i, l + 1, 200, j | 0xFF000000);
        }
    }
}

