/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.enhancedgroups.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import de.maxhenkel.enhancedgroups.EnhancedGroups;
import de.maxhenkel.enhancedgroups.config.PersistentGroup;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;

public class PersistentGroupStore {
    private final File file;
    private final Gson gson;
    private List<PersistentGroup> groups;
    private Map<UUID, PersistentGroup> groupCache;

    public PersistentGroupStore(File file) {
        this.file = file;
        this.gson = new GsonBuilder().create();
        this.groups = new ArrayList<PersistentGroup>();
        this.groupCache = new HashMap<UUID, PersistentGroup>();
        this.load();
    }

    public void load() {
        if (!this.file.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(this.file);){
            Type groupListType = new TypeToken<ArrayList<PersistentGroup>>(){}.getType();
            this.groups = (List)this.gson.fromJson((Reader)reader, groupListType);
        }
        catch (Exception e) {
            EnhancedGroups.LOGGER.error("Failed to load persistent groups", (Throwable)e);
        }
        if (this.groups == null) {
            this.groups = new ArrayList<PersistentGroup>();
        }
        for (PersistentGroup group : this.groups) {
            group.getId();
        }
        this.save();
    }

    public void save() {
        this.file.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(this.file);){
            this.gson.toJson(this.groups, (Appendable)writer);
        }
        catch (Exception e) {
            EnhancedGroups.LOGGER.error("Failed to save persistent groups", (Throwable)e);
        }
    }

    @Nullable
    public PersistentGroup getCached(UUID uuid) {
        return this.groupCache.get(uuid);
    }

    public void addCached(UUID uuid, PersistentGroup group) {
        this.groupCache.put(uuid, group);
    }

    @Nullable
    public PersistentGroup getGroup(String name) {
        return this.groups.stream().filter(g -> g.getName().trim().equals(name.trim())).findFirst().orElse(null);
    }

    @Nullable
    public PersistentGroup getGroup(UUID id) {
        return this.groups.stream().filter(g -> g.getId().equals(id)).findFirst().orElse(null);
    }

    @Nullable
    public UUID getVoicechatId(UUID persistentGroupId) {
        return this.groupCache.entrySet().stream().filter(e -> ((PersistentGroup)e.getValue()).getId().equals(persistentGroupId)).findFirst().map(Map.Entry::getKey).orElse(null);
    }

    public List<PersistentGroup> getGroups() {
        return this.groups;
    }

    public void addGroup(PersistentGroup group) {
        this.groups.add(group);
        this.save();
    }

    public void removeGroup(PersistentGroup group) {
        this.groups.remove(group);
        this.save();
    }
}

