/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.enhancedgroups.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import de.maxhenkel.enhancedgroups.EnhancedGroups;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;

public class AutoJoinGroupStore {
    private final File file;
    private final Gson gson;
    private Map<UUID, UUID> playerGroups;

    public AutoJoinGroupStore(File file) {
        this.file = file;
        this.gson = new GsonBuilder().create();
        this.playerGroups = new HashMap<UUID, UUID>();
        this.load();
    }

    public void load() {
        if (!this.file.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(this.file);){
            Type playerGroupsType = new TypeToken<Map<UUID, UUID>>(){}.getType();
            this.playerGroups = (Map)this.gson.fromJson((Reader)reader, playerGroupsType);
        }
        catch (Exception e) {
            EnhancedGroups.LOGGER.error("Failed to load auto join groups", (Throwable)e);
        }
        if (this.playerGroups == null) {
            this.playerGroups = new HashMap<UUID, UUID>();
        }
    }

    public void save() {
        this.file.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(this.file);){
            this.gson.toJson(this.playerGroups, (Appendable)writer);
        }
        catch (Exception e) {
            EnhancedGroups.LOGGER.error("Failed to save auto join groups", (Throwable)e);
        }
    }

    @Nullable
    public UUID getPlayerGroup(UUID playerUuid) {
        return this.playerGroups.get(playerUuid);
    }

    public void setPlayerGroup(UUID playerUuid, UUID groupId) {
        this.playerGroups.put(playerUuid, groupId);
        this.save();
    }

    public void removePlayerGroup(UUID playerUuid) {
        this.playerGroups.remove(playerUuid);
        this.save();
    }
}

