/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_neoforge.functions;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.natamus.collective_common_neoforge.data.GlobalVariables;
import com.natamus.collective_common_neoforge.features.PlayerHeadCacheFeature;
import com.natamus.collective_common_neoforge.functions.DataFunctions;
import com.natamus.collective_common_neoforge.functions.UUIDFunctions;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class HeadFunctions {
    public static ItemStack getNewPlayerHead(ServerLevel serverLevel, String playerName, Integer amount) {
        GameProfile gameProfile = HeadFunctions.getGameProfileFromPlayerName(serverLevel, playerName);
        if (gameProfile == null) {
            return null;
        }
        return HeadFunctions.getNewPlayerHead(gameProfile, amount);
    }

    public static ItemStack getNewPlayerHead(GameProfile gameProfile, Integer amount) {
        if (gameProfile == null) {
            return null;
        }
        PropertyMap propertyMap = gameProfile.getProperties();
        String encodedTextures = "";
        for (Property textureProperty : propertyMap.get((Object)"textures")) {
            if (!textureProperty.name().equals("textures")) continue;
            encodedTextures = textureProperty.value();
            break;
        }
        String decodedTextures = new String(Base64.getDecoder().decode(encodedTextures));
        StringBuilder decodedNoTimestampTextures = new StringBuilder();
        for (String line : decodedTextures.split("\n")) {
            if (!decodedNoTimestampTextures.toString().equals("")) {
                decodedNoTimestampTextures.append("\n");
            }
            if (line.contains("\"timestamp\" : ")) {
                decodedNoTimestampTextures.append("  \"timestamp\" : 0,");
                continue;
            }
            decodedNoTimestampTextures.append(line);
        }
        String textures = Base64.getEncoder().encodeToString(decodedNoTimestampTextures.toString().getBytes());
        if (textures.isEmpty()) {
            return null;
        }
        int[] headIntArray = UUIDUtil.uuidToIntArray((UUID)gameProfile.getId());
        return HeadFunctions.getNewTexturedHead(gameProfile.getName(), textures, headIntArray, amount);
    }

    public static ItemStack getNewTexturedHead(String playerName, String texture, String uuidString, Integer amount) {
        UUID uuid = UUIDFunctions.getUUIDFromStringLenient(uuidString);
        int[] intArray = UUIDUtil.uuidToIntArray((UUID)uuid);
        return HeadFunctions.getNewTexturedHead(playerName, texture, intArray, amount);
    }

    public static ItemStack getNewTexturedHead(String playerName, String texture, int[] idIntArray, Integer amount) {
        ItemStack texturedHeadStack = new ItemStack((ItemLike)Items.PLAYER_HEAD, amount.intValue());
        CompoundTag skullOwnerCompoundTag = HeadFunctions.getSkullOwnerCompoundTag(playerName, texture, idIntArray);
        texturedHeadStack.addTagElement("SkullOwner", (Tag)skullOwnerCompoundTag);
        MutableComponent tcname = Component.literal((String)(playerName + "'s Head"));
        texturedHeadStack.setHoverName((Component)tcname);
        return texturedHeadStack;
    }

    public static GameProfile getGameProfileFromPlayerName(ServerLevel serverLevel, String playerName) {
        GameProfile gameProfile;
        UUID headUUID;
        MinecraftSessionService minecraftSessionService = serverLevel.getServer().getSessionService();
        if (PlayerHeadCacheFeature.cachedPlayerNamesMap.containsKey(playerName.toLowerCase())) {
            headUUID = PlayerHeadCacheFeature.cachedPlayerNamesMap.get(playerName.toLowerCase());
            playerName = PlayerHeadCacheFeature.cachedPlayerUUIDsMap.get(headUUID);
        } else {
            String nameIdJsonString = DataFunctions.readStringFromURL(GlobalVariables.playerDataURL + playerName.toLowerCase());
            if (nameIdJsonString.equals("")) {
                return null;
            }
            Map nameIdJson = (Map)new Gson().fromJson(nameIdJsonString, new TypeToken<HashMap<String, String>>(){}.getType());
            String headName = (String)nameIdJson.get("name");
            String headUUIDRaw = (String)nameIdJson.get("id");
            headUUID = UUIDFunctions.getUUIDFromStringLenient(headUUIDRaw);
            PlayerHeadCacheFeature.cachedPlayerNamesMap.put(headName.toLowerCase(), headUUID);
            PlayerHeadCacheFeature.cachedPlayerUUIDsMap.put(headUUID, headName);
        }
        if (PlayerHeadCacheFeature.cachedGameProfileMap.containsKey(headUUID)) {
            gameProfile = PlayerHeadCacheFeature.cachedGameProfileMap.get(headUUID);
        } else {
            ProfileResult profileResult = minecraftSessionService.fetchProfile(headUUID, false);
            if (profileResult == null) {
                return null;
            }
            gameProfile = profileResult.profile();
            if (gameProfile == null) {
                return null;
            }
            PlayerHeadCacheFeature.cachedGameProfileMap.put(headUUID, gameProfile);
        }
        return gameProfile;
    }

    public static CompoundTag getSkullOwnerCompoundTag(ServerLevel serverLevel, String playerName) {
        GameProfile gameProfile = HeadFunctions.getGameProfileFromPlayerName(serverLevel, playerName);
        PropertyMap propertyMap = gameProfile.getProperties();
        String textures = "";
        for (Property textureProperty : propertyMap.get((Object)"textures")) {
            if (!textureProperty.name().equals("textures")) continue;
            textures = textureProperty.value();
        }
        if (textures.equals("")) {
            return null;
        }
        int[] headIntArray = UUIDUtil.uuidToIntArray((UUID)gameProfile.getId());
        return HeadFunctions.getSkullOwnerCompoundTag(playerName, textures, headIntArray);
    }

    public static CompoundTag getSkullOwnerCompoundTag(String playerName, String textures, int[] idIntArray) {
        CompoundTag skullOwnerCompoundTag = new CompoundTag();
        skullOwnerCompoundTag.putString("Name", playerName);
        skullOwnerCompoundTag.putIntArray("Id", idIntArray);
        CompoundTag propertiesCompoundTag = new CompoundTag();
        ListTag texturesListTag = new ListTag();
        CompoundTag texturesCompoundTag = new CompoundTag();
        texturesCompoundTag.putString("Value", textures);
        texturesListTag.add((Object)texturesCompoundTag);
        propertiesCompoundTag.put("textures", (Tag)texturesListTag);
        skullOwnerCompoundTag.put("Properties", (Tag)propertiesCompoundTag);
        return skullOwnerCompoundTag;
    }

    public static boolean hasStandardHead(String mobname) {
        return mobname.equals("creeper") || mobname.equals("zombie") || mobname.equals("skeleton");
    }

    public static ItemStack getPlayerHead(String playername, Integer amount) {
        String nameIdJsonString = DataFunctions.readStringFromURL(GlobalVariables.playerDataURL + playername.toLowerCase());
        if (nameIdJsonString.equals("")) {
            return null;
        }
        try {
            Map nameIdJson = (Map)new Gson().fromJson(nameIdJsonString, new TypeToken<HashMap<String, String>>(){}.getType());
            String headName = (String)nameIdJson.get("name");
            String headUUID = (String)nameIdJson.get("id");
            String profileJsonString = DataFunctions.readStringFromURL(GlobalVariables.skinDataURL + headUUID);
            if (profileJsonString.equals("")) {
                return null;
            }
            String[] rawValue = profileJsonString.replaceAll(" ", "").split("value\":\"");
            String texturevalue = rawValue[1].split("\"")[0];
            String d = new String(Base64.getDecoder().decode(texturevalue.getBytes()));
            String texture = Base64.getEncoder().encodeToString(("{\"textures\"" + d.split("\"textures\"")[1]).getBytes());
            String oldid = new UUID(texture.hashCode(), texture.hashCode()).toString();
            return HeadFunctions.getTexturedHead(headName + "'s Head", texture, oldid, 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public static ItemStack getTexturedHead(String headname, String texture, String oldid, Integer amount) {
        ItemStack texturedhead = new ItemStack((ItemLike)Items.PLAYER_HEAD, amount.intValue());
        List<Integer> intarray = UUIDFunctions.oldIdToIntArray(oldid);
        CompoundTag skullOwner = new CompoundTag();
        skullOwner.putIntArray("Id", intarray);
        CompoundTag properties = new CompoundTag();
        ListTag textures = new ListTag();
        CompoundTag tex = new CompoundTag();
        tex.putString("Value", texture);
        textures.add((Object)tex);
        properties.put("textures", (Tag)textures);
        skullOwner.put("Properties", (Tag)properties);
        texturedhead.addTagElement("SkullOwner", (Tag)skullOwner);
        MutableComponent tcname = Component.literal((String)headname);
        texturedhead.setHoverName((Component)tcname);
        return texturedhead;
    }
}

