/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_fabric.functions;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.natamus.collective_common_fabric.data.GlobalVariables;
import com.natamus.collective_common_fabric.features.PlayerHeadCacheFeature;
import com.natamus.collective_common_fabric.functions.DataFunctions;
import com.natamus.collective_common_fabric.functions.UUIDFunctions;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_4844;
import net.minecraft.class_5250;

public class HeadFunctions {
    public static class_1799 getNewPlayerHead(class_3218 serverLevel, String playerName, Integer amount) {
        GameProfile gameProfile = HeadFunctions.getGameProfileFromPlayerName(serverLevel, playerName);
        if (gameProfile == null) {
            return null;
        }
        return HeadFunctions.getNewPlayerHead(gameProfile, amount);
    }

    public static class_1799 getNewPlayerHead(GameProfile gameProfile, Integer amount) {
        if (gameProfile == null) {
            return null;
        }
        PropertyMap propertyMap = gameProfile.getProperties();
        String encodedTextures = "";
        for (Property textureProperty : propertyMap.get((Object)"textures")) {
            if (!textureProperty.name().equals("textures")) continue;
            encodedTextures = textureProperty.value();
            break;
        }
        String decodedTextures = new String(Base64.getDecoder().decode(encodedTextures));
        StringBuilder decodedNoTimestampTextures = new StringBuilder();
        for (String line : decodedTextures.split("\n")) {
            if (!decodedNoTimestampTextures.toString().equals("")) {
                decodedNoTimestampTextures.append("\n");
            }
            if (line.contains("\"timestamp\" : ")) {
                decodedNoTimestampTextures.append("  \"timestamp\" : 0,");
                continue;
            }
            decodedNoTimestampTextures.append(line);
        }
        String textures = Base64.getEncoder().encodeToString(decodedNoTimestampTextures.toString().getBytes());
        if (textures.isEmpty()) {
            return null;
        }
        int[] headIntArray = class_4844.method_26275((UUID)gameProfile.getId());
        return HeadFunctions.getNewTexturedHead(gameProfile.getName(), textures, headIntArray, amount);
    }

    public static class_1799 getNewTexturedHead(String playerName, String texture, String uuidString, Integer amount) {
        UUID uuid = UUIDFunctions.getUUIDFromStringLenient(uuidString);
        int[] intArray = class_4844.method_26275((UUID)uuid);
        return HeadFunctions.getNewTexturedHead(playerName, texture, intArray, amount);
    }

    public static class_1799 getNewTexturedHead(String playerName, String texture, int[] idIntArray, Integer amount) {
        class_1799 texturedHeadStack = new class_1799((class_1935)class_1802.field_8575, amount.intValue());
        class_2487 skullOwnerCompoundTag = HeadFunctions.getSkullOwnerCompoundTag(playerName, texture, idIntArray);
        texturedHeadStack.method_7959("SkullOwner", (class_2520)skullOwnerCompoundTag);
        class_5250 tcname = class_2561.method_43470((String)(playerName + "'s Head"));
        texturedHeadStack.method_7977((class_2561)tcname);
        return texturedHeadStack;
    }

    public static GameProfile getGameProfileFromPlayerName(class_3218 serverLevel, String playerName) {
        GameProfile gameProfile;
        UUID headUUID;
        MinecraftSessionService minecraftSessionService = serverLevel.method_8503().method_3844();
        if (PlayerHeadCacheFeature.cachedPlayerNamesMap.containsKey(playerName.toLowerCase())) {
            headUUID = PlayerHeadCacheFeature.cachedPlayerNamesMap.get(playerName.toLowerCase());
            playerName = PlayerHeadCacheFeature.cachedPlayerUUIDsMap.get(headUUID);
        } else {
            String nameIdJsonString = DataFunctions.readStringFromURL(GlobalVariables.playerDataURL + playerName.toLowerCase());
            if (nameIdJsonString.equals("")) {
                return null;
            }
            Map nameIdJson = (Map)new Gson().fromJson(nameIdJsonString, new TypeToken<HashMap<String, String>>(){}.getType());
            String headName = (String)nameIdJson.get("name");
            String headUUIDRaw = (String)nameIdJson.get("id");
            headUUID = UUIDFunctions.getUUIDFromStringLenient(headUUIDRaw);
            PlayerHeadCacheFeature.cachedPlayerNamesMap.put(headName.toLowerCase(), headUUID);
            PlayerHeadCacheFeature.cachedPlayerUUIDsMap.put(headUUID, headName);
        }
        if (PlayerHeadCacheFeature.cachedGameProfileMap.containsKey(headUUID)) {
            gameProfile = PlayerHeadCacheFeature.cachedGameProfileMap.get(headUUID);
        } else {
            ProfileResult profileResult = minecraftSessionService.fetchProfile(headUUID, false);
            if (profileResult == null) {
                return null;
            }
            gameProfile = profileResult.profile();
            if (gameProfile == null) {
                return null;
            }
            PlayerHeadCacheFeature.cachedGameProfileMap.put(headUUID, gameProfile);
        }
        return gameProfile;
    }

    public static class_2487 getSkullOwnerCompoundTag(class_3218 serverLevel, String playerName) {
        GameProfile gameProfile = HeadFunctions.getGameProfileFromPlayerName(serverLevel, playerName);
        PropertyMap propertyMap = gameProfile.getProperties();
        String textures = "";
        for (Property textureProperty : propertyMap.get((Object)"textures")) {
            if (!textureProperty.name().equals("textures")) continue;
            textures = textureProperty.value();
        }
        if (textures.equals("")) {
            return null;
        }
        int[] headIntArray = class_4844.method_26275((UUID)gameProfile.getId());
        return HeadFunctions.getSkullOwnerCompoundTag(playerName, textures, headIntArray);
    }

    public static class_2487 getSkullOwnerCompoundTag(String playerName, String textures, int[] idIntArray) {
        class_2487 skullOwnerCompoundTag = new class_2487();
        skullOwnerCompoundTag.method_10582("Name", playerName);
        skullOwnerCompoundTag.method_10539("Id", idIntArray);
        class_2487 propertiesCompoundTag = new class_2487();
        class_2499 texturesListTag = new class_2499();
        class_2487 texturesCompoundTag = new class_2487();
        texturesCompoundTag.method_10582("Value", textures);
        texturesListTag.add((Object)texturesCompoundTag);
        propertiesCompoundTag.method_10566("textures", (class_2520)texturesListTag);
        skullOwnerCompoundTag.method_10566("Properties", (class_2520)propertiesCompoundTag);
        return skullOwnerCompoundTag;
    }

    public static boolean hasStandardHead(String mobname) {
        return mobname.equals("creeper") || mobname.equals("zombie") || mobname.equals("skeleton");
    }

    public static class_1799 getPlayerHead(String playername, Integer amount) {
        String nameIdJsonString = DataFunctions.readStringFromURL(GlobalVariables.playerDataURL + playername.toLowerCase());
        if (nameIdJsonString.equals("")) {
            return null;
        }
        try {
            Map nameIdJson = (Map)new Gson().fromJson(nameIdJsonString, new TypeToken<HashMap<String, String>>(){}.getType());
            String headName = (String)nameIdJson.get("name");
            String headUUID = (String)nameIdJson.get("id");
            String profileJsonString = DataFunctions.readStringFromURL(GlobalVariables.skinDataURL + headUUID);
            if (profileJsonString.equals("")) {
                return null;
            }
            String[] rawValue = profileJsonString.replaceAll(" ", "").split("value\":\"");
            String texturevalue = rawValue[1].split("\"")[0];
            String d = new String(Base64.getDecoder().decode(texturevalue.getBytes()));
            String texture = Base64.getEncoder().encodeToString(("{\"textures\"" + d.split("\"textures\"")[1]).getBytes());
            String oldid = new UUID(texture.hashCode(), texture.hashCode()).toString();
            return HeadFunctions.getTexturedHead(headName + "'s Head", texture, oldid, 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public static class_1799 getTexturedHead(String headname, String texture, String oldid, Integer amount) {
        class_1799 texturedhead = new class_1799((class_1935)class_1802.field_8575, amount.intValue());
        List<Integer> intarray = UUIDFunctions.oldIdToIntArray(oldid);
        class_2487 skullOwner = new class_2487();
        skullOwner.method_10572("Id", intarray);
        class_2487 properties = new class_2487();
        class_2499 textures = new class_2499();
        class_2487 tex = new class_2487();
        tex.method_10582("Value", texture);
        textures.add((Object)tex);
        properties.method_10566("textures", (class_2520)textures);
        skullOwner.method_10566("Properties", (class_2520)properties);
        texturedhead.method_7959("SkullOwner", (class_2520)skullOwner);
        class_5250 tcname = class_2561.method_43470((String)headname);
        texturedhead.method_7977((class_2561)tcname);
        return texturedhead;
    }
}

