/*
 * Decompiled with CFR 0.152.
 */
package cc.cosmetica.cosmetica.utils.textures;

import cc.cosmetica.cosmetica.Cosmetica;
import cc.cosmetica.cosmetica.mixin.textures.NativeImageAccessorMixin;
import com.mojang.blaze3d.platform.TextureUtil;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1011;
import net.minecraft.class_1046;
import net.minecraft.class_1061;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class CosmeticIconTexture
extends class_1046
implements class_1061 {
    private int frameHeight;
    private int frames;
    private int frame;
    private int tick;
    private class_1011 image;
    private final String url;
    private final Set<String> indicators;

    public CosmeticIconTexture(@Nullable File file, String url) {
        super(file, url, new class_2960("cosmetica", "textures/gui/loading.png"), false, null);
        this.url = url;
        this.indicators = new HashSet<String>();
    }

    public void firstUpload(class_1011 image, boolean loading) {
        if (this.image != null && ((NativeImageAccessorMixin)this.image).getPixels() != 0L) {
            this.image.close();
        }
        this.image = image;
        this.frames = image.method_4323() / image.method_4307();
        this.frameHeight = image.method_4323() / this.frames;
        this.frame = 0;
        try {
            this.upload(image, !loading);
        }
        catch (IllegalStateException e) {
            Cosmetica.LOGGER.error("Error while uploading icon texture (loading: {}, icon url: {})", (Object)loading, (Object)this.url);
            e.printStackTrace();
        }
    }

    public void upload(class_1011 image, boolean close) {
        TextureUtil.prepareImage((int)this.method_4624(), (int)0, (int)image.method_4307(), (int)this.frameHeight);
        image.method_22619(0, 0, 0, 0, this.frameHeight * this.frame, image.method_4307(), this.frameHeight, this.field_5205, false, false, close);
    }

    public void method_4622() {
        if (this.frames > 1 && this.image != null && ((NativeImageAccessorMixin)this.image).getPixels() != 0L) {
            this.tick = (this.tick + 1) % 2;
            if (this.tick == 0) {
                this.frame = (this.frame + 1) % this.frames;
                this.upload(this.image, false);
            }
        }
    }

    public void close() {
        if (this.image != null) {
            this.image.close();
        }
    }

    private static void copyRect(class_1011 src, int srcX, int srcY, class_1011 dest, int destX, int destY, int width, int height) {
        for (int dx = 0; dx < width; ++dx) {
            for (int dy = 0; dy < height; ++dy) {
                int colour = src.method_4315(srcX + dx, srcY + dy);
                dest.method_4305(destX + dx, destY + dy, colour);
            }
        }
    }
}

