/*
 * Decompiled with CFR 0.152.
 */
package cc.cosmetica.cosmetica.utils.textures;

import cc.cosmetica.cosmetica.Cosmetica;
import cc.cosmetica.cosmetica.mixin.textures.NativeImageAccessorMixin;
import cc.cosmetica.cosmetica.utils.DebugMode;
import cc.cosmetica.cosmetica.utils.textures.AnimatedTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import net.minecraft.class_1011;
import net.minecraft.class_1061;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import org.lwjgl.system.MemoryUtil;

public class Base64Texture
extends AnimatedTexture {
    private final class_2960 path;
    private final String base64;

    private Base64Texture(class_2960 path, String base64, class_1011 initialImage, int aspectRatio) throws IOException {
        super(aspectRatio);
        this.base64 = base64;
        this.path = path;
        this.loadImage(initialImage);
    }

    public void method_4625(class_3300 resourceManager) {
        if (((NativeImageAccessorMixin)this.image).getPixels() == 0L) {
            if (RenderSystem.isOnRenderThreadOrInit()) {
                this.reload();
            } else {
                RenderSystem.recordRenderCall(this::reload);
            }
            return;
        }
        this.upload();
    }

    private void reload() {
        DebugMode.log("Re-uploading texture {}", this.path);
        try {
            this.loadImage(Base64Texture.loadBase64(this.base64));
            this.upload();
        }
        catch (IOException e) {
            Cosmetica.LOGGER.error("Error re-uploading Base64 Texture", (Throwable)e);
        }
    }

    private void loadImage(class_1011 image) {
        this.image = image;
        if (this.isAnimatable()) {
            this.setupAnimations();
        } else {
            this.setupStatic();
        }
    }

    private static class_1011 loadBase64(String base64) throws IOException {
        byte[] bs = Base64.getDecoder().decode(base64.replace("\n", "").getBytes(StandardCharsets.UTF_8));
        ByteBuffer buffer = MemoryUtil.memAlloc((int)bs.length);
        buffer.put(bs);
        buffer.rewind();
        class_1011 image = class_1011.method_4324((ByteBuffer)buffer);
        MemoryUtil.memFree((Buffer)buffer);
        return image;
    }

    public static Base64Texture square(class_2960 path, String base64, int frameDelayMs) throws IOException {
        class_1011 image = Base64Texture.loadBase64(base64);
        if (image.method_4323() > image.method_4307()) {
            return new TickingCape(path, base64, image, frameDelayMs, 1);
        }
        return new Base64Texture(path, base64, image, 0);
    }

    public static Base64Texture cape(class_2960 path, String base64, int frameDelayMs) throws IOException {
        class_1011 image = Base64Texture.loadBase64(base64);
        if (image.method_4323() >= image.method_4307()) {
            return new TickingCape(path, base64, image, frameDelayMs, 2);
        }
        return new Base64Texture(path, base64, image, 0);
    }

    public static Base64Texture skin(class_2960 path, String base64) throws IOException {
        return new Base64Texture(path, base64, Base64Texture.loadBase64(base64), 0);
    }

    private static class TickingCape
    extends Base64Texture
    implements class_1061 {
        private TickingCape(class_2960 path, String base64, class_1011 initialImage, int frameDelayMs, int aspectRatio) throws IOException {
            super(path, base64, initialImage, aspectRatio);
            this.frameCounterTicks = Math.max(1, frameDelayMs / 50);
        }

        public void method_4622() {
            this.doTick();
        }
    }
}

