/*
 * Decompiled with CFR 0.152.
 */
package cc.cosmetica.cosmetica.utils.collections;

import cc.cosmetica.cosmetica.utils.collections.LazyMap;
import com.mojang.datafixers.util.Either;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class HashMapBackedLazyMap<K, V>
implements LazyMap<K, V> {
    private final Map<K, Either<Supplier<V>, V>> map = new HashMap<K, Either<Supplier<V>, V>>();
    private int size;

    @Override
    public void put(K key, Supplier<V> value) {
        this.map.put(key, Either.left(value));
    }

    @Override
    public V get(K key) {
        Either<Supplier<V>, V> item = this.map.get(key);
        if (item.left().isPresent()) {
            Object value = ((Supplier)item.left().get()).get();
            this.map.put(key, Either.right(value));
            ++this.size;
            return (V)value;
        }
        return (V)item.right().get();
    }

    @Override
    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean isEvaluated(K key) {
        return this.map.containsKey(key) && this.map.get(key).right().isPresent();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int capacity() {
        return this.map.size();
    }
}

