/*
 * Decompiled with CFR 0.152.
 */
package cc.cosmetica.cosmetica.utils;

import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;

public class Scheduler {
    private static final AtomicInteger TASK_NUMBER = new AtomicInteger(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeScheduledTasks(Location location) {
        int i = location.tasks.size();
        while (i-- > 0) {
            location.tasks.remove().run();
        }
        Int2ObjectMap<Runnable> int2ObjectMap = location.repeatables;
        synchronized (int2ObjectMap) {
            for (Runnable repeatableTask : location.repeatables.values()) {
                repeatableTask.run();
            }
        }
    }

    public static void scheduleTask(Location location, Runnable r) {
        location.tasks.add(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int scheduleRepeatable(Location location, Runnable r) {
        int tn = TASK_NUMBER.getAndIncrement();
        Int2ObjectMap<Runnable> int2ObjectMap = location.repeatables;
        synchronized (int2ObjectMap) {
            location.repeatables.put(tn, (Object)r);
        }
        return tn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearRepeatable(Location location, int taskId) {
        Int2ObjectMap<Runnable> int2ObjectMap = location.repeatables;
        synchronized (int2ObjectMap) {
            location.repeatables.remove(taskId);
        }
    }

    public static enum Location {
        TEXTURE_TICK;

        private final Queue<Runnable> tasks = new ArrayDeque<Runnable>();
        private final Int2ObjectMap<Runnable> repeatables = new Int2ObjectLinkedOpenHashMap();
    }
}

