/*
 * Decompiled with CFR 0.152.
 */
package cc.cosmetica.cosmetica.utils;

import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class MutableOptionalFloat {
    private float value;
    private boolean isPresent;

    private MutableOptionalFloat() {
        this.isPresent = false;
    }

    private MutableOptionalFloat(float value) {
        this.isPresent = true;
        this.value = value;
    }

    public float get() throws NullPointerException {
        if (!this.isPresent) {
            throw new NullPointerException("No value present.");
        }
        return this.value;
    }

    public float orElse(float value) {
        if (!this.isPresent) {
            this.isPresent = true;
            this.value = value;
        }
        return this.value;
    }

    public float orElseGet(FloatSupplier supplier) {
        if (!this.isPresent) {
            this.isPresent = true;
            this.value = supplier.get();
        }
        return this.value;
    }

    public MutableOptionalFloat computeIfAbsent(Supplier<@Nullable Float> ifAbsent) {
        Float newValue;
        if (!this.isPresent && (newValue = ifAbsent.get()) != null) {
            this.isPresent = true;
            this.value = newValue.floatValue();
        }
        return this;
    }

    public static MutableOptionalFloat of(float f) {
        return new MutableOptionalFloat(f);
    }

    public static MutableOptionalFloat empty() {
        return new MutableOptionalFloat();
    }

    @FunctionalInterface
    public static interface FloatSupplier {
        public float get();
    }
}

