/*
 * Decompiled with CFR 0.152.
 */
package cc.cosmetica.cosmetica.screens.widget;

import cc.cosmetica.api.CosmeticType;
import cc.cosmetica.api.CustomCape;
import cc.cosmetica.api.CustomCosmetic;
import cc.cosmetica.api.Model;
import cc.cosmetica.cosmetica.Cosmetica;
import cc.cosmetica.cosmetica.CosmeticaSkinManager;
import cc.cosmetica.cosmetica.screens.widget.Selection;
import cc.cosmetica.cosmetica.utils.TextComponents;
import cc.cosmetica.cosmetica.utils.textures.CosmeticIconTexture;
import cc.cosmetica.cosmetica.utils.textures.Indicators;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class CosmeticSelection<T extends CustomCosmetic>
extends Selection<Entry> {
    private final String cosmeticType;
    private final Map<String, Entry> byId = new HashMap<String, Entry>();
    private static final int OFFSET_X = 45;

    public CosmeticSelection(class_310 minecraft, class_437 parent, String cosmeticType, class_327 font, Consumer<String> onSelect) {
        super(minecraft, parent, font, 64, 25, 60, onSelect);
        this.cosmeticType = cosmeticType;
    }

    public void add(T cosmetic) {
        this._add(cosmetic, true);
    }

    public void addWithoutRegisteringTexture(T cosmetic) {
        this._add(cosmetic, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(CosmeticSelection<T> other) {
        class_1060 class_10602 = this.field_22740.method_1531();
        synchronized (class_10602) {
            for (Entry entry : other.method_25396()) {
                this._add(entry.cosmetic, true);
            }
        }
    }

    protected final void _add(T cosmetic, boolean register) {
        Entry entry = new Entry(this, cosmetic, register);
        this.method_25321((class_350.class_351)entry);
        this.byId.put(cosmetic.getId(), entry);
    }

    @Override
    protected Entry findEntry(Entry key) {
        return this.byId.get(key.item);
    }

    @Nullable
    public T getSelectedCosmetic() {
        @Nullable Entry selected = (Entry)this.method_25334();
        return selected == null ? null : (T)selected.cosmetic;
    }

    public void method_16014(double mouseX, double mouseY) {
        for (Entry entry : this.byId.values()) {
            entry.method_16014(mouseX, mouseY);
        }
    }

    protected void method_44398(class_332 poseStack, int y0, int j, int dy, int colour1, int colour2) {
        int x0 = this.method_46426() + (this.field_22758 - j) / 2 + 45;
        int x1 = this.method_46426() + (this.field_22758 + j) / 2;
        poseStack.method_51739(class_1921.method_51784(), x0, y0 - 2, x1, y0 + dy + 2, colour1);
        poseStack.method_51739(class_1921.method_51784(), x0 + 1, y0 - 1, x1 - 1, y0 + dy + 1, colour2);
    }

    protected class Entry
    extends Selection.Entry<Entry> {
        private final String displayName;
        private final T cosmetic;
        private final class_2960 texture;
        private volatile boolean textureRegistered;
        private final List<class_2960> indicators;
        private final class_437 screen;
        @Nullable
        private class_2960 hoveredIndicator;
        private int indicatorStartY;
        private int mouseX;
        private int mouseY;
        final /* synthetic */ CosmeticSelection this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public Entry(T cosmetic, boolean register) {
            int n;
            this.this$0 = (CosmeticSelection)this$0;
            super((Selection)this$0, cosmetic.getId());
            this.textureRegistered = false;
            this.indicatorStartY = 100000000;
            String cosmeticId = cosmetic.getId();
            this.displayName = cosmetic.getName();
            this.cosmetic = cosmetic;
            this.texture = new class_2960("cosmetica", "icon/" + CosmeticaSkinManager.pathify(cosmeticId));
            CosmeticType cosmeticType = cosmetic.getType();
            if (cosmetic instanceof Model) {
                Model model = (Model)cosmetic;
                n = model.flags();
            } else {
                n = ((CustomCape)cosmetic).getFrameDelay();
            }
            this.indicators = Indicators.getIcons(cosmeticType, n);
            if (register) {
                if (RenderSystem.isOnRenderThreadOrInit()) {
                    class_310.method_1551().method_1531().method_4616(this.texture, (class_1044)new CosmeticIconTexture(Cosmetica.getCacheDirectory().resolve(".icon_cache").resolve(cosmeticId.substring(0, 2)).resolve(cosmeticId + "-" + this.cosmetic.getType().getUrlString() + ".png").toFile(), String.format("http://images.cosmetica.cc/?subject=%s&type=icon&id=%s", this$0.cosmeticType, cosmeticId)));
                    this.textureRegistered = true;
                } else {
                    Cosmetica.LOGGER.warn("Tried to register cosmetic icon texture on thread \"{}\". Avoiding crashes by delaying registration!", (Object)Thread.currentThread().getName());
                    RenderSystem.recordRenderCall(() -> {
                        class_310.method_1551().method_1531().method_4616(this.texture, (class_1044)new CosmeticIconTexture(Cosmetica.getCacheDirectory().resolve(".icon_cache").resolve(cosmeticId.substring(0, 2)).resolve(cosmeticId + "-" + this.cosmetic.getType().getUrlString() + ".png").toFile(), String.format("http://images.cosmetica.cc/?subject=%s&type=icon&id=%s", this.this$0.cosmeticType, cosmeticId)));
                        this.textureRegistered = true;
                    });
                }
            }
            this.screen = this.selection.parent;
        }

        public void method_25343(class_332 graphics, int x, int y, int k, int l, int m, int n, int o, boolean isHovered, float f) {
            class_4587 poseStack = graphics.method_51448();
            this.indicatorStartY = y + 16;
            x = class_310.method_1551().field_1755.field_22789 / 2 - 60;
            int textY = y;
            y += 28;
            Matrix4f pose = poseStack.method_23760().method_23761();
            if (this.textureRegistered) {
                Cosmetica.renderTexture(pose, this.texture, x - 25, x + 25, y - 25, y + 25, 0, 1.0f);
            }
            graphics.method_51433(this.selection.font, this.displayName, x + 30, textY + 6, 0xFFFFFF, true);
            int indicatorX = x + 30;
            for (class_2960 location : this.indicators) {
                Cosmetica.renderTexture(pose, location, indicatorX, indicatorX + 10, this.indicatorStartY, this.indicatorStartY + 10, 0, 1.0f);
                indicatorX += 14;
            }
            if (this.hoveredIndicator != null) {
                graphics.method_51438(this.selection.font, (class_2561)Indicators.TOOLTIPS.get(this.hoveredIndicator), this.mouseX, this.mouseY + 8);
            }
        }

        public void method_16014(double mouseX, double mouseY) {
            this.mouseX = (int)mouseX;
            this.mouseY = (int)mouseY;
            int indicatorStartX = class_310.method_1551().field_1755.field_22789 / 2 - 60 + 30;
            for (class_2960 location : this.indicators) {
                if (mouseX >= (double)indicatorStartX && mouseX <= (double)(indicatorStartX + 10) && mouseY >= (double)this.indicatorStartY && mouseY <= (double)(this.indicatorStartY + 10)) {
                    this.hoveredIndicator = location;
                    return;
                }
                indicatorStartX += 14;
            }
            this.hoveredIndicator = null;
        }

        @Override
        public boolean method_25402(double mouseX, double mouseY, int i) {
            if (mouseX >= (double)(this.this$0.method_46426() + this.this$0.field_22758 / 2 - this.this$0.method_25322() / 2 + 45)) {
                return super.method_25402(mouseX, mouseY, i);
            }
            return false;
        }

        public class_2561 method_37006() {
            return TextComponents.formattedTranslatable("narrator.select", this.displayName);
        }
    }
}

