/*
 * Decompiled with CFR 0.152.
 */
package cc.cosmetica.cosmetica.screens.fakeplayer;

import cc.cosmetica.cosmetica.Cosmetica;
import cc.cosmetica.cosmetica.mixin.fakeplayer.HumanoidModelAccessor;
import cc.cosmetica.cosmetica.mixin.fakeplayer.PlayerModelAccessor;
import cc.cosmetica.cosmetica.screens.fakeplayer.FakePlayer;
import cc.cosmetica.cosmetica.screens.fakeplayer.MenuRenderLayer;
import cc.cosmetica.cosmetica.utils.LinearAlgebra;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1299;
import net.minecraft.class_1306;
import net.minecraft.class_148;
import net.minecraft.class_1664;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4896;
import net.minecraft.class_5348;
import net.minecraft.class_572;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class FakePlayerRenderer {
    public static Quaternionf cameraOrientation = LinearAlgebra.QUATERNION_ONE;

    public static void render(class_4587 stack, FakePlayer player, class_4597 bufferSource, double xOffset, double yOffset, double zOffset, float rotation, float delta, int light) {
        try {
            class_243 vec3 = FakePlayerRenderer.getRenderOffset(player, delta);
            double x = xOffset + vec3.method_10216();
            double y = yOffset + vec3.method_10214();
            double z = zOffset + vec3.method_10215();
            stack.method_22903();
            stack.method_22904(x, y, z);
            FakePlayerRenderer.drawFakePlayer(player, rotation, delta, stack, bufferSource, light);
            stack.method_22909();
        }
        catch (Throwable var24) {
            class_128 crashReport = class_128.method_560((Throwable)var24, (String)"Rendering fake player in menu");
            crashReport.method_562("Fake Player being rendered");
            class_129 crashReportCategory2 = crashReport.method_562("Renderer details");
            crashReportCategory2.method_578("Location", (Object)(xOffset + "," + yOffset + "," + zOffset));
            crashReportCategory2.method_578("Rotation", (Object)Float.valueOf(rotation));
            crashReportCategory2.method_578("Delta", (Object)Float.valueOf(delta));
            throw new class_148(crashReport);
        }
    }

    private static class_243 getRenderOffset(FakePlayer player, float delta) {
        return player.isSneaking() ? new class_243(0.0, -0.125, 0.0) : class_243.field_1353;
    }

    private static void drawFakePlayer(FakePlayer player, float rotation, float delta, class_4587 stack, class_4597 bufferSource, int light) {
        FakePlayerRenderer.setModelProperties(player);
        FakePlayerRenderer.drawLivingEntity(player, rotation, delta, stack, bufferSource, light);
    }

    private static void setModelProperties(FakePlayer fakePlayer) {
        class_591<class_742> playerModel = fakePlayer.getModel();
        playerModel.method_2805(true);
        playerModel.field_3394.field_3665 = fakePlayer.isModelPartShown(class_1664.field_7563);
        playerModel.field_3483.field_3665 = fakePlayer.isModelPartShown(class_1664.field_7564);
        playerModel.field_3482.field_3665 = fakePlayer.isModelPartShown(class_1664.field_7566);
        playerModel.field_3479.field_3665 = fakePlayer.isModelPartShown(class_1664.field_7565);
        playerModel.field_3484.field_3665 = fakePlayer.isModelPartShown(class_1664.field_7568);
        playerModel.field_3486.field_3665 = fakePlayer.isModelPartShown(class_1664.field_7570);
        playerModel.field_3400 = fakePlayer.isSneaking();
        if (fakePlayer.getMainArm() == class_1306.field_6183) {
            playerModel.field_3395 = fakePlayer.isMainArmRaised() ? class_572.class_573.field_3410 : class_572.class_573.field_3409;
            playerModel.field_3399 = class_572.class_573.field_3409;
        } else {
            playerModel.field_3395 = class_572.class_573.field_3409;
            playerModel.field_3399 = fakePlayer.isMainArmRaised() ? class_572.class_573.field_3410 : class_572.class_573.field_3409;
        }
    }

    private static void drawLivingEntity(FakePlayer player, float rotation, float delta, class_4587 stack, class_4597 bufferSource, int light) {
        stack.method_22903();
        class_591<class_742> model = player.getModel();
        model.field_3447 = 0.0f;
        model.field_3449 = false;
        model.field_3448 = false;
        float yRotBody = player.getYRotBody(delta);
        float yRotHead = player.getYRotHead(delta);
        float yRotDiff = yRotHead - yRotBody;
        float bob = delta;
        float xRot = player.getXRot(delta);
        if (player.getData().upsideDown()) {
            xRot *= -1.0f;
            yRotDiff *= -1.0f;
        }
        FakePlayerRenderer.setupRotations(player, stack, bob, yRotBody, delta);
        stack.method_22905(-1.0f, -1.0f, 1.0f);
        stack.method_22905(0.9375f, 0.9375f, 0.9375f);
        stack.method_22904(0.0, (double)-1.501f, 0.0);
        float animationSpeed = 0.0f;
        float animationPosition = 0.0f;
        if (animationSpeed > 1.0f) {
            animationSpeed = 1.0f;
        }
        FakePlayerRenderer.modelSetupAnim(model, player, animationPosition, animationSpeed, bob, yRotDiff, xRot);
        class_1921 renderType = FakePlayerRenderer.getRenderType(player, true, false, false);
        if (renderType != null) {
            class_4588 vertexConsumer = bufferSource.getBuffer(renderType);
            int packedOverlayCoords = FakePlayerRenderer.getOverlayCoords(0.0f);
            model.method_2828(stack, vertexConsumer, light, packedOverlayCoords, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        for (MenuRenderLayer layer : player.getLayers()) {
            layer.render(stack, bufferSource, light, player, animationPosition, animationSpeed, delta, bob, yRotDiff, xRot);
        }
        stack.method_22909();
        if (player.renderNametag) {
            FakePlayerRenderer.renderNameTag(player, stack, bufferSource, light);
        }
    }

    private static class_1921 getRenderType(FakePlayer player, boolean isVisible, boolean isInvisibleToPlayer, boolean isGlowing) {
        class_2960 resourceLocation = player.getSkin();
        if (isInvisibleToPlayer) {
            return class_1921.method_29379((class_2960)resourceLocation);
        }
        if (isVisible) {
            return player.getModel().method_23500(resourceLocation);
        }
        return isGlowing ? class_1921.method_23287((class_2960)resourceLocation) : null;
    }

    private static void modelSetupAnim(class_591<class_742> model, FakePlayer player, float f, float g, float bob, float yRotDiff, float xRot) {
        boolean bl4;
        class_630 currentModel;
        model.field_3398.field_3675 = yRotDiff * ((float)Math.PI / 180);
        model.field_3398.field_3654 = model.field_3396 > 0.0f ? ((HumanoidModelAccessor)model).invokeRotlerpRad(model.field_3396, model.field_3398.field_3654, xRot * ((float)Math.PI / 180)) : xRot * ((float)Math.PI / 180);
        model.field_3391.field_3675 = 0.0f;
        model.field_3401.field_3655 = 0.0f;
        model.field_3401.field_3657 = -5.0f;
        model.field_27433.field_3655 = 0.0f;
        model.field_27433.field_3657 = 5.0f;
        float k = 1.0f;
        if (k < 1.0f) {
            k = 1.0f;
        }
        model.field_3401.field_3654 = class_3532.method_15362((float)(f * 0.6662f + (float)Math.PI)) * 2.0f * g * 0.5f / k;
        model.field_27433.field_3654 = class_3532.method_15362((float)(f * 0.6662f)) * 2.0f * g * 0.5f / k;
        model.field_3401.field_3674 = 0.0f;
        model.field_27433.field_3674 = 0.0f;
        model.field_3392.field_3654 = class_3532.method_15362((float)(f * 0.6662f)) * 1.4f * g / k;
        model.field_3397.field_3654 = class_3532.method_15362((float)(f * 0.6662f + (float)Math.PI)) * 1.4f * g / k;
        model.field_3392.field_3675 = 0.0f;
        model.field_3397.field_3675 = 0.0f;
        model.field_3392.field_3674 = 0.0f;
        model.field_3397.field_3674 = 0.0f;
        if (model.field_3449) {
            currentModel = model.field_3401;
            currentModel.field_3654 += -0.62831855f;
            currentModel = model.field_27433;
            currentModel.field_3654 += -0.62831855f;
            model.field_3392.field_3654 = -1.4137167f;
            model.field_3392.field_3675 = 0.31415927f;
            model.field_3392.field_3674 = 0.07853982f;
            model.field_3397.field_3654 = -1.4137167f;
            model.field_3397.field_3675 = -0.31415927f;
            model.field_3397.field_3674 = -0.07853982f;
        }
        model.field_3401.field_3675 = 0.0f;
        model.field_27433.field_3675 = 0.0f;
        boolean bl3 = player.getMainArm() == class_1306.field_6183;
        boolean bl = bl4 = bl3 ? model.field_3399.method_30156() : model.field_3395.method_30156();
        if (bl3 != bl4) {
            FakePlayerRenderer.poseLeftArm(model);
            FakePlayerRenderer.poseRightArm(model);
        } else {
            FakePlayerRenderer.poseRightArm(model);
            FakePlayerRenderer.poseLeftArm(model);
        }
        if (model.field_3400) {
            model.field_3391.field_3654 = 0.5f;
            currentModel = model.field_3401;
            currentModel.field_3654 += 0.4f;
            currentModel = model.field_27433;
            currentModel.field_3654 += 0.4f;
            model.field_3392.field_3655 = 4.0f;
            model.field_3397.field_3655 = 4.0f;
            model.field_3392.field_3656 = 12.2f;
            model.field_3397.field_3656 = 12.2f;
            model.field_3398.field_3656 = 4.2f;
            model.field_3391.field_3656 = 3.2f;
            model.field_27433.field_3656 = 5.2f;
            model.field_3401.field_3656 = 5.2f;
        } else {
            model.field_3391.field_3654 = 0.0f;
            model.field_3392.field_3655 = 0.1f;
            model.field_3397.field_3655 = 0.1f;
            model.field_3392.field_3656 = 12.0f;
            model.field_3397.field_3656 = 12.0f;
            model.field_3398.field_3656 = 0.0f;
            model.field_3391.field_3656 = 0.0f;
            model.field_27433.field_3656 = 2.0f;
            model.field_3401.field_3656 = 2.0f;
        }
        if (model.field_3395 != class_572.class_573.field_27434) {
            class_4896.method_29350((class_630)model.field_3401, (float)bob, (float)1.0f);
        }
        if (model.field_3399 != class_572.class_573.field_27434) {
            class_4896.method_29350((class_630)model.field_27433, (float)bob, (float)-1.0f);
        }
        if (model.field_3396 > 0.0f) {
            float n;
            float l = f % 26.0f;
            class_1306 humanoidArm = player.getMainArm();
            float m = humanoidArm == class_1306.field_6183 && model.field_3447 > 0.0f ? 0.0f : model.field_3396;
            float f2 = n = humanoidArm == class_1306.field_6182 && model.field_3447 > 0.0f ? 0.0f : model.field_3396;
            if (l < 14.0f) {
                model.field_27433.field_3654 = ((HumanoidModelAccessor)model).invokeRotlerpRad(n, model.field_27433.field_3654, 0.0f);
                model.field_3401.field_3654 = class_3532.method_16439((float)m, (float)model.field_3401.field_3654, (float)0.0f);
                model.field_27433.field_3675 = ((HumanoidModelAccessor)model).invokeRotlerpRad(n, model.field_27433.field_3675, (float)Math.PI);
                model.field_3401.field_3675 = class_3532.method_16439((float)m, (float)model.field_3401.field_3675, (float)((float)Math.PI));
                model.field_27433.field_3674 = ((HumanoidModelAccessor)model).invokeRotlerpRad(n, model.field_27433.field_3674, (float)Math.PI + 1.8707964f * ((HumanoidModelAccessor)model).invokeQuadraticArmUpdate(l) / ((HumanoidModelAccessor)model).invokeQuadraticArmUpdate(14.0f));
                model.field_3401.field_3674 = class_3532.method_16439((float)m, (float)model.field_3401.field_3674, (float)((float)Math.PI - 1.8707964f * ((HumanoidModelAccessor)model).invokeQuadraticArmUpdate(l) / ((HumanoidModelAccessor)model).invokeQuadraticArmUpdate(14.0f)));
            } else if (l >= 14.0f && l < 22.0f) {
                float o = (l - 14.0f) / 8.0f;
                model.field_27433.field_3654 = ((HumanoidModelAccessor)model).invokeRotlerpRad(n, model.field_27433.field_3654, 1.5707964f * o);
                model.field_3401.field_3654 = class_3532.method_16439((float)m, (float)model.field_3401.field_3654, (float)(1.5707964f * o));
                model.field_27433.field_3675 = ((HumanoidModelAccessor)model).invokeRotlerpRad(n, model.field_27433.field_3675, (float)Math.PI);
                model.field_3401.field_3675 = class_3532.method_16439((float)m, (float)model.field_3401.field_3675, (float)((float)Math.PI));
                model.field_27433.field_3674 = ((HumanoidModelAccessor)model).invokeRotlerpRad(n, model.field_27433.field_3674, 5.012389f - 1.8707964f * o);
                model.field_3401.field_3674 = class_3532.method_16439((float)m, (float)model.field_3401.field_3674, (float)(1.2707963f + 1.8707964f * o));
            } else if (l >= 22.0f && l < 26.0f) {
                float o = (l - 22.0f) / 4.0f;
                model.field_27433.field_3654 = ((HumanoidModelAccessor)model).invokeRotlerpRad(n, model.field_27433.field_3654, 1.5707964f - 1.5707964f * o);
                model.field_3401.field_3654 = class_3532.method_16439((float)m, (float)model.field_3401.field_3654, (float)(1.5707964f - 1.5707964f * o));
                model.field_27433.field_3675 = ((HumanoidModelAccessor)model).invokeRotlerpRad(n, model.field_27433.field_3675, (float)Math.PI);
                model.field_3401.field_3675 = class_3532.method_16439((float)m, (float)model.field_3401.field_3675, (float)((float)Math.PI));
                model.field_27433.field_3674 = ((HumanoidModelAccessor)model).invokeRotlerpRad(n, model.field_27433.field_3674, (float)Math.PI);
                model.field_3401.field_3674 = class_3532.method_16439((float)m, (float)model.field_3401.field_3674, (float)((float)Math.PI));
            }
            model.field_3397.field_3654 = class_3532.method_16439((float)model.field_3396, (float)model.field_3397.field_3654, (float)(0.3f * class_3532.method_15362((float)(f * 0.33333334f + (float)Math.PI))));
            model.field_3392.field_3654 = class_3532.method_16439((float)model.field_3396, (float)model.field_3392.field_3654, (float)(0.3f * class_3532.method_15362((float)(f * 0.33333334f))));
        }
        model.field_3394.method_17138(model.field_3398);
        model.field_3482.method_17138(model.field_3397);
        model.field_3479.method_17138(model.field_3392);
        model.field_3484.method_17138(model.field_27433);
        model.field_3486.method_17138(model.field_3401);
        model.field_3483.method_17138(model.field_3391);
        class_630 cloak = ((PlayerModelAccessor)model).getCloak();
        if (player.isSneaking()) {
            cloak.field_3655 = 1.4f;
            cloak.field_3656 = 1.85f;
        } else {
            cloak.field_3655 = 0.0f;
            cloak.field_3656 = 0.0f;
        }
    }

    private static void poseLeftArm(class_591 model) {
        switch (model.field_3399) {
            case field_3409: {
                model.field_27433.field_3675 = 0.0f;
                break;
            }
            case field_3406: {
                model.field_27433.field_3654 = model.field_27433.field_3654 * 0.5f - 0.9424779f;
                model.field_27433.field_3675 = 0.5235988f;
                break;
            }
            case field_3410: {
                model.field_27433.field_3654 = model.field_27433.field_3654 * 0.5f - 0.31415927f;
                model.field_27433.field_3675 = 0.0f;
            }
        }
    }

    private static void poseRightArm(class_591 model) {
        switch (model.field_3395) {
            case field_3409: {
                model.field_3401.field_3675 = 0.0f;
                break;
            }
            case field_3406: {
                model.field_3401.field_3654 = model.field_3401.field_3654 * 0.5f - 0.9424779f;
                model.field_3401.field_3675 = -0.5235988f;
                break;
            }
            case field_3410: {
                model.field_3401.field_3654 = model.field_3401.field_3654 * 0.5f - 0.31415927f;
                model.field_3401.field_3675 = 0.0f;
            }
        }
    }

    private static void setupRotations(FakePlayer player, class_4587 stack, float f, float g, float h) {
        stack.method_22907(LinearAlgebra.quaternionDegrees(LinearAlgebra.YP, 180.0f - g));
        if (player.getData().upsideDown()) {
            stack.method_22904(0.0, (double)class_1299.field_6097.method_18386().field_18068 + 0.1, 0.0);
            stack.method_22907(LinearAlgebra.quaternionDegrees(LinearAlgebra.ZP, 180.0f));
        }
    }

    private static int getOverlayCoords(float u) {
        return class_4608.method_23625((int)class_4608.method_23210((float)u), (int)class_4608.method_23212((boolean)false));
    }

    private static void renderNameTag(FakePlayer player, class_4587 stack, class_4597 bufferSource, int light) {
        class_2561 name = player.getDisplayName();
        boolean fullyRender = !player.renderDiscreteNametag();
        float yPosition = class_1299.field_6097.method_18386().field_18068 + 0.5f;
        int offsetForDeadmau5 = "deadmau5".equals(name.getString()) ? -10 : 0;
        stack.method_22903();
        Cosmetica.renderLore(stack, cameraOrientation, class_310.method_1551().field_1772, bufferSource, player.getData().lore(), player.getData().hats(), false, true, player.renderDiscreteNametag(), player.getData().upsideDown(), class_1299.field_6097.method_18386().field_18068, player.getModel().method_2838().field_3654, light);
        stack.method_22904(0.0, (double)yPosition, 0.0);
        stack.method_22907(cameraOrientation);
        stack.method_22905(-0.025f, -0.025f, 0.025f);
        Matrix4f pose = stack.method_23760().method_23761();
        float backgroundOpacity = class_310.method_1551().field_1690.method_19343(0.25f);
        int k = (int)(backgroundOpacity * 255.0f) << 24;
        class_327 font = class_310.method_1551().field_1772;
        float h = -font.method_27525((class_5348)name) / 2;
        font.method_30882(name, h, (float)offsetForDeadmau5, 0x20FFFFFF, false, pose, bufferSource, fullyRender ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993, k, light);
        if (fullyRender) {
            font.method_30882(name, h, (float)offsetForDeadmau5, -1, false, pose, bufferSource, class_327.class_6415.field_33993, 0, light);
        }
        if (player.getData().icon() != null) {
            Cosmetica.renderIcon(stack, bufferSource, player, font, light, name);
        }
        stack.method_22909();
    }
}

