/*
 * Decompiled with CFR 0.152.
 */
package cc.cosmetica.cosmetica.screens;

import benzenestudios.sulphate.Anchor;
import cc.cosmetica.api.CosmeticType;
import cc.cosmetica.api.CustomCosmetic;
import cc.cosmetica.cosmetica.cosmetics.BackBling;
import cc.cosmetica.cosmetica.cosmetics.CustomLayer;
import cc.cosmetica.cosmetica.cosmetics.Hats;
import cc.cosmetica.cosmetica.cosmetics.PlayerData;
import cc.cosmetica.cosmetica.cosmetics.ShoulderBuddies;
import cc.cosmetica.cosmetica.cosmetics.model.BakableModel;
import cc.cosmetica.cosmetica.cosmetics.model.CosmeticStack;
import cc.cosmetica.cosmetica.screens.MainScreen;
import cc.cosmetica.cosmetica.screens.PlayerRenderScreen;
import cc.cosmetica.cosmetica.screens.ServerOptions;
import cc.cosmetica.cosmetica.screens.fakeplayer.FakePlayer;
import cc.cosmetica.cosmetica.screens.widget.TextWidget;
import cc.cosmetica.cosmetica.utils.TextComponents;
import com.google.common.collect.ImmutableList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;

public class ViewCosmeticsScreen
extends PlayerRenderScreen {
    private final ServerOptions options;
    private Section cloakSection;
    private Section loreSection;
    private Section hatsSection;
    private Section shoulderBuddiesSection;
    private Section backBlingSection;
    private Section selected;

    public ViewCosmeticsScreen(class_2561 title, class_437 parentScreen, FakePlayer player, ServerOptions options) {
        this(title, parentScreen, player, options, 1.0);
    }

    protected ViewCosmeticsScreen(class_2561 title, class_437 parentScreen, FakePlayer player, ServerOptions options, double transitionProgress) {
        super(title, parentScreen, player);
        this.setAnchorX(Anchor.RIGHT, () -> this.field_22789 / 2 - 50);
        this.setAnchorY(Anchor.CENTRE, () -> this.field_22790 / 2);
        this.options = options;
        this.setTransitionProgress(transitionProgress);
    }

    private Section createDisabledSection(String title) {
        Div section = Div.create(title);
        this.addTextTo(section, (class_2561)TextComponents.translatable("cosmetica.entry." + title.replace(" ", "")), 100, false);
        this.addTextTo(section, (class_2561)TextComponents.translatable("cosmetica.entry.disabled"), 100, false);
        section.calculateDimensions();
        return section;
    }

    protected <T extends CustomCosmetic, E> Section createActiveSection(String title, List<String> items, @Nullable CosmeticType<T> type, @Nullable CosmeticStack<E> stack) {
        Div section = Div.create(title);
        class_5250 headerText = TextComponents.translatable("cosmetica.entry." + title.replace(" ", ""));
        this.addTextTo(section, (class_2561)headerText, 200, false);
        if (items.isEmpty()) {
            this.addTextTo((Section)section, (class_2561)TextComponents.translatable((String)"cosmetica.entry.none"), (int)200, (boolean)false).field_22763 = false;
        } else {
            for (String item : items) {
                this.addTextTo((Section)section, (class_2561)TextComponents.literal((String)item), (int)200, (boolean)false).field_22763 = false;
            }
        }
        section.calculateDimensions();
        return section;
    }

    private List<String> immutableListOf(String str) {
        return str.isEmpty() ? ImmutableList.of() : ImmutableList.of((Object)str);
    }

    private List<String> immutableListOf(String mainString, String additionalString) {
        return mainString.isEmpty() ? ImmutableList.of() : ImmutableList.of((Object)mainString, (Object)additionalString);
    }

    protected void addWidgets() {
        PlayerData data = this.fakePlayer.getData();
        this.cloakSection = this.createActiveSection("Cape", this.immutableListOf(data.cape().getName(), "\u00a78" + data.cape().getOrigin()), CosmeticType.CAPE, CustomLayer.CAPE_OVERRIDER);
        this.loreSection = this.options.lore.get() ? this.createActiveSection("Lore", this.immutableListOf(data.lore()), null, null) : this.createDisabledSection("Lore");
        this.hatsSection = this.options.hats.get() ? this.createActiveSection("Hats", data.hats().stream().map(BakableModel::name).collect(Collectors.toList()), CosmeticType.HAT, Hats.OVERRIDDEN) : this.createDisabledSection("Hats");
        ImmutableList shoulderBuddies = ImmutableList.of((Object)("Left: " + (data.leftShoulderBuddy() == null ? "None" : data.leftShoulderBuddy().name())), (Object)("Right: " + (data.rightShoulderBuddy() == null ? "None" : data.rightShoulderBuddy().name())));
        Section section = this.shoulderBuddiesSection = this.options.shoulderBuddies.get() ? this.createActiveSection("Shoulder Buddies", (List<String>)shoulderBuddies, CosmeticType.SHOULDER_BUDDY, ShoulderBuddies.RIGHT_OVERRIDDEN) : this.createDisabledSection("Shoulder Buddies");
        this.backBlingSection = this.options.backBlings.get() ? this.createActiveSection("Back Bling", (List<String>)(data.backBling() == null ? ImmutableList.of() : ImmutableList.of((Object)data.backBling().name())), CosmeticType.BACK_BLING, BackBling.OVERRIDDEN) : this.createDisabledSection("Back Bling");
        ImmutableList availableSections = ImmutableList.of((Object)((Object)this.cloakSection), (Object)((Object)this.loreSection), (Object)((Object)this.hatsSection), (Object)((Object)this.shoulderBuddiesSection), (Object)((Object)this.backBlingSection));
        if (this.selected == null) {
            this.selected = this.cloakSection;
        } else {
            for (Section s : availableSections) {
                if (!s.method_25369().equals(this.selected.method_25369())) continue;
                this.selected = s;
                break;
            }
        }
        for (Section section2 : availableSections) {
            class_4185 button = this.addButton(100, 20, section2.method_25369(), b -> this.select(section2));
            if (section2 != this.selected) continue;
            button.field_22763 = false;
        }
        this.selected.method_46421(this.field_22789 / 2 + 50);
        this.selected.method_46419(this.field_22790 / 2 - availableSections.size() * 12 - 2);
        this.method_37063((class_364)this.selected);
        this.addDone(this.field_22790 - 40);
        this.initialPlayerLeft = this.field_22789 / 3 + 10;
        this.deltaPlayerLeft = this.field_22789 / 2 - this.initialPlayerLeft;
    }

    private void select(Section section) {
        this.selected = section;
        this.method_25423(this.field_22787, this.field_22789, this.field_22790);
    }

    public void afterInit() {
        for (class_364 widget : this.method_25396()) {
            if (!(widget instanceof Section)) continue;
            Section section = (Section)widget;
            section.repositionChildren();
        }
    }

    public void method_25419() {
        class_437 class_4372 = this.parent;
        if (class_4372 instanceof MainScreen) {
            MainScreen main = (MainScreen)class_4372;
            main.setTransitionProgress(1.0 - this.getTransitionProgress());
        }
        super.method_25419();
    }

    private TextWidget addText(class_2561 text, int width, boolean centered) {
        return (TextWidget)this.addWidget((x, y, w, h, component) -> new TextWidget(x, y, w, h, centered, component), text, width, 20);
    }

    TextWidget addTextTo(Section section, class_2561 text, int width, boolean centered) {
        return section.addChild(new TextWidget(0, 0, width, 20, centered, text));
    }

    static class Div
    extends Section {
        public Div(int x, int y, int width, int height, class_2561 component) {
            super(x, y, width, height, component);
        }

        @Override
        public void calculateDimensions() {
            super.calculateDimensions();
            this.method_25358(this.children.stream().mapToInt(w -> w.method_25368()).max().orElse(0));
            this.field_22759 = this.children.stream().mapToInt(w -> w.method_25364()).sum();
        }

        @Override
        public void repositionChildren() {
            int y0 = this.method_46427();
            for (class_339 child : this.children) {
                child.method_46421(child.method_46426() + this.method_46426());
                child.method_46419(child.method_46427() + y0);
                y0 += child.method_25364();
            }
            super.repositionChildren();
        }

        static Div create(String name) {
            return new Div(0, 0, 0, 0, (class_2561)TextComponents.literal(name));
        }
    }

    static abstract class Section
    extends class_339 {
        protected List<class_339> children = new LinkedList<class_339>();

        public Section(int i, int j, int k, int l, class_2561 component) {
            super(i, j, k, l, component);
        }

        public void calculateDimensions() {
            for (class_339 child : this.children) {
                if (!(child instanceof Section)) continue;
                Section section = (Section)child;
                section.calculateDimensions();
            }
        }

        public void repositionChildren() {
            for (class_339 child : this.children) {
                if (!(child instanceof Section)) continue;
                Section section = (Section)child;
                section.repositionChildren();
            }
        }

        public <T extends class_339> T addChild(T widget) {
            this.children.add(widget);
            return widget;
        }

        public void removeChildren() {
            this.children.clear();
        }

        public boolean method_25402(double x, double y, int i) {
            for (class_339 child : this.children) {
                if (!((double)child.method_46426() <= x) || !(x < (double)(child.method_46426() + child.method_25368())) || !((double)child.method_46427() <= y) || !(y < (double)(child.method_46427() + child.method_25364()))) continue;
                return child.method_25402(x, y, i);
            }
            return false;
        }

        public void method_25357(double x, double y) {
            for (class_339 child : this.children) {
                if (!((double)child.method_46426() <= x) || !(x < (double)(child.method_46426() + child.method_25368())) || !((double)child.method_46427() <= y) || !(y < (double)(child.method_46427() + child.method_25364()))) continue;
                child.method_25357(x, y);
                return;
            }
        }

        public boolean method_25403(double x, double y, int button, double prevX, double prevY) {
            for (class_339 child : this.children) {
                if (!((double)child.method_46426() <= x) || !(x < (double)(child.method_46426() + child.method_25368())) || !((double)child.method_46427() <= y) || !(y < (double)(child.method_46427() + child.method_25364()))) continue;
                return child.method_25403(x, y, button, prevX, prevY);
            }
            return false;
        }

        public void method_47399(class_6382 narration) {
            for (class_339 child : this.children) {
                child.method_37020(narration);
            }
        }

        public void method_48579(class_332 poseStack, int i, int j, float f) {
            for (class_339 child : this.children) {
                child.method_25394(poseStack, i, j, f);
            }
        }
    }

    static class Span
    extends Section {
        public Span(int x, int y, int width, int height, class_2561 component) {
            super(x, y, width, height, component);
        }

        @Override
        public void calculateDimensions() {
            super.calculateDimensions();
            this.method_25358(this.children.stream().mapToInt(w -> w.method_25368()).sum());
            this.field_22759 = this.children.stream().mapToInt(w -> w.method_25364()).max().orElse(0);
        }

        @Override
        public void repositionChildren() {
            int x0 = this.method_46426();
            for (class_339 child : this.children) {
                child.method_46421(child.method_46426() + x0);
                child.method_46419(child.method_46427() + this.method_46427());
                x0 += child.method_25368();
            }
            super.repositionChildren();
        }

        static Span create(String name) {
            return new Span(0, 0, 0, 0, (class_2561)TextComponents.literal(name));
        }
    }
}

