/*
 * Decompiled with CFR 0.152.
 */
package cc.cosmetica.cosmetica.screens;

import cc.cosmetica.api.CapeDisplay;
import cc.cosmetica.cosmetica.Authentication;
import cc.cosmetica.cosmetica.Cosmetica;
import cc.cosmetica.cosmetica.cosmetics.PlayerData;
import cc.cosmetica.cosmetica.screens.MainScreen;
import cc.cosmetica.cosmetica.screens.PlayerRenderScreen;
import cc.cosmetica.cosmetica.screens.ServerOptions;
import cc.cosmetica.cosmetica.utils.DebugMode;
import cc.cosmetica.cosmetica.utils.LoadingTypeScreen;
import cc.cosmetica.cosmetica.utils.TextComponents;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5489;

public class UpdatingSettingsScreen
extends class_437
implements LoadingTypeScreen {
    private class_437 parentScreen;
    private class_2561 reason = TextComponents.translatable("cosmetica.updating.message");
    private class_5489 message;
    private int textHeight;

    public UpdatingSettingsScreen(class_437 parentScreen, ServerOptions oldOptions, ServerOptions newOptions) throws IOException, InterruptedException {
        super((class_2561)TextComponents.translatable("cosmetica.updating"));
        this.parentScreen = parentScreen;
        HashMap<String, Object> changedSettings = new HashMap<String, Object>();
        boolean doReload = newOptions.regionSpecificEffects.appendToIfChanged(oldOptions.regionSpecificEffects, (Map<String, Object>)changedSettings);
        doReload |= newOptions.shoulderBuddies.appendToIfChanged(oldOptions.shoulderBuddies, (Map<String, Object>)changedSettings);
        doReload |= newOptions.hats.appendToIfChanged(oldOptions.hats, (Map<String, Object>)changedSettings);
        doReload |= newOptions.lore.appendToIfChanged(oldOptions.lore, (Map<String, Object>)changedSettings);
        doReload |= newOptions.backBlings.appendToIfChanged(oldOptions.backBlings, (Map<String, Object>)changedSettings);
        doReload |= newOptions.onlineActivity.appendToIfChanged(oldOptions.onlineActivity, (Map<String, Object>)changedSettings);
        boolean finalDoReload = doReload |= newOptions.icons.appendToIfChanged(oldOptions.icons, (Map<String, Object>)changedSettings);
        if (!changedSettings.isEmpty()) {
            Thread requestThread = new Thread(() -> Cosmetica.api.updateUserSettings(changedSettings).ifSuccessfulOrElse(response -> {
                if (finalDoReload) {
                    class_310.method_1551().method_18858(() -> {
                        class_437 patt3009$temp;
                        Cosmetica.clearAllCaches();
                        if (response.booleanValue() && (patt3009$temp = this.parentScreen) instanceof PlayerRenderScreen) {
                            PlayerRenderScreen playerRenderScreen = (PlayerRenderScreen)patt3009$temp;
                            UUID uuid = class_310.method_1551().method_1548().method_44717();
                            playerRenderScreen.setPlayerData(PlayerData.get(uuid, class_310.method_1551().method_1548().method_1676(), true));
                        }
                    });
                }
                if (response.booleanValue()) {
                    class_310.method_1551().method_18858(() -> class_310.method_1551().method_1507(this.parentScreen));
                } else {
                    Authentication.showUnauthenticatedIfLoading(true, null);
                }
            }, e -> {
                e.printStackTrace();
                Authentication.showUnauthenticatedIfLoading(true, e);
            }));
            requestThread.start();
        } else {
            DebugMode.log("No settings changed.", new Object[0]);
            if (doReload) {
                Cosmetica.clearAllCaches();
            }
            class_310.method_1551().method_18858(this::method_25419);
        }
    }

    public UpdatingSettingsScreen(class_437 parentScreen, Map<String, CapeDisplay> oldOptions, Map<String, CapeDisplay> newOptions) throws IOException, InterruptedException {
        super((class_2561)TextComponents.translatable("cosmetica.updating"));
        this.parentScreen = parentScreen;
        boolean updateCapeServerSettings = oldOptions.entrySet().stream().anyMatch(entry -> ((CapeDisplay)entry.getValue()).id != ((CapeDisplay)newOptions.get(entry.getKey())).id);
        if (updateCapeServerSettings) {
            DebugMode.log("Updating cape server settings.", new Object[0]);
            Thread requestThread = new Thread(() -> {
                Cosmetica.api.setCapeServerSettings(newOptions).ifSuccessfulOrElse(response -> {
                    class_437 patt4470$temp = this.parentScreen;
                    if (patt4470$temp instanceof MainScreen) {
                        MainScreen main = (MainScreen)patt4470$temp;
                        main.setCapeServerSettings((Map<String, CapeDisplay>)response);
                        UUID uuid = class_310.method_1551().method_1548().method_44717();
                        PlayerData.get(uuid, class_310.method_1551().method_1548().method_1676(), true);
                    }
                    class_310.method_1551().method_18858(() -> class_310.method_1551().method_1507(this.parentScreen));
                }, e -> {
                    e.printStackTrace();
                    Authentication.showUnauthenticatedIfLoading(true, e);
                });
                class_310.method_1551().method_18858(() -> Cosmetica.clearAllCaches());
            });
            requestThread.start();
        } else {
            DebugMode.log("No cape server settings changed.", new Object[0]);
            class_310.method_1551().method_18858(this::method_25419);
        }
    }

    public void method_25419() {
        class_310.method_1551().method_1507(this.parentScreen);
    }

    @Override
    public class_437 getParent() {
        return this.parentScreen;
    }

    protected void method_25426() {
        this.message = class_5489.method_30890((class_327)this.field_22793, (class_5348)this.reason, (int)(this.field_22789 - 50));
        int var10001 = this.message.method_30887();
        Objects.requireNonNull(this.field_22793);
        this.textHeight = var10001 * 9;
    }

    public void method_25394(class_332 poseStack, int i, int j, float f) {
        super.method_25394(poseStack, i, j, f);
        int x = this.field_22789 / 2;
        int y = this.field_22790 / 2 - this.textHeight / 2;
        Objects.requireNonNull(this.field_22793);
        poseStack.method_27534(this.field_22793, this.field_22785, x, y - 18, 0xAAAAAA);
        this.message.method_30888(poseStack, this.field_22789 / 2, this.field_22790 / 2 - this.textHeight / 2);
    }
}

