/*
 * Decompiled with CFR 0.152.
 */
package cc.cosmetica.cosmetica.screens;

import benzenestudios.sulphate.Anchor;
import benzenestudios.sulphate.ClassicButton;
import cc.cosmetica.api.CapeDisplay;
import cc.cosmetica.api.CapeServer;
import cc.cosmetica.api.UserSettings;
import cc.cosmetica.cosmetica.Authentication;
import cc.cosmetica.cosmetica.Cosmetica;
import cc.cosmetica.cosmetica.screens.CapeServerSettingsScreen;
import cc.cosmetica.cosmetica.screens.CosmeticaSettingsScreen;
import cc.cosmetica.cosmetica.screens.CustomiseCosmeticsScreen;
import cc.cosmetica.cosmetica.screens.PlayerRenderScreen;
import cc.cosmetica.cosmetica.screens.ServerOptions;
import cc.cosmetica.cosmetica.screens.WelcomeScreen;
import cc.cosmetica.cosmetica.screens.fakeplayer.FakePlayer;
import cc.cosmetica.cosmetica.utils.DebugMode;
import cc.cosmetica.cosmetica.utils.TextComponents;
import cc.cosmetica.impl.CosmeticaWebAPI;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_440;

public class MainScreen
extends PlayerRenderScreen {
    private ServerOptions cosmeticaOptions;
    private Map<String, CapeDisplay> capeServerSettings;
    private List<Map.Entry<String, CapeServer>> capeServerSettingsForButtons;
    private class_4264 done;
    private boolean doReload;
    private boolean demo;
    private static final class_2960 DISCORD = new class_2960("cosmetica", "textures/gui/discord.png");

    public MainScreen(class_437 parentScreen, UserSettings settings, FakePlayer fakePlayer, boolean demo) {
        super((class_2561)TextComponents.translatable("cosmetica.cosmeticaMainMenu"), parentScreen, fakePlayer);
        this.cosmeticaOptions = new ServerOptions(settings);
        this.capeServerSettings = Cosmetica.map(settings.getCapeServerSettings(), CapeServer::getDisplay);
        this.capeServerSettingsForButtons = new ArrayList(settings.getCapeServerSettings().entrySet());
        Collections.sort(this.capeServerSettingsForButtons, Comparator.comparingInt(a -> ((CapeServer)a.getValue()).getCheckOrder()));
        this.setAnchorX(Anchor.LEFT, () -> this.field_22789 / 2);
        this.setAnchorY(Anchor.CENTRE, () -> this.field_22790 / 2);
        this.setTransitionProgress(1.0);
        this.demo = demo;
    }

    protected void addWidgets() {
        this.addButton(150, 20, (class_2561)TextComponents.translatable("cosmetica.customizeCosmetics"), button -> {
            this.demo = false;
            this.field_22787.method_1507((class_437)new CustomiseCosmeticsScreen((class_437)this, this.fakePlayer, this.cosmeticaOptions, 1.0 - this.getTransitionProgress()));
        });
        this.addButton((int)150, (int)20, (class_2561)TextComponents.translatable((String)"cosmetica.capeServerSettings"), (class_4185.class_4241)(class_4185.class_4241)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/class_4185;)V, lambda$addWidgets$4(net.minecraft.class_4185 ), (Lnet/minecraft/class_4185;)V)((MainScreen)this)).field_22763 = !this.demo;
        this.addButton((int)150, (int)20, (class_2561)TextComponents.translatable((String)"cosmetica.cosmeticaSettings"), (class_4185.class_4241)(class_4185.class_4241)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/class_4185;)V, lambda$addWidgets$5(net.minecraft.class_4185 ), (Lnet/minecraft/class_4185;)V)((MainScreen)this)).field_22763 = !this.demo;
        this.addButton((int)150, (int)20, (class_2561)TextComponents.translatable((String)"options.skinCustomisation"), (class_4185.class_4241)(class_4185.class_4241)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/class_4185;)V, lambda$addWidgets$6(net.minecraft.class_4185 ), (Lnet/minecraft/class_4185;)V)((MainScreen)this)).field_22763 = !this.demo;
        this.addButton((int)150, (int)20, (class_2561)TextComponents.translatable((String)"cosmetica.openWebPanel"), (class_4185.class_4241)(class_4185.class_4241)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/class_4185;)V, lambda$addWidgets$7(net.minecraft.class_4185 ), (Lnet/minecraft/class_4185;)V)((MainScreen)this)).field_22763 = !this.demo;
        this.done = this.addDoneWithOffset((x$0, x$1, x$2, x$3, x$4, x$5, x$6) -> {
            class ReloadingButton
            extends ClassicButton {
                public ReloadingButton(int i, int j, int k, int l, class_2561 component, class_4185.class_4241 onPress, ClassicButton.OnTooltip tooltip) {
                    super(i, j, k, l, component, onPress, tooltip);
                }

                public void method_25306() {
                    if (MainScreen.this.doReload) {
                        Cosmetica.clearAllCaches();
                        if (DebugMode.ENABLED) {
                            DebugMode.reloadTestModels();
                        }
                    }
                    WelcomeScreen.isInTutorial = false;
                    this.field_22767.onPress((class_4185)this);
                }
            }
            return new ReloadingButton(x$0, x$1, x$2, x$3, x$4, x$5, x$6);
        }, 36);
        this.done.field_22763 = !this.demo;
        this.initialPlayerLeft = this.field_22789 / 2;
        this.deltaPlayerLeft = this.field_22789 / 3 + 10 - this.initialPlayerLeft;
    }

    public void afterInit() {
        ((ClassicButton)this.method_37063((class_364)new ClassicButton((int)(this.field_22789 / 2 - 100), (int)(this.done.method_46427() - 24), (int)200, (int)20, (class_2561)TextComponents.translatable((String)"cosmetica.reloadCosmetics"), (class_4185.class_4241)(class_4185.class_4241)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/class_4185;)V, lambda$afterInit$9(net.minecraft.class_4185 ), (Lnet/minecraft/class_4185;)V)((MainScreen)this)))).field_22763 = !this.demo;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.isMouseOnDiscord((int)mouseX, (int)mouseY) && button == 0) {
            MainScreen.copyAndOpenURL("https://cosmetica.cc/discord");
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    void setCapeServerSettings(Map<String, CapeDisplay> settings) {
        this.capeServerSettings = settings;
    }

    void setCosmeticaOptions(ServerOptions options) {
        this.cosmeticaOptions = options;
        Authentication.setCachedOptions(options);
    }

    public boolean method_25422() {
        return !this.demo;
    }

    @Override
    public void method_25394(class_332 matrices, int mouseX, int mouseY, float delta) {
        super.method_25394(matrices, mouseX, mouseY, delta);
        this.renderRSENotif(matrices, mouseX, mouseY);
        RenderSystem.enableBlend();
        Cosmetica.renderTexture(matrices.method_51448().method_23760().method_23761(), DISCORD, this.field_22789 - 10 - 19, this.field_22789 - 10, 10, 25, 0, this.isMouseOnDiscord(mouseX, mouseY) ? 1.0f : 0.5f);
    }

    private boolean isMouseOnDiscord(int x, int y) {
        return x >= this.field_22789 - 10 - 19 && x <= this.field_22789 - 10 && y >= 10 && y <= 25;
    }

    public static void copyAndOpenURL(String url) {
        try {
            class_310.method_1551().field_1774.method_1455(url);
            class_156.method_668().method_670(url);
        }
        catch (Exception e) {
            throw new RuntimeException("bruh", e);
        }
    }

    private /* synthetic */ void lambda$afterInit$9(class_4185 button) {
        boolean bl = this.doReload = !this.doReload;
        if (this.doReload) {
            button.method_25355((class_2561)TextComponents.translatable("cosmetica.willReload"));
        } else {
            button.method_25355((class_2561)TextComponents.translatable("cosmetica.reloadCosmetics"));
        }
    }

    private /* synthetic */ void lambda$addWidgets$7(class_4185 button) {
        MainScreen.copyAndOpenURL(Cosmetica.websiteHost + "/manage?" + ((CosmeticaWebAPI)Cosmetica.api).getMasterToken());
    }

    private /* synthetic */ void lambda$addWidgets$6(class_4185 button) {
        this.field_22787.method_1507((class_437)new class_440((class_437)this, class_310.method_1551().field_1690));
    }

    private /* synthetic */ void lambda$addWidgets$5(class_4185 button) {
        this.field_22787.method_1507((class_437)new CosmeticaSettingsScreen((class_437)this, this.cosmeticaOptions));
    }

    private /* synthetic */ void lambda$addWidgets$4(class_4185 button) {
        this.field_22787.method_1507((class_437)new CapeServerSettingsScreen((class_437)this, this.capeServerSettings, this.capeServerSettingsForButtons));
    }
}

