/*
 * Decompiled with CFR 0.152.
 */
package cc.cosmetica.cosmetica.config;

import cc.cosmetica.api.CapeDisplay;
import cc.cosmetica.cosmetica.Cosmetica;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;

public class DefaultSettingsConfig {
    private final Path propertiesPath;
    private String capeId = "";
    private Optional<Boolean> enableHats = Optional.empty();
    private Optional<Boolean> enableShoulderBuddies = Optional.empty();
    private Optional<Boolean> enableBackBlings = Optional.empty();
    private Optional<Boolean> enableLore = Optional.empty();
    private Optional<Boolean> onlineActivity = Optional.empty();
    private OptionalInt iconSettings = OptionalInt.empty();
    private boolean loaded = false;
    private final Map<String, CapeDisplay> capeServerSettings = new HashMap<String, CapeDisplay>();

    public DefaultSettingsConfig(Path propertiesPath) {
        this.propertiesPath = propertiesPath;
    }

    public String getCapeId() {
        return this.capeId;
    }

    public Optional<Boolean> areHatsEnabled() {
        return this.enableHats;
    }

    public Optional<Boolean> areShoulderBuddiesEnabled() {
        return this.enableShoulderBuddies;
    }

    public Optional<Boolean> areBackBlingsEnabled() {
        return this.enableBackBlings;
    }

    public Optional<Boolean> isLoreEnabled() {
        return this.enableLore;
    }

    public Optional<Boolean> shouldDoOnlineActivity() {
        return this.onlineActivity;
    }

    public OptionalInt getIconSettings() {
        return this.iconSettings;
    }

    public void initialize() throws IOException {
        this.load();
        if (!Files.exists(this.propertiesPath, new LinkOption[0])) {
            this.save();
        }
    }

    public void load() throws IOException {
        if (!Files.exists(this.propertiesPath, new LinkOption[0])) {
            return;
        }
        Properties properties = new Properties();
        properties.load(Files.newInputStream(this.propertiesPath, new OpenOption[0]));
        this.capeId = properties.getProperty("starter-cape-id");
        this.enableHats = DefaultSettingsConfig.parseBlankableBoolean(properties.getProperty("enable-hats", ""));
        this.enableShoulderBuddies = DefaultSettingsConfig.parseBlankableBoolean(properties.getProperty("enable-shoulder-buddies", ""));
        this.enableBackBlings = DefaultSettingsConfig.parseBlankableBoolean(properties.getProperty("enable-back-blings", ""));
        this.enableLore = DefaultSettingsConfig.parseBlankableBoolean(properties.getProperty("enable-lore", ""));
        this.onlineActivity = DefaultSettingsConfig.parseBlankableBoolean(properties.getProperty("online-activity", ""));
        this.iconSettings = properties.getProperty("enable-icons", "").isEmpty() ? OptionalInt.empty() : OptionalInt.of(DefaultSettingsConfig.flag(1, !Boolean.parseBoolean(properties.getProperty("enable-icons", "true"))) | DefaultSettingsConfig.flag(2, !DefaultSettingsConfig.parseBlankableBoolean(properties.getProperty("enable-online-icons", ""), true)) | DefaultSettingsConfig.flag(4, !DefaultSettingsConfig.parseBlankableBoolean(properties.getProperty("enable-special-icons", ""), true)));
        this.capeServerSettings.clear();
        for (String propertyName : properties.stringPropertyNames()) {
            if (!propertyName.startsWith("cape-setting-")) continue;
            String service = propertyName.substring(13);
            try {
                CapeDisplay value = CapeDisplay.valueOf((String)properties.getProperty(propertyName).toUpperCase(Locale.ROOT));
                this.capeServerSettings.put(service, value);
            }
            catch (IllegalArgumentException e) {
                Cosmetica.LOGGER.warn("Unknown cape display type: \"" + properties.getProperty(propertyName) + "\". Putting \"show\"! (Valid options are \"show\", \"hide\", \"replace\"");
                this.capeServerSettings.put(service, CapeDisplay.SHOW);
            }
        }
        this.loaded = true;
    }

    public Map<String, CapeDisplay> getCapeServerSettings() {
        return this.capeServerSettings;
    }

    public void save() throws IOException {
        File parentDir = this.propertiesPath.getParent().toFile();
        if (!parentDir.exists()) {
            parentDir.mkdir();
        }
        Properties properties = new Properties();
        properties.setProperty("starter-cape-id", this.capeId);
        properties.setProperty("enable-hats", DefaultSettingsConfig.toStringBlankable(this.enableHats));
        properties.setProperty("enable-shoulder-buddies", DefaultSettingsConfig.toStringBlankable(this.enableShoulderBuddies));
        properties.setProperty("enable-back-blings", DefaultSettingsConfig.toStringBlankable(this.enableBackBlings));
        properties.setProperty("enable-lore", DefaultSettingsConfig.toStringBlankable(this.enableLore));
        if (this.iconSettings.isPresent()) {
            properties.setProperty("enable-icons", Boolean.toString((this.iconSettings.getAsInt() & 1) == 0));
            properties.setProperty("enable-offline-icons", Boolean.toString((this.iconSettings.getAsInt() & 2) == 0));
            properties.setProperty("enable-special-icons", Boolean.toString((this.iconSettings.getAsInt() & 4) == 0));
        } else {
            properties.setProperty("enable-icons", "");
            properties.setProperty("enable-offline-icons", "");
            properties.setProperty("enable-special-icons", "");
        }
        properties.setProperty("online-activity", DefaultSettingsConfig.toStringBlankable(this.onlineActivity));
        this.capeServerSettings.forEach((capeServerSetting, display) -> properties.setProperty("cape-setting-" + capeServerSetting, display.name().toLowerCase(Locale.ROOT)));
        properties.store(Files.newOutputStream(this.propertiesPath, new OpenOption[0]), "Cosmetica Default Settings Config");
    }

    public boolean wasLoaded() {
        return this.loaded;
    }

    private static int flag(int flag, boolean condition) {
        return condition ? flag : 0;
    }

    private static Optional<Boolean> parseBlankableBoolean(String property) {
        if (property.equals("")) {
            return Optional.empty();
        }
        return Optional.of(Boolean.parseBoolean(property));
    }

    private static boolean parseBlankableBoolean(String property, boolean defaultValue) {
        if (property.equals("")) {
            return defaultValue;
        }
        return Boolean.parseBoolean(property);
    }

    private static String toStringBlankable(Optional<Boolean> property) {
        return property.isPresent() ? Boolean.toString(property.get()) : "";
    }
}

