/*
 * Decompiled with CFR 0.152.
 */
package cc.cosmetica.cosmetica;

import cc.cosmetica.api.Cape;
import cc.cosmetica.api.Model;
import cc.cosmetica.cosmetica.Cosmetica;
import cc.cosmetica.cosmetica.utils.DebugMode;
import cc.cosmetica.cosmetica.utils.textures.AnimatedTexture;
import cc.cosmetica.cosmetica.utils.textures.Base64Texture;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1044;
import net.minecraft.class_1068;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.apache.commons.codec.binary.Base64;
import org.jetbrains.annotations.Nullable;

public class CosmeticaSkinManager {
    private static Map<class_2960, class_1044> textures = new HashMap<class_2960, class_1044>();
    private static Set<class_2960> uploaded = new HashSet<class_2960>();
    private static final MessageDigest SHA1;

    public static void clearCaches() {
        DebugMode.log("Clearing cosmetica skin caches", new Object[0]);
        textures = new HashMap<class_2960, class_1044>();
        uploaded = new HashSet<class_2960>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUploaded(class_2960 id) {
        Set<class_2960> set = uploaded;
        synchronized (set) {
            return uploaded.contains(id);
        }
    }

    public static class_2960 testId(String id) {
        return new class_2960("cosmetica", "test/" + id);
    }

    public static class_2960 textureId(String type, String id) {
        return new class_2960("cosmetica", type + "/" + CosmeticaSkinManager.pathify(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTestUploaded(String testId) {
        Set<class_2960> set = uploaded;
        synchronized (set) {
            uploaded.add(CosmeticaSkinManager.testId(testId));
        }
    }

    public static String pathify(String id) {
        StringBuilder result = new StringBuilder();
        for (char c : id.toCharArray()) {
            if (c == '+') {
                result.append(".");
                continue;
            }
            if (c == '=') {
                result.append("__");
                continue;
            }
            if (Character.isUpperCase(c)) {
                result.append("_").append(Character.toLowerCase(c));
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static class_2960 processIcon(String base64Texture) {
        return CosmeticaSkinManager.saveTexture(CosmeticaSkinManager.textureId("icon", Base64.encodeBase64String((byte[])SHA1.digest(base64Texture.getBytes()))), base64Texture, 100);
    }

    public static class_2960 processModel(Model model) {
        return CosmeticaSkinManager.saveTexture(CosmeticaSkinManager.textureId(model.getType().getUrlString(), model.getId()), model.getTexture(), 50 * (model.flags() >> 4 & 0x1F));
    }

    public static class_2960 processCape(Cape cloak) {
        return CosmeticaSkinManager.saveTexture(CosmeticaSkinManager.textureId("cape", cloak.getId()), cloak.getImage(), cloak.getFrameDelay());
    }

    public static class_2960 processSkin(@Nullable String base64Skin, UUID uuid) {
        if (base64Skin == null) {
            return class_1068.method_4648((UUID)uuid).comp_1626();
        }
        return CosmeticaSkinManager.saveTexture(new class_2960("cosmetica", "skin/" + uuid.toString().toLowerCase(Locale.ROOT)), base64Skin, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static class_2960 saveTexture(class_2960 id, String texture, int mspf) {
        if (!textures.containsKey(id)) {
            try {
                String type = id.method_12832().split("\\/")[0];
                AnimatedTexture tex = CosmeticaSkinManager.createTexture(type, id, texture, mspf);
                if (RenderSystem.isOnRenderThreadOrInit()) {
                    class_310.method_1551().method_1531().method_4616(id, (class_1044)tex);
                    Set<class_2960> set = uploaded;
                    synchronized (set) {
                        uploaded.add(id);
                    }
                } else {
                    RenderSystem.recordRenderCall(() -> {
                        class_310.method_1551().method_1531().method_4616(id, (class_1044)tex);
                        Set<class_2960> set = uploaded;
                        synchronized (set) {
                            uploaded.add(id);
                        }
                    });
                }
                DebugMode.log("Registering " + type + " texture for {}. Raw Size: {}x{}, Interpreted Size: {}x{} with {} frames.", id, tex.getRawImage().method_4307(), tex.getRawImage().method_4323(), tex.getRawImage().method_4307(), tex.getFrameHeight(), tex.getFrameCount());
                textures.put(id, tex);
            }
            catch (IOException e) {
                Cosmetica.LOGGER.error("Error loading texture", (Throwable)e);
                return null;
            }
        }
        return id;
    }

    private static AnimatedTexture createTexture(String type, class_2960 id, String texture, int mspf) throws IOException {
        texture = texture.substring(22);
        if ("cape".equals(type)) {
            return Base64Texture.cape(id, texture, mspf);
        }
        if ("skin".equals(type)) {
            return Base64Texture.skin(id, texture);
        }
        return Base64Texture.square(id, texture, mspf);
    }

    static {
        try {
            SHA1 = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("SHA-1 Hashing not supported by the current Java Configuration.", e);
        }
    }
}

