/*
 * Decompiled with CFR 0.152.
 */
package cc.cosmetica.cosmetica;

import cc.cosmetica.api.CapeDisplay;
import cc.cosmetica.api.CosmeticPosition;
import cc.cosmetica.api.CosmeticaAPI;
import cc.cosmetica.api.FatalServerErrorException;
import cc.cosmetica.api.LoginInfo;
import cc.cosmetica.api.ServerResponse;
import cc.cosmetica.api.User;
import cc.cosmetica.api.UserSettings;
import cc.cosmetica.cosmetica.Cosmetica;
import cc.cosmetica.cosmetica.config.DefaultSettingsConfig;
import cc.cosmetica.cosmetica.cosmetics.PlayerData;
import cc.cosmetica.cosmetica.screens.CosmeticaErrorScreen;
import cc.cosmetica.cosmetica.screens.CustomiseCosmeticsScreen;
import cc.cosmetica.cosmetica.screens.MainScreen;
import cc.cosmetica.cosmetica.screens.RSEWarningScreen;
import cc.cosmetica.cosmetica.screens.ServerOptions;
import cc.cosmetica.cosmetica.screens.SnipeScreen;
import cc.cosmetica.cosmetica.screens.UnauthenticatedScreen;
import cc.cosmetica.cosmetica.screens.WelcomeScreen;
import cc.cosmetica.cosmetica.screens.fakeplayer.FakePlayer;
import cc.cosmetica.cosmetica.utils.DebugMode;
import cc.cosmetica.cosmetica.utils.LoadingTypeScreen;
import cc.cosmetica.cosmetica.utils.TextComponents;
import cc.cosmetica.impl.CosmeticaWebAPI;
import cc.cosmetica.util.Response;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_320;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class Authentication {
    private static volatile boolean currentlyAuthenticated = false;
    private static volatile boolean currentlyAuthenticating = false;
    private static UUID authenticatedAsUUID;
    public static int settingLoadTarget;
    @Nullable
    public static User snipedPlayer;
    private static ServerOptions savedOptions;
    private static final AtomicInteger UNIQUE_THREAD_ID;

    public static boolean isCurrentlyAuthenticated() {
        return currentlyAuthenticated;
    }

    public static void setCachedOptions(ServerOptions options) {
        savedOptions = options;
    }

    public static boolean hasCachedOptions() {
        return savedOptions != null;
    }

    public static void openSnipeScreen(class_437 parent, PlayerData foreignData, PlayerData ownData) {
        if (snipedPlayer == null) {
            throw new IllegalStateException("Can't show snipe screen for null sniped player.");
        }
        FakePlayer player = new FakePlayer(class_310.method_1551(), snipedPlayer.getUUID(), snipedPlayer.getUsername(), foreignData);
        class_310.method_1551().method_1507((class_437)new SnipeScreen((class_2561)TextComponents.literal(player.getName()), parent, player, savedOptions, ownData, new User(player.getUUID(), player.getName())));
    }

    public static void openCustomiseCosmeticsScreen(class_437 parent, PlayerData playerData) {
        FakePlayer player = new FakePlayer(class_310.method_1551(), class_310.method_1551().method_1548().method_44717(), class_310.method_1551().method_1548().method_1676(), playerData);
        class_310.method_1551().method_1507((class_437)new CustomiseCosmeticsScreen(parent, player, savedOptions));
    }

    private static void syncSettings() {
        if (Cosmetica.api == null) {
            return;
        }
        DebugMode.log("Synchronising Settings", new Object[0]);
        Thread requestThread = new Thread(() -> {
            if (!Cosmetica.api.isAuthenticated() || !class_310.method_1551().method_1548().method_44717().equals(authenticatedAsUUID)) {
                DebugMode.log("Not authenticated. [Re]authenticating...", new Object[0]);
                Authentication.runAuthentication(true, false);
                return;
            }
            ServerResponse settings_ = Cosmetica.api.getUserSettings();
            settings_.ifSuccessfulOrElse(settings -> {
                DebugMode.log("Handling successful cosmetics settings response.", new Object[0]);
                savedOptions = new ServerOptions((UserSettings)settings);
                boolean bl = RSEWarningScreen.appearNextScreenChange = !settings.hasPerRegionEffectsSet() && Cosmetica.getConfig().regionalEffectsPrompt();
                if (class_310.method_1551().field_1755 instanceof LoadingTypeScreen) {
                    class_437 patt6673$temp;
                    PlayerData snipedInfo;
                    UUID ownUUID = class_310.method_1551().method_1548().method_44717();
                    String ownName = class_310.method_1551().method_1548().method_1676();
                    User snipedPlayer = snipedPlayer;
                    int loadTarget = settingLoadTarget;
                    DebugMode.log("Loading own player info for menu (mode: " + loadTarget + ")", new Object[0]);
                    PlayerData ownInfo = PlayerData.get(ownUUID, ownName, true);
                    if (loadTarget == 2) {
                        DebugMode.log("Loading sniped player info", new Object[0]);
                    }
                    PlayerData playerData = snipedInfo = loadTarget == 2 && snipedPlayer != null ? PlayerData.get(snipedPlayer.getUUID(), snipedPlayer.getUsername(), true) : null;
                    if (loadTarget == 2 && snipedInfo == null) {
                        DebugMode.log("Failed to load sniped player info (sniped player was null)", new Object[0]);
                    }
                    if (loadTarget != 2 || snipedInfo != null) {
                        DebugMode.log("Will use skin " + (loadTarget == 2 ? snipedInfo : ownInfo).skin(), new Object[0]);
                    }
                    if ((patt6673$temp = class_310.method_1551().field_1755) instanceof LoadingTypeScreen) {
                        LoadingTypeScreen lts = (LoadingTypeScreen)patt6673$temp;
                        class_310.method_1551().method_18858(() -> {
                            switch (loadTarget) {
                                case 2: {
                                    if (snipedInfo == null || snipedInfo == PlayerData.NONE) {
                                        class_310.method_1551().method_1507((class_437)new CosmeticaErrorScreen(lts.getParent(), (class_2561)TextComponents.translatable("cosmetica.stealhislook.snipe"), (class_2561)(snipedInfo == null ? TextComponents.translatable("cosmetica.stealhislook.snipe.cannotFind") : TextComponents.formattedTranslatable("cosmetica.stealhislook.snipe.err", snipedPlayer.getUsername()))));
                                        break;
                                    }
                                    Authentication.openSnipeScreen(lts.getParent(), snipedInfo, ownInfo);
                                    break;
                                }
                                case 1: {
                                    Authentication.openCustomiseCosmeticsScreen(lts.getParent(), ownInfo);
                                    break;
                                }
                                default: {
                                    class_310.method_1551().method_1507((class_437)new MainScreen(lts.getParent(), (UserSettings)settings, new FakePlayer(class_310.method_1551(), ownUUID, ownName, ownInfo), loadTarget == 3));
                                }
                            }
                        });
                    }
                }
            }, error -> {
                if (error.getMessage().contains("invalid token")) {
                    Cosmetica.LOGGER.info("Invalid token found on settings sync. Reauthenticating...");
                    Authentication.runAuthentication(true, true);
                } else {
                    Cosmetica.LOGGER.error("Error during settings get:", (Throwable)error);
                    Authentication.showUnauthenticatedIfLoading(false, error);
                    if (error instanceof JsonSyntaxException && DebugMode.elevatedLogging()) {
                        Cosmetica.LOGGER.error("The Json causing this error is as follows, assuming repetitive issue:");
                        try {
                            Cosmetica.LOGGER.error(Response.get((String)settings_.getURL()).getAsString());
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        });
        requestThread.start();
    }

    public static void showUnauthenticatedIfLoading(boolean fromSave, @Nullable Exception exception) {
        class_310 minecraft = class_310.method_1551();
        class_437 current = minecraft.field_1755;
        UnauthenticatedScreen.UnauthenticatedReason reason = Authentication.diagnose(exception);
        if (current instanceof LoadingTypeScreen) {
            LoadingTypeScreen lts = (LoadingTypeScreen)current;
            minecraft.method_18858(() -> minecraft.method_1507((class_437)new UnauthenticatedScreen(lts.getParent(), fromSave, reason)));
        }
    }

    private static UnauthenticatedScreen.UnauthenticatedReason diagnose(@Nullable Exception exception) {
        UnauthenticatedScreen.UnauthenticatedReason reason;
        if (exception != null && (reason = Authentication.diagnoseError(exception)) != null) {
            return reason;
        }
        class_320 currentUser = class_310.method_1551().method_1548();
        UUID uuid = currentUser.method_44717();
        if (uuid.version() != 4) {
            return new UnauthenticatedScreen.UnauthenticatedReason(UnauthenticatedScreen.UnauthenticatedReason.CRACKED, null);
        }
        return new UnauthenticatedScreen.UnauthenticatedReason(UnauthenticatedScreen.UnauthenticatedReason.GENERIC, exception);
    }

    @Nullable
    private static UnauthenticatedScreen.UnauthenticatedReason diagnoseError(Exception exception) {
        if (exception instanceof UncheckedIOException) {
            exception = ((UncheckedIOException)exception).getCause();
        }
        if (exception instanceof NoRouteToHostException) {
            return new UnauthenticatedScreen.UnauthenticatedReason(UnauthenticatedScreen.UnauthenticatedReason.OFFLINE, exception);
        }
        if (exception instanceof UnknownHostException) {
            return new UnauthenticatedScreen.UnauthenticatedReason(UnauthenticatedScreen.UnauthenticatedReason.UNKNOWN_HOST, exception);
        }
        if (exception instanceof SocketException) {
            return new UnauthenticatedScreen.UnauthenticatedReason(UnauthenticatedScreen.UnauthenticatedReason.CONNECTION_ISSUE, exception);
        }
        if (exception instanceof FatalServerErrorException) {
            return new UnauthenticatedScreen.UnauthenticatedReason(UnauthenticatedScreen.UnauthenticatedReason.FIVE_HUNDRED, exception);
        }
        return null;
    }

    private static void prepareWelcome(UUID uuid, String name, boolean newPlayer, boolean suppressErrors) {
        boolean isWelcomeScreenAllowed = newPlayer && Cosmetica.mayShowWelcomeScreen();
        DebugMode.log("Preparing potential welcome... || newPlayer=" + newPlayer + " mayShowWelcomeScreen=" + Cosmetica.mayShowWelcomeScreen(), new Object[0]);
        Cosmetica.api.getUserInfo(uuid, name).ifSuccessfulOrElse(userInfo -> {
            String colourlessLore = TextComponents.stripColour(userInfo.getLore());
            DebugMode.log("Received user info on Authenticate/prepareWelcome || displayNext=" + Cosmetica.displayNext + " colourlessLore=" + colourlessLore + " show-welcome-message=" + Cosmetica.getConfig().showWelcomeMessage(), new Object[0]);
            if (Cosmetica.getConfig().showWelcomeMessage().shouldShowChatMessage(isWelcomeScreenAllowed) && Cosmetica.displayNext == null && colourlessLore.equals("New to Cosmetica")) {
                class_5250 menuOpenText = TextComponents.translatable("cosmetica.linkhere");
                menuOpenText.method_10862(menuOpenText.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11748, "cosmetica.customise")));
                Cosmetica.displayNext = TextComponents.formattedTranslatable("cosmetica.welcome", menuOpenText);
            }
            if (Cosmetica.getConfig().showWelcomeMessage().shouldShowWelcomeTutorial(isWelcomeScreenAllowed)) {
                DebugMode.log("New Player: Showing Welcome Screen", new Object[0]);
                RenderSystem.recordRenderCall(() -> {
                    class_437 screen = class_310.method_1551().field_1755;
                    class_310.method_1551().method_1507((class_437)new WelcomeScreen(screen, uuid, name, Cosmetica.newPlayerData(userInfo, uuid)));
                });
            }
        }, e -> {
            if (suppressErrors) {
                DebugMode.logError("Suppressed Error:", e);
            } else {
                Cosmetica.LOGGER.error("Failed to request user info on authenticate for preparing welcome.", (Throwable)e);
            }
        });
    }

    public static void runAuthentication() {
        Authentication.runAuthentication(false, false);
    }

    private static void runAuthentication(boolean force, final boolean ignoreCache) {
        if (!Cosmetica.api.isAuthenticated() || force) {
            String devToken = System.getProperty("cosmetica.token");
            if (devToken != null) {
                DebugMode.log("Authenticating API from provided token.", new Object[0]);
                Cosmetica.api = CosmeticaAPI.fromToken((String)devToken);
                Cosmetica.api.setUrlLogger(DebugMode::logURL);
                class_320 user = class_310.method_1551().method_1548();
                authenticatedAsUUID = user.method_44717();
                currentlyAuthenticated = true;
                Authentication.prepareWelcome(authenticatedAsUUID, user.method_1676(), false, false);
            } else if (currentlyAuthenticating) {
                DebugMode.log("API is not authenticated but authentication is already in progress.", new Object[0]);
            } else {
                DebugMode.log("Starting authentication!", new Object[0]);
                currentlyAuthenticating = true;
                new Thread("Cosmetica Authenticator #" + UNIQUE_THREAD_ID.incrementAndGet()){

                    @Override
                    public void run() {
                        try {
                            boolean reauthenticate = true;
                            String reason = "Forced token refresh.";
                            Properties tokens = new Properties();
                            Path tokensPath = Cosmetica.getCacheDirectory().resolve("tokens");
                            class_320 user = class_310.method_1551().method_1548();
                            UUID uuid = user.method_44717();
                            if (!ignoreCache) {
                                if (Files.isRegularFile(tokensPath, new LinkOption[0])) {
                                    try (InputStream inputStream = Files.newInputStream(tokensPath, new OpenOption[0]);){
                                        tokens.load(inputStream);
                                    }
                                    catch (IOException e) {
                                        Cosmetica.LOGGER.error("Failed to read tokens file.", (Throwable)e);
                                    }
                                } else {
                                    try {
                                        Files.createFile(tokensPath, new FileAttribute[0]);
                                    }
                                    catch (IOException e) {
                                        Cosmetica.LOGGER.error("Failed to create tokens file.", (Throwable)e);
                                    }
                                }
                                reason = "No cached Cosmetica token found.";
                                String foundToken = tokens.getProperty(uuid.toString());
                                if (foundToken != null) {
                                    DebugMode.log("Found cached token. Trying to authenticate...", new Object[0]);
                                    Cosmetica.api = CosmeticaAPI.fromTokens((String)foundToken, (String)tokens.getProperty(uuid + "-l"));
                                    Cosmetica.api.setUrlLogger(DebugMode::logURL);
                                    authenticatedAsUUID = user.method_44717();
                                    reauthenticate = Authentication.isTokenInvalid(((CosmeticaWebAPI)Cosmetica.api).getMasterToken());
                                    reason = "Invalid Cosmetica Token.";
                                }
                            }
                            if (reauthenticate) {
                                DebugMode.log(reason + " Authenticating from minecraft access token.", new Object[0]);
                                Cosmetica.api = CosmeticaAPI.fromMinecraftToken((String)user.method_1674(), (String)user.method_1676(), (UUID)uuid, (String)System.getProperty("cosmetica.client", "cosmetica"));
                                Cosmetica.api.setUrlLogger(DebugMode::logURL);
                                authenticatedAsUUID = user.method_44717();
                                tokens.setProperty(uuid.toString(), ((CosmeticaWebAPI)Cosmetica.api).getMasterToken());
                                Field fieldLT = CosmeticaWebAPI.class.getDeclaredField("limitedToken");
                                fieldLT.setAccessible(true);
                                tokens.setProperty(uuid + "-l", fieldLT.get(Cosmetica.api).toString());
                                DebugMode.log("Caching authentication tokens", new Object[0]);
                                try (OutputStream stream = Files.newOutputStream(tokensPath, new OpenOption[0]);){
                                    tokens.store(stream, "Cosmetica Tokens (shh!)");
                                }
                                catch (IOException e) {
                                    Cosmetica.LOGGER.error("Failed to save tokens.", (Throwable)e);
                                }
                            } else {
                                DebugMode.log("Authentication Successful.", new Object[0]);
                            }
                            currentlyAuthenticated = true;
                            currentlyAuthenticating = false;
                            Optional oInfo = Cosmetica.api.getLoginInfo();
                            oInfo.ifPresent(info -> {
                                DefaultSettingsConfig defaults;
                                if (info.isNewPlayer() && (defaults = Cosmetica.getDefaultSettingsConfig()).wasLoaded()) {
                                    Map<String, CapeDisplay> capeServerSettings;
                                    String capeId;
                                    HashMap settings = new HashMap();
                                    defaults.areHatsEnabled().ifPresent(v -> settings.put("dohats", v));
                                    defaults.areShoulderBuddiesEnabled().ifPresent(v -> settings.put("doshoulderbuddies", v));
                                    defaults.areBackBlingsEnabled().ifPresent(v -> settings.put("dobackblings", v));
                                    defaults.isLoreEnabled().ifPresent(v -> settings.put("dolore", v));
                                    defaults.shouldDoOnlineActivity().ifPresent(v -> settings.put("doonlineactivity", v));
                                    defaults.getIconSettings().ifPresent(v -> settings.put("iconsettings", v));
                                    if (!settings.isEmpty()) {
                                        Cosmetica.api.updateUserSettings(settings);
                                    }
                                    if (!info.hasSpecialCape() && !(capeId = defaults.getCapeId()).isEmpty()) {
                                        Cosmetica.api.setCosmetic(CosmeticPosition.CAPE, capeId, true);
                                    }
                                    if (!(capeServerSettings = defaults.getCapeServerSettings()).isEmpty()) {
                                        Cosmetica.api.setCapeServerSettings(capeServerSettings);
                                    }
                                }
                            });
                            if (reauthenticate) {
                                Authentication.prepareWelcome(uuid, user.method_1676(), oInfo.map(LoginInfo::isNewPlayer).orElse(false), false);
                            }
                            RenderSystem.recordRenderCall(() -> PlayerData.get(uuid, user.method_1676(), false));
                            Authentication.syncSettings();
                        }
                        catch (Exception e) {
                            Cosmetica.LOGGER.error("Couldn't connect to cosmetica auth server", (Throwable)e);
                            currentlyAuthenticating = false;
                            Authentication.showUnauthenticatedIfLoading(false, e);
                        }
                    }
                }.start();
            }
        } else {
            DebugMode.log("Api is authenticated: syncing settings!", new Object[0]);
            Authentication.syncSettings();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isTokenInvalid(String token) throws UncheckedIOException {
        try (Response response = Response.get((String)("https://api.cosmetica.cc/get/uuid?token=" + token));){
            JsonObject object = response.getAsJson();
            if (!object.has("error")) return false;
            boolean bl = object.get("error").getAsString().contains("invalid token");
            return bl;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Checking token validity", e);
        }
    }

    protected static void runSyncSettingsThread() {
        Thread settingsSyncThread = new Thread(() -> {
            while (true) {
                try {
                    Thread.sleep(300000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                Authentication.syncSettings();
            }
        });
        settingsSyncThread.start();
    }

    static {
        UNIQUE_THREAD_ID = new AtomicInteger(0);
    }
}

