/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.server;

import io.netty.buffer.Unpooled;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2802;
import net.minecraft.class_3215;
import net.minecraft.class_3222;
import net.minecraft.class_3898;
import net.minecraft.class_4050;
import net.minecraft.class_5629;
import net.minecraft.class_8710;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vivecraft.common.CommonDataHolder;
import org.vivecraft.common.network.CommonNetworkHelper;
import org.vivecraft.common.network.Pose;
import org.vivecraft.common.network.VrPlayerState;
import org.vivecraft.common.network.packets.VivecraftDataPacket;
import org.vivecraft.mixin.server.ChunkMapAccessor;
import org.vivecraft.mixin.server.TrackedEntityAccessor;
import org.vivecraft.server.ServerVRPlayers;
import org.vivecraft.server.ServerVivePlayer;
import org.vivecraft.server.config.ServerConfig;

public class ServerNetworking {
    private static final Map<UUID, Map<CommonNetworkHelper.PacketDiscriminators, class_2540>> legacyDataMap = new HashMap<UUID, Map<CommonNetworkHelper.PacketDiscriminators, class_2540>>();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"VivecraftServer");

    /*
     * Unable to fully structure code
     */
    public static void handlePacket(CommonNetworkHelper.PacketDiscriminators packetID, class_2540 buffer, class_3222 player, Consumer<class_2658> packetConsumer) {
        vivePlayer = ServerVRPlayers.getVivePlayer(player);
        if (vivePlayer == null && packetID != CommonNetworkHelper.PacketDiscriminators.VERSION) {
            return;
        }
        switch (1.$SwitchMap$org$vivecraft$common$network$CommonNetworkHelper$PacketDiscriminators[packetID.ordinal()]) {
            case 1: {
                vivePlayer = new ServerVivePlayer(player);
                stringBytes = new byte[buffer.readableBytes()];
                buffer.method_52979(stringBytes);
                parts = new String(stringBytes).split("\\n");
                clientVivecraftVersion = parts[0];
                if (((Boolean)ServerConfig.debug.get()).booleanValue()) {
                    ServerNetworking.LOGGER.info("Vivecraft: player '{}' joined with {}", (Object)player.method_5477().getString(), (Object)clientVivecraftVersion);
                }
                if (parts.length < 3) ** GOTO lbl26
                clientMaxVersion = Integer.parseInt(parts[1]);
                clientMinVersion = Integer.parseInt(parts[2]);
                if (0 <= clientMaxVersion && clientMinVersion <= 0) {
                    vivePlayer.networkVersion = Math.min(clientMaxVersion, 0);
                    if (((Boolean)ServerConfig.debug.get()).booleanValue()) {
                        ServerNetworking.LOGGER.info("{} networking supported, using version {}", (Object)player.method_5477().getString(), (Object)vivePlayer.networkVersion);
                    }
                } else {
                    player.method_43496((class_2561)class_2561.method_43470((String)"Unsupported vivecraft version, VR features will not work"));
                    if (((Boolean)ServerConfig.debug.get()).booleanValue()) {
                        ServerNetworking.LOGGER.info("{} networking not supported. client range [{},{}], server range [{},{}]", new Object[]{player.method_5477().getString(), clientMinVersion, clientMaxVersion, 0, 0});
                    }
                    return;
lbl26:
                    // 1 sources

                    vivePlayer.networkVersion = -1;
                    if (((Boolean)ServerConfig.debug.get()).booleanValue()) {
                        ServerNetworking.LOGGER.info("{} using legacy networking", (Object)player.method_5477().getString());
                    }
                }
                vivePlayer.setVR(clientVivecraftVersion.contains("NONVR") == false);
                ServerVRPlayers.getPlayersWithVivecraft(player.field_13995).put(player.method_5667(), vivePlayer);
                packetConsumer.accept(ServerNetworking.getVivecraftServerPacket(CommonNetworkHelper.PacketDiscriminators.VERSION, CommonDataHolder.getInstance().versionIdentifier));
                packetConsumer.accept(ServerNetworking.getVivecraftServerPacket(CommonNetworkHelper.PacketDiscriminators.REQUESTDATA, new byte[0]));
                if (((Boolean)ServerConfig.climbeyEnabled.get()).booleanValue()) {
                    packetConsumer.accept(ServerNetworking.getClimbeyServerPacket());
                }
                if (((Boolean)ServerConfig.teleportEnabled.get()).booleanValue()) {
                    packetConsumer.accept(ServerNetworking.getVivecraftServerPacket(CommonNetworkHelper.PacketDiscriminators.TELEPORT, new byte[0]));
                }
                if (((Boolean)ServerConfig.teleportLimitedSurvival.get()).booleanValue()) {
                    byteBuf = new class_2540(Unpooled.buffer());
                    byteBuf.method_10814("limitedTeleport");
                    byteBuf.method_10814("true");
                    byteBuf.method_10814("teleportLimitUp");
                    byteBuf.method_10814("" + ServerConfig.teleportUpLimit.get());
                    byteBuf.method_10814("teleportLimitDown");
                    byteBuf.method_10814("" + ServerConfig.teleportDownLimit.get());
                    byteBuf.method_10814("teleportLimitHoriz");
                    byteBuf.method_10814("" + ServerConfig.teleportHorizontalLimit.get());
                    array = new byte[byteBuf.readableBytes()];
                    byteBuf.method_52979(array);
                    byteBuf.release();
                    packetConsumer.accept(ServerNetworking.getVivecraftServerPacket(CommonNetworkHelper.PacketDiscriminators.SETTING_OVERRIDE, array));
                }
                if (((Boolean)ServerConfig.worldscaleLimited.get()).booleanValue()) {
                    byteBuf = new class_2540(Unpooled.buffer());
                    byteBuf.method_10814("worldScale.min");
                    byteBuf.method_10814("" + ServerConfig.worldscaleMin.get());
                    byteBuf.method_10814("worldScale.max");
                    byteBuf.method_10814("" + ServerConfig.worldscaleMax.get());
                    array = new byte[byteBuf.readableBytes()];
                    byteBuf.method_52979(array);
                    byteBuf.release();
                    packetConsumer.accept(ServerNetworking.getVivecraftServerPacket(CommonNetworkHelper.PacketDiscriminators.SETTING_OVERRIDE, array));
                }
                if (((Boolean)ServerConfig.forceThirdPersonItems.get()).booleanValue()) {
                    byteBuf = new class_2540(Unpooled.buffer());
                    byteBuf.method_10814("thirdPersonItems");
                    byteBuf.method_10814("true");
                    array = new byte[byteBuf.readableBytes()];
                    byteBuf.method_52979(array);
                    byteBuf.release();
                    packetConsumer.accept(ServerNetworking.getVivecraftServerPacket(CommonNetworkHelper.PacketDiscriminators.SETTING_OVERRIDE, array));
                }
                if (((Boolean)ServerConfig.crawlingEnabled.get()).booleanValue()) {
                    packetConsumer.accept(ServerNetworking.getVivecraftServerPacket(CommonNetworkHelper.PacketDiscriminators.CRAWL, new byte[0]));
                }
                packetConsumer.accept(ServerNetworking.getVivecraftServerPacket(CommonNetworkHelper.PacketDiscriminators.VR_SWITCHING, new byte[]{(byte)((Boolean)ServerConfig.vrSwitchingEnabled.get() != false && (Boolean)ServerConfig.vr_only.get() == false)}));
                packetConsumer.accept(ServerNetworking.getVivecraftServerPacket(CommonNetworkHelper.PacketDiscriminators.NETWORK_VERSION, new byte[]{(byte)vivePlayer.networkVersion}));
                break;
            }
            case 2: {
                if (vivePlayer.isVR() == buffer.readBoolean()) break;
                vivePlayer.setVR(vivePlayer.isVR() == false);
                if (vivePlayer.isVR()) break;
                for (class_5629 trackingPlayer : ServerNetworking.getTrackingPlayers((class_1297)player)) {
                    if (!ServerVRPlayers.getPlayersWithVivecraft(player.field_13995).containsKey(trackingPlayer.method_32311().method_5667()) || trackingPlayer.method_32311() == player) continue;
                    trackingPlayer.method_14364((class_2596)ServerNetworking.createVRActivePlayerPacket(false, player.method_5667()));
                }
                break;
            }
            case 3: {
                vivePlayer.draw = buffer.readFloat();
                break;
            }
            case 4: {
                vivePlayer.vrPlayerState = VrPlayerState.deserialize(buffer);
            }
            default: {
                break;
            }
            case 7: {
                vivePlayer.worldScale = buffer.readFloat();
                break;
            }
            case 8: {
                vivePlayer.heightScale = buffer.readFloat();
                break;
            }
            case 9: {
                f = buffer.readFloat();
                f1 = buffer.readFloat();
                f2 = buffer.readFloat();
                player.method_5641((double)f, (double)f1, (double)f2, player.method_36454(), player.method_36455());
                break;
            }
            case 10: {
                player.field_6017 = 0.0f;
                break;
            }
            case 11: {
                vivePlayer.activeHand = buffer.readByte();
                if (!vivePlayer.isSeated()) break;
                vivePlayer.activeHand = 0;
                break;
            }
            case 12: {
                v0 = vivePlayer.crawling = buffer.readByte() != 0;
                if (!vivePlayer.crawling) break;
                player.method_18380(class_4050.field_18079);
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                playerData = ServerNetworking.legacyDataMap.get(player.method_5667());
                if (playerData == null) {
                    playerData = new HashMap<CommonNetworkHelper.PacketDiscriminators, class_2540>();
                    ServerNetworking.legacyDataMap.put(player.method_5667(), playerData);
                }
                buffer.method_52938();
                playerData.put(packetID, buffer);
                if (playerData.size() != 3) break;
                controller0Data = playerData.get((Object)CommonNetworkHelper.PacketDiscriminators.CONTROLLER0DATA);
                controller0Data.method_52933().readByte();
                controller1Data = playerData.get((Object)CommonNetworkHelper.PacketDiscriminators.CONTROLLER1DATA);
                controller1Data.method_52933().readByte();
                headData = playerData.get((Object)CommonNetworkHelper.PacketDiscriminators.HEADDATA);
                headData.method_52933().readByte();
                vivePlayer.vrPlayerState = new VrPlayerState(headData.readBoolean(), Pose.deserialize(headData), controller0Data.readBoolean(), Pose.deserialize(controller0Data), controller1Data.readBoolean(), Pose.deserialize(controller1Data));
                headData.release();
                controller0Data.release();
                controller1Data.release();
                ServerNetworking.legacyDataMap.remove(player.method_5667());
            }
        }
    }

    public static Set<class_5629> getTrackingPlayers(class_1297 entity) {
        class_2802 manager = entity.method_37908().method_8398();
        class_3898 storage = ((class_3215)manager).field_17254;
        TrackedEntityAccessor playerTracker = (TrackedEntityAccessor)((ChunkMapAccessor)storage).getTrackedEntities().get(entity.method_5628());
        return playerTracker != null ? playerTracker.getPlayersTracking() : Collections.emptySet();
    }

    public static class_2658 createVRActivePlayerPacket(boolean vrActive, UUID playerID) {
        class_2540 tempBuffer = new class_2540(Unpooled.buffer());
        tempBuffer.method_52997(CommonNetworkHelper.PacketDiscriminators.IS_VR_ACTIVE.ordinal());
        tempBuffer.method_52964(vrActive);
        tempBuffer.method_10797(playerID);
        class_2658 p = new class_2658((class_8710)new VivecraftDataPacket(tempBuffer));
        tempBuffer.release();
        return p;
    }

    public static class_2658 createUberPacket(class_1657 player, VrPlayerState vrPlayerState, float worldScale, float heightScale) {
        class_2540 tempBuffer = new class_2540(Unpooled.buffer());
        tempBuffer.method_52997(CommonNetworkHelper.PacketDiscriminators.UBERPACKET.ordinal());
        tempBuffer.method_10797(player.method_5667());
        vrPlayerState.serialize(tempBuffer);
        tempBuffer.method_52941(worldScale);
        tempBuffer.method_52941(heightScale);
        class_2658 p = new class_2658((class_8710)new VivecraftDataPacket(tempBuffer));
        tempBuffer.release();
        return p;
    }

    public static class_2658 getVivecraftServerPacket(CommonNetworkHelper.PacketDiscriminators command, byte[] payload) {
        return new class_2658((class_8710)new VivecraftDataPacket(command, payload));
    }

    public static class_2658 getClimbeyServerPacket() {
        class_2540 friendlybytebuf = new class_2540(Unpooled.buffer());
        friendlybytebuf.method_52997(CommonNetworkHelper.PacketDiscriminators.CLIMBING.ordinal());
        friendlybytebuf.method_52964(true);
        if (!"DISABLED".equals(ServerConfig.climbeyBlockmode.get())) {
            if ("WHITELIST".equals(ServerConfig.climbeyBlockmode.get())) {
                friendlybytebuf.method_52997(1);
            } else {
                friendlybytebuf.method_52997(2);
            }
            for (String block : (List)ServerConfig.climbeyBlocklist.get()) {
                friendlybytebuf.method_10814(block);
            }
        } else {
            friendlybytebuf.method_52997(0);
        }
        class_2658 p = new class_2658((class_8710)new VivecraftDataPacket(friendlybytebuf));
        friendlybytebuf.release();
        return p;
    }

    public static class_2658 getVivecraftServerPacket(CommonNetworkHelper.PacketDiscriminators command, String payload) {
        class_2540 tempBuffer = new class_2540(Unpooled.buffer());
        tempBuffer.method_52997(command.ordinal());
        tempBuffer.method_10814(payload);
        class_2658 p = new class_2658((class_8710)new VivecraftDataPacket(tempBuffer));
        tempBuffer.release();
        return p;
    }

    public static void sendVrPlayerStateToClients(class_3222 vrPlayerEntity) {
        Map<UUID, ServerVivePlayer> playersWithVivecraft = ServerVRPlayers.getPlayersWithVivecraft(vrPlayerEntity.field_13995);
        ServerVivePlayer vivePlayer = playersWithVivecraft.get(vrPlayerEntity.method_5667());
        if (vivePlayer == null) {
            return;
        }
        if (vivePlayer.player == null || vivePlayer.player.method_14239()) {
            playersWithVivecraft.remove(vrPlayerEntity.method_5667());
        }
        if (!vivePlayer.isVR() || vivePlayer.vrPlayerState == null) {
            return;
        }
        for (class_5629 trackingPlayer : ServerNetworking.getTrackingPlayers((class_1297)vrPlayerEntity)) {
            if (!playersWithVivecraft.containsKey(trackingPlayer.method_32311().method_5667()) || trackingPlayer.method_32311() == vrPlayerEntity) continue;
            trackingPlayer.method_14364((class_2596)ServerNetworking.createUberPacket((class_1657)vivePlayer.player, vivePlayer.vrPlayerState, vivePlayer.worldScale, vivePlayer.heightScale));
        }
    }
}

