/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mod_compat_vr.iris.mixin.irisshaders;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.irisshaders.iris.pipeline.PipelineManager;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.irisshaders.iris.shaderpack.materialmap.NamespacedId;
import net.irisshaders.iris.shadows.ShadowRenderTargets;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Group;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.render.RenderPass;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.client_xr.render_pass.RenderPassManager;
import org.vivecraft.client_xr.render_pass.RenderPassType;
import org.vivecraft.client_xr.render_pass.WorldRenderPass;
import org.vivecraft.mod_compat_vr.iris.extensions.PipelineManagerExtension;

@Pseudo
@Mixin(value={PipelineManager.class})
public class IrisPipelineManagerVRMixin
implements PipelineManagerExtension {
    @Shadow(remap=false)
    private WorldRenderingPipeline pipeline;
    @Shadow(remap=false)
    @Final
    private Function<Object, WorldRenderingPipeline> pipelineFactory;
    @Unique
    private ShadowRenderTargets vivecraft$shadowRenderTargets;
    @Unique
    private final Map<Object, Map<RenderPass, WorldRenderingPipeline>> vivecraft$vrPipelinesPerDimension = new HashMap<Object, Map<RenderPass, WorldRenderingPipeline>>();
    @Unique
    private WorldRenderingPipeline vivecraft$vanillaPipeline;
    @Unique
    private Map<RenderPass, WorldRenderingPipeline> vivecraft$vrPipelinesCurrentDimension;
    @Unique
    private WorldRenderPass vivecraft$currentWorldRenderPass = null;

    @Shadow(remap=false)
    private void resetTextureState() {
    }

    @Override
    @Unique
    public Object vivecraft$getShadowRenderTargets() {
        return this.vivecraft$shadowRenderTargets;
    }

    @Override
    @Unique
    public void vivecraft$setShadowRenderTargets(Object targets) {
        this.vivecraft$shadowRenderTargets = (ShadowRenderTargets)targets;
    }

    @Inject(method={"preparePipeline"}, at={@At(value="INVOKE", target="Ljava/util/function/Function;apply(Ljava/lang/Object;)Ljava/lang/Object;", shift=At.Shift.BEFORE)}, remap=false)
    private void vivecraft$generateVanillaPipeline(CallbackInfoReturnable<WorldRenderingPipeline> cir) {
        if (VRState.vrInitialized && RenderPassManager.INSTANCE != null) {
            this.vivecraft$currentWorldRenderPass = RenderPassManager.wrp;
            RenderPass currentRenderPass = ClientDataHolderVR.getInstance().currentPass;
            RenderPassManager.setVanillaRenderPass();
            ClientDataHolderVR.getInstance().currentPass = currentRenderPass;
        }
    }

    @Inject(method={"preparePipeline"}, at={@At(value="INVOKE", target="Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", shift=At.Shift.AFTER)}, remap=false, expect=0)
    @Group(name="generateVRPipelines", min=1, max=1)
    private void vivecraft$generateVRPipelines165(NamespacedId newDimension, CallbackInfoReturnable<WorldRenderingPipeline> cir) {
        this.vivecraft$generateVRPipelines(newDimension);
    }

    @Unique
    private void vivecraft$generateVRPipelines(Object newDimension) {
        if (VRState.vrInitialized) {
            this.vivecraft$vanillaPipeline = this.pipeline;
            if (!this.vivecraft$vrPipelinesPerDimension.containsKey(newDimension)) {
                this.vivecraft$vrPipelinesPerDimension.put(newDimension, new HashMap());
                this.vivecraft$vrPipelinesCurrentDimension = this.vivecraft$vrPipelinesPerDimension.get(newDimension);
                this.vivecraft$shadowRenderTargets = null;
                block8: for (RenderPass renderPass : RenderPass.values()) {
                    VRSettings.logger.info("Creating VR pipeline for dimension {}, RenderPass {}", newDimension, (Object)renderPass);
                    WorldRenderPass worldRenderPass = null;
                    switch (renderPass) {
                        case LEFT: 
                        case RIGHT: {
                            worldRenderPass = WorldRenderPass.stereoXR;
                            break;
                        }
                        case CENTER: {
                            worldRenderPass = WorldRenderPass.center;
                            break;
                        }
                        case THIRD: {
                            worldRenderPass = WorldRenderPass.mixedReality;
                            break;
                        }
                        case SCOPEL: {
                            worldRenderPass = WorldRenderPass.leftTelescope;
                            break;
                        }
                        case SCOPER: {
                            worldRenderPass = WorldRenderPass.rightTelescope;
                            break;
                        }
                        case CAMERA: {
                            worldRenderPass = WorldRenderPass.camera;
                            break;
                        }
                        default: {
                            VRSettings.logger.info("skipped VR pipeline for dimension {}, RenderPass {}, not used", newDimension, (Object)renderPass);
                            continue block8;
                        }
                    }
                    if (worldRenderPass == null) continue;
                    RenderPassManager.setWorldRenderPass(worldRenderPass);
                    WorldRenderingPipeline pipe = this.pipelineFactory.apply(newDimension);
                    this.vivecraft$vrPipelinesPerDimension.get(newDimension).put(renderPass, pipe);
                }
                if (this.vivecraft$currentWorldRenderPass != null) {
                    RenderPassManager.setWorldRenderPass(this.vivecraft$currentWorldRenderPass);
                } else if (ClientDataHolderVR.getInstance().currentPass == RenderPass.GUI) {
                    RenderPassManager.setGUIRenderPass();
                } else {
                    RenderPassManager.setVanillaRenderPass();
                }
            }
            this.vivecraft$vrPipelinesCurrentDimension = this.vivecraft$vrPipelinesPerDimension.get(newDimension);
            if (!RenderPassType.isVanilla()) {
                this.pipeline = ClientDataHolderVR.getInstance().currentPass != null ? this.vivecraft$vrPipelinesCurrentDimension.get((Object)ClientDataHolderVR.getInstance().currentPass) : this.vivecraft$vrPipelinesCurrentDimension.get((Object)RenderPass.LEFT);
            }
        }
    }

    @Inject(method={"preparePipeline"}, at={@At(value="INVOKE", target="Ljava/util/Map;get(Ljava/lang/Object;)Ljava/lang/Object;")}, remap=false, cancellable=true, expect=0)
    @Group(name="returnCurrentVRPipeline", min=1, max=1)
    private void vivecraft$returnCurrentVRPipeline165(NamespacedId newDimension, CallbackInfoReturnable<WorldRenderingPipeline> cir) {
        if (!RenderPassType.isVanilla()) {
            this.pipeline = this.vivecraft$getCurrentVRPipeline(newDimension);
            cir.setReturnValue((Object)this.pipeline);
        }
    }

    @Unique
    private WorldRenderingPipeline vivecraft$getCurrentVRPipeline(Object key) {
        return this.vivecraft$vrPipelinesPerDimension.get(key).get((Object)ClientDataHolderVR.getInstance().currentPass);
    }

    @Inject(method={"destroyPipeline"}, at={@At(value="INVOKE", target="Ljava/util/Map;clear()V")}, remap=false)
    private void vivecraft$destroyVRPipelines(CallbackInfo ci) {
        if (VRState.vrInitialized) {
            this.vivecraft$vrPipelinesPerDimension.forEach((dimID, map) -> {
                map.forEach((renderPass, pipeline) -> {
                    VRSettings.logger.info("Destroying VR pipeline {}", (Object)renderPass);
                    this.resetTextureState();
                    pipeline.destroy();
                });
                map.clear();
            });
            this.vivecraft$shadowRenderTargets = null;
            this.vivecraft$vrPipelinesPerDimension.clear();
            this.vivecraft$vanillaPipeline = null;
        }
    }

    @Unique
    public WorldRenderingPipeline vivecraft$getVRPipeline(RenderPass pass) {
        return this.vivecraft$vrPipelinesCurrentDimension.get((Object)pass);
    }

    @Unique
    public WorldRenderingPipeline vivecraft$getVanillaPipeline() {
        return this.vivecraft$vanillaPipeline;
    }
}

