/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mod_compat_vr.iris.mixin.coderbot;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EnumMap;
import me.jellysquid.mods.sodium.client.gl.shader.GlProgram;
import net.coderbot.iris.Iris;
import net.coderbot.iris.compat.sodium.impl.shader_overrides.IrisChunkProgramOverrides;
import net.coderbot.iris.compat.sodium.impl.shader_overrides.IrisChunkShaderInterface;
import net.coderbot.iris.compat.sodium.impl.shader_overrides.IrisTerrainPass;
import net.coderbot.iris.pipeline.SodiumTerrainPipeline;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.render.RenderPass;
import org.vivecraft.client_xr.render_pass.RenderPassManager;
import org.vivecraft.client_xr.render_pass.RenderPassType;
import org.vivecraft.client_xr.render_pass.WorldRenderPass;
import org.vivecraft.mod_compat_vr.iris.extensions.IrisChunkProgramOverridesExtension;
import org.vivecraft.mod_compat_vr.iris.extensions.PipelineManagerExtension;

@Pseudo
@Mixin(value={IrisChunkProgramOverrides.class})
public class IrisChunkProgramOverridesMixin
implements IrisChunkProgramOverridesExtension {
    @Shadow(remap=false)
    @Final
    private EnumMap<IrisTerrainPass, GlProgram<IrisChunkShaderInterface>> programs;
    @Unique
    private final EnumMap<RenderPass, EnumMap<IrisTerrainPass, GlProgram<IrisChunkShaderInterface>>> vivecraft$pipelinePrograms = new EnumMap(RenderPass.class);

    @Override
    @Unique
    public void vivecraft$createAllPipelinesShadersSodiumProcessing(Object sodiumTerrainPipeline, Object chunkVertexType, Method createShadersMethod) throws InvocationTargetException, IllegalAccessException {
        if (VRState.vrInitialized) {
            WorldRenderPass current = RenderPassManager.wrp;
            RenderPass currentPass = ClientDataHolderVR.getInstance().currentPass;
            RenderPassManager.renderPassType = RenderPassType.WORLD_ONLY;
            for (RenderPass renderPass : RenderPass.values()) {
                Iris.logger.info("Creating VR sodium shaders for RenderPass {}", new Object[]{renderPass});
                WorldRenderingPipeline worldPipeline = (WorldRenderingPipeline)((PipelineManagerExtension)Iris.getPipelineManager()).vivecraft$getVRPipeline(renderPass);
                if (worldPipeline == null) continue;
                SodiumTerrainPipeline sodiumPipeline = worldPipeline.getSodiumTerrainPipeline();
                EnumMap<IrisTerrainPass, GlProgram<IrisChunkShaderInterface>> renderPassShaders = new EnumMap<IrisTerrainPass, GlProgram<IrisChunkShaderInterface>>(IrisTerrainPass.class);
                this.vivecraft$pipelinePrograms.put(renderPass, renderPassShaders);
                createShadersMethod.invoke((Object)this, sodiumPipeline, chunkVertexType);
                renderPassShaders.putAll(this.programs);
                this.programs.clear();
            }
            RenderPassManager.setVanillaRenderPass();
            Iris.logger.info("Creating sodium shaders for vanilla RenderPass");
            createShadersMethod.invoke((Object)this, ((WorldRenderingPipeline)((PipelineManagerExtension)Iris.getPipelineManager()).vivecraft$getVanillaPipeline()).getSodiumTerrainPipeline(), chunkVertexType);
            if (current != null) {
                RenderPassManager.setWorldRenderPass(current);
                ClientDataHolderVR.getInstance().currentPass = currentPass;
            }
        } else {
            createShadersMethod.invoke((Object)this, sodiumTerrainPipeline, chunkVertexType);
        }
    }

    @Redirect(method={"getProgramOverride"}, at=@At(value="INVOKE", target="Ljava/util/EnumMap;get(Ljava/lang/Object;)Ljava/lang/Object;"), remap=false)
    public Object vivecraft$getVRPipelineShaders(EnumMap<IrisTerrainPass, GlProgram<IrisChunkShaderInterface>> instance, Object key) {
        return !RenderPassType.isVanilla() ? this.vivecraft$pipelinePrograms.get((Object)ClientDataHolderVR.getInstance().currentPass).get((IrisTerrainPass)key) : instance.get((IrisTerrainPass)key);
    }

    @Inject(method={"deleteShaders"}, at={@At(value="HEAD")}, remap=false)
    public void vivecraft$deleteVRPipelineShaders(CallbackInfo ci) {
        if (VRState.vrInitialized) {
            for (EnumMap<IrisTerrainPass, GlProgram<IrisChunkShaderInterface>> map : this.vivecraft$pipelinePrograms.values()) {
                for (GlProgram<IrisChunkShaderInterface> program : map.values()) {
                    if (program == null) continue;
                    program.delete();
                }
                map.clear();
            }
            this.vivecraft$pipelinePrograms.clear();
        }
    }
}

