/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.settings;

import com.google.gson.JsonObject;
import java.awt.Color;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.StringJoiner;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_1074;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_7923;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vivecraft.client.utils.LangHelper;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.gameplay.VRPlayer;
import org.vivecraft.client_vr.gameplay.screenhandlers.KeyboardHandler;
import org.vivecraft.client_vr.gui.PhysicalKeyboard;
import org.vivecraft.client_vr.settings.OptionEnum;
import org.vivecraft.client_vr.settings.SettingField;
import org.vivecraft.client_vr.settings.profile.ProfileManager;
import org.vivecraft.client_vr.settings.profile.ProfileReader;
import org.vivecraft.client_vr.settings.profile.ProfileWriter;
import org.vivecraft.common.utils.math.Angle;
import org.vivecraft.common.utils.math.Quaternion;
import org.vivecraft.common.utils.math.Vector3;
import org.vivecraft.mod_compat_vr.ShadersHelper;

public class VRSettings {
    public static final int VERSION = 2;
    public static final Logger logger = LoggerFactory.getLogger((String)"Vivecraft");
    public static VRSettings inst;
    public JsonObject defaults = new JsonObject();
    public static final int UNKNOWN_VERSION = 0;
    public static final String DEGREE = "\u00b0";
    @SettingField
    public int version = 0;
    @SettingField(value=VrOptions.VR_PLUGIN)
    public VRProvider stereoProviderPluginID = VRProvider.OPENVR;
    public boolean storeDebugAim = false;
    @SettingField
    public int smoothRunTickCount = 20;
    @SettingField
    public boolean smoothTick = false;
    @SettingField(config="QUICKCOMMAND", separate=true)
    public String[] vrQuickCommands = this.getQuickCommandsDefaults();
    @SettingField(config="RADIAL", separate=true)
    public String[] vrRadialItems = this.getRadialItemsDefault();
    @SettingField(config="RADIALALT", separate=true)
    public String[] vrRadialItemsAlt = this.getRadialItemsAltDefault();
    @SettingField(fixedSize=false)
    public int[] keyboardCodes = this.getKeyboardCodesDefault();
    @SettingField(value=VrOptions.REVERSE_HANDS)
    public boolean reverseHands = false;
    public boolean reverseShootingEye = false;
    @SettingField(value=VrOptions.WORLD_SCALE)
    public float worldScale = 1.0f;
    @SettingField(value=VrOptions.WORLD_ROTATION)
    public float worldRotation = 0.0f;
    public float worldRotationCached;
    @SettingField(value=VrOptions.WORLD_ROTATION_INCREMENT, config="vrWorldRotationIncrement")
    public float worldRotationIncrement = 45.0f;
    @SettingField(value=VrOptions.X_SENSITIVITY)
    public float xSensitivity = 1.0f;
    @SettingField(value=VrOptions.Y_SENSITIVITY)
    public float ySensitivity = 1.0f;
    @SettingField(value=VrOptions.KEYHOLE)
    public float keyholeX = 15.0f;
    @SettingField
    public double headToHmdLength = 0.1f;
    @SettingField
    public float autoCalibration = -1.0f;
    @SettingField
    public float manualCalibration = -1.0f;
    @SettingField
    public boolean alwaysSimulateKeyboard = false;
    @SettingField(value=VrOptions.BOW_MODE)
    public BowMode bowMode = BowMode.ON;
    @SettingField
    public String keyboardKeys = "`1234567890-=qwertyuiop[]\\asdfghjkl;':\"zxcvbnm,./?<>";
    @SettingField
    public String keyboardKeysShift = "~!@#$%^&*()_+QWERTYUIOP{}|ASDFGHJKL;':\"ZXCVBNM,./?<>";
    @SettingField(value=VrOptions.HRTF_SELECTION)
    public int hrtfSelection = 0;
    @SettingField(value=VrOptions.RIGHT_CLICK_DELAY)
    public RightClickDelay rightclickDelay = RightClickDelay.VANILLA;
    @SettingField(value=VrOptions.INGAME_BINDINGS_IN_GUI)
    public boolean ingameBindingsInGui = false;
    @SettingField(value=VrOptions.THIRDPERSON_ITEMTRANSFORMS)
    public boolean thirdPersonItems = false;
    @SettingField(value=VrOptions.INERTIA_FACTOR)
    public InertiaFactor inertiaFactor = InertiaFactor.NORMAL;
    @SettingField(value=VrOptions.WALK_UP_BLOCKS)
    public boolean walkUpBlocks = true;
    @SettingField(value=VrOptions.SIMULATE_FALLING)
    public boolean simulateFalling = true;
    @SettingField(value=VrOptions.WEAPON_COLLISION, config="weaponCollisionNew")
    public WeaponCollision weaponCollision = WeaponCollision.AUTO;
    @SettingField(value=VrOptions.MOVEMENT_MULTIPLIER)
    public float movementSpeedMultiplier = 1.0f;
    @SettingField(value=VrOptions.FREEMOVE_MODE)
    public FreeMove vrFreeMoveMode = FreeMove.CONTROLLER;
    @SettingField(value=VrOptions.FREEMOVE_FLY_MODE)
    public FreeMove vrFreeMoveFlyMode = FreeMove.AUTO;
    @SettingField(value=VrOptions.LIMIT_TELEPORT, config="limitedTeleport")
    public boolean vrLimitedSurvivalTeleport = true;
    @SettingField(value=VrOptions.TELEPORT_UP_LIMIT, config="teleportLimitUp")
    public int vrTeleportUpLimit = 1;
    @SettingField(value=VrOptions.TELEPORT_DOWN_LIMIT, config="teleportLimitDown")
    public int vrTeleportDownLimit = 4;
    @SettingField(value=VrOptions.TELEPORT_HORIZ_LIMIT, config="teleportLimitHoriz")
    public int vrTeleportHorizLimit = 16;
    @SettingField(value=VrOptions.PLAY_MODE_SEATED)
    public boolean seated = false;
    @SettingField(value=VrOptions.SEATED_HMD, config="seatedhmd")
    public boolean seatedUseHMD = false;
    @SettingField
    public float jumpThreshold = 0.05f;
    @SettingField
    public float sneakThreshold = 0.4f;
    @SettingField
    public float crawlThreshold = 0.82f;
    @SettingField(value=VrOptions.REALISTIC_JUMP)
    public RealisticJump realisticJumpEnabled = RealisticJump.AUTO;
    @SettingField(value=VrOptions.REALISTIC_SNEAK)
    public boolean realisticSneakEnabled = true;
    @SettingField(value=VrOptions.REALISTIC_CLIMB)
    public boolean realisticClimbEnabled = true;
    @SettingField(value=VrOptions.REALISTIC_SWIM)
    public boolean realisticSwimEnabled = true;
    @SettingField(value=VrOptions.REALISTIC_ROW)
    public boolean realisticRowEnabled = true;
    @SettingField(value=VrOptions.REALISTIC_DISMOUNT)
    public boolean realisticDismountEnabled = true;
    @SettingField(value=VrOptions.BACKPACK_SWITCH)
    public boolean backpackSwitching = true;
    @SettingField(value=VrOptions.PHYSICAL_GUI)
    public boolean physicalGuiEnabled = false;
    @SettingField(value=VrOptions.WALK_MULTIPLIER)
    public float walkMultiplier = 1.0f;
    @SettingField(value=VrOptions.ALLOW_CRAWLING)
    public boolean allowCrawling = true;
    @SettingField(value=VrOptions.BCB_ON, config="bcbOn")
    public boolean vrShowBlueCircleBuddy = true;
    @SettingField(value=VrOptions.VEHICLE_ROTATION)
    public boolean vehicleRotation = true;
    @SettingField(value=VrOptions.ANALOG_MOVEMENT)
    public boolean analogMovement = true;
    @SettingField(value=VrOptions.AUTO_SPRINT)
    public boolean autoSprint = true;
    @SettingField(value=VrOptions.AUTO_SPRINT_THRESHOLD)
    public float autoSprintThreshold = 0.9f;
    @SettingField
    public Vector3 originOffset = new Vector3(0.0f, 0.0f, 0.0f);
    @SettingField(value=VrOptions.ALLOW_STANDING_ORIGIN_OFFSET)
    public boolean allowStandingOriginOffset = false;
    @SettingField(value=VrOptions.SEATED_FREE_MOVE)
    public boolean seatedFreeMove = false;
    @SettingField(value=VrOptions.FORCE_STANDING_FREE_MOVE)
    public boolean forceStandingFreeMove = false;
    @SettingField(value=VrOptions.FSAA)
    public boolean useFsaa = false;
    @SettingField(value=VrOptions.LOW_HEALTH_INDICATOR)
    public boolean low_health_indicator = true;
    @SettingField(value=VrOptions.FOV_REDUCTION, config="fovReduction")
    public boolean useFOVReduction = false;
    @SettingField(value=VrOptions.FOV_REDUCTION_OFFSET)
    public float fovRedutioncOffset = 0.1f;
    @SettingField(value=VrOptions.FOV_REDUCTION_MIN)
    public float fovReductionMin = 0.25f;
    @SettingField(value=VrOptions.STENCIL_ON, config="stencilOn")
    public boolean vrUseStencil = true;
    @SettingField
    public boolean insideBlockSolidColor = false;
    @SettingField(value=VrOptions.RENDER_SCALEFACTOR)
    public float renderScaleFactor = 1.0f;
    @SettingField(value=VrOptions.MIRROR_DISPLAY)
    public MirrorMode displayMirrorMode = MirrorMode.CROPPED;
    @SettingField(value=VrOptions.MIRROR_CROP)
    public float mirrorCrop = 0.15f;
    @SettingField(value=VrOptions.MIRROR_EYE)
    public boolean displayMirrorLeftEye = false;
    @SettingField(value=VrOptions.MIRROR_CENTER_SMOOTH)
    public float displayMirrorCenterSmooth = 0.0f;
    public boolean shouldRenderSelf = false;
    @SettingField(value=VrOptions.MENU_WORLD_SELECTION)
    public MenuWorld menuWorldSelection = MenuWorld.BOTH;
    @SettingField(value=VrOptions.MENU_WORLD_FALLBACK)
    public boolean menuWorldFallbackPanorama = true;
    @SettingField(value=VrOptions.MIXED_REALITY_KEY_COLOR)
    public Color mixedRealityKeyColor = new Color(0, 0, 0);
    public float mixedRealityAspectRatio = 1.7777778f;
    @SettingField(value=VrOptions.MIXED_REALITY_RENDER_HANDS)
    public boolean mixedRealityRenderHands = false;
    @SettingField(value=VrOptions.MIXED_REALITY_UNITY_LIKE)
    public boolean mixedRealityUnityLike = true;
    @SettingField(value=VrOptions.MIXED_REALITY_UNDISTORTED)
    public boolean mixedRealityUndistorted = true;
    @SettingField(value=VrOptions.MIXED_REALITY_ALPHA_MASK)
    public boolean mixedRealityAlphaMask = false;
    @SettingField(value=VrOptions.MIXED_REALITY_FOV)
    public float mixedRealityFov = 40.0f;
    @SettingField
    public float vrFixedCamposX = -1.0f;
    @SettingField
    public float vrFixedCamposY = 2.4f;
    @SettingField
    public float vrFixedCamposZ = 2.7f;
    @SettingField(config="vrFixedCamrot", separate=true)
    public Quaternion vrFixedCamrotQuat = new Quaternion(0.962f, 0.125f, 0.239f, 0.041f);
    @SettingField
    public float mrMovingCamOffsetX = 0.0f;
    @SettingField
    public float mrMovingCamOffsetY = 0.0f;
    @SettingField
    public float mrMovingCamOffsetZ = 0.0f;
    @SettingField(config="mrMovingCamOffsetRot", separate=true)
    public Quaternion mrMovingCamOffsetRotQuat = new Quaternion();
    @SettingField
    public Angle.Order externalCameraAngleOrder = Angle.Order.XZY;
    @SettingField(value=VrOptions.HANDHELD_CAMERA_FOV)
    public float handCameraFov = 70.0f;
    @SettingField(value=VrOptions.HANDHELD_CAMERA_RENDER_SCALE)
    public float handCameraResScale = 1.0f;
    @SettingField(value=VrOptions.MIXED_REALITY_RENDER_CAMERA_MODEL)
    public boolean mixedRealityRenderCameraModel = true;
    @SettingField(value=VrOptions.TOUCH_HOTBAR)
    public boolean vrTouchHotbar = true;
    @SettingField(value=VrOptions.HUD_SCALE, config="headHudScale")
    public float hudScale = 1.0f;
    @SettingField(value=VrOptions.HUD_DISTANCE)
    public float hudDistance = 1.25f;
    @SettingField
    public float hudPitchOffset = -2.0f;
    @SettingField
    public float hudYawOffset = 0.0f;
    public boolean floatInventory = true;
    @SettingField(value=VrOptions.MENU_ALWAYS_FOLLOW_FACE)
    public boolean menuAlwaysFollowFace;
    @SettingField(value=VrOptions.HUD_LOCK_TO)
    public HUDLock vrHudLockMode = HUDLock.WRIST;
    @SettingField(value=VrOptions.HUD_OCCLUSION)
    public boolean hudOcclusion = true;
    @SettingField(value=VrOptions.CROSSHAIR_SCALE)
    public float crosshairScale = 1.0f;
    @SettingField(value=VrOptions.CROSSHAIR_SCALES_WITH_DISTANCE)
    public boolean crosshairScalesWithDistance = false;
    @SettingField(value=VrOptions.RENDER_CROSSHAIR_MODE)
    public RenderPointerElement renderInGameCrosshairMode = RenderPointerElement.ALWAYS;
    @SettingField(value=VrOptions.RENDER_BLOCK_OUTLINE_MODE)
    public RenderPointerElement renderBlockOutlineMode = RenderPointerElement.ALWAYS;
    @SettingField(value=VrOptions.HUD_OPACITY)
    public float hudOpacity = 1.0f;
    @SettingField(value=VrOptions.RENDER_MENU_BACKGROUND)
    public boolean menuBackground = false;
    @SettingField(value=VrOptions.MENU_CROSSHAIR_SCALE)
    public float menuCrosshairScale = 1.0f;
    @SettingField(value=VrOptions.CROSSHAIR_OCCLUSION)
    public boolean useCrosshairOcclusion = true;
    @SettingField(value=VrOptions.SEATED_HUD_XHAIR)
    public boolean seatedHudAltMode = true;
    @SettingField(value=VrOptions.AUTO_OPEN_KEYBOARD)
    public boolean autoOpenKeyboard = false;
    @SettingField(value=VrOptions.AUTO_CLOSE_KEYBOARD)
    public boolean autoCloseKeyboard = true;
    @SettingField
    public int forceHardwareDetection = 0;
    @SettingField(value=VrOptions.RADIAL_MODE_HOLD)
    public boolean radialModeHold = true;
    @SettingField(value=VrOptions.PHYSICAL_KEYBOARD)
    public boolean physicalKeyboard = true;
    @SettingField(value=VrOptions.PHYSICAL_KEYBOARD_SCALE)
    public float physicalKeyboardScale = 1.0f;
    @SettingField(value=VrOptions.PHYSICAL_KEYBOARD_THEME)
    public PhysicalKeyboard.KeyboardTheme physicalKeyboardTheme = PhysicalKeyboard.KeyboardTheme.DEFAULT;
    @SettingField(value=VrOptions.KEYBOARD_PRESS_BINDS)
    public boolean keyboardPressBinds = false;
    @SettingField(value=VrOptions.ALLOW_ADVANCED_BINDINGS)
    public boolean allowAdvancedBindings = false;
    @SettingField(value=VrOptions.CHAT_NOTIFICATIONS)
    public ChatNotifications chatNotifications = ChatNotifications.NONE;
    @SettingField(value=VrOptions.CHAT_NOTIFICATION_SOUND)
    public String chatNotificationSound = "block.note_block.bell";
    @SettingField(value=VrOptions.GUI_APPEAR_OVER_BLOCK)
    public boolean guiAppearOverBlock = true;
    @SettingField(value=VrOptions.SHADER_GUI_RENDER)
    public ShaderGUIRender shaderGUIRender = ShaderGUIRender.AFTER_SHADER;
    @SettingField(value=VrOptions.DOUBLE_GUI_RESOLUTION)
    public boolean doubleGUIResolution = false;
    @SettingField(value=VrOptions.GUI_SCALE)
    public int guiScale = 0;
    @SettingField(value=VrOptions.HUD_MAX_GUI_SCALE)
    public boolean hudMaxScale = false;
    @SettingField(value=VrOptions.SHOW_UPDATES)
    public boolean alwaysShowUpdates = true;
    @SettingField
    public String lastUpdate = "";
    @SettingField(value=VrOptions.UPDATE_TYPE)
    public UpdateType updateType = UpdateType.RELEASE;
    @SettingField(value=VrOptions.SHOW_PLUGIN)
    public ChatServerPluginMessage showServerPluginMessage = ChatServerPluginMessage.SERVER_ONLY;
    @SettingField(value=VrOptions.SHOW_PLUGIN_MISSING)
    public boolean showServerPluginMissingMessageAlways = true;
    @SettingField(value=VrOptions.CHAT_MESSAGE_STENCIL)
    public boolean showChatMessageStencil = true;
    @SettingField(value=VrOptions.VR_ENABLED, config="vrEnabled")
    public boolean vrEnabled = false;
    @SettingField(value=VrOptions.VR_REMEMBER_ENABLED)
    public boolean rememberVr = true;
    @SettingField(value=VrOptions.VR_HOTSWITCH)
    public boolean vrHotswitchingEnabled = true;
    @SettingField(value=VrOptions.VR_TOGGLE_BUTTON_VISIBLE, config="vrToggleButtonEnabled")
    public boolean vrToggleButtonEnabled = true;
    @SettingField(value=VrOptions.VR_SETTINGS_BUTTON_VISIBLE, config="vrSettingsButtonEnabled")
    public boolean vrSettingsButtonEnabled = true;
    @SettingField(value=VrOptions.VR_SETTINGS_BUTTON_POSITION, config="vrSettingsButtonPositionLeft")
    public boolean vrSettingsButtonPositionLeft = true;
    @SettingField
    public boolean disableGarbageCollectorMessage = false;
    @SettingField
    public boolean selfButtSparklesInFirstPerson = false;
    @SettingField(value=VrOptions.HUD_HIDE)
    @Deprecated
    public boolean hideGUI;
    @SettingField(value=VrOptions.MONO_FOV)
    @Deprecated
    public float monoFOV;
    public ServerOverrides overrides = new ServerOverrides();
    private final Map<VrOptions, ConfigEntry> fieldEnumMap = new EnumMap<VrOptions, ConfigEntry>(VrOptions.class);
    private final Map<String, ConfigEntry> fieldConfigMap = new HashMap<String, ConfigEntry>();
    private Map<String, String> preservedSettingMap;
    private final class_310 mc;

    public VRSettings(class_310 minecraft, File dataDir) {
        this.initializeFieldInfo();
        this.mc = minecraft;
        inst = this;
        this.storeDefaults();
        this.loadOptions();
    }

    private void initializeFieldInfo() {
        try {
            for (Field field : VRSettings.class.getFields()) {
                SettingField ann = field.getAnnotation(SettingField.class);
                if (ann == null) continue;
                String config = ann.config().isEmpty() ? field.getName() : ann.config();
                ConfigEntry configEntry = new ConfigEntry(field, ann.value(), config, ann.separate(), ann.fixedSize());
                if (ann.value() != VrOptions.DUMMY) {
                    if (this.fieldEnumMap.containsKey((Object)ann.value())) {
                        throw new RuntimeException("duplicate enum in setting field: " + field.getName());
                    }
                    this.fieldEnumMap.put(ann.value(), configEntry);
                }
                if (ann.separate() && field.getType().isArray()) {
                    int len = Array.getLength(field.get(this));
                    IntStream.range(0, len).forEach(i -> this.fieldConfigMap.put(config + "_" + i, configEntry));
                    continue;
                }
                if (ann.separate() && Quaternion.class.isAssignableFrom(field.getType())) {
                    Stream.of(Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z')).forEach(suffix -> this.fieldConfigMap.put(config + suffix, configEntry));
                    continue;
                }
                if (ann.separate() && Vector3.class.isAssignableFrom(field.getType())) {
                    Stream.of(Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z')).forEach(suffix -> this.fieldConfigMap.put(config + suffix, configEntry));
                    continue;
                }
                this.fieldConfigMap.put(config, configEntry);
            }
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Object loadOption(String name, String value, Object currentValue, VrOptions option, Class<?> type, boolean separate) throws ReflectiveOperationException {
        Object obj = option.convertOption(value);
        if (obj == null) {
            obj = option.loadOption(value);
        }
        if (obj != null) {
            return obj;
        }
        if (type == String.class) {
            return value;
        }
        if (type == Boolean.TYPE) {
            return value.equals("true");
        }
        if (type == Integer.TYPE) {
            return Integer.parseInt(value);
        }
        if (type == Long.TYPE) {
            return Long.parseLong(value);
        }
        if (type == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (type == Double.TYPE) {
            return Double.parseDouble(value);
        }
        if (type.isEnum()) {
            Method m = type.getMethod("valueOf", String.class);
            return m.invoke(null, value);
        }
        if (Quaternion.class.isAssignableFrom(type)) {
            Quaternion quat = ((Quaternion)currentValue).copy();
            if (separate) {
                float f = Float.parseFloat(value);
                switch (name.charAt(name.length() - 1)) {
                    case 'W': {
                        quat.w = f;
                        break;
                    }
                    case 'X': {
                        quat.x = f;
                        break;
                    }
                    case 'Y': {
                        quat.y = f;
                        break;
                    }
                    case 'Z': {
                        quat.z = f;
                    }
                }
            } else {
                String[] split = value.split(",");
                quat.w = Float.parseFloat(split[0]);
                quat.x = Float.parseFloat(split[1]);
                quat.y = Float.parseFloat(split[2]);
                quat.z = Float.parseFloat(split[3]);
            }
            return quat;
        }
        if (Vector3.class.isAssignableFrom(type)) {
            Vector3 vec = ((Vector3)currentValue).copy();
            if (separate) {
                float f = Float.parseFloat(value);
                switch (name.charAt(name.length() - 1)) {
                    case 'X': {
                        vec.x = f;
                        break;
                    }
                    case 'Y': {
                        vec.y = f;
                        break;
                    }
                    case 'Z': {
                        vec.z = f;
                    }
                }
            } else {
                String[] split = value.split(",");
                vec.x = Float.parseFloat(split[0]);
                vec.y = Float.parseFloat(split[1]);
                vec.z = Float.parseFloat(split[2]);
            }
            return vec;
        }
        logger.warn("Don't know how to load VR option " + name + " with type " + type.getSimpleName());
        return null;
    }

    private String saveOption(String name, Object obj, VrOptions option, Class<?> type, boolean separate) {
        String value = option.saveOption(obj);
        if (value != null) {
            return value;
        }
        if (type == String.class) {
            return (String)obj;
        }
        if (type == Boolean.TYPE || type == Integer.TYPE || type == Long.TYPE || type == Float.TYPE || type == Double.TYPE) {
            return obj.toString();
        }
        if (type.isEnum()) {
            return ((Enum)obj).name();
        }
        if (Quaternion.class.isAssignableFrom(type)) {
            Quaternion quat = (Quaternion)obj;
            if (separate) {
                return Float.toString(switch (name.charAt(name.length() - 1)) {
                    case 'W' -> quat.w;
                    case 'X' -> quat.x;
                    case 'Y' -> quat.y;
                    case 'Z' -> quat.z;
                    default -> 0.0f;
                });
            }
            return quat.w + "," + quat.x + "," + quat.y + "," + quat.z;
        }
        if (Vector3.class.isAssignableFrom(type)) {
            Vector3 vec = (Vector3)obj;
            if (separate) {
                return Float.toString(switch (name.charAt(name.length() - 1)) {
                    case 'X' -> vec.x;
                    case 'Y' -> vec.y;
                    case 'Z' -> vec.z;
                    default -> 0.0f;
                });
            }
            return vec.x + "," + vec.y + "," + vec.z;
        }
        logger.warn("Don't know how to save VR option " + name + " with type " + type.getSimpleName());
        return null;
    }

    private Object loadDefault(String name, String value, VrOptions option, Class<?> type, boolean separate, Map<String, String> profileSet) throws ReflectiveOperationException {
        Object obj;
        if (value == null) {
            value = profileSet.get(name);
        }
        if ((obj = option.loadOption(value)) != null) {
            return obj;
        }
        if (type == String.class) {
            return value;
        }
        if (type == Boolean.TYPE) {
            return value.equals("true");
        }
        if (type == Integer.TYPE) {
            return Integer.parseInt(value);
        }
        if (type == Long.TYPE) {
            return Long.parseLong(value);
        }
        if (type == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (type == Double.TYPE) {
            return Double.parseDouble(value);
        }
        if (type.isEnum()) {
            Method m = type.getMethod("valueOf", String.class);
            return m.invoke(null, value);
        }
        if (Quaternion.class.isAssignableFrom(type)) {
            Quaternion quat = new Quaternion();
            if (separate) {
                Stream.of(Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z')).forEach(suffix -> {
                    String str = (String)profileSet.get(name + suffix);
                    float f = Float.parseFloat(str);
                    switch (suffix.charValue()) {
                        case 'W': {
                            quat.w = f;
                            break;
                        }
                        case 'X': {
                            quat.x = f;
                            break;
                        }
                        case 'Y': {
                            quat.y = f;
                            break;
                        }
                        case 'Z': {
                            quat.z = f;
                        }
                    }
                });
            } else {
                String[] split = value.split(",");
                quat.w = Float.parseFloat(split[0]);
                quat.x = Float.parseFloat(split[1]);
                quat.y = Float.parseFloat(split[2]);
                quat.z = Float.parseFloat(split[3]);
            }
            return quat;
        }
        if (Vector3.class.isAssignableFrom(type)) {
            Vector3 vec = new Vector3();
            if (separate) {
                Stream.of(Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z')).forEach(suffix -> {
                    String str = (String)profileSet.get(name + suffix);
                    float f = Float.parseFloat(str);
                    switch (suffix.charValue()) {
                        case 'X': {
                            vec.x = f;
                            break;
                        }
                        case 'Y': {
                            vec.y = f;
                            break;
                        }
                        case 'Z': {
                            vec.z = f;
                        }
                    }
                });
            } else {
                String[] split = value.split(",");
                vec.x = Float.parseFloat(split[0]);
                vec.y = Float.parseFloat(split[1]);
                vec.z = Float.parseFloat(split[2]);
            }
            return vec;
        }
        logger.warn("Don't know how to load default VR option " + name + " with type " + type.getSimpleName());
        return null;
    }

    public void loadDefault(VrOptions option) {
        if (this.defaults == null) {
            return;
        }
        try {
            ConfigEntry mapping = this.fieldEnumMap.get((Object)option);
            if (mapping == null) {
                return;
            }
            Field field = mapping.field;
            Class<?> type = field.getType();
            String name = mapping.configName;
            Map<String, String> profileSet = ProfileManager.getProfileSet(this.defaults, "Vr");
            if (type.isArray()) {
                Object arr = field.get(this);
                int len = Array.getLength(arr);
                if (mapping.separate) {
                    for (int i = 0; i < len; ++i) {
                        Object obj = Objects.requireNonNull(this.loadDefault(name + "_" + i, null, option, type.getComponentType(), false, profileSet));
                        Array.set(arr, i, obj);
                    }
                } else {
                    String str = profileSet.get(name);
                    String[] split = str.split(";", -1);
                    for (int i = 0; i < len; ++i) {
                        Object obj = Objects.requireNonNull(this.loadDefault(name, split[i], option, type.getComponentType(), false, profileSet));
                        Array.set(arr, i, obj);
                    }
                }
            } else {
                Object obj = Objects.requireNonNull(this.loadDefault(name, null, option, type, mapping.separate, profileSet));
                field.set(this, obj);
            }
        }
        catch (Exception ex) {
            logger.warn("Failed to load default VR option: " + option);
            ex.printStackTrace();
        }
    }

    public void loadOptions() {
        this.loadOptions(null);
    }

    public void loadDefaults() {
        this.loadOptions(this.defaults);
    }

    public void loadOptions(JsonObject theProfiles) {
        try {
            ProfileReader optionsVRReader = new ProfileReader("Vr", theProfiles);
            String var2 = "";
            while ((var2 = optionsVRReader.readLine()) != null) {
                try {
                    String[] optionTokens = var2.split(":", 2);
                    String name = optionTokens[0];
                    String value = optionTokens.length > 1 ? optionTokens[1] : "";
                    ConfigEntry mapping = this.fieldConfigMap.get(name);
                    if (mapping == null) continue;
                    Field field = mapping.field;
                    Class<?> type = field.getType();
                    Object currentValue = field.get(this);
                    if (type.isArray()) {
                        if (mapping.separate) {
                            int index = Integer.parseInt(name.substring(name.lastIndexOf(95) + 1));
                            Object obj = Objects.requireNonNull(this.loadOption(name.substring(0, name.lastIndexOf(95)), value, Array.get(currentValue, index), mapping.vrOptions, type.getComponentType(), false));
                            Array.set(currentValue, index, obj);
                            continue;
                        }
                        int len = Array.getLength(currentValue);
                        String[] split = value.split(";", -1);
                        if (split.length != len && !mapping.fixedSize) {
                            Object newValue = Array.newInstance(type.getComponentType(), split.length);
                            System.arraycopy(currentValue, 0, newValue, 0, Math.min(len, split.length));
                            field.set(this, newValue);
                            currentValue = newValue;
                            len = split.length;
                        }
                        for (int i = 0; i < len; ++i) {
                            Object obj = Objects.requireNonNull(this.loadOption(name, split[i], Array.get(currentValue, i), mapping.vrOptions, type.getComponentType(), false));
                            Array.set(currentValue, i, obj);
                        }
                        continue;
                    }
                    Object obj = Objects.requireNonNull(this.loadOption(name, value, currentValue, mapping.vrOptions, type, mapping.separate));
                    field.set(this, obj);
                }
                catch (Exception var7) {
                    logger.warn("Skipping bad VR option: " + var2);
                    var7.printStackTrace();
                }
            }
            this.preservedSettingMap = optionsVRReader.getData();
            optionsVRReader.close();
        }
        catch (Exception var8) {
            logger.warn("Failed to load VR options!");
            var8.printStackTrace();
        }
    }

    public void saveOptions() {
        this.saveOptions(null);
    }

    private void storeDefaults() {
        this.saveOptions(this.defaults);
    }

    private void saveOptions(JsonObject theProfiles) {
        try {
            ProfileWriter var5 = new ProfileWriter("Vr", theProfiles);
            if (this.preservedSettingMap != null) {
                var5.setData(this.preservedSettingMap);
            }
            for (Map.Entry<String, ConfigEntry> entry2 : this.fieldConfigMap.entrySet()) {
                String name = entry2.getKey();
                ConfigEntry mapping = entry2.getValue();
                Field field = mapping.field;
                Class<?> type = field.getType();
                Object obj = field.get(this);
                try {
                    if (type.isArray()) {
                        if (mapping.separate) {
                            int index = Integer.parseInt(name.substring(name.lastIndexOf(95) + 1));
                            String value = Objects.requireNonNull(this.saveOption(name.substring(0, name.lastIndexOf(95)), Array.get(obj, index), mapping.vrOptions, type.getComponentType(), mapping.separate));
                            var5.println(name + ":" + value);
                            continue;
                        }
                        StringJoiner joiner = new StringJoiner(";");
                        int len = Array.getLength(obj);
                        for (int i = 0; i < len; ++i) {
                            String value = Objects.requireNonNull(this.saveOption(name, Array.get(obj, i), mapping.vrOptions, type.getComponentType(), mapping.separate));
                            joiner.add(value);
                        }
                        var5.println(name + ":" + joiner);
                        continue;
                    }
                    String value = Objects.requireNonNull(this.saveOption(name, obj, mapping.vrOptions, type, mapping.separate));
                    var5.println(name + ":" + value);
                }
                catch (Exception ex) {
                    logger.warn("Failed to save VR option: " + name);
                    ex.printStackTrace();
                }
            }
            var5.close();
        }
        catch (Exception var3) {
            logger.warn("Failed to save VR options: " + var3.getMessage());
            var3.printStackTrace();
        }
    }

    public void resetSettings() {
        this.loadDefaults();
    }

    public String getButtonDisplayString(VrOptions par1EnumOptions) {
        return this.getButtonDisplayString(par1EnumOptions, false);
    }

    public String getButtonDisplayString(VrOptions par1EnumOptions, boolean valueOnly) {
        String var2 = class_1074.method_4662((String)("vivecraft.options." + par1EnumOptions.name()), (Object[])new Object[0]);
        String var3 = var2 + ": ";
        Object var4 = var3;
        if (valueOnly) {
            var4 = "";
        }
        try {
            String str;
            ConfigEntry mapping = this.fieldEnumMap.get((Object)par1EnumOptions);
            if (mapping == null) {
                return var2;
            }
            Field field = mapping.field;
            Class<?> type = field.getType();
            Object obj = field.get(this);
            if (this.overrides.hasSetting(par1EnumOptions)) {
                obj = this.overrides.getSetting(par1EnumOptions).getValue();
            }
            if ((str = par1EnumOptions.getDisplayString((String)var4, obj)) != null) {
                return str;
            }
            if (type == Boolean.TYPE) {
                Pair<String, String> langKeys = par1EnumOptions.getBooleanLangKeys();
                return (Boolean)obj != false ? (String)var4 + class_1074.method_4662((String)((String)langKeys.getLeft()), (Object[])new Object[0]) : (String)var4 + class_1074.method_4662((String)((String)langKeys.getRight()), (Object[])new Object[0]);
            }
            if (type == Float.TYPE || type == Double.TYPE) {
                if (par1EnumOptions.getDecimalPlaces() < 0) {
                    return (String)var4 + Math.round(((Number)obj).floatValue() * 100.0f) + "%";
                }
                return (String)var4 + String.format("%." + par1EnumOptions.getDecimalPlaces() + "f", Float.valueOf(((Number)obj).floatValue()));
            }
            if (OptionEnum.class.isAssignableFrom(type)) {
                return (String)var4 + class_1074.method_4662((String)((OptionEnum)obj).getLangKey(), (Object[])new Object[0]);
            }
            return (String)var4 + obj.toString();
        }
        catch (Exception ex) {
            System.out.println("Failed to get VR option display string: " + par1EnumOptions);
            ex.printStackTrace();
            return var2;
        }
    }

    public float getOptionFloatValue(VrOptions par1EnumOptions) {
        try {
            ConfigEntry mapping = this.fieldEnumMap.get((Object)par1EnumOptions);
            if (mapping == null) {
                return 0.0f;
            }
            Field field = mapping.field;
            float value = ((Number)field.get(this)).floatValue();
            if (this.overrides.hasSetting(par1EnumOptions)) {
                value = this.overrides.getSetting(par1EnumOptions).getFloat();
            }
            return Objects.requireNonNullElse(par1EnumOptions.getOptionFloatValue(value), Float.valueOf(value)).floatValue();
        }
        catch (Exception ex) {
            System.out.println("Failed to get VR option float value: " + par1EnumOptions);
            ex.printStackTrace();
            return 0.0f;
        }
    }

    public void setOptionValue(VrOptions par1EnumOptions) {
        try {
            ConfigEntry mapping = this.fieldEnumMap.get((Object)par1EnumOptions);
            if (mapping == null) {
                return;
            }
            Field field = mapping.field;
            Class<?> type = field.getType();
            Object obj = par1EnumOptions.setOptionValue(field.get(this));
            if (obj != null) {
                field.set(this, obj);
            } else if (type == Boolean.TYPE) {
                field.set(this, (Boolean)field.get(this) == false);
            } else if (OptionEnum.class.isAssignableFrom(type)) {
                field.set(this, ((OptionEnum)field.get(this)).getNext());
            } else {
                logger.warn("Don't know how to set VR option " + mapping.configName + " with type " + type.getSimpleName());
                return;
            }
            par1EnumOptions.onOptionChange();
            this.saveOptions();
        }
        catch (Exception ex) {
            System.out.println("Failed to set VR option: " + par1EnumOptions);
            ex.printStackTrace();
        }
    }

    public void setOptionFloatValue(VrOptions par1EnumOptions, float par2) {
        try {
            ConfigEntry mapping = this.fieldEnumMap.get((Object)par1EnumOptions);
            if (mapping == null) {
                return;
            }
            Field field = mapping.field;
            Class<?> type = field.getType();
            float f = Objects.requireNonNullElse(par1EnumOptions.setOptionFloatValue(par2), Float.valueOf(par2)).floatValue();
            if (this.overrides.hasSetting(par1EnumOptions)) {
                f = class_3532.method_15363((float)f, (float)this.overrides.getSetting(par1EnumOptions).getValueMin(), (float)this.overrides.getSetting(par1EnumOptions).getValueMax());
            }
            if (type == Integer.TYPE) {
                field.set(this, (int)f);
            } else if (type == Long.TYPE) {
                field.set(this, (long)f);
            } else {
                field.set(this, Float.valueOf(f));
            }
            par1EnumOptions.onOptionChange();
            this.saveOptions();
        }
        catch (Exception ex) {
            System.out.println("Failed to set VR option float value: " + par1EnumOptions);
            ex.printStackTrace();
        }
    }

    private float parseFloat(String par1Str) {
        return par1Str.equals("true") ? 1.0f : (par1Str.equals("false") ? 0.0f : Float.parseFloat(par1Str));
    }

    public float getHeadTrackSensitivity() {
        return 1.0f;
    }

    public static synchronized void initSettings(class_310 mc, File dataDir) {
        ProfileManager.init(dataDir);
        VRSettings vrSettings = new VRSettings(mc, dataDir);
        vrSettings.saveOptions();
        ClientDataHolderVR.getInstance().vrSettings = vrSettings;
    }

    public static synchronized void loadAll(class_310 mc) {
        mc.field_1690.method_1636();
        ClientDataHolderVR.getInstance().vrSettings.loadOptions();
    }

    public static synchronized void saveAll(class_310 mc) {
        mc.field_1690.method_1640();
        ClientDataHolderVR.getInstance().vrSettings.saveOptions();
    }

    public static synchronized void resetAll(class_310 mc) {
        ClientDataHolderVR.getInstance().vrSettings.resetSettings();
    }

    public static synchronized String getCurrentProfile() {
        return ProfileManager.getCurrentProfileName();
    }

    public static synchronized boolean profileExists(String profile) {
        return ProfileManager.profileExists(profile);
    }

    public static synchronized SortedSet<String> getProfileList() {
        return ProfileManager.getProfileList();
    }

    public static synchronized boolean setCurrentProfile(String profile) {
        StringBuilder error = new StringBuilder();
        return VRSettings.setCurrentProfile(profile, error);
    }

    public static synchronized boolean setCurrentProfile(String profile, StringBuilder error) {
        boolean result = true;
        class_310 mc = class_310.method_1551();
        VRSettings.saveAll(mc);
        result = ProfileManager.setCurrentProfile(profile, error);
        if (result) {
            VRSettings.loadAll(mc);
        }
        return result;
    }

    public static synchronized boolean createProfile(String profile, boolean useDefaults, StringBuilder error) {
        boolean result = true;
        class_310 mc = class_310.method_1551();
        String originalProfile = VRSettings.getCurrentProfile();
        VRSettings.saveAll(mc);
        if (!ProfileManager.createProfile(profile, error)) {
            return false;
        }
        ProfileManager.setCurrentProfile(profile, error);
        if (useDefaults) {
            VRSettings.resetAll(mc);
        }
        VRSettings.saveAll(mc);
        ProfileManager.setCurrentProfile(originalProfile, error);
        VRSettings.loadAll(mc);
        return result;
    }

    public static synchronized boolean deleteProfile(String profile) {
        StringBuilder error = new StringBuilder();
        return VRSettings.deleteProfile(profile, error);
    }

    public static synchronized boolean deleteProfile(String profile, StringBuilder error) {
        class_310 mc = class_310.method_1551();
        VRSettings.saveAll(mc);
        if (!ProfileManager.deleteProfile(profile, error)) {
            return false;
        }
        VRSettings.loadAll(mc);
        return true;
    }

    public static synchronized boolean duplicateProfile(String originalProfile, String newProfile, StringBuilder error) {
        class_310 mc = class_310.method_1551();
        VRSettings.saveAll(mc);
        return ProfileManager.duplicateProfile(originalProfile, newProfile, error);
    }

    public static synchronized boolean renameProfile(String originalProfile, String newProfile, StringBuilder error) {
        class_310 mc = class_310.method_1551();
        VRSettings.saveAll(mc);
        return ProfileManager.renameProfile(originalProfile, newProfile, error);
    }

    public String[] getQuickCommandsDefaults() {
        String[] out = new String[]{"/gamemode survival", "/gamemode creative", "/help", "/home", "/sethome", "/spawn", "hi!", "bye!", "follow me!", "take this!", "thank you!", "praise the sun!"};
        return out;
    }

    public String[] getRadialItemsDefault() {
        String[] out = new String[]{"key.drop", "key.chat", "vivecraft.key.rotateRight", "key.pickItem", "vivecraft.key.toggleHandheldCam", "vivecraft.key.togglePlayerList", "vivecraft.key.rotateLeft", "vivecraft.key.quickTorch"};
        return out;
    }

    public String[] getRadialItemsAltDefault() {
        String[] out = new String[]{"", "", "", "", "", "", "", ""};
        return out;
    }

    public int[] getKeyboardCodesDefault() {
        int[] out = new int[]{96, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 45, 61, 81, 87, 69, 82, 84, 89, 85, 73, 79, 80, 91, 93, 92, 65, 83, 68, 70, 71, 72, 74, 75, 76, 59, 39, -1, -1, 90, 88, 67, 86, 66, 78, 77, 44, 46, 47, -1, -1, -1};
        return out;
    }

    public double normalizeValue(float optionFloatValue) {
        return 0.0;
    }

    public static enum VRProvider implements OptionEnum<VRProvider>
    {
        OPENVR,
        NULLVR;

    }

    public static enum BowMode implements OptionEnum<BowMode>
    {
        OFF,
        VANILLA,
        ON;

    }

    public static enum RightClickDelay implements OptionEnum<RightClickDelay>
    {
        VANILLA,
        SLOW,
        SLOWER,
        SLOWEST;

    }

    public static enum InertiaFactor implements OptionEnum<InertiaFactor>
    {
        NONE(100.0f),
        NORMAL(1.0f),
        LARGE(0.25f),
        MASSIVE(0.0625f);

        private final float factor;

        private InertiaFactor(float factor) {
            this.factor = factor;
        }

        public float getFactor() {
            return this.factor;
        }
    }

    public static enum WeaponCollision implements OptionEnum<WeaponCollision>
    {
        OFF,
        ON,
        AUTO;

    }

    public static enum FreeMove implements OptionEnum<FreeMove>
    {
        CONTROLLER,
        HMD,
        RUN_IN_PLACE,
        ROOM,
        AUTO;

    }

    public static enum RealisticJump implements OptionEnum<RealisticJump>
    {
        OFF,
        ON,
        AUTO;

    }

    public static enum MirrorMode implements OptionEnum<MirrorMode>
    {
        OFF,
        CROPPED,
        SINGLE,
        DUAL,
        FIRST_PERSON,
        THIRD_PERSON,
        MIXED_REALITY,
        GUI;

    }

    public static enum MenuWorld implements OptionEnum<MenuWorld>
    {
        BOTH,
        CUSTOM,
        OFFICIAL,
        NONE;

    }

    public static enum HUDLock implements OptionEnum<HUDLock>
    {
        WRIST,
        HAND,
        HEAD;

    }

    public static enum RenderPointerElement implements OptionEnum<RenderPointerElement>
    {
        ALWAYS,
        WITH_HUD,
        NEVER;

    }

    public static enum ChatNotifications implements OptionEnum<ChatNotifications>
    {
        NONE,
        HAPTIC,
        SOUND,
        BOTH;

    }

    public static enum ShaderGUIRender implements OptionEnum<ShaderGUIRender>
    {
        BEFORE_TRANSLUCENT_SOLID,
        AFTER_TRANSLUCENT,
        AFTER_SHADER;

    }

    public static enum UpdateType implements OptionEnum<UpdateType>
    {
        RELEASE,
        BETA,
        ALPHA;

    }

    public static enum ChatServerPluginMessage implements OptionEnum<ChatServerPluginMessage>
    {
        ALWAYS,
        SERVER_ONLY,
        NEVER;

    }

    public class ServerOverrides {
        private final Map<VrOptions, Setting> optionMap = new EnumMap<VrOptions, Setting>(VrOptions.class);
        private final Map<String, Setting> networkNameMap = new HashMap<String, Setting>();

        private ServerOverrides() {
            this.registerSetting(VrOptions.LIMIT_TELEPORT, "limitedTeleport", () -> VRSettings.this.vrLimitedSurvivalTeleport);
            this.registerSetting(VrOptions.TELEPORT_UP_LIMIT, "teleportLimitUp", () -> VRSettings.this.vrTeleportUpLimit);
            this.registerSetting(VrOptions.TELEPORT_DOWN_LIMIT, "teleportLimitDown", () -> VRSettings.this.vrTeleportDownLimit);
            this.registerSetting(VrOptions.TELEPORT_HORIZ_LIMIT, "teleportLimitHoriz", () -> VRSettings.this.vrTeleportHorizLimit);
            this.registerSetting(VrOptions.WORLD_SCALE, "worldScale", () -> Float.valueOf(VRSettings.this.worldScale));
            this.registerSetting(VrOptions.THIRDPERSON_ITEMTRANSFORMS, "thirdPersonItems", () -> VRSettings.this.thirdPersonItems);
        }

        private void registerSetting(VrOptions option, String networkName, Supplier<Object> originalValue) {
            Setting setting = new Setting(option, networkName, originalValue);
            this.optionMap.put(option, setting);
            this.networkNameMap.put(networkName, setting);
        }

        public void resetAll() {
            for (Setting setting : this.optionMap.values()) {
                setting.valueSet = false;
                setting.valueMinSet = false;
                setting.valueMaxSet = false;
            }
        }

        public boolean hasSetting(VrOptions option) {
            return this.optionMap.containsKey((Object)option);
        }

        public boolean hasSetting(String networkName) {
            return this.networkNameMap.containsKey(networkName);
        }

        public Setting getSetting(VrOptions option) {
            Setting setting = this.optionMap.get((Object)option);
            if (setting == null) {
                throw new IllegalArgumentException("setting not registered: " + option);
            }
            return setting;
        }

        public Setting getSetting(String networkName) {
            Setting setting = this.networkNameMap.get(networkName);
            if (setting == null) {
                throw new IllegalArgumentException("setting not registered: " + networkName);
            }
            return setting;
        }

        public class Setting {
            private final VrOptions option;
            private final String networkName;
            private final Supplier<Object> originalValue;
            private boolean valueSet;
            private Object value;
            private boolean valueMinSet;
            private boolean valueMaxSet;
            private float valueMin;
            private float valueMax;

            public Setting(VrOptions option, String networkName, Supplier<Object> originalValue) {
                this.option = option;
                this.networkName = networkName;
                this.originalValue = originalValue;
            }

            private void checkFloat() {
                if (!this.option.enumFloat) {
                    throw new IllegalArgumentException("not a float option: " + this.option);
                }
            }

            public boolean isFloat() {
                return this.option.enumFloat;
            }

            public Object getOriginalValue() {
                return this.originalValue.get();
            }

            public boolean isValueOverridden() {
                return this.valueSet;
            }

            public Object getValue() {
                Object val = this.valueSet ? this.value : this.originalValue.get();
                if (val instanceof Integer) {
                    val = class_3532.method_15340((int)((Number)val).intValue(), (int)((int)this.getValueMin()), (int)((int)this.getValueMax()));
                } else if (val instanceof Float) {
                    val = Float.valueOf(class_3532.method_15363((float)((Number)val).floatValue(), (float)this.getValueMin(), (float)this.getValueMax()));
                }
                return val;
            }

            public boolean getBoolean() {
                Object val = this.getValue();
                return val instanceof Boolean && (Boolean)val != false;
            }

            public int getInt() {
                Object val = this.getValue();
                return val instanceof Number ? ((Number)val).intValue() : 0;
            }

            public float getFloat() {
                Object val = this.getValue();
                return val instanceof Number ? ((Number)val).floatValue() : 0.0f;
            }

            public String getString() {
                Object val = this.getValue();
                return val instanceof String ? val.toString() : "";
            }

            public void setValue(Object value) {
                this.value = value;
                this.valueSet = true;
            }

            public void resetValue() {
                this.valueSet = false;
            }

            public boolean isValueMinOverridden() {
                this.checkFloat();
                return this.valueMinSet;
            }

            public float getValueMin() {
                this.checkFloat();
                if (this.valueMinSet) {
                    return this.valueMin;
                }
                return Float.MIN_VALUE;
            }

            public void setValueMin(float valueMin) {
                this.checkFloat();
                this.valueMin = valueMin;
                this.valueMinSet = true;
            }

            public void resetValueMin() {
                this.checkFloat();
                this.valueMinSet = false;
            }

            public boolean isValueMaxOverridden() {
                this.checkFloat();
                return this.valueMaxSet;
            }

            public float getValueMax() {
                this.checkFloat();
                if (this.valueMaxSet) {
                    return this.valueMax;
                }
                return Float.MAX_VALUE;
            }

            public void setValueMax(float valueMax) {
                this.checkFloat();
                this.valueMax = valueMax;
                this.valueMaxSet = true;
            }

            public void resetValueMax() {
                this.checkFloat();
                this.valueMaxSet = false;
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum VrOptions {
        DUMMY(false, true),
        VR_PLUGIN(false, true),
        VR_ENABLED(false, true){

            @Override
            void onOptionChange() {
                VRState.vrEnabled = ClientDataHolderVR.getInstance().vrSettings.vrEnabled;
            }
        }
        ,
        VR_REMEMBER_ENABLED(false, true),
        HUD_SCALE(true, false, 0.35f, 2.5f, 0.01f, -1),
        HUD_DISTANCE(true, false, 0.25f, 5.0f, 0.01f, 2){

            @Override
            String getDisplayString(String prefix, Object value) {
                return prefix + String.format("%.2f", Float.valueOf(((Float)value).floatValue())) + "m";
            }
        }
        ,
        HUD_LOCK_TO(false, true){

            @Override
            Object convertOption(String value) {
                try {
                    int ord = Integer.parseInt(value);
                    return HUDLock.values()[3 - ord];
                }
                catch (NumberFormatException ex) {
                    return null;
                }
            }
        }
        ,
        HUD_OPACITY(true, false, 0.15f, 1.0f, 0.05f, -1){

            @Override
            String getDisplayString(String prefix, Object value) {
                if ((double)((Float)value).floatValue() > 0.99) {
                    return prefix + class_1074.method_4662((String)"vivecraft.options.opaque", (Object[])new Object[0]);
                }
                return null;
            }
        }
        ,
        HUD_HIDE(false, true){

            @Override
            Object loadOption(String value) {
                class_310.method_1551().field_1690.field_1842 = value.equals("true");
                return false;
            }

            @Override
            String saveOption(Object value) {
                return Boolean.toString(class_310.method_1551().field_1690.field_1842);
            }

            @Override
            String getDisplayString(String prefix, Object value) {
                return class_310.method_1551().field_1690.field_1842 ? prefix + LangHelper.getYes() : prefix + LangHelper.getNo();
            }

            @Override
            Object setOptionValue(Object value) {
                class_310.method_1551().field_1690.field_1842 = !class_310.method_1551().field_1690.field_1842;
                return false;
            }
        }
        ,
        RENDER_MENU_BACKGROUND(false, true),
        HUD_OCCLUSION(false, true),
        MENU_ALWAYS_FOLLOW_FACE(false, true, "vivecraft.options.always", "vivecraft.options.seated"),
        CROSSHAIR_OCCLUSION(false, true),
        CROSSHAIR_SCALE(true, false, 0.25f, 1.0f, 0.01f, -1),
        MENU_CROSSHAIR_SCALE(true, false, 0.25f, 2.5f, 0.05f, -1),
        RENDER_CROSSHAIR_MODE(false, true){

            @Override
            Object convertOption(String value) {
                try {
                    int ord = Integer.parseInt(value);
                    return RenderPointerElement.values()[ord];
                }
                catch (NumberFormatException ex) {
                    return null;
                }
            }
        }
        ,
        CHAT_NOTIFICATIONS(false, true){

            @Override
            Object convertOption(String value) {
                try {
                    int ord = Integer.parseInt(value);
                    return ChatNotifications.values()[ord];
                }
                catch (NumberFormatException ex) {
                    return null;
                }
            }
        }
        ,
        CHAT_NOTIFICATION_SOUND(false, true){

            @Override
            String getDisplayString(String prefix, Object value) {
                try {
                    class_3414 se = (class_3414)class_7923.field_41172.method_10223(new class_2960((String)value));
                    return class_1074.method_4662((String)se.method_14833().method_12832(), (Object[])new Object[0]);
                }
                catch (Exception e) {
                    return "error";
                }
            }

            @Override
            Object setOptionValue(Object value) {
                class_3414 se = (class_3414)class_7923.field_41172.method_10223(new class_2960((String)value));
                int i = class_7923.field_41172.method_10206((Object)se);
                if (++i >= class_7923.field_41172.method_10235().size()) {
                    i = 0;
                }
                return ((class_3414)class_7923.field_41172.method_10200(i)).method_14833().method_12832();
            }
        }
        ,
        CROSSHAIR_SCALES_WITH_DISTANCE(false, true),
        RENDER_BLOCK_OUTLINE_MODE(false, true){

            @Override
            Object convertOption(String value) {
                try {
                    int ord = Integer.parseInt(value);
                    return RenderPointerElement.values()[ord];
                }
                catch (NumberFormatException ex) {
                    return null;
                }
            }
        }
        ,
        SHOW_UPDATES(false, true, "vivecraft.options.always", "vivecraft.options.once"),
        UPDATE_TYPE(false, true),
        SHOW_PLUGIN(false, true),
        SHOW_PLUGIN_MISSING(false, true, "vivecraft.options.always", "vivecraft.options.once"),
        CHAT_MESSAGE_STENCIL(false, true),
        AUTO_OPEN_KEYBOARD(false, true),
        AUTO_CLOSE_KEYBOARD(false, true),
        RADIAL_MODE_HOLD(false, true, "vivecraft.options.hold", "vivecraft.options.press"),
        PHYSICAL_KEYBOARD(false, true, "vivecraft.options.keyboard.physical", "vivecraft.options.keyboard.pointer"),
        PHYSICAL_KEYBOARD_SCALE(true, false, 0.75f, 1.5f, 0.01f, -1){

            @Override
            void onOptionChange() {
                KeyboardHandler.physicalKeyboard.setScale(ClientDataHolderVR.getInstance().vrSettings.physicalKeyboardScale);
            }
        }
        ,
        PHYSICAL_KEYBOARD_THEME(false, false),
        KEYBOARD_PRESS_BINDS(false, true),
        GUI_APPEAR_OVER_BLOCK(false, true),
        SHADER_GUI_RENDER(false, false),
        DOUBLE_GUI_RESOLUTION(false, true),
        GUI_SCALE(true, true, 0.0f, 6.0f, 1.0f, 0){

            @Override
            String getDisplayString(String prefix, Object value) {
                if ((Integer)value == 0) {
                    return prefix + class_1074.method_4662((String)"options.guiScale.auto", (Object[])new Object[0]);
                }
                if (ClientDataHolderVR.getInstance().vrSettings.doubleGUIResolution) {
                    return prefix + value;
                }
                return prefix + (int)Math.ceil((float)((Integer)value).intValue() * 0.5f);
            }

            @Override
            void onOptionChange() {
                if (VRState.vrEnabled) {
                    ClientDataHolderVR.getInstance().vrRenderer.resizeFrameBuffers("");
                }
            }
        }
        ,
        HUD_MAX_GUI_SCALE(false, true),
        VR_TOGGLE_BUTTON_VISIBLE(false, true),
        VR_SETTINGS_BUTTON_VISIBLE(false, true),
        VR_SETTINGS_BUTTON_POSITION(false, true, "vivecraft.options.left", "vivecraft.options.right"),
        FSAA(false, true),
        LOW_HEALTH_INDICATOR(false, true),
        MIRROR_DISPLAY(false, true){

            @Override
            Object convertOption(String value) {
                try {
                    int ord = Integer.parseInt(value);
                    return switch (ord) {
                        case 10 -> MirrorMode.OFF;
                        case 11 -> MirrorMode.DUAL;
                        case 12 -> MirrorMode.SINGLE;
                        case 16 -> MirrorMode.CROPPED;
                        default -> MirrorMode.values()[ord - 9];
                    };
                }
                catch (NumberFormatException ex) {
                    return null;
                }
            }

            @Override
            void onOptionChange() {
                if (VRState.vrRunning && !ShadersHelper.isShaderActive()) {
                    ClientDataHolderVR.getInstance().vrRenderer.reinitFrameBuffers("Mirror Setting Changed");
                }
            }
        }
        ,
        MIRROR_CROP(true, false, 0.0f, 0.25f, 0.01f, -1),
        MIRROR_EYE(false, true, "vivecraft.options.left", "vivecraft.options.right"),
        MIRROR_CENTER_SMOOTH(true, false, 0.0f, 1.0f, 0.1f, 1){

            @Override
            String getDisplayString(String prefix, Object value) {
                if (((Float)value).floatValue() == 0.0f) {
                    return prefix + class_1074.method_4662((String)"options.off", (Object[])new Object[0]);
                }
                return prefix + String.format("%.1f", Float.valueOf(((Float)value).floatValue())) + "s";
            }
        }
        ,
        MIXED_REALITY_KEY_COLOR(false, false){
            private static final List<Pair<Color, String>> colors = new ArrayList<Pair<Color, String>>();

            @Override
            String getDisplayString(String prefix, Object value) {
                Color color = (Color)value;
                Pair p = colors.stream().filter(c -> ((Color)c.getLeft()).equals(color)).findFirst().orElse(null);
                return p != null ? prefix + class_1074.method_4662((String)((String)p.getRight()), (Object[])new Object[0]) : prefix + color.getRed() + " " + color.getGreen() + " " + color.getBlue();
            }

            @Override
            Object loadOption(String value) {
                String[] split = value.split(",");
                return new Color(Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]));
            }

            @Override
            String saveOption(Object value) {
                Color color = (Color)value;
                return color.getRed() + "," + color.getGreen() + "," + color.getBlue();
            }

            @Override
            Object setOptionValue(Object value) {
                int index = IntStream.range(0, colors.size()).filter(i -> ((Color)colors.get(i).getLeft()).equals(value)).findFirst().orElse(-1);
                return index == -1 || index == colors.size() - 1 ? colors.get(0).getLeft() : colors.get(index + 1).getLeft();
            }

            static {
                colors.add((Pair<Color, String>)Pair.of((Object)new Color(0, 0, 0), (Object)"vivecraft.options.color.black"));
                colors.add((Pair<Color, String>)Pair.of((Object)new Color(255, 0, 0), (Object)"vivecraft.options.color.red"));
                colors.add((Pair<Color, String>)Pair.of((Object)new Color(255, 255, 0), (Object)"vivecraft.options.color.yellow"));
                colors.add((Pair<Color, String>)Pair.of((Object)new Color(0, 255, 0), (Object)"vivecraft.options.color.green"));
                colors.add((Pair<Color, String>)Pair.of((Object)new Color(0, 255, 255), (Object)"vivecraft.options.color.cyan"));
                colors.add((Pair<Color, String>)Pair.of((Object)new Color(0, 0, 255), (Object)"vivecraft.options.color.blue"));
                colors.add((Pair<Color, String>)Pair.of((Object)new Color(255, 0, 255), (Object)"vivecraft.options.color.magenta"));
            }
        }
        ,
        MIXED_REALITY_RENDER_HANDS(false, true),
        MIXED_REALITY_UNITY_LIKE(false, true, "vivecraft.options.unity", "vivecraft.options.sidebyside"){

            @Override
            void onOptionChange() {
                ClientDataHolderVR.getInstance().vrRenderer.reinitFrameBuffers("MR Setting Changed");
            }
        }
        ,
        MIXED_REALITY_UNDISTORTED(false, true){

            @Override
            void onOptionChange() {
                ClientDataHolderVR.getInstance().vrRenderer.reinitFrameBuffers("MR Setting Changed");
            }
        }
        ,
        MIXED_REALITY_ALPHA_MASK(false, true),
        MIXED_REALITY_FOV(true, false, 0.0f, 179.0f, 1.0f, 0){

            @Override
            String getDisplayString(String prefix, Object value) {
                return prefix + String.format("%.0f\u00b0", Float.valueOf(((Float)value).floatValue()));
            }
        }
        ,
        WALK_UP_BLOCKS(false, true),
        MOVEMENT_MULTIPLIER(true, false, 0.15f, 1.3f, 0.01f, 2),
        INERTIA_FACTOR(false, true){

            @Override
            Object convertOption(String value) {
                try {
                    int ord = Integer.parseInt(value);
                    return InertiaFactor.values()[ord];
                }
                catch (NumberFormatException ex) {
                    return null;
                }
            }
        }
        ,
        SIMULATE_FALLING(false, true),
        WEAPON_COLLISION(false, true){

            @Override
            Object convertOption(String value) {
                try {
                    int ord = Integer.parseInt(value);
                    return WeaponCollision.values()[ord];
                }
                catch (NumberFormatException ex) {
                    return null;
                }
            }
        }
        ,
        ALLOW_CRAWLING(false, true),
        LIMIT_TELEPORT(false, true),
        REVERSE_HANDS(false, true),
        STENCIL_ON(false, true),
        BCB_ON(false, true),
        WORLD_SCALE(true, false, 0.0f, 29.0f, 1.0f, 2){

            @Override
            String getDisplayString(String prefix, Object value) {
                return prefix + String.format("%.2f", Float.valueOf(((Float)value).floatValue())) + "x";
            }

            @Override
            Float getOptionFloatValue(float value) {
                if (value == 0.1f) {
                    return Float.valueOf(0.0f);
                }
                if (value == 0.25f) {
                    return Float.valueOf(1.0f);
                }
                if (value >= 0.5f && value <= 2.0f) {
                    return Float.valueOf(value / 0.1f - 3.0f);
                }
                if (value == 3.0f) {
                    return Float.valueOf(18.0f);
                }
                if (value == 4.0f) {
                    return Float.valueOf(19.0f);
                }
                if (value == 6.0f) {
                    return Float.valueOf(20.0f);
                }
                if (value == 8.0f) {
                    return Float.valueOf(21.0f);
                }
                if (value == 10.0f) {
                    return Float.valueOf(22.0f);
                }
                if (value == 12.0f) {
                    return Float.valueOf(23.0f);
                }
                if (value == 16.0f) {
                    return Float.valueOf(24.0f);
                }
                if (value == 20.0f) {
                    return Float.valueOf(25.0f);
                }
                if (value == 30.0f) {
                    return Float.valueOf(26.0f);
                }
                if (value == 50.0f) {
                    return Float.valueOf(27.0f);
                }
                if (value == 75.0f) {
                    return Float.valueOf(28.0f);
                }
                if (value == 100.0f) {
                    return Float.valueOf(29.0f);
                }
                return Float.valueOf(7.0f);
            }

            @Override
            Float setOptionFloatValue(float value) {
                if (value == 0.0f) {
                    return Float.valueOf(0.1f);
                }
                if (value == 1.0f) {
                    return Float.valueOf(0.25f);
                }
                if (value >= 2.0f && value <= 17.0f) {
                    return Float.valueOf(value * 0.1f + 0.3f);
                }
                if (value == 18.0f) {
                    return Float.valueOf(3.0f);
                }
                if (value == 19.0f) {
                    return Float.valueOf(4.0f);
                }
                if (value == 20.0f) {
                    return Float.valueOf(6.0f);
                }
                if (value == 21.0f) {
                    return Float.valueOf(8.0f);
                }
                if (value == 22.0f) {
                    return Float.valueOf(10.0f);
                }
                if (value == 23.0f) {
                    return Float.valueOf(12.0f);
                }
                if (value == 24.0f) {
                    return Float.valueOf(16.0f);
                }
                if (value == 25.0f) {
                    return Float.valueOf(20.0f);
                }
                if (value == 26.0f) {
                    return Float.valueOf(30.0f);
                }
                if (value == 27.0f) {
                    return Float.valueOf(50.0f);
                }
                if (value == 28.0f) {
                    return Float.valueOf(75.0f);
                }
                if (value == 29.0f) {
                    return Float.valueOf(100.0f);
                }
                return Float.valueOf(1.0f);
            }

            @Override
            void onOptionChange() {
                if (VRState.vrRunning) {
                    ClientDataHolderVR.getInstance().vrPlayer.roomScaleMovementDelay = 2;
                    ClientDataHolderVR.getInstance().vrPlayer.snapRoomOriginToPlayerEntity(class_310.method_1551().field_1724, false, true);
                    VRPlayer.get().preTick();
                }
            }
        }
        ,
        WORLD_ROTATION(true, false, 0.0f, 360.0f, 30.0f, 0){

            @Override
            String getDisplayString(String prefix, Object value) {
                return prefix + String.format("%.0f\u00b0", Float.valueOf(((Float)value).floatValue()));
            }

            @Override
            Float setOptionFloatValue(float value) {
                return null;
            }
        }
        ,
        WORLD_ROTATION_INCREMENT(true, false, -1.0f, 4.0f, 1.0f, 0){

            @Override
            String getDisplayString(String prefix, Object value) {
                if (((Float)value).floatValue() == 0.0f) {
                    return prefix + class_1074.method_4662((String)"vivecraft.options.smooth", (Object[])new Object[0]);
                }
                return prefix + String.format("%.0f\u00b0", Float.valueOf(((Float)value).floatValue()));
            }

            @Override
            Float getOptionFloatValue(float value) {
                if (value == 0.0f) {
                    return Float.valueOf(-1.0f);
                }
                if (value == 10.0f) {
                    return Float.valueOf(0.0f);
                }
                if (value == 36.0f) {
                    return Float.valueOf(1.0f);
                }
                if (value == 45.0f) {
                    return Float.valueOf(2.0f);
                }
                if (value == 90.0f) {
                    return Float.valueOf(3.0f);
                }
                if (value == 180.0f) {
                    return Float.valueOf(4.0f);
                }
                return Float.valueOf(2.0f);
            }

            @Override
            Float setOptionFloatValue(float value) {
                if (value == -1.0f) {
                    return Float.valueOf(0.0f);
                }
                if (value == 0.0f) {
                    return Float.valueOf(10.0f);
                }
                if (value == 1.0f) {
                    return Float.valueOf(36.0f);
                }
                if (value == 2.0f) {
                    return Float.valueOf(45.0f);
                }
                if (value == 3.0f) {
                    return Float.valueOf(90.0f);
                }
                if (value == 4.0f) {
                    return Float.valueOf(180.0f);
                }
                return Float.valueOf(45.0f);
            }

            @Override
            void onOptionChange() {
                ClientDataHolderVR.getInstance().vrSettings.worldRotation = 0.0f;
            }
        }
        ,
        TOUCH_HOTBAR(false, true),
        PLAY_MODE_SEATED(false, true, "vivecraft.options.seated", "vivecraft.options.standing"),
        VR_HOTSWITCH(false, true),
        RENDER_SCALEFACTOR(true, false, 0.1f, 9.0f, 0.1f, 0){

            @Override
            String getDisplayString(String prefix, Object value) {
                if (VRState.vrEnabled) {
                    class_276 eye0 = ClientDataHolderVR.getInstance().vrRenderer.framebufferEye0;
                    return prefix + Math.round(((Float)value).floatValue() * 100.0f) + "% (" + (int)Math.ceil((double)eye0.field_1480 * Math.sqrt(((Float)value).floatValue())) + "x" + (int)Math.ceil((double)eye0.field_1477 * Math.sqrt(((Float)value).floatValue())) + ")";
                }
                return prefix + Math.round(((Float)value).floatValue() * 100.0f) + "%";
            }
        }
        ,
        MONO_FOV(true, false, 30.0f, 110.0f, 1.0f, 0){

            @Override
            String getDisplayString(String prefix, Object value) {
                return prefix + String.format("%.0f\u00b0", Float.valueOf(((Integer)class_310.method_1551().field_1690.method_41808().method_41753()).intValue()));
            }

            @Override
            Float getOptionFloatValue(float value) {
                return Float.valueOf(((Integer)class_310.method_1551().field_1690.method_41808().method_41753()).intValue());
            }

            @Override
            Float setOptionFloatValue(float value) {
                class_310.method_1551().field_1690.method_41808().method_41748((Object)((int)value));
                return Float.valueOf(0.0f);
            }
        }
        ,
        HANDHELD_CAMERA_FOV(true, false, 1.0f, 179.0f, 1.0f, 0){

            @Override
            String getDisplayString(String prefix, Object value) {
                return prefix + String.format("%.0f\u00b0", Float.valueOf(((Float)value).floatValue()));
            }
        }
        ,
        HANDHELD_CAMERA_RENDER_SCALE(true, false, 0.5f, 3.0f, 0.25f, 0){

            @Override
            String getDisplayString(String prefix, Object value) {
                return prefix + Math.round(1920.0f * ((Float)value).floatValue()) + "x" + Math.round(1080.0f * ((Float)value).floatValue());
            }
        }
        ,
        MIXED_REALITY_RENDER_CAMERA_MODEL(false, true, "vivecraft.options.yes", "vivecraft.options.no"),
        REALISTIC_JUMP(false, true),
        REALISTIC_SNEAK(false, true),
        PHYSICAL_GUI(false, true){

            @Override
            Object loadOption(String value) {
                return false;
            }
        }
        ,
        REALISTIC_CLIMB(false, true),
        REALISTIC_SWIM(false, true),
        REALISTIC_ROW(false, true),
        REALISTIC_DISMOUNT(false, true),
        WALK_MULTIPLIER(true, false, 1.0f, 10.0f, 0.1f, 1),
        FREEMOVE_MODE(false, true){

            @Override
            Object convertOption(String value) {
                try {
                    int ord = Integer.parseInt(value);
                    return switch (ord) {
                        case 4 -> FreeMove.CONTROLLER;
                        case 5 -> FreeMove.ROOM;
                        default -> FreeMove.values()[ord - 1];
                    };
                }
                catch (NumberFormatException ex) {
                    return null;
                }
            }

            @Override
            Object setOptionValue(Object value) {
                if (value == FreeMove.ROOM) {
                    return FreeMove.CONTROLLER;
                }
                return null;
            }
        }
        ,
        FREEMOVE_FLY_MODE(false, true){

            @Override
            Object setOptionValue(Object value) {
                if (value == FreeMove.CONTROLLER) {
                    return FreeMove.HMD;
                }
                if (value == FreeMove.AUTO) {
                    return FreeMove.CONTROLLER;
                }
                return FreeMove.AUTO;
            }
        }
        ,
        VEHICLE_ROTATION(false, true),
        RESET_ORIGIN(false, true),
        X_SENSITIVITY(true, false, 0.1f, 5.0f, 0.01f, 2),
        Y_SENSITIVITY(true, false, 0.1f, 5.0f, 0.01f, 2),
        KEYHOLE(true, false, 0.0f, 40.0f, 5.0f, 0){

            @Override
            String getDisplayString(String prefix, Object value) {
                return prefix + String.format("%.0f\u00b0", Float.valueOf(((Float)value).floatValue()));
            }
        }
        ,
        FOV_REDUCTION(false, true),
        FOV_REDUCTION_MIN(true, false, 0.1f, 0.7f, 0.05f, 2),
        FOV_REDUCTION_OFFSET(true, false, 0.0f, 0.3f, 0.01f, 2),
        SEATED_HMD(false, true, "vivecraft.options.hmd", "vivecraft.options.crosshair"),
        SEATED_HUD_XHAIR(false, true, "vivecraft.options.crosshair", "vivecraft.options.hmd"),
        BACKPACK_SWITCH(false, true),
        ANALOG_MOVEMENT(false, true),
        AUTO_SPRINT(false, true),
        AUTO_SPRINT_THRESHOLD(true, false, 0.5f, 1.0f, 0.01f, 2),
        THIRDPERSON_ITEMTRANSFORMS(false, true),
        BOW_MODE(false, true){

            @Override
            Object convertOption(String value) {
                try {
                    int ord = Integer.parseInt(value);
                    return BowMode.values()[ord];
                }
                catch (NumberFormatException ex) {
                    return null;
                }
            }
        }
        ,
        TELEPORT_DOWN_LIMIT(true, false, 0.0f, 16.0f, 1.0f, 0){

            @Override
            String getDisplayString(String prefix, Object value) {
                return (Integer)value > 0 ? prefix + LangHelper.get("vivecraft.options.teleportlimit", value) : prefix + "OFF";
            }
        }
        ,
        TELEPORT_UP_LIMIT(true, false, 0.0f, 4.0f, 1.0f, 0){

            @Override
            String getDisplayString(String prefix, Object value) {
                return (Integer)value > 0 ? prefix + LangHelper.get("vivecraft.options.teleportlimit", value) : prefix + "OFF";
            }
        }
        ,
        TELEPORT_HORIZ_LIMIT(true, false, 0.0f, 32.0f, 1.0f, 0){

            @Override
            String getDisplayString(String prefix, Object value) {
                return (Integer)value > 0 ? prefix + LangHelper.get("vivecraft.options.teleportlimit", value) : prefix + "OFF";
            }
        }
        ,
        ALLOW_STANDING_ORIGIN_OFFSET(false, true, "vivecraft.options.yes", "vivecraft.options.no"),
        SEATED_FREE_MOVE(false, true, "vivecraft.options.freemove", "vivecraft.options.teleport"),
        FORCE_STANDING_FREE_MOVE(false, true, "vivecraft.options.yes", "vivecraft.options.no"),
        ALLOW_ADVANCED_BINDINGS(false, true, "vivecraft.options.yes", "vivecraft.options.no"),
        MENU_WORLD_SELECTION(false, false){

            @Override
            Object convertOption(String value) {
                try {
                    int ord = Integer.parseInt(value);
                    return MenuWorld.values()[ord];
                }
                catch (NumberFormatException ex) {
                    return null;
                }
            }
        }
        ,
        MENU_WORLD_FALLBACK(false, true, "vivecraft.options.menuworldfallback.panorama", "vivecraft.options.menuworldfallback.dirtbox"),
        HRTF_SELECTION(false, false){

            @Override
            Object setOptionValue(Object value) {
                return value;
            }
        }
        ,
        RELOAD_EXTERNAL_CAMERA(false, false){

            @Override
            String getDisplayString(String prefix, Object value) {
                return class_1074.method_4662((String)("vivecraft.options." + this.name()), (Object[])new Object[0]);
            }
        }
        ,
        INGAME_BINDINGS_IN_GUI(false, true),
        RIGHT_CLICK_DELAY(false, false);

        private final boolean enumFloat;
        private final boolean enumBoolean;
        private final float valueStep;
        private final float valueMin;
        private final float valueMax;
        private final int decimalPlaces;
        private final Pair<String, String> booleanLangKeys;

        public static VrOptions getEnumOptions(int par0) {
            for (VrOptions options : VrOptions.values()) {
                if (options.returnEnumOrdinal() != par0) continue;
                return options;
            }
            return null;
        }

        private VrOptions(boolean isfloat, boolean isbool) {
            this(isfloat, isbool, 0.0f, 1.0f, 0.0f, 0);
        }

        private VrOptions(boolean isfloat, boolean isbool, String trueLangKey, String falseKangKey) {
            this(isfloat, isbool, 0.0f, 1.0f, 0.0f, 0, trueLangKey, falseKangKey);
        }

        private VrOptions(boolean isfloat, boolean isbool, float min, float max, float step, int decimalPlaces) {
            this(isfloat, isbool, min, max, step, decimalPlaces, "options.on", "options.off");
        }

        private VrOptions(boolean isfloat, boolean isboolean, float min, float max, float step, int decimalPlaces, String trueLangKey, String falseKangKey) {
            this.enumFloat = isfloat;
            this.enumBoolean = isboolean;
            this.valueMin = min;
            this.valueMax = max;
            this.valueStep = step;
            this.decimalPlaces = decimalPlaces;
            this.booleanLangKeys = Pair.of((Object)trueLangKey, (Object)falseKangKey);
        }

        Object convertOption(String value) {
            return null;
        }

        Object loadOption(String value) {
            return null;
        }

        String saveOption(Object value) {
            return null;
        }

        String getDisplayString(String prefix, Object value) {
            return null;
        }

        Object setOptionValue(Object value) {
            return null;
        }

        Float getOptionFloatValue(float value) {
            return null;
        }

        Float setOptionFloatValue(float value) {
            return null;
        }

        void onOptionChange() {
        }

        public boolean getEnumFloat() {
            return this.enumFloat;
        }

        public boolean getEnumBoolean() {
            return this.enumBoolean;
        }

        public int returnEnumOrdinal() {
            return this.ordinal();
        }

        public float getValueMax() {
            return this.valueMax;
        }

        public float getValueMin() {
            return this.valueMin;
        }

        public int getDecimalPlaces() {
            return this.decimalPlaces;
        }

        public Pair<String, String> getBooleanLangKeys() {
            return this.booleanLangKeys;
        }

        protected float snapToStep(float p_148264_1_) {
            if (this.valueStep > 0.0f) {
                p_148264_1_ = this.valueStep * (float)Math.round(p_148264_1_ / this.valueStep);
            }
            return p_148264_1_;
        }

        public double normalizeValue(float value) {
            return class_3532.method_15350((double)((this.snapToStep(value) - this.valueMin) / (this.valueMax - this.valueMin)), (double)0.0, (double)1.0);
        }

        public double denormalizeValue(float value) {
            return this.snapToStep((float)((double)this.valueMin + (double)(this.valueMax - this.valueMin) * class_3532.method_15350((double)value, (double)0.0, (double)1.0)));
        }
    }

    record ConfigEntry(Field field, VrOptions vrOptions, String configName, boolean separate, boolean fixedSize) {
    }
}

