/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.settings;

import java.lang.reflect.Method;

public interface OptionEnum<T extends Enum<T>> {
    default public String getLangKey() {
        switch (this.name().toLowerCase()) {
            case "yes": {
                return "vivecraft.options.yes";
            }
            case "no": {
                return "vivecraft.options.no";
            }
            case "on": {
                return "options.on";
            }
            case "off": {
                return "options.off";
            }
        }
        Class<?> cls = this.getClass();
        return "vivecraft.options." + (cls.isAnonymousClass() ? cls.getSuperclass() : cls).getSimpleName().toLowerCase() + "." + this.name().toLowerCase().replace("_", "");
    }

    default public T getNext() {
        if (this.ordinal() == this.getValues().length - 1) {
            return (T)this.getValues()[0];
        }
        return (T)this.getValues()[this.ordinal() + 1];
    }

    default public T getPrevious() {
        if (this.ordinal() == 0) {
            return (T)this.getValues()[this.getValues().length - 1];
        }
        return (T)this.getValues()[this.ordinal() - 1];
    }

    public String name();

    public int ordinal();

    default public T[] getValues() {
        try {
            Method m = this.getClass().getMethod("values", new Class[0]);
            return (Enum[])m.invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
    }
}

