/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.provider;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_276;
import net.minecraft.class_285;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_2874;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_4494;
import net.minecraft.class_5244;
import net.minecraft.class_5321;
import net.minecraft.class_5365;
import net.minecraft.class_7134;
import net.minecraft.class_757;
import net.minecraft.class_8251;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;
import org.lwjgl.system.MemoryUtil;
import org.vivecraft.client.extensions.RenderTargetExtension;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRTextureTarget;
import org.vivecraft.client_vr.extensions.GameRendererExtension;
import org.vivecraft.client_vr.extensions.WindowExtension;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.gameplay.screenhandlers.KeyboardHandler;
import org.vivecraft.client_vr.gameplay.screenhandlers.RadialHandler;
import org.vivecraft.client_vr.gameplay.trackers.TelescopeTracker;
import org.vivecraft.client_vr.provider.MCVR;
import org.vivecraft.client_vr.render.RenderConfigException;
import org.vivecraft.client_vr.render.RenderPass;
import org.vivecraft.client_vr.render.ShaderHelper;
import org.vivecraft.client_vr.render.VRShaders;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.client_xr.render_pass.WorldRenderPass;
import org.vivecraft.mod_compat_vr.ShadersHelper;
import org.vivecraft.mod_compat_vr.resolutioncontrol.ResolutionControlHelper;
import oshi.SystemInfo;
import oshi.hardware.GraphicsCard;

public abstract class VRRenderer {
    public static final String RENDER_SETUP_FAILURE_MESSAGE = "Failed to initialise stereo rendering plugin: ";
    public class_276 cameraFramebuffer;
    public class_276 cameraRenderFramebuffer;
    protected int dispLastWidth;
    protected int dispLastHeight;
    public Matrix4f[] eyeproj = new Matrix4f[2];
    public class_276 framebufferEye0;
    public class_276 framebufferEye1;
    public class_276 framebufferMR;
    public class_276 framebufferUndistorted;
    public class_276 framebufferVrRender;
    public class_276 fsaaFirstPassResultFBO;
    public class_276 fsaaLastPassResultFBO;
    protected float[][] hiddenMesheVertecies = new float[2][];
    public class_5321<class_2874> lastDimensionId = class_7134.field_37666;
    public int lastDisplayFBHeight = 0;
    public int lastDisplayFBWidth = 0;
    public boolean lastEnableVsync = true;
    public boolean lastFogFancy = true;
    public boolean lastFogFast = false;
    private class_5365 previousGraphics = null;
    public int lastGuiScale = 0;
    protected VRSettings.MirrorMode lastMirror;
    public int lastRenderDistanceChunks = -1;
    public long lastWindow = 0L;
    public float lastWorldScale = 0.0f;
    protected int LeftEyeTextureId = -1;
    protected int RightEyeTextureId = -1;
    public int mirrorFBHeight;
    public int mirrorFBWidth;
    protected boolean reinitFramebuffers = true;
    protected boolean resizeFrameBuffers = false;
    protected boolean acceptReinits = true;
    public boolean reinitShadersFlag = false;
    public float renderScale;
    protected class_3545<Integer, Integer> resolution;
    public float ss = -1.0f;
    public class_276 telescopeFramebufferL;
    public class_276 telescopeFramebufferR;
    protected MCVR vr;
    FloatBuffer buffer = MemoryUtil.memAllocFloat((int)16);
    FloatBuffer buffer2 = MemoryUtil.memAllocFloat((int)16);

    public VRRenderer(MCVR vr) {
        this.vr = vr;
    }

    protected void checkGLError(String message) {
        if (GlStateManager._getError() != 0) {
            System.err.println(message);
        }
    }

    public abstract void createRenderTexture(int var1, int var2);

    public abstract Matrix4f getProjectionMatrix(int var1, float var2, float var3);

    public abstract void endFrame() throws RenderConfigException;

    public abstract boolean providesStencilMask();

    public void deleteRenderTextures() {
        if (this.LeftEyeTextureId > 0) {
            RenderSystem.deleteTexture((int)this.LeftEyeTextureId);
        }
        if (this.RightEyeTextureId > 0) {
            RenderSystem.deleteTexture((int)this.RightEyeTextureId);
        }
        this.RightEyeTextureId = -1;
        this.LeftEyeTextureId = -1;
    }

    public void doStencil(boolean inverse) {
        class_310 minecraft = class_310.method_1551();
        ClientDataHolderVR dataholder = ClientDataHolderVR.getInstance();
        GL11.glEnable((int)2960);
        RenderSystem.stencilOp((int)7680, (int)7680, (int)7681);
        RenderSystem.stencilMask((int)255);
        if (inverse) {
            RenderSystem.clearStencil((int)255);
            RenderSystem.clearDepth((double)0.0);
            RenderSystem.stencilFunc((int)519, (int)0, (int)255);
            RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)true);
        } else {
            RenderSystem.clearStencil((int)0);
            RenderSystem.clearDepth((double)1.0);
            RenderSystem.stencilFunc((int)519, (int)255, (int)255);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
        RenderSystem.clear((int)1280, (boolean)false);
        RenderSystem.clearStencil((int)0);
        RenderSystem.clearDepth((double)1.0);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)519);
        RenderSystem.disableCull();
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        class_276 fb = minecraft.method_1522();
        RenderSystem.backupProjectionMatrix();
        RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f().setOrtho(0.0f, (float)fb.field_1480, 0.0f, (float)fb.field_1477, 0.0f, 20.0f), (class_8251)class_8251.field_43361);
        RenderSystem.getModelViewStack().method_22903();
        RenderSystem.getModelViewStack().method_34426();
        if (inverse) {
            RenderSystem.getModelViewStack().method_46416(0.0f, 0.0f, -20.0f);
        }
        RenderSystem.applyModelViewMatrix();
        int s = GlStateManager._getInteger((int)35725);
        if (dataholder.currentPass == RenderPass.SCOPEL || dataholder.currentPass == RenderPass.SCOPER) {
            this.drawCircle(fb.field_1480, fb.field_1477);
        } else if (dataholder.currentPass == RenderPass.LEFT || dataholder.currentPass == RenderPass.RIGHT) {
            this.drawMask();
        }
        RenderSystem.restoreProjectionMatrix();
        RenderSystem.getModelViewStack().method_22909();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableCull();
        class_285.method_22094((int)s);
        RenderSystem.stencilFunc((int)517, (int)255, (int)1);
        RenderSystem.stencilOp((int)7680, (int)7680, (int)7680);
        RenderSystem.stencilMask((int)0);
        RenderSystem.depthFunc((int)515);
    }

    public void doFSAA(boolean hasShaders) {
        if (this.fsaaFirstPassResultFBO == null) {
            this.reinitFrameBuffers("FSAA Setting Changed");
        } else {
            RenderSystem.disableBlend();
            RenderSystem.depthFunc((int)519);
            this.fsaaFirstPassResultFBO.method_1235(true);
            RenderSystem.setShaderTexture((int)0, (int)this.framebufferVrRender.method_30277());
            RenderSystem.setShaderTexture((int)1, (int)this.framebufferVrRender.method_30278());
            RenderSystem.activeTexture((int)33985);
            this.framebufferVrRender.method_35610();
            RenderSystem.activeTexture((int)33986);
            RenderSystem.bindTexture((int)this.framebufferVrRender.method_30278());
            RenderSystem.activeTexture((int)33984);
            VRShaders.lanczosShader.method_34583("Sampler0", (Object)RenderSystem.getShaderTexture((int)0));
            VRShaders.lanczosShader.method_34583("Sampler1", (Object)RenderSystem.getShaderTexture((int)1));
            VRShaders._Lanczos_texelWidthOffsetUniform.method_1251(1.0f / (3.0f * (float)this.fsaaFirstPassResultFBO.field_1480));
            VRShaders._Lanczos_texelHeightOffsetUniform.method_1251(0.0f);
            VRShaders.lanczosShader.method_34586();
            this.drawQuad();
            this.fsaaLastPassResultFBO.method_1235(true);
            RenderSystem.setShaderTexture((int)0, (int)this.fsaaFirstPassResultFBO.method_30277());
            RenderSystem.setShaderTexture((int)1, (int)this.fsaaFirstPassResultFBO.method_30278());
            RenderSystem.activeTexture((int)33985);
            this.fsaaFirstPassResultFBO.method_35610();
            RenderSystem.activeTexture((int)33986);
            RenderSystem.bindTexture((int)this.fsaaFirstPassResultFBO.method_30278());
            RenderSystem.activeTexture((int)33984);
            VRShaders.lanczosShader.method_34583("Sampler0", (Object)RenderSystem.getShaderTexture((int)0));
            VRShaders.lanczosShader.method_34583("Sampler1", (Object)RenderSystem.getShaderTexture((int)1));
            VRShaders._Lanczos_texelWidthOffsetUniform.method_1251(0.0f);
            VRShaders._Lanczos_texelHeightOffsetUniform.method_1251(1.0f / (3.0f * (float)this.fsaaLastPassResultFBO.field_1477));
            VRShaders.lanczosShader.method_34586();
            this.drawQuad();
            VRShaders.lanczosShader.method_34585();
            this.fsaaLastPassResultFBO.method_1240();
            RenderSystem.depthFunc((int)515);
            RenderSystem.enableBlend();
        }
    }

    private void drawCircle(float width, float height) {
        class_287 builder = class_289.method_1348().method_1349();
        builder.method_1328(class_293.class_5596.field_27381, class_290.field_1592);
        int i = 32;
        float f = width / 2.0f;
        builder.method_22912((double)(width / 2.0f), (double)(width / 2.0f), 0.0).method_1344();
        for (int j = 0; j < i + 1; ++j) {
            float f1 = (float)j / (float)i * (float)Math.PI * 2.0f;
            float f2 = (float)((double)(width / 2.0f) + Math.cos(f1) * (double)f);
            float f3 = (float)((double)(width / 2.0f) + Math.sin(f1) * (double)f);
            builder.method_22912((double)f2, (double)f3, 0.0).method_1344();
        }
        class_286.method_43433((class_287.class_7433)builder.method_1326());
    }

    private void drawMask() {
        class_310 mc = class_310.method_1551();
        ClientDataHolderVR dh = ClientDataHolderVR.getInstance();
        float[] verts = this.getStencilMask(dh.currentPass);
        if (verts == null) {
            return;
        }
        class_287 builder = class_289.method_1348().method_1349();
        builder.method_1328(class_293.class_5596.field_27379, class_290.field_1592);
        mc.method_1531().method_22813(new class_2960("vivecraft:textures/black.png"));
        for (int i = 0; i < verts.length; i += 2) {
            builder.method_22912((double)(verts[i] * dh.vrRenderer.renderScale), (double)(verts[i + 1] * dh.vrRenderer.renderScale), 0.0).method_1344();
        }
        RenderSystem.setShader(class_757::method_34539);
        class_286.method_43433((class_287.class_7433)builder.method_1326());
    }

    private void drawQuad() {
        class_287 builder = class_289.method_1348().method_1349();
        builder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        builder.method_22912(-1.0, -1.0, 0.0).method_22913(0.0f, 0.0f).method_1344();
        builder.method_22912(1.0, -1.0, 0.0).method_22913(1.0f, 0.0f).method_1344();
        builder.method_22912(1.0, 1.0, 0.0).method_22913(1.0f, 1.0f).method_1344();
        builder.method_22912(-1.0, 1.0, 0.0).method_22913(0.0f, 1.0f).method_1344();
        class_286.method_43437((class_287.class_7433)builder.method_1326());
    }

    public double getCurrentTimeSecs() {
        return (double)System.nanoTime() / 1.0E9;
    }

    public double getFrameTiming() {
        return this.getCurrentTimeSecs();
    }

    public String getinitError() {
        return this.vr.initStatus;
    }

    public String getLastError() {
        return "";
    }

    public String getName() {
        return "OpenVR";
    }

    public List<RenderPass> getRenderPasses() {
        class_310 minecraft = class_310.method_1551();
        ClientDataHolderVR dataholder = ClientDataHolderVR.getInstance();
        ArrayList<RenderPass> list = new ArrayList<RenderPass>();
        list.add(RenderPass.LEFT);
        list.add(RenderPass.RIGHT);
        if (((WindowExtension)minecraft.method_22683()).vivecraft$getActualScreenWidth() > 0 && ((WindowExtension)minecraft.method_22683()).vivecraft$getActualScreenHeight() > 0) {
            if (dataholder.vrSettings.displayMirrorMode == VRSettings.MirrorMode.FIRST_PERSON) {
                list.add(RenderPass.CENTER);
            } else if (dataholder.vrSettings.displayMirrorMode == VRSettings.MirrorMode.MIXED_REALITY) {
                if (dataholder.vrSettings.mixedRealityUndistorted && dataholder.vrSettings.mixedRealityUnityLike) {
                    list.add(RenderPass.CENTER);
                }
                list.add(RenderPass.THIRD);
            } else if (dataholder.vrSettings.displayMirrorMode == VRSettings.MirrorMode.THIRD_PERSON) {
                list.add(RenderPass.THIRD);
            }
        }
        if (minecraft.field_1724 != null) {
            if (TelescopeTracker.isTelescope(minecraft.field_1724.method_6047()) && TelescopeTracker.isViewing(0)) {
                list.add(RenderPass.SCOPER);
            }
            if (TelescopeTracker.isTelescope(minecraft.field_1724.method_6079()) && TelescopeTracker.isViewing(1)) {
                list.add(RenderPass.SCOPEL);
            }
            if (dataholder.cameraTracker.isVisible()) {
                list.add(RenderPass.CAMERA);
            }
        }
        return list;
    }

    public abstract class_3545<Integer, Integer> getRenderTextureSizes();

    public class_3545<Integer, Integer> getMirrorTextureSize(int eyeFBWidth, int eyeFBHeight, float resolutionScale) {
        this.mirrorFBWidth = (int)Math.ceil((float)((WindowExtension)class_310.method_1551().method_22683()).vivecraft$getActualScreenWidth() * resolutionScale);
        this.mirrorFBHeight = (int)Math.ceil((float)((WindowExtension)class_310.method_1551().method_22683()).vivecraft$getActualScreenHeight() * resolutionScale);
        if (ClientDataHolderVR.getInstance().vrSettings.displayMirrorMode == VRSettings.MirrorMode.MIXED_REALITY) {
            this.mirrorFBWidth /= 2;
            if (ClientDataHolderVR.getInstance().vrSettings.mixedRealityUnityLike) {
                this.mirrorFBHeight /= 2;
            }
        }
        if (ShadersHelper.needsSameSizeBuffers()) {
            this.mirrorFBWidth = eyeFBWidth;
            this.mirrorFBHeight = eyeFBHeight;
        }
        return new class_3545((Object)this.mirrorFBWidth, (Object)this.mirrorFBHeight);
    }

    public class_3545<Integer, Integer> getTelescopeTextureSize(int eyeFBWidth, int eyeFBHeight) {
        int telescopeFBwidth = 720;
        int telescopeFBheight = 720;
        if (ShadersHelper.needsSameSizeBuffers()) {
            telescopeFBwidth = eyeFBWidth;
            telescopeFBheight = eyeFBHeight;
        }
        return new class_3545((Object)telescopeFBwidth, (Object)telescopeFBheight);
    }

    public class_3545<Integer, Integer> getCameraTextureSize(int eyeFBWidth, int eyeFBHeight) {
        int cameraFBwidth = Math.round(1920.0f * ClientDataHolderVR.getInstance().vrSettings.handCameraResScale);
        int cameraFBheight = Math.round(1080.0f * ClientDataHolderVR.getInstance().vrSettings.handCameraResScale);
        if (ShadersHelper.needsSameSizeBuffers()) {
            float aspect = (float)cameraFBwidth / (float)cameraFBheight;
            if (aspect > (float)(eyeFBWidth / eyeFBHeight)) {
                cameraFBwidth = eyeFBWidth;
                cameraFBheight = Math.round((float)eyeFBWidth / aspect);
            } else {
                cameraFBwidth = Math.round((float)eyeFBHeight * aspect);
                cameraFBheight = eyeFBHeight;
            }
        }
        return new class_3545((Object)cameraFBwidth, (Object)cameraFBheight);
    }

    public float[] getStencilMask(RenderPass eye) {
        if (this.hiddenMesheVertecies != null && (eye == RenderPass.LEFT || eye == RenderPass.RIGHT)) {
            return eye == RenderPass.LEFT ? this.hiddenMesheVertecies[0] : this.hiddenMesheVertecies[1];
        }
        return null;
    }

    public boolean isInitialized() {
        return this.vr.initSuccess;
    }

    public void reinitFrameBuffers(String cause) {
        if (this.acceptReinits) {
            if (!this.reinitFramebuffers) {
                System.out.println("Reinit Render: " + cause);
            }
            this.reinitFramebuffers = true;
        }
    }

    public void resizeFrameBuffers(String cause) {
        if (!cause.isEmpty() && !this.resizeFrameBuffers) {
            System.out.println("Resizing Buffers: " + cause);
        }
        this.resizeFrameBuffers = true;
    }

    public void setupRenderConfiguration() throws Exception {
        class_3545<Integer, Integer> cameraSize;
        Object telescopeSize;
        int eyeFBHeight;
        int eyeFBWidth;
        float resolutionScale;
        int eyeh;
        int eyew;
        class_3545<Integer, Integer> tuple;
        class_310 minecraft = class_310.method_1551();
        ClientDataHolderVR dataholder = ClientDataHolderVR.getInstance();
        if (minecraft.method_22683().method_4490() != this.lastWindow) {
            this.lastWindow = minecraft.method_22683().method_4490();
            this.reinitFrameBuffers("Window Handle Changed");
        }
        if (this.lastEnableVsync != (Boolean)minecraft.field_1690.method_42433().method_41753()) {
            this.reinitFrameBuffers("VSync Changed");
            this.lastEnableVsync = (Boolean)minecraft.field_1690.method_42433().method_41753();
        }
        if (this.lastMirror != dataholder.vrSettings.displayMirrorMode) {
            if (!ShadersHelper.isShaderActive()) {
                this.reinitFrameBuffers("Mirror Changed");
            } else if (this.lastMirror == VRSettings.MirrorMode.MIXED_REALITY || dataholder.vrSettings.displayMirrorMode == VRSettings.MirrorMode.MIXED_REALITY) {
                this.resizeFrameBuffers("Mirror Changed");
            }
            this.lastMirror = dataholder.vrSettings.displayMirrorMode;
        }
        if ((this.framebufferMR == null || this.framebufferUndistorted == null) && ShadersHelper.isShaderActive()) {
            this.reinitFrameBuffers("Shaders on, but some buffers not initialized");
        }
        if (class_310.method_1551().field_1690.method_42534().method_41753() != this.previousGraphics) {
            this.previousGraphics = (class_5365)class_310.method_1551().field_1690.method_42534().method_41753();
            ClientDataHolderVR.getInstance().vrRenderer.reinitFrameBuffers("gfx setting change");
        }
        if (this.resizeFrameBuffers && !this.reinitFramebuffers) {
            this.resizeFrameBuffers = false;
            tuple = this.getRenderTextureSizes();
            eyew = (Integer)tuple.method_15442();
            eyeh = (Integer)tuple.method_15441();
            resolutionScale = ResolutionControlHelper.isLoaded() ? ResolutionControlHelper.getCurrentScaleFactor() : 1.0f;
            this.renderScale = (float)Math.sqrt(dataholder.vrSettings.renderScaleFactor) * resolutionScale;
            eyeFBWidth = (int)Math.ceil((float)eyew * this.renderScale);
            eyeFBHeight = (int)Math.ceil((float)eyeh * this.renderScale);
            class_3545<Integer, Integer> mirrorSize = this.getMirrorTextureSize(eyeFBWidth, eyeFBHeight, resolutionScale);
            telescopeSize = this.getTelescopeTextureSize(eyeFBWidth, eyeFBHeight);
            cameraSize = this.getCameraTextureSize(eyeFBWidth, eyeFBHeight);
            ((RenderTargetExtension)((Object)WorldRenderPass.stereoXR.target)).vivecraft$setUseStencil(dataholder.vrSettings.vrUseStencil);
            WorldRenderPass.stereoXR.resize(eyeFBWidth, eyeFBHeight);
            if (dataholder.vrSettings.useFsaa) {
                this.fsaaFirstPassResultFBO.method_1234(eyew, eyeFBHeight, class_310.field_1703);
            }
            if ((Integer)mirrorSize.method_15442() > 0 && (Integer)mirrorSize.method_15441() > 0) {
                if (WorldRenderPass.center != null) {
                    WorldRenderPass.center.resize((Integer)mirrorSize.method_15442(), (Integer)mirrorSize.method_15441());
                }
                if (WorldRenderPass.mixedReality != null) {
                    WorldRenderPass.mixedReality.resize((Integer)mirrorSize.method_15442(), (Integer)mirrorSize.method_15441());
                }
            }
            WorldRenderPass.leftTelescope.resize((Integer)telescopeSize.method_15442(), (Integer)telescopeSize.method_15441());
            WorldRenderPass.rightTelescope.resize((Integer)telescopeSize.method_15442(), (Integer)telescopeSize.method_15441());
            this.cameraFramebuffer.method_1234(((Integer)cameraSize.method_15442()).intValue(), ((Integer)cameraSize.method_15441()).intValue(), class_310.field_1703);
            if (ShadersHelper.needsSameSizeBuffers()) {
                WorldRenderPass.camera.resize(eyeFBWidth, eyeFBHeight);
            } else {
                WorldRenderPass.camera.resize((Integer)cameraSize.method_15442(), (Integer)cameraSize.method_15441());
            }
            if (GuiHandler.updateResolution()) {
                GuiHandler.guiFramebuffer.method_1234(GuiHandler.guiWidth, GuiHandler.guiHeight, class_310.field_1703);
                if (minecraft.field_1755 != null) {
                    int l2 = minecraft.method_22683().method_4486();
                    int j3 = minecraft.method_22683().method_4502();
                    minecraft.field_1755.method_25423(minecraft, l2, j3);
                }
            }
        }
        if (this.reinitFramebuffers) {
            this.reinitShadersFlag = true;
            this.checkGLError("Start Init");
            if (class_156.method_668() == class_156.class_158.field_1133 && class_4494.method_22090().toLowerCase().contains("intel")) {
                StringBuilder gpus = new StringBuilder();
                boolean onlyIntel = true;
                for (GraphicsCard gpu : new SystemInfo().getHardware().getGraphicsCards()) {
                    gpus.append("\n");
                    if (gpu.getVendor().toLowerCase().contains("intel") || gpu.getName().toLowerCase().contains("intel")) {
                        gpus.append("\u00a7c\u274c\u00a7r ");
                    } else {
                        onlyIntel = false;
                        gpus.append("\u00a7a\u2714\u00a7r ");
                    }
                    gpus.append(gpu.getVendor()).append(": ").append(gpu.getName());
                }
                throw new RenderConfigException("Incompatible", (class_2561)class_2561.method_43469((String)"vivecraft.messages.intelgraphics1", (Object[])new Object[]{class_2561.method_43470((String)class_4494.method_22090()).method_27692(class_124.field_1065), gpus.toString(), onlyIntel ? class_2561.method_43473() : class_2561.method_43469((String)"vivecraft.messages.intelgraphics2", (Object[])new Object[]{class_2561.method_43470((String)"https://www.vivecraft.org/faq/#gpu").method_27694(style -> style.method_30938(Boolean.valueOf(true)).method_10977(class_124.field_1060).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_5244.field_44968)).method_10958(new class_2558(class_2558.class_2559.field_11749, "https://www.vivecraft.org/faq/#gpu")))})}));
            }
            if (!this.isInitialized()) {
                throw new RenderConfigException(RENDER_SETUP_FAILURE_MESSAGE + this.getName(), (class_2561)class_2561.method_43470((String)this.getinitError()));
            }
            tuple = this.getRenderTextureSizes();
            eyew = (Integer)tuple.method_15442();
            eyeh = (Integer)tuple.method_15441();
            this.destroy();
            if (this.LeftEyeTextureId == -1) {
                this.createRenderTexture(eyew, eyeh);
                if (this.LeftEyeTextureId == -1) {
                    throw new RenderConfigException(RENDER_SETUP_FAILURE_MESSAGE + this.getName(), (class_2561)class_2561.method_43470((String)this.getLastError()));
                }
                dataholder.print("Provider supplied render texture IDs: " + this.LeftEyeTextureId + " " + this.RightEyeTextureId);
                dataholder.print("Provider supplied texture resolution: " + eyew + " x " + eyeh);
            }
            this.checkGLError("Render Texture setup");
            if (this.framebufferEye0 == null) {
                this.framebufferEye0 = new VRTextureTarget("L Eye", eyew, eyeh, false, false, this.LeftEyeTextureId, false, true, false);
                dataholder.print(this.framebufferEye0.toString());
                this.checkGLError("Left Eye framebuffer setup");
            }
            if (this.framebufferEye1 == null) {
                this.framebufferEye1 = new VRTextureTarget("R Eye", eyew, eyeh, false, false, this.RightEyeTextureId, false, true, false);
                dataholder.print(this.framebufferEye1.toString());
                this.checkGLError("Right Eye framebuffer setup");
            }
            resolutionScale = ResolutionControlHelper.isLoaded() ? ResolutionControlHelper.getCurrentScaleFactor() : 1.0f;
            this.renderScale = (float)Math.sqrt(dataholder.vrSettings.renderScaleFactor) * resolutionScale;
            eyeFBWidth = (int)Math.ceil((float)eyew * this.renderScale);
            eyeFBHeight = (int)Math.ceil((float)eyeh * this.renderScale);
            this.framebufferVrRender = new VRTextureTarget("3D Render", eyeFBWidth, eyeFBHeight, true, false, -1, true, true, dataholder.vrSettings.vrUseStencil);
            WorldRenderPass.stereoXR = new WorldRenderPass((VRTextureTarget)this.framebufferVrRender);
            dataholder.print(this.framebufferVrRender.toString());
            this.checkGLError("3D framebuffer setup");
            this.getMirrorTextureSize(eyeFBWidth, eyeFBHeight, resolutionScale);
            List<RenderPass> list = this.getRenderPasses();
            for (RenderPass renderpass : list) {
                System.out.println("Passes: " + renderpass.toString());
            }
            if (this.mirrorFBWidth > 0 && this.mirrorFBHeight > 0) {
                if (list.contains((Object)RenderPass.THIRD) || ShadersHelper.isShaderActive()) {
                    this.framebufferMR = new VRTextureTarget("Mixed Reality Render", this.mirrorFBWidth, this.mirrorFBHeight, true, false, -1, true, false, false);
                    WorldRenderPass.mixedReality = new WorldRenderPass((VRTextureTarget)this.framebufferMR);
                    dataholder.print(this.framebufferMR.toString());
                    this.checkGLError("Mixed reality framebuffer setup");
                }
                if (list.contains((Object)RenderPass.CENTER) || ShadersHelper.isShaderActive()) {
                    this.framebufferUndistorted = new VRTextureTarget("Undistorted View Render", this.mirrorFBWidth, this.mirrorFBHeight, true, false, -1, false, false, false);
                    WorldRenderPass.center = new WorldRenderPass((VRTextureTarget)this.framebufferUndistorted);
                    dataholder.print(this.framebufferUndistorted.toString());
                    this.checkGLError("Undistorted view framebuffer setup");
                }
            }
            GuiHandler.updateResolution();
            GuiHandler.guiFramebuffer = new VRTextureTarget("GUI", GuiHandler.guiWidth, GuiHandler.guiHeight, true, false, -1, false, true, false);
            dataholder.print(GuiHandler.guiFramebuffer.toString());
            this.checkGLError("GUI framebuffer setup");
            KeyboardHandler.Framebuffer = new VRTextureTarget("Keyboard", GuiHandler.guiWidth, GuiHandler.guiHeight, true, false, -1, false, true, false);
            dataholder.print(KeyboardHandler.Framebuffer.toString());
            this.checkGLError("Keyboard framebuffer setup");
            RadialHandler.Framebuffer = new VRTextureTarget("Radial Menu", GuiHandler.guiWidth, GuiHandler.guiHeight, true, false, -1, false, true, false);
            dataholder.print(RadialHandler.Framebuffer.toString());
            this.checkGLError("Radial framebuffer setup");
            telescopeSize = this.getTelescopeTextureSize(eyeFBWidth, eyeFBHeight);
            this.telescopeFramebufferR = new VRTextureTarget("TelescopeR", (Integer)telescopeSize.method_15442(), (Integer)telescopeSize.method_15441(), true, false, -1, true, false, false);
            WorldRenderPass.rightTelescope = new WorldRenderPass((VRTextureTarget)this.telescopeFramebufferR);
            dataholder.print(this.telescopeFramebufferR.toString());
            this.telescopeFramebufferR.method_1236(0.0f, 0.0f, 0.0f, 1.0f);
            this.telescopeFramebufferR.method_1230(class_310.field_1703);
            this.checkGLError("TelescopeR framebuffer setup");
            this.telescopeFramebufferL = new VRTextureTarget("TelescopeL", (Integer)telescopeSize.method_15442(), (Integer)telescopeSize.method_15441(), true, false, -1, true, false, false);
            WorldRenderPass.leftTelescope = new WorldRenderPass((VRTextureTarget)this.telescopeFramebufferL);
            dataholder.print(this.telescopeFramebufferL.toString());
            this.telescopeFramebufferL.method_1236(0.0f, 0.0f, 0.0f, 1.0f);
            this.telescopeFramebufferL.method_1230(class_310.field_1703);
            this.checkGLError("TelescopeL framebuffer setup");
            cameraSize = this.getCameraTextureSize(eyeFBWidth, eyeFBHeight);
            int cameraRenderFBwidth = (Integer)cameraSize.method_15442();
            int cameraRenderFBheight = (Integer)cameraSize.method_15441();
            if (ShadersHelper.needsSameSizeBuffers()) {
                cameraRenderFBwidth = eyeFBWidth;
                cameraRenderFBheight = eyeFBHeight;
            }
            this.cameraFramebuffer = new VRTextureTarget("Handheld Camera", (Integer)cameraSize.method_15442(), (Integer)cameraSize.method_15441(), true, false, -1, true, false, false);
            dataholder.print(this.cameraFramebuffer.toString());
            this.checkGLError("Camera framebuffer setup");
            this.cameraRenderFramebuffer = new VRTextureTarget("Handheld Camera Render", cameraRenderFBwidth, cameraRenderFBheight, true, false, -1, true, true, false);
            WorldRenderPass.camera = new WorldRenderPass((VRTextureTarget)this.cameraRenderFramebuffer);
            dataholder.print(this.cameraRenderFramebuffer.toString());
            this.checkGLError("Camera render framebuffer setup");
            ((GameRendererExtension)minecraft.field_1773).vivecraft$setupClipPlanes();
            this.eyeproj[0] = this.getProjectionMatrix(0, ((GameRendererExtension)minecraft.field_1773).vivecraft$getMinClipDistance(), ((GameRendererExtension)minecraft.field_1773).vivecraft$getClipDistance());
            this.eyeproj[1] = this.getProjectionMatrix(1, ((GameRendererExtension)minecraft.field_1773).vivecraft$getMinClipDistance(), ((GameRendererExtension)minecraft.field_1773).vivecraft$getClipDistance());
            if (dataholder.vrSettings.useFsaa) {
                try {
                    this.checkGLError("pre FSAA FBO creation");
                    this.fsaaFirstPassResultFBO = new VRTextureTarget("FSAA Pass1 FBO", eyew, eyeFBHeight, true, false, -1, false, false, false);
                    this.fsaaLastPassResultFBO = new VRTextureTarget("FSAA Pass2 FBO", eyew, eyeh, true, false, -1, false, false, false);
                    dataholder.print(this.fsaaFirstPassResultFBO.toString());
                    dataholder.print(this.fsaaLastPassResultFBO.toString());
                    this.checkGLError("FSAA FBO creation");
                    VRShaders.setupFSAA();
                    ShaderHelper.checkGLError("FBO init fsaa shader");
                }
                catch (Exception exception) {
                    dataholder.vrSettings.useFsaa = false;
                    dataholder.vrSettings.saveOptions();
                    System.out.println(exception.getMessage());
                    this.reinitFramebuffers = true;
                    return;
                }
            }
            try {
                minecraft.field_1689 = this.framebufferVrRender;
                VRShaders.setupDepthMask();
                ShaderHelper.checkGLError("init depth shader");
                VRShaders.setupFOVReduction();
                ShaderHelper.checkGLError("init FOV shader");
                VRShaders.setupPortalShaders();
                ShaderHelper.checkGLError("init portal shader");
                minecraft.field_1773.method_3167(minecraft.method_1560());
            }
            catch (Exception exception1) {
                System.out.println(exception1.getMessage());
                System.exit(-1);
            }
            if (minecraft.field_1755 != null) {
                int l2 = minecraft.method_22683().method_4486();
                int j3 = minecraft.method_22683().method_4502();
                minecraft.field_1755.method_25423(minecraft, l2, j3);
            }
            long windowPixels = (long)((WindowExtension)minecraft.method_22683()).vivecraft$getActualScreenWidth() * (long)((WindowExtension)minecraft.method_22683()).vivecraft$getActualScreenHeight();
            long vrPixels = (long)(eyeFBWidth * eyeFBHeight) * 2L;
            if (list.contains((Object)RenderPass.CENTER)) {
                vrPixels += windowPixels;
            }
            if (list.contains((Object)RenderPass.THIRD)) {
                vrPixels += windowPixels;
            }
            System.out.println("[Minecrift] New render config:\nOpenVR target width: " + eyew + ", height: " + eyeh + " [" + String.format("%.1f", Float.valueOf((float)(eyew * eyeh) / 1000000.0f)) + " MP]\nRender target width: " + eyeFBWidth + ", height: " + eyeFBHeight + " [Render scale: " + Math.round(dataholder.vrSettings.renderScaleFactor * 100.0f) + "%, " + String.format("%.1f", Float.valueOf((float)(eyeFBWidth * eyeFBHeight) / 1000000.0f)) + " MP]\nMain window width: " + ((WindowExtension)minecraft.method_22683()).vivecraft$getActualScreenWidth() + ", height: " + ((WindowExtension)minecraft.method_22683()).vivecraft$getActualScreenHeight() + " [" + String.format("%.1f", Float.valueOf((float)windowPixels / 1000000.0f)) + " MP]\nTotal shaded pixels per frame: " + String.format("%.1f", Float.valueOf((float)vrPixels / 1000000.0f)) + " MP (eye stencil not accounted for)");
            this.lastDisplayFBWidth = eyeFBWidth;
            this.lastDisplayFBHeight = eyeFBHeight;
            this.reinitFramebuffers = false;
            this.acceptReinits = false;
            ShadersHelper.maybeReloadShaders();
            this.acceptReinits = true;
        }
    }

    public boolean wasDisplayResized() {
        class_310 minecraft = class_310.method_1551();
        int i = ((WindowExtension)minecraft.method_22683()).vivecraft$getActualScreenHeight();
        int j = ((WindowExtension)minecraft.method_22683()).vivecraft$getActualScreenWidth();
        boolean flag = this.dispLastHeight != i || this.dispLastWidth != j;
        this.dispLastHeight = i;
        this.dispLastWidth = j;
        return flag;
    }

    public void destroy() {
        if (this.framebufferVrRender != null) {
            WorldRenderPass.stereoXR.close();
            WorldRenderPass.stereoXR = null;
            this.framebufferVrRender.method_1238();
            this.framebufferVrRender = null;
        }
        if (this.framebufferMR != null) {
            WorldRenderPass.mixedReality.close();
            WorldRenderPass.mixedReality = null;
            this.framebufferMR.method_1238();
            this.framebufferMR = null;
        }
        if (this.framebufferUndistorted != null) {
            WorldRenderPass.center.close();
            WorldRenderPass.center = null;
            this.framebufferUndistorted.method_1238();
            this.framebufferUndistorted = null;
        }
        if (GuiHandler.guiFramebuffer != null) {
            GuiHandler.guiFramebuffer.method_1238();
            GuiHandler.guiFramebuffer = null;
        }
        if (KeyboardHandler.Framebuffer != null) {
            KeyboardHandler.Framebuffer.method_1238();
            KeyboardHandler.Framebuffer = null;
        }
        if (RadialHandler.Framebuffer != null) {
            RadialHandler.Framebuffer.method_1238();
            RadialHandler.Framebuffer = null;
        }
        if (this.telescopeFramebufferL != null) {
            WorldRenderPass.leftTelescope.close();
            WorldRenderPass.leftTelescope = null;
            this.telescopeFramebufferL.method_1238();
            this.telescopeFramebufferL = null;
        }
        if (this.telescopeFramebufferR != null) {
            WorldRenderPass.rightTelescope.close();
            WorldRenderPass.rightTelescope = null;
            this.telescopeFramebufferR.method_1238();
            this.telescopeFramebufferR = null;
        }
        if (this.cameraFramebuffer != null) {
            this.cameraFramebuffer.method_1238();
            this.cameraFramebuffer = null;
        }
        if (this.cameraRenderFramebuffer != null) {
            WorldRenderPass.camera.close();
            WorldRenderPass.camera = null;
            this.cameraRenderFramebuffer.method_1238();
            this.cameraRenderFramebuffer = null;
        }
        if (this.fsaaFirstPassResultFBO != null) {
            this.fsaaFirstPassResultFBO.method_1238();
            this.fsaaFirstPassResultFBO = null;
        }
        if (this.fsaaLastPassResultFBO != null) {
            this.fsaaLastPassResultFBO.method_1238();
            this.fsaaLastPassResultFBO = null;
        }
        if (this.framebufferEye0 != null) {
            this.framebufferEye0.method_1238();
            this.framebufferEye0 = null;
        }
        if (this.framebufferEye1 != null) {
            this.framebufferEye1.method_1238();
            this.framebufferEye1 = null;
        }
    }
}

