/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_703;
import org.vivecraft.client.extensions.SparkParticleExtension;
import org.vivecraft.client.utils.Utils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.common.network.VrPlayerState;
import org.vivecraft.common.utils.math.Quaternion;
import org.vivecraft.common.utils.math.Vector3;

public class VRPlayersClient {
    private final class_310 mc;
    private final Map<UUID, RotInfo> vivePlayers = new HashMap<UUID, RotInfo>();
    private final Map<UUID, RotInfo> vivePlayersLast = new HashMap<UUID, RotInfo>();
    private final Map<UUID, RotInfo> vivePlayersReceived = Collections.synchronizedMap(new HashMap());
    private final Map<UUID, Integer> donors = new HashMap<UUID, Integer>();
    static VRPlayersClient instance;
    private final Random rand = new Random();
    public boolean debug = false;

    public static VRPlayersClient getInstance() {
        if (instance == null) {
            instance = new VRPlayersClient();
        }
        return instance;
    }

    public static void clear() {
        if (instance != null) {
            VRPlayersClient.instance.vivePlayers.clear();
            VRPlayersClient.instance.vivePlayersLast.clear();
            VRPlayersClient.instance.vivePlayersReceived.clear();
        }
    }

    private VRPlayersClient() {
        this.mc = class_310.method_1551();
    }

    public boolean isVRPlayer(class_1657 player) {
        return this.vivePlayers.containsKey(player.method_5667());
    }

    public void disableVR(UUID player) {
        this.vivePlayers.remove(player);
        this.vivePlayersLast.remove(player);
        this.vivePlayersReceived.remove(player);
    }

    public void Update(UUID uuid, VrPlayerState vrPlayerState, float worldScale, float heightScale, boolean localPlayer) {
        if (localPlayer || !this.mc.field_1724.method_5667().equals(uuid)) {
            Vector3 forward = new Vector3(0.0f, 0.0f, -1.0f);
            Vector3 hmdDir = vrPlayerState.hmd().orientation().multiply(forward);
            Vector3 controller0Dir = vrPlayerState.controller0().orientation().multiply(forward);
            Vector3 controller1Dir = vrPlayerState.controller1().orientation().multiply(forward);
            RotInfo rotInfo = new RotInfo();
            rotInfo.reverse = vrPlayerState.reverseHands();
            rotInfo.seated = vrPlayerState.seated();
            if (this.donors.containsKey(uuid)) {
                rotInfo.hmd = this.donors.get(uuid);
            }
            rotInfo.leftArmRot = new class_243((double)controller1Dir.getX(), (double)controller1Dir.getY(), (double)controller1Dir.getZ());
            rotInfo.rightArmRot = new class_243((double)controller0Dir.getX(), (double)controller0Dir.getY(), (double)controller0Dir.getZ());
            rotInfo.headRot = new class_243((double)hmdDir.getX(), (double)hmdDir.getY(), (double)hmdDir.getZ());
            rotInfo.Headpos = vrPlayerState.hmd().position();
            rotInfo.leftArmPos = vrPlayerState.controller1().position();
            rotInfo.rightArmPos = vrPlayerState.controller0().position();
            rotInfo.leftArmQuat = vrPlayerState.controller1().orientation();
            rotInfo.rightArmQuat = vrPlayerState.controller0().orientation();
            rotInfo.headQuat = vrPlayerState.hmd().orientation();
            rotInfo.worldScale = worldScale;
            if (heightScale < 0.5f) {
                heightScale = 0.5f;
            }
            if (heightScale > 1.5f) {
                heightScale = 1.5f;
            }
            rotInfo.heightScale = heightScale;
            if (rotInfo.seated) {
                rotInfo.heightScale = 1.0f;
            }
            this.vivePlayersReceived.put(uuid, rotInfo);
        }
    }

    public void Update(UUID uuid, VrPlayerState vrPlayerState, float worldscale, float heightscale) {
        this.Update(uuid, vrPlayerState, worldscale, heightscale, false);
    }

    public void tick() {
        for (Map.Entry<UUID, RotInfo> entry2 : this.vivePlayers.entrySet()) {
            this.vivePlayersLast.put(entry2.getKey(), entry2.getValue());
        }
        for (Map.Entry<UUID, RotInfo> entry1 : this.vivePlayersReceived.entrySet()) {
            this.vivePlayers.put(entry1.getKey(), entry1.getValue());
        }
        class_638 level = class_310.method_1551().field_1687;
        if (level != null) {
            Iterator<UUID> iterator = this.vivePlayers.keySet().iterator();
            while (iterator.hasNext()) {
                UUID uuid = iterator.next();
                if (level.method_18470(uuid) != null) continue;
                iterator.remove();
                this.vivePlayersLast.remove(uuid);
                this.vivePlayersReceived.remove(uuid);
            }
            if (!this.mc.method_1493()) {
                for (class_1657 player : level.method_18456()) {
                    if (this.donors.getOrDefault(player.method_5667(), 0) <= 3 || this.rand.nextInt(10) >= 4) continue;
                    RotInfo playermodelcontroller$rotinfo = this.vivePlayers.get(player.method_5667());
                    class_243 vec3 = player.method_5720();
                    if (playermodelcontroller$rotinfo != null) {
                        vec3 = playermodelcontroller$rotinfo.leftArmPos.method_1020(playermodelcontroller$rotinfo.rightArmPos).method_1024(-1.5707964f);
                        if (playermodelcontroller$rotinfo.reverse) {
                            vec3 = vec3.method_1021(-1.0);
                        } else if (playermodelcontroller$rotinfo.seated) {
                            vec3 = playermodelcontroller$rotinfo.rightArmRot;
                        }
                        if (vec3.method_1033() < (double)1.0E-4f) {
                            vec3 = playermodelcontroller$rotinfo.headRot;
                        }
                    }
                    vec3 = vec3.method_1021((double)0.1f);
                    class_243 vec31 = playermodelcontroller$rotinfo != null && player == this.mc.field_1724 ? playermodelcontroller$rotinfo.Headpos.method_1019(player.method_19538()) : player.method_5836(1.0f);
                    class_703 particle = this.mc.field_1713.method_3056((class_2394)class_2398.field_11248, vec31.field_1352 + (player.method_5715() ? -vec3.field_1352 * 3.0 : 0.0) + ((double)this.rand.nextFloat() - 0.5) * (double)0.02f, vec31.field_1351 - (double)(player.method_5715() ? 1.0f : 0.8f) + ((double)this.rand.nextFloat() - 0.5) * (double)0.02f, vec31.field_1350 + (player.method_5715() ? -vec3.field_1350 * 3.0 : 0.0) + ((double)this.rand.nextFloat() - 0.5) * (double)0.02f, -vec3.field_1352 + ((double)this.rand.nextFloat() - 0.5) * (double)0.01f, ((double)this.rand.nextFloat() - (double)0.05f) * (double)0.05f, -vec3.field_1350 + ((double)this.rand.nextFloat() - 0.5) * (double)0.01f);
                    if (particle == null) continue;
                    particle.method_3084(0.5f + this.rand.nextFloat() / 2.0f, 0.5f + this.rand.nextFloat() / 2.0f, 0.5f + this.rand.nextFloat() / 2.0f);
                    ((SparkParticleExtension)particle).vivecraft$setPlayerUUID(player.method_5667());
                }
            }
        }
    }

    public void setHMD(UUID uuid, int level) {
        this.donors.put(uuid, level);
    }

    public boolean HMDCHecked(UUID uuid) {
        return this.donors.containsKey(uuid);
    }

    public RotInfo getRotationsForPlayer(UUID uuid) {
        RotInfo playermodelcontroller$rotinfo;
        if (this.debug) {
            uuid = this.mc.field_1724.method_5667();
        }
        if ((playermodelcontroller$rotinfo = this.vivePlayers.get(uuid)) != null && this.vivePlayersLast.containsKey(uuid)) {
            RotInfo playermodelcontroller$rotinfo1 = this.vivePlayersLast.get(uuid);
            RotInfo playermodelcontroller$rotinfo2 = new RotInfo();
            float f = class_310.method_1551().method_1488();
            playermodelcontroller$rotinfo2.reverse = playermodelcontroller$rotinfo.reverse;
            playermodelcontroller$rotinfo2.seated = playermodelcontroller$rotinfo.seated;
            playermodelcontroller$rotinfo2.hmd = playermodelcontroller$rotinfo.hmd;
            playermodelcontroller$rotinfo2.leftArmPos = Utils.vecLerp(playermodelcontroller$rotinfo1.leftArmPos, playermodelcontroller$rotinfo.leftArmPos, f);
            playermodelcontroller$rotinfo2.rightArmPos = Utils.vecLerp(playermodelcontroller$rotinfo1.rightArmPos, playermodelcontroller$rotinfo.rightArmPos, f);
            playermodelcontroller$rotinfo2.Headpos = Utils.vecLerp(playermodelcontroller$rotinfo1.Headpos, playermodelcontroller$rotinfo.Headpos, f);
            playermodelcontroller$rotinfo2.leftArmQuat = playermodelcontroller$rotinfo.leftArmQuat;
            playermodelcontroller$rotinfo2.rightArmQuat = playermodelcontroller$rotinfo.rightArmQuat;
            playermodelcontroller$rotinfo2.headQuat = playermodelcontroller$rotinfo.headQuat;
            Vector3 vector3 = new Vector3(0.0f, 0.0f, -1.0f);
            playermodelcontroller$rotinfo2.leftArmRot = Utils.vecLerp(playermodelcontroller$rotinfo1.leftArmRot, Utils.convertToVector3d(playermodelcontroller$rotinfo2.leftArmQuat.multiply(vector3)), f);
            playermodelcontroller$rotinfo2.rightArmRot = Utils.vecLerp(playermodelcontroller$rotinfo1.rightArmRot, Utils.convertToVector3d(playermodelcontroller$rotinfo2.rightArmQuat.multiply(vector3)), f);
            playermodelcontroller$rotinfo2.headRot = Utils.vecLerp(playermodelcontroller$rotinfo1.headRot, Utils.convertToVector3d(playermodelcontroller$rotinfo2.headQuat.multiply(vector3)), f);
            playermodelcontroller$rotinfo2.heightScale = playermodelcontroller$rotinfo.heightScale;
            playermodelcontroller$rotinfo2.worldScale = playermodelcontroller$rotinfo.worldScale;
            return playermodelcontroller$rotinfo2;
        }
        return playermodelcontroller$rotinfo;
    }

    public static RotInfo getMainPlayerRotInfo(VRData data) {
        Quaternion quaternion2;
        RotInfo playermodelcontroller$rotinfo = new RotInfo();
        Quaternion quaternion = new Quaternion(data.getController(1).getMatrix());
        Quaternion quaternion1 = new Quaternion(data.getController(0).getMatrix());
        playermodelcontroller$rotinfo.headQuat = quaternion2 = new Quaternion(data.hmd.getMatrix());
        playermodelcontroller$rotinfo.leftArmQuat = quaternion;
        playermodelcontroller$rotinfo.rightArmQuat = quaternion1;
        playermodelcontroller$rotinfo.seated = ClientDataHolderVR.getInstance().vrSettings.seated;
        playermodelcontroller$rotinfo.leftArmPos = data.getController(1).getPosition();
        playermodelcontroller$rotinfo.rightArmPos = data.getController(0).getPosition();
        playermodelcontroller$rotinfo.Headpos = data.hmd.getPosition();
        return playermodelcontroller$rotinfo;
    }

    public boolean isTracked(UUID uuid) {
        this.debug = false;
        return this.debug || this.vivePlayers.containsKey(uuid);
    }

    public static float getFacingYaw(RotInfo rotInfo) {
        class_243 vec3 = VRPlayersClient.getOrientVec(rotInfo.headQuat);
        return (float)Math.toDegrees(Math.atan2(vec3.field_1352, vec3.field_1350));
    }

    public static class_243 getOrientVec(Quaternion quat) {
        class_243 vec3 = quat.multiply(new class_243(0.0, 0.0, -1.0)).method_1036(quat.multiply(new class_243(0.0, 1.0, 0.0))).method_1029();
        return new class_243(0.0, 1.0, 0.0).method_1036(vec3).method_1029();
    }

    public static class RotInfo {
        public boolean seated;
        public boolean reverse;
        public int hmd = 0;
        public Quaternion leftArmQuat;
        public Quaternion rightArmQuat;
        public Quaternion headQuat;
        public class_243 leftArmRot;
        public class_243 rightArmRot;
        public class_243 headRot;
        public class_243 leftArmPos;
        public class_243 rightArmPos;
        public class_243 Headpos;
        public float worldScale;
        public float heightScale;

        public double getBodyYawRadians() {
            class_243 vec3 = this.leftArmPos.method_1020(this.rightArmPos).method_1024(-1.5707964f);
            if (this.reverse) {
                vec3 = vec3.method_1021(-1.0);
            }
            if (this.seated) {
                vec3 = this.rightArmRot;
            }
            class_243 vec31 = Utils.vecLerp(vec3, this.headRot, 0.5);
            return Math.atan2(-vec31.field_1352, vec31.field_1350);
        }
    }
}

