/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client.controller;

import eu.midnightdust.midnightcontrols.ControlsMode;
import eu.midnightdust.midnightcontrols.client.MidnightControlsConfig;
import eu.midnightdust.midnightcontrols.client.controller.ButtonBinding;
import eu.midnightdust.midnightcontrols.client.controller.ButtonCategory;
import eu.midnightdust.midnightcontrols.client.controller.InputHandlers;
import eu.midnightdust.midnightcontrols.client.controller.PressAction;
import eu.midnightdust.midnightcontrols.client.enums.ButtonState;
import eu.midnightdust.midnightcontrols.client.mixin.MouseAccessor;
import it.unimi.dsi.fastutil.ints.Int2FloatMap;
import it.unimi.dsi.fastutil.ints.Int2FloatOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_1074;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import org.aperlambda.lambdacommon.Identifier;
import org.aperlambda.lambdacommon.utils.function.PairPredicate;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;

public class InputManager {
    public static final InputManager INPUT_MANAGER = new InputManager();
    private static final List<ButtonBinding> BINDINGS = new ArrayList<ButtonBinding>();
    private static final List<ButtonCategory> CATEGORIES = new ArrayList<ButtonCategory>();
    public static final Int2ObjectMap<ButtonState> STATES = new Int2ObjectOpenHashMap();
    public static final Int2FloatMap BUTTON_VALUES = new Int2FloatOpenHashMap();
    public int prevTargetMouseX = 0;
    public int prevTargetMouseY = 0;
    public int targetMouseX = 0;
    public int targetMouseY = 0;
    private static ButtonBinding tempBinding;
    private static List<ButtonBinding> unboundBindings;

    protected InputManager() {
    }

    public void tick(@NotNull class_310 client) {
        if (MidnightControlsConfig.autoSwitchMode && !MidnightControlsConfig.isEditing && MidnightControlsConfig.controlsMode != ControlsMode.TOUCHSCREEN) {
            MidnightControlsConfig.controlsMode = MidnightControlsConfig.getController().isConnected() && MidnightControlsConfig.getController().isGamepad() ? ControlsMode.CONTROLLER : ControlsMode.DEFAULT;
        }
        if (MidnightControlsConfig.controlsMode == ControlsMode.CONTROLLER) {
            this.controllerTick(client);
        }
    }

    public void controllerTick(@NotNull class_310 client) {
        this.prevTargetMouseX = this.targetMouseX;
        this.prevTargetMouseY = this.targetMouseY;
    }

    public void updateMousePosition(@NotNull class_310 client) {
        Objects.requireNonNull(client, "Client instance cannot be null.");
        if (this.prevTargetMouseX != this.targetMouseX || this.prevTargetMouseY != this.targetMouseY) {
            double mouseX = (double)((float)this.prevTargetMouseX + (float)(this.targetMouseX - this.prevTargetMouseX) * client.method_1488()) + 0.5;
            double mouseY = (double)((float)this.prevTargetMouseY + (float)(this.targetMouseY - this.prevTargetMouseY) * client.method_1488()) + 0.5;
            if (!MidnightControlsConfig.virtualMouse) {
                GLFW.glfwSetCursorPos((long)client.method_22683().method_4490(), (double)mouseX, (double)mouseY);
            }
            ((MouseAccessor)client.field_1729).midnightcontrols$onCursorPos(client.method_22683().method_4490(), mouseX, mouseY);
        }
    }

    public void resetMousePosition(int windowWidth, int windowHeight) {
        this.targetMouseX = this.prevTargetMouseX = (int)((float)windowWidth / 2.0f);
        this.targetMouseY = this.prevTargetMouseY = (int)((float)windowHeight / 2.0f);
    }

    public void resetMouseTarget(@NotNull class_310 client) {
        double mouseX = client.field_1729.method_1603();
        double mouseY = client.field_1729.method_1604();
        this.prevTargetMouseX = this.targetMouseX = (int)mouseX;
        this.prevTargetMouseY = this.targetMouseY = (int)mouseY;
    }

    public static boolean hasBinding(@NotNull ButtonBinding binding) {
        return BINDINGS.contains(binding);
    }

    public static boolean hasBinding(@NotNull String name) {
        return BINDINGS.parallelStream().map(ButtonBinding::getName).anyMatch(binding -> binding.equalsIgnoreCase(name));
    }

    public static boolean hasBinding(@NotNull Identifier identifier) {
        return InputManager.hasBinding(identifier.getNamespace() + "." + identifier.getName());
    }

    public static ButtonBinding getBinding(@NotNull String name) {
        if (BINDINGS.parallelStream().map(ButtonBinding::getName).anyMatch(binding -> binding.equalsIgnoreCase(name))) {
            BINDINGS.forEach(binding -> {
                if (binding.getName().equalsIgnoreCase(name)) {
                    tempBinding = binding;
                }
            });
        }
        return tempBinding;
    }

    public static List<ButtonBinding> getUnboundBindings() {
        unboundBindings = new ArrayList<ButtonBinding>();
        BINDINGS.forEach(binding -> {
            if (binding.isNotBound() && !MidnightControlsConfig.ignoredUnboundKeys.contains(binding.getTranslationKey())) {
                unboundBindings.add((ButtonBinding)binding);
            }
        });
        unboundBindings.sort(Comparator.comparing(s -> class_1074.method_4662((String)s.getTranslationKey(), (Object[])new Object[0])));
        return unboundBindings;
    }

    @NotNull
    public static ButtonBinding registerBinding(@NotNull ButtonBinding binding) {
        if (InputManager.hasBinding(binding)) {
            throw new IllegalStateException("Cannot register twice a button binding in the registry.");
        }
        BINDINGS.add(binding);
        return binding;
    }

    @NotNull
    public static ButtonBinding registerBinding(@NotNull Identifier id, int[] defaultButton, @NotNull List<PressAction> actions, @NotNull PairPredicate<class_310, ButtonBinding> filter, boolean hasCooldown) {
        return InputManager.registerBinding(new ButtonBinding(id.getNamespace() + "." + id.getName(), defaultButton, actions, filter, hasCooldown));
    }

    @NotNull
    public static ButtonBinding registerBinding(@NotNull Identifier id, int[] defaultButton, boolean hasCooldown) {
        return InputManager.registerBinding(id, defaultButton, Collections.emptyList(), (PairPredicate<class_310, ButtonBinding>)((PairPredicate)InputHandlers::always), hasCooldown);
    }

    @NotNull
    public static ButtonBinding registerBinding(@NotNull class_2960 id, int[] defaultButton, @NotNull List<PressAction> actions, @NotNull PairPredicate<class_310, ButtonBinding> filter, boolean hasCooldown) {
        return InputManager.registerBinding(new Identifier(id.method_12836(), id.method_12832()), defaultButton, actions, filter, hasCooldown);
    }

    @NotNull
    public static ButtonBinding registerBinding(@NotNull class_2960 id, int[] defaultButton, boolean hasCooldown) {
        return InputManager.registerBinding(id, defaultButton, Collections.emptyList(), (PairPredicate<class_310, ButtonBinding>)((PairPredicate)InputHandlers::always), hasCooldown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sortBindings() {
        List<ButtonBinding> list = BINDINGS;
        synchronized (list) {
            List<ButtonBinding> sorted = BINDINGS.stream().sorted(Collections.reverseOrder(Comparator.comparingInt(binding -> binding.getButton().length))).toList();
            BINDINGS.clear();
            BINDINGS.addAll(sorted);
        }
    }

    public static ButtonCategory registerCategory(@NotNull ButtonCategory category) {
        CATEGORIES.add(category);
        return category;
    }

    public static ButtonCategory registerCategory(@NotNull Identifier identifier, int priority) {
        return InputManager.registerCategory(new ButtonCategory(identifier, priority));
    }

    public static ButtonCategory registerCategory(@NotNull Identifier identifier) {
        return InputManager.registerCategory(new ButtonCategory(identifier));
    }

    protected static ButtonCategory registerDefaultCategory(@NotNull String key, @NotNull Consumer<ButtonCategory> keyAdder) {
        ButtonCategory category = InputManager.registerCategory(new Identifier("minecraft", key), CATEGORIES.size());
        keyAdder.accept(category);
        return category;
    }

    public static void loadButtonBindings() {
        ArrayList<ButtonBinding> queue = new ArrayList<ButtonBinding>(BINDINGS);
        queue.forEach(MidnightControlsConfig::loadButtonBinding);
    }

    @NotNull
    public static ButtonState getBindingState(@NotNull ButtonBinding binding) {
        ButtonState state = ButtonState.REPEAT;
        for (int btn : binding.getButton()) {
            ButtonState btnState = (ButtonState)((Object)STATES.getOrDefault(btn, (Object)ButtonState.NONE));
            if (btnState == ButtonState.PRESS) {
                state = ButtonState.PRESS;
                continue;
            }
            if (btnState == ButtonState.RELEASE) {
                state = ButtonState.RELEASE;
                break;
            }
            if (btnState != ButtonState.NONE) continue;
            state = ButtonState.NONE;
            break;
        }
        return state;
    }

    public static float getBindingValue(@NotNull ButtonBinding binding, @NotNull ButtonState state) {
        if (state.isUnpressed()) {
            return 0.0f;
        }
        float value = 0.0f;
        for (int btn : binding.getButton()) {
            if (ButtonBinding.isAxis(btn)) {
                value = BUTTON_VALUES.getOrDefault(btn, 1.0f);
                break;
            }
            value = 1.0f;
        }
        return value;
    }

    public static boolean hasDuplicatedBindings(int[] button) {
        return BINDINGS.parallelStream().filter(binding -> InputManager.areButtonsEquivalent(binding.getButton(), button)).count() > 1L;
    }

    public static boolean hasDuplicatedBindings(ButtonBinding binding) {
        return BINDINGS.parallelStream().filter(other -> InputManager.areButtonsEquivalent(other.getButton(), binding.getButton()) && other.filter.equals(binding.filter)).count() > 1L;
    }

    public static boolean areButtonsEquivalent(int[] buttons1, int[] buttons2) {
        if (buttons1.length != buttons2.length) {
            return false;
        }
        int count = 0;
        block0: for (int btn : buttons1) {
            for (int btn2 : buttons2) {
                if (btn != btn2) continue;
                ++count;
                continue block0;
            }
        }
        return count == buttons1.length;
    }

    public static boolean containsButton(int[] buttons, int button) {
        return Arrays.stream(buttons).anyMatch(btn -> btn == button);
    }

    public static void updateStates() {
        for (Int2ObjectMap.Entry entry : STATES.int2ObjectEntrySet()) {
            if (entry.getValue() == ButtonState.PRESS) {
                STATES.put(entry.getIntKey(), (Object)ButtonState.REPEAT);
                continue;
            }
            if (entry.getValue() != ButtonState.RELEASE) continue;
            STATES.put(entry.getIntKey(), (Object)ButtonState.NONE);
        }
    }

    public static void updateBindings(@NotNull class_310 client) {
        IntArrayList skipButtons = new IntArrayList();
        Object2ObjectOpenHashMap states = new Object2ObjectOpenHashMap();
        for (ButtonBinding binding2 : BINDINGS) {
            ButtonState state2;
            ButtonState buttonState = state2 = binding2.isAvailable(client) ? InputManager.getBindingState(binding2) : ButtonState.NONE;
            if (skipButtons.intStream().anyMatch(btn -> InputManager.containsButton(binding2.getButton(), btn))) {
                state2 = binding2.pressed ? ButtonState.RELEASE : ButtonState.NONE;
            }
            if (state2 == ButtonState.RELEASE && !binding2.pressed) {
                state2 = ButtonState.NONE;
            }
            binding2.pressed = state2.isPressed();
            binding2.update();
            if (binding2.pressed) {
                Arrays.stream(binding2.getButton()).forEach(arg_0 -> ((IntArrayList)skipButtons).add(arg_0));
            }
            float value = InputManager.getBindingValue(binding2, state2);
            record ButtonStateValue(ButtonState state, float value) {
            }
            states.put((Object)binding2, (Object)new ButtonStateValue(state2, value));
        }
        states.forEach((binding, state) -> {
            if (state.state() != ButtonState.NONE) {
                binding.handle(client, state.value(), state.state());
            }
        });
    }

    public static void queueMousePosition(double x, double y) {
        InputManager.INPUT_MANAGER.targetMouseX = (int)class_3532.method_15350((double)x, (double)0.0, (double)class_310.method_1551().method_22683().method_4480());
        InputManager.INPUT_MANAGER.targetMouseY = (int)class_3532.method_15350((double)y, (double)0.0, (double)class_310.method_1551().method_22683().method_4507());
    }

    public static void queueMoveMousePosition(double x, double y) {
        InputManager.queueMousePosition((double)InputManager.INPUT_MANAGER.targetMouseX + x, (double)InputManager.INPUT_MANAGER.targetMouseY + y);
    }

    @NotNull
    public static Stream<ButtonBinding> streamBindings() {
        return BINDINGS.stream();
    }

    @NotNull
    public static Stream<ButtonCategory> streamCategories() {
        return CATEGORIES.stream();
    }

    @NotNull
    public static class_304 makeKeyBinding(@NotNull class_2960 id, class_3675.class_307 type, int code, @NotNull String category) {
        return InputManager.makeKeyBinding(new Identifier(id.method_12836(), id.method_12832()), type, code, category);
    }

    @NotNull
    public static class_304 makeKeyBinding(@NotNull Identifier id, class_3675.class_307 type, int code, @NotNull String category) {
        return new class_304(String.format("key.%s.%s", id.getNamespace(), id.getName()), type, code, category);
    }
}

